/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.databinding.lcdui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.ItemStateListener;
import javax.microedition.lcdui.TextField;
import org.netbeans.microedition.databinding.DataBinder;
import org.netbeans.microedition.databinding.lcdui.ItemBindingProvider;

public class TextFieldBindingProvider
extends ItemBindingProvider
implements ItemCommandListener,
ItemStateListener {
    private String elPointer;
    private static final Command COMMIT_COMMAND = new Command("OK", "OK", 4, 1);
    private TextField textField;
    private FeatureText featureText;

    public void notifyBind(String elPointer, Object consumer, Object feature) {
        this.elPointer = elPointer;
        if (consumer instanceof TextField && this.textField == null) {
            this.textField = (TextField)consumer;
            if (feature instanceof FeatureText) {
                this.featureText = (FeatureText)feature;
                if (this.featureText.parentForm != null) {
                    this.featureText.parentForm.setItemStateListener((ItemStateListener)this);
                } else if (this.featureText.commitCommand != null) {
                    this.textField.addCommand(this.featureText.commitCommand);
                    this.textField.setItemCommandListener((ItemCommandListener)this);
                }
            }
        }
    }

    public void notifyUnbind(Object consumer, Object feature) {
        if (consumer == this.textField) {
            if (this.featureText.commitCommand != null) {
                this.textField.removeCommand(this.featureText.commitCommand);
                this.textField.setItemCommandListener(null);
            } else if (this.featureText.parentForm != null) {
                this.featureText.parentForm.setItemStateListener(null);
            }
        }
    }

    public Object pullDataFromConsumer(String elPointer, Object consumer, Object feature) {
        if (consumer instanceof TextField) {
            TextField textField = (TextField)consumer;
            if (feature == this.featureText) {
                return textField.getString();
            }
        }
        return null;
    }

    public void pushDataToConsumer(String elPointer, Object consumer, Object feature, Object value) {
        if (consumer instanceof TextField) {
            TextField textField = (TextField)consumer;
            if (feature == this.featureText) {
                textField.setString("" + value);
            } else {
                super.pushDataToConsumer(elPointer, consumer, feature, value);
            }
        }
    }

    public void commandAction(Command command, Item item) {
        if (item == this.textField && command == COMMIT_COMMAND && this.featureText != null) {
            DataBinder.updateDataSet(this.elPointer, this, this.textField, this.featureText);
        }
    }

    public void itemStateChanged(Item item) {
        if (item == this.textField && this.featureText != null) {
            DataBinder.updateDataSet(this.elPointer, this, this.textField, this.featureText);
        }
    }

    public static final class FeatureText {
        private Command commitCommand;
        private Form parentForm = null;

        public FeatureText() {
            this(COMMIT_COMMAND);
        }

        public FeatureText(boolean attachCommand) {
            if (attachCommand) {
                this.commitCommand = COMMIT_COMMAND;
            }
        }

        public FeatureText(Form parentForm) {
            this((Command)null);
            this.parentForm = parentForm;
        }

        public FeatureText(Command commitCommand) {
            this.commitCommand = commitCommand;
        }
    }
}

