/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.keywords;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionUtils;
import org.netbeans.modules.cnd.completion.keywords.CsmKeywordCompletionItem;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class CsmKeywordsCompletionProvider
implements CompletionProvider {
    private static final boolean TRACE = false;
    private static final List<String> predefinedVariables = Arrays.asList("__VA_ARGS__");
    private static final List<CppTokenId> keywordsAll;
    private static final List<CppTokenId> keywordsFirst;

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if ((queryType & 1) != 0) {
            int dot = component.getCaret().getDot();
            if (this.showKeywordCompletion(component.getDocument(), dot)) {
                return new AsyncCompletionTask((AsyncCompletionQuery)new Query(dot, queryType), component);
            }
        }
        return null;
    }

    private boolean showKeywordCompletion(final Document doc, final int offset) {
        final AtomicBoolean out = new AtomicBoolean(false);
        doc.render(new Runnable(){

            @Override
            public void run() {
                out.set(CsmKeywordsCompletionProvider.this.showKeywordCompletionImpl(doc, offset));
            }
        });
        return out.get();
    }

    private boolean showKeywordCompletionImpl(Document doc, int offset) {
        TokenId id;
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)offset, (boolean)false, (boolean)true);
        if (ts == null) {
            return false;
        }
        if (ts.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
            TokenId id2;
            TokenSequence embedded = ts.embedded();
            if (CndTokenUtilities.moveToPreprocKeyword((TokenSequence)embedded) && (id2 = embedded.token().id()) instanceof CppTokenId) {
                switch ((CppTokenId)id2) {
                    case PREPROCESSOR_DEFINE: {
                        return embedded.offset() + embedded.token().length() < offset;
                    }
                }
                return false;
            }
        } else if (CndTokenUtilities.shiftToNonWhite((TokenSequence)ts, (boolean)true) && (id = ts.token().id()) instanceof CppTokenId) {
            switch ((CppTokenId)id) {
                case NAMESPACE: {
                    return false;
                }
                case GOTO: {
                    return false;
                }
                case NEW: 
                case SCOPE: 
                case ARROW: 
                case ARROWMBR: 
                case DOT: 
                case DOTMBR: {
                    return false;
                }
                case IF: 
                case WHILE: 
                case FOR: 
                case SWITCH: 
                case CATCH: 
                case ALIGNAS: 
                case ALIGNOF: 
                case DECLTYPE: {
                    return false;
                }
                case STATIC_CAST: 
                case CONST_CAST: 
                case REINTERPRET_CAST: 
                case TEMPLATE: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    static {
        keywordsFirst = Arrays.asList(CppTokenId.ALIGNOF, CppTokenId.CONST_CAST, CppTokenId.CONTINUE, CppTokenId.DEFAULT, CppTokenId.DELETE, CppTokenId.DOUBLE, CppTokenId.DYNAMIC_CAST, CppTokenId.EXPLICIT, CppTokenId.EXPORT, CppTokenId.EXTERN, CppTokenId.FINALLY, CppTokenId.FRIEND, CppTokenId.INLINE, CppTokenId.MUTABLE, CppTokenId.NAMESPACE, CppTokenId.OPERATOR, CppTokenId.PRIVATE, CppTokenId.PROTECTED, CppTokenId.PUBLIC, CppTokenId.REGISTER, CppTokenId.REINTERPRET_CAST, CppTokenId.RESTRICT, CppTokenId.RETURN, CppTokenId.SIGNED, CppTokenId.SIZEOF, CppTokenId.STATIC, CppTokenId.STATIC_CAST, CppTokenId.STRUCT, CppTokenId.SWITCH, CppTokenId.TEMPLATE, CppTokenId.TYPEDEF, CppTokenId.TYPEID, CppTokenId.TYPENAME, CppTokenId.TYPEOF, CppTokenId.UNSIGNED, CppTokenId.VIRTUAL, CppTokenId.VOLATILE, CppTokenId.WCHAR_T, CppTokenId.OVERRIDE, CppTokenId.CONSTEXPR, CppTokenId.DECLTYPE, CppTokenId.NULLPTR, CppTokenId.THREAD_LOCAL, CppTokenId.STATIC_ASSERT, CppTokenId.ALIGNAS, CppTokenId.CHAR16_T, CppTokenId.CHAR32_T, CppTokenId.NOEXCEPT);
        keywordsAll = new ArrayList<CppTokenId>();
        for (CppTokenId token : CppTokenId.values()) {
            String text;
            if (!"keyword".equals(token.primaryCategory()) && !"keyword-directive".equals(token.primaryCategory()) || (text = token.fixedText()) == null || text.length() <= 2) continue;
            keywordsAll.add(token);
        }
    }

    private static final class Query
    extends AsyncCompletionQuery {
        private Collection<CsmKeywordCompletionItem> results;
        private int creationCaretOffset;
        private int queryAnchorOffset;
        private String filterPrefix;
        private final int queryType;
        private boolean caseSensitive = false;
        private boolean inDefine = false;

        Query(int caretOffset, int queryType) {
            this.queryType = queryType;
            this.creationCaretOffset = caretOffset;
            this.queryAnchorOffset = -1;
        }

        protected void preQueryUpdate(JTextComponent component) {
            String mimeType = CsmCompletionUtils.getMimeType(component);
            this.caseSensitive = mimeType != null ? CsmCompletionUtils.isCaseSensitive(mimeType) : false;
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            Collection<CsmKeywordCompletionItem> items = this.getItems((BaseDocument)doc, caretOffset);
            if (this.queryAnchorOffset > 0) {
                if (!items.isEmpty()) {
                    this.results = items;
                    items = this.getFilteredData(items, this.filterPrefix);
                    resultSet.estimateItems(items.size(), -1);
                    resultSet.addAllItems(items);
                    resultSet.setAnchorOffset(this.queryAnchorOffset);
                }
                resultSet.setHasAdditionalItems(false);
            }
            resultSet.finish();
        }

        protected boolean canFilter(JTextComponent component) {
            int caretOffset = component.getCaretPosition();
            this.filterPrefix = null;
            if (this.queryAnchorOffset > -1 && caretOffset >= this.queryAnchorOffset) {
                Document doc = component.getDocument();
                try {
                    this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
                    if (this.results == null || !this.isCppIdentifierPart(this.filterPrefix)) {
                        this.filterPrefix = null;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            return this.filterPrefix != null;
        }

        protected void filter(CompletionResultSet resultSet) {
            if (this.filterPrefix != null && this.results != null) {
                resultSet.setAnchorOffset(this.queryAnchorOffset);
                Collection<CsmKeywordCompletionItem> items = this.getFilteredData(this.results, this.filterPrefix);
                resultSet.estimateItems(items.size(), -1);
                resultSet.addAllItems(items);
            }
            resultSet.setHasAdditionalItems(false);
            resultSet.finish();
        }

        private Filter<CppTokenId> getLanguageFilter(BaseDocument doc) {
            InputAttributes lexerAttrs;
            Language language = (Language)doc.getProperty(Language.class);
            if (language != null && (lexerAttrs = (InputAttributes)doc.getProperty(InputAttributes.class)) != null) {
                return (Filter)lexerAttrs.getValue(LanguagePath.get((Language)language), (Object)"lexer-filter");
            }
            return null;
        }

        private Collection<CsmKeywordCompletionItem> getItems(BaseDocument doc, int caretOffset) {
            ArrayList<CsmKeywordCompletionItem> items = new ArrayList<CsmKeywordCompletionItem>();
            try {
                if (this.init(doc, caretOffset)) {
                    Filter<CppTokenId> languageFilter = this.getLanguageFilter(doc);
                    for (Object id : keywordsAll) {
                        if (languageFilter != null && languageFilter.check((CharSequence)id.fixedText()) == null) continue;
                        items.add(CsmKeywordCompletionItem.createItem(this.queryAnchorOffset, caretOffset, id.fixedText(), keywordsFirst.contains(id)));
                    }
                    if (this.inDefine) {
                        for (Object id : predefinedVariables) {
                            items.add(CsmKeywordCompletionItem.createItem(this.queryAnchorOffset, caretOffset, (String)id, false));
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return items;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean init(BaseDocument doc, int caretOffset) throws BadLocationException {
            this.filterPrefix = "";
            this.queryAnchorOffset = -1;
            doc.readLock();
            try {
                TokenSequence ppTs = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)caretOffset, (boolean)true, (boolean)true);
                if (ppTs == null || ppTs.token() == null) {
                    boolean bl = false;
                    return bl;
                }
                TokenId id = ppTs.token().id();
                if (id instanceof CppTokenId) {
                    switch ((CppTokenId)id) {
                        case DOXYGEN_COMMENT: 
                        case BLOCK_COMMENT: 
                        case NEW_LINE: 
                        case WHITESPACE: {
                            this.queryAnchorOffset = caretOffset;
                            break;
                        }
                        default: {
                            this.queryAnchorOffset = this.isCppIdentifierPart(ppTs.token().text().toString()) ? ppTs.offset() : caretOffset;
                            this.inDefine = ppTs.token().id() == CppTokenId.PREPROCESSOR_IDENTIFIER;
                        }
                    }
                }
                this.filterPrefix = doc.getText(this.queryAnchorOffset, caretOffset - this.queryAnchorOffset);
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                doc.readUnlock();
            }
            return this.queryAnchorOffset >= 0;
        }

        private boolean isCppIdentifierPart(String text) {
            for (int i = 0; i < text.length(); ++i) {
                if (CndLexerUtilities.isCppIdentifierPart((int)text.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private Collection<CsmKeywordCompletionItem> getFilteredData(Collection<CsmKeywordCompletionItem> data, String prefix) {
            Collection<CsmKeywordCompletionItem> out;
            if (prefix == null || prefix.isEmpty()) {
                if (this.queryType == 9) {
                    out = data;
                } else {
                    out = new ArrayList<CsmKeywordCompletionItem>(data.size());
                    for (CsmKeywordCompletionItem itm : data) {
                        if (!itm.isFistCompletion()) continue;
                        out.add(itm);
                    }
                }
            } else {
                out = new ArrayList<CsmKeywordCompletionItem>(data.size());
                for (CsmKeywordCompletionItem itm : data) {
                    if (!this.matchPrefix(itm.getItemText(), prefix, this.caseSensitive)) continue;
                    out.add(itm);
                }
            }
            return out;
        }

        private boolean matchPrefix(CharSequence text, String prefix, boolean caseSensitive) {
            if (CharSequenceUtils.startsWith((CharSequence)text, (CharSequence)prefix)) {
                return true;
            }
            if (!caseSensitive) {
                return CharSequenceUtils.startsWithIgnoreCase((CharSequence)text, (CharSequence)prefix);
            }
            return false;
        }
    }
}

