/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SimpleDialogPanel
extends JPanel {
    private JTextComponent[] jTextComponents;
    private JLabel[] jLabels;
    private JButton[] jButtons;
    private GridBagConstraints gridBagConstraints;

    public SimpleDialogPanel(DialogDescriptor desc) {
        this.initComponents(desc.getLabels(), desc.isTextField(), desc.getSize(), desc.getButtons(), desc.getMnemonics(), desc.getA11yDesc(), desc.includesMnemonics);
        String[] initValues = desc.getInitValues();
        if (initValues != null) {
            for (int i = 0; i < initValues.length; ++i) {
                this.jTextComponents[i].setText(initValues[i]);
            }
        }
    }

    private void initComponents(String[] labels, boolean[] isTextField, int size, boolean[] customizers, char[] mnem, String[] a11yDesc, boolean includesMnemonics) {
        int i;
        this.setLayout(new GridBagLayout());
        this.jLabels = new JLabel[labels.length];
        this.jTextComponents = new JTextComponent[labels.length];
        for (i = 0; i < labels.length; ++i) {
            if (!includesMnemonics) {
                this.jLabels[i] = new JLabel(labels[i]);
            } else {
                this.jLabels[i] = new JLabel();
                Mnemonics.setLocalizedText((JLabel)this.jLabels[i], (String)labels[i]);
            }
            this.gridBagConstraints = new GridBagConstraints();
            this.gridBagConstraints.gridx = 0;
            this.gridBagConstraints.gridy = i;
            this.gridBagConstraints.insets = new Insets(5, 12, 0, 0);
            this.gridBagConstraints.anchor = isTextField[i] ? 17 : 18;
            this.add((Component)this.jLabels[i], this.gridBagConstraints);
        }
        for (i = 0; i < this.jTextComponents.length; ++i) {
            if (isTextField[i]) {
                this.jTextComponents[i] = new JTextField();
                ((JTextField)this.jTextComponents[i]).setColumns(size);
            } else {
                this.jTextComponents[i] = new JTextArea();
                ((JTextArea)this.jTextComponents[i]).setRows(3);
                ((JTextArea)this.jTextComponents[i]).setColumns(size);
            }
            this.gridBagConstraints = new GridBagConstraints();
            this.gridBagConstraints.gridx = 1;
            this.gridBagConstraints.gridy = i;
            this.gridBagConstraints.insets = new Insets(5, 12, 0, 11);
            this.gridBagConstraints.weightx = 1.0;
            this.jLabels[i].setLabelFor(this.jTextComponents[i]);
            if (isTextField[i]) {
                this.gridBagConstraints.fill = 2;
                this.add((Component)this.jTextComponents[i], this.gridBagConstraints);
                continue;
            }
            this.gridBagConstraints.weighty = 1.0;
            this.gridBagConstraints.fill = 1;
            JScrollPane sp = new JScrollPane(this.jTextComponents[i]);
            this.add((Component)sp, this.gridBagConstraints);
        }
        if (customizers != null) {
            ArrayList<JButton> buttonList = new ArrayList<JButton>();
            int j = 0;
            for (int i2 = 0; i2 < customizers.length; ++i2) {
                if (!customizers[i2]) continue;
                JButton button = new JButton();
                button.setText(NbBundle.getMessage(SimpleDialogPanel.class, (String)("LBL_browse" + String.valueOf(j))));
                button.setMnemonic(NbBundle.getMessage(SimpleDialogPanel.class, (String)("LBL_browse" + String.valueOf(j++) + "_mnem")).charAt(0));
                button.setMargin(new Insets(0, 14, 0, 14));
                button.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SimpleDialogPanel.class, (String)"ACSD_browse"));
                buttonList.add(button);
                this.gridBagConstraints = new GridBagConstraints();
                this.gridBagConstraints.gridx = 2;
                this.gridBagConstraints.gridy = i2;
                this.gridBagConstraints.insets = new Insets(3, 0, 0, 11);
                this.add((Component)button, this.gridBagConstraints);
            }
            this.jButtons = new JButton[buttonList.size()];
            buttonList.toArray(this.jButtons);
        }
        if (mnem != null && !"Aqua".equals(UIManager.getLookAndFeel().getID())) {
            for (int i3 = 0; i3 < labels.length; ++i3) {
                this.jLabels[i3].setLabelFor(this.jTextComponents[i3]);
                this.jLabels[i3].setDisplayedMnemonic(mnem[i3]);
            }
        }
        if (a11yDesc != null) {
            for (int i4 = 0; i4 < this.jTextComponents.length; ++i4) {
                this.jTextComponents[i4].getAccessibleContext().setAccessibleDescription(a11yDesc[i4]);
            }
        }
    }

    public String[] getValues() {
        if (this.jTextComponents == null) {
            return null;
        }
        String[] values = new String[this.jTextComponents.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.jTextComponents[i].getText();
        }
        return values;
    }

    public JButton[] getCustomizerButtons() {
        return this.jButtons;
    }

    public JTextComponent[] getTextComponents() {
        return this.jTextComponents;
    }

    JLabel[] getLabels() {
        return this.jLabels;
    }

    public static class DialogDescriptor {
        String[] labels;
        String[] initValues;
        boolean adding;
        boolean[] buttons;
        boolean[] textField;
        char[] mnem;
        String[] a11yDesc;
        int size;
        boolean includesMnemonics;

        public DialogDescriptor(String[] labels) {
            this(labels, false);
        }

        public DialogDescriptor(String[] labels, boolean includesMnemonics) {
            this.labels = labels;
            this.size = 25;
            this.adding = true;
            this.textField = new boolean[labels.length];
            for (int i = 0; i < labels.length; ++i) {
                this.textField[i] = true;
            }
            this.includesMnemonics = includesMnemonics;
        }

        public String[] getLabels() {
            return this.labels;
        }

        public void setButtons(boolean[] buttons) {
            this.buttons = buttons;
        }

        public boolean[] getButtons() {
            return this.buttons;
        }

        public void setTextField(boolean[] textField) {
            this.textField = textField;
        }

        public boolean[] isTextField() {
            return this.textField;
        }

        public void setInitValues(String[] initValues) {
            this.initValues = initValues;
            this.adding = false;
        }

        public String[] getInitValues() {
            return this.initValues;
        }

        public void setAdding(boolean adding) {
            this.adding = adding;
        }

        public boolean isAdding() {
            return this.adding;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public void setMnemonics(char[] mnem) {
            this.mnem = mnem;
        }

        public char[] getMnemonics() {
            return this.mnem;
        }

        public void setA11yDesc(String[] a11yDesc) {
            this.a11yDesc = a11yDesc;
        }

        public String[] getA11yDesc() {
            return this.a11yDesc;
        }
    }
}

