/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openidex.search.FileObjectFilter;

class SimpleSearchIterator
implements Iterator<FileObject> {
    private Enumeration<? extends FileObject> childrenEnum;
    private List<FileObjectFilter> filters;
    private List<FileObjectFilter> filtersCopy;
    private final boolean recursive;
    private boolean searchInArchives = false;
    private final List<Enumeration<? extends FileObject>> enums = new ArrayList<Enumeration<? extends FileObject>>();
    private final List<List<FileObjectFilter>> filterLists = new ArrayList<List<FileObjectFilter>>();
    private boolean upToDate = false;
    private FileObject nextObject;

    SimpleSearchIterator(DataFolder folder, boolean recursive, List<FileObjectFilter> filters) {
        this.childrenEnum = folder.getPrimaryFile().getChildren(false);
        this.recursive = recursive;
        this.filters = filters != null ? new ArrayList<FileObjectFilter>(filters) : null;
    }

    @Override
    public boolean hasNext() {
        if (!this.upToDate) {
            this.update();
        }
        return this.nextObject != null;
    }

    @Override
    public FileObject next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.upToDate = false;
        return this.nextObject;
    }

    private void update() {
        assert (!this.upToDate);
        assert (this.childrenEnum != null);
        do {
            if (this.childrenEnum.hasMoreElements()) {
                FileObject file = this.childrenEnum.nextElement();
                if (file.isFolder()) {
                    if (!this.recursive) continue;
                    this.processFolder(file);
                    continue;
                }
                if (FileUtil.isArchiveFile((FileObject)file) && this.recursive && this.searchInArchives) {
                    this.processFolder(FileUtil.getArchiveRoot((FileObject)file));
                }
                if (this.filters != null && !this.checkFileFilters(file)) continue;
                this.nextObject = file;
                break;
            }
            assert (this.enums.isEmpty() == this.filterLists.isEmpty());
            this.nextObject = null;
            if (this.enums.isEmpty()) {
                this.childrenEnum = null;
                continue;
            }
            this.childrenEnum = this.enums.remove(this.enums.size() - 1);
            this.filters = this.filterLists.remove(this.filterLists.size() - 1);
            if (this.filtersCopy == null || this.filtersCopy.size() == this.filters.size()) continue;
            this.filtersCopy = null;
        } while (this.childrenEnum != null);
        this.upToDate = true;
    }

    private void processFolder(FileObject folder) {
        if (this.filters != null) {
            List<FileObjectFilter> subfolderFilters = this.checkFolderFilters(folder);
            if (subfolderFilters == null) {
                return;
            }
            this.filterLists.add(this.filters);
            if (subfolderFilters.size() != this.filters.size()) {
                this.filters = !subfolderFilters.isEmpty() ? subfolderFilters : null;
            }
        } else {
            this.filterLists.add(null);
        }
        this.enums.add(this.childrenEnum);
        this.childrenEnum = folder.getChildren(false);
    }

    private List<FileObjectFilter> checkFolderFilters(FileObject folder) {
        assert (folder.isFolder());
        assert (this.filters != null);
        if (this.filtersCopy == null) {
            this.filtersCopy = new ArrayList<FileObjectFilter>(this.filters);
        }
        List<FileObjectFilter> result = this.filtersCopy;
        Iterator<FileObjectFilter> i = result.iterator();
        block5: while (i.hasNext()) {
            FileObjectFilter filter = i.next();
            int traverseCommand = filter.traverseFolder(folder);
            switch (traverseCommand) {
                case 1: {
                    continue block5;
                }
                case 0: {
                    result = null;
                    break block5;
                }
                case 2: {
                    i.remove();
                    this.filtersCopy = null;
                    continue block5;
                }
                default: {
                    assert (false);
                    continue block5;
                }
            }
        }
        return result;
    }

    private boolean checkFileFilters(FileObject file) {
        assert (!file.isFolder());
        assert (this.filters != null);
        for (FileObjectFilter filter : this.filters) {
            if (filter.searchFile(file)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

