/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ListenersImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;
import org.openide.util.Parameters;

public final class LibraryManager {
    private static final Map<Integer, LibraryManager> instances = new HashMap<Integer, LibraryManager>();
    private final int repositoryId;
    private final ConcurrentHashMap<LibraryKey, LibraryEntry> librariesEntries = new ConcurrentHashMap();
    private final Object lock = new Lock();

    public static LibraryManager getInstance(int sourceUnitId) {
        int repositoryId = Repository.getLayeringSupport((int)sourceUnitId).getStorageID();
        return LibraryManager.getInstanceByRepositoryId(repositoryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LibraryManager getInstanceByRepositoryId(int repositoryId) {
        Map<Integer, LibraryManager> map = instances;
        synchronized (map) {
            LibraryManager manager = instances.get(repositoryId);
            if (manager == null) {
                manager = new LibraryManager(repositoryId);
                instances.put(repositoryId, manager);
            }
            return manager;
        }
    }

    private LibraryManager(int repositoryId) {
        this.repositoryId = repositoryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Collection<LibraryManager> list;
        Map<Integer, LibraryManager> map = instances;
        synchronized (map) {
            list = instances.values();
        }
        for (LibraryManager manager : list) {
            manager.shutdownImpl();
        }
    }

    private void shutdownImpl() {
        this.librariesEntries.clear();
    }

    public List<LibProjectImpl> getLibraries(ProjectImpl project) {
        ArrayList<LibProjectImpl> res = new ArrayList<LibProjectImpl>();
        CsmUID<CsmProject> projectUid = project.getUID();
        for (LibraryEntry entry : this.librariesEntries.values()) {
            CsmUID library;
            CsmProject lib;
            if (!entry.containsProject((CsmUID<CsmProject>)projectUid) || !((lib = (CsmProject)(library = entry.getLibrary()).getObject()) instanceof LibProjectImpl)) continue;
            res.add((LibProjectImpl)lib);
        }
        return res;
    }

    public Collection<ProjectBase> getProjectsByLibrary(LibProjectImpl library) {
        LibraryKey libraryKey = new LibraryKey(library.getFileSystem(), library.getPath());
        LibraryEntry entry = this.librariesEntries.get(libraryKey);
        if (entry == null) {
            return Collections.emptyList();
        }
        Collection uids = entry.getDependentProjects();
        ArrayList<ProjectBase> projects = new ArrayList<ProjectBase>(uids.size());
        for (CsmUID uid : uids) {
            ProjectBase project = (ProjectBase)uid.getObject();
            if (project == null || project.isDisposing() || !project.isValid()) continue;
            projects.add(project);
        }
        return projects;
    }

    public Collection<CsmUID<CsmProject>> getLirariesKeys(CsmUID<CsmProject> projectUid) {
        ArrayList<CsmUID<CsmProject>> res = new ArrayList<CsmUID<CsmProject>>();
        for (LibraryEntry entry : this.librariesEntries.values()) {
            if (!entry.containsProject((CsmUID<CsmProject>)projectUid)) continue;
            res.add((CsmUID<CsmProject>)entry.getLibrary());
        }
        return res;
    }

    private void trace(String where, FileImpl curFile, ResolvedPath resolvedPath, ProjectBase res, ProjectBase start) {
        System.out.println("Resolved Path " + resolvedPath.getPath());
        System.out.println("    start project " + start);
        System.out.println("    found in " + where + " " + res);
        System.out.println("    included from " + curFile);
        System.out.println("    file from project " + curFile.getProject());
        for (CsmProject prj : start.getLibraries()) {
            System.out.println("    search lib " + prj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectBase resolveFileProjectOnInclude(ProjectBase baseProject, FileImpl curFile, ResolvedPath resolvedPath) {
        CharSequence absPath = resolvedPath.getPath();
        HashSet<ProjectBase> antiLoop = new HashSet<ProjectBase>();
        ProjectBase res = LibraryManager.searchInProjectFiles(baseProject, resolvedPath, antiLoop);
        if (res != null) {
            baseProject.prepareIncludeStorage(res);
            if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                this.trace("Projects", curFile, resolvedPath, res, baseProject);
            }
            return res;
        }
        CharSequence folder = resolvedPath.getFolder();
        antiLoop.clear();
        res = LibraryManager.searchInProjectRoots(baseProject, resolvedPath.getFileSystem(), this.getPathToFolder(folder, absPath), antiLoop);
        if (res != null) {
            baseProject.prepareIncludeStorage(res);
            if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                this.trace("Projects roots", curFile, resolvedPath, res, baseProject);
            }
            return res;
        }
        Collection libraries = baseProject.getLibraries();
        res = LibraryManager.searchInProjectFilesArtificial((List<CsmProject>)libraries, resolvedPath, antiLoop);
        if (res != null) {
            baseProject.prepareIncludeStorage(res);
            if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                this.trace("Libraries", curFile, resolvedPath, res, baseProject);
            }
            return res;
        }
        Object object = this.lock;
        synchronized (object) {
            antiLoop.clear();
            res = LibraryManager.searchInProjectRootsArtificial((List<CsmProject>)libraries, resolvedPath.getFileSystem(), this.getPathToFolder(folder, absPath), antiLoop);
            if (res == null) {
                if (resolvedPath.isDefaultSearchPath()) {
                    res = curFile.getProjectImpl(true);
                    if (res != null) {
                        if (resolvedPath.getFileSystem() == res.getFileSystem()) {
                            if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                                this.trace("Base Project as Default Search Path", curFile, resolvedPath, res, baseProject);
                            }
                        } else {
                            CndUtils.assertTrue((boolean)false, (String)("Wrong FS for " + resolvedPath + ": " + res.getFileSystem() + " vs " + resolvedPath.getFileSystem()));
                            res = null;
                        }
                    }
                } else if (!baseProject.isArtificial()) {
                    res = this.getLibrary((ProjectImpl)baseProject, resolvedPath.getFileSystem(), folder);
                    if (res == null && CndUtils.isDebugMode() && baseProject.isValid()) {
                        CndUtils.assertTrue((boolean)false, (String)("Can not create library; folder=" + folder + " curFile=" + curFile + " path=" + resolvedPath + " baseProject=" + baseProject));
                    }
                    if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                        this.trace("Library for folder " + folder, curFile, resolvedPath, res, baseProject);
                    }
                } else {
                    if (CndUtils.isDebugMode() && baseProject.isValid()) {
                        CndUtils.assertTrue((boolean)false, (String)"Can not get library for artificial project; ", (Object)("folder=" + folder + " curFile=" + curFile + " path=" + resolvedPath + " baseProject=" + baseProject));
                    }
                    if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                        this.trace("Base Project", curFile, resolvedPath, res, baseProject);
                    }
                }
            } else if (TraceFlags.TRACE_RESOLVED_LIBRARY) {
                this.trace("Libraries roots", curFile, resolvedPath, res, baseProject);
            }
        }
        if (res != null) {
            baseProject.prepareIncludeStorage(res);
        }
        return res;
    }

    private List<CharSequence> getPathToFolder(CharSequence folder, CharSequence path) {
        ArrayList<CharSequence> res = new ArrayList<CharSequence>(3);
        res.add(folder);
        if (CharSequenceUtils.startsWith((CharSequence)path, (CharSequence)folder)) {
            CharSequence dir;
            while ((dir = LibraryManager.getDirName(path)) != null && CharSequences.comparator().compare(folder, dir) != 0 && CharSequenceUtils.startsWith((CharSequence)dir, (CharSequence)folder)) {
                res.add(dir);
                if (res.size() == 3) break;
                path = dir;
            }
        }
        return res;
    }

    private static CharSequence getDirName(CharSequence path) {
        if (path == null) {
            return null;
        }
        int sep = CharSequenceUtils.lastIndexOf((CharSequence)(path = LibraryManager.trimRightSlashes(path)), (int)47);
        if (sep == -1) {
            sep = CharSequenceUtils.lastIndexOf((CharSequence)path, (int)92);
        }
        if (sep != -1) {
            return LibraryManager.trimRightSlashes(path.subSequence(0, sep));
        }
        return null;
    }

    private static CharSequence trimRightSlashes(CharSequence path) {
        int length = path.length();
        if (length > 0 && (path.charAt(length - 1) == '\\' || path.charAt(length - 1) == '/')) {
            path = path.subSequence(0, length - 1);
        }
        return path;
    }

    private static ProjectBase searchInProjectFiles(ProjectBase baseProject, ResolvedPath searchFor, Set<ProjectBase> set) {
        CsmProject prj;
        if (set.contains(baseProject)) {
            return null;
        }
        set.add(baseProject);
        if (baseProject.getFileSystem() == searchFor.getFileSystem()) {
            baseProject.ensureFilesCreated();
            CsmUID<CsmFile> file = baseProject.getFileUID(searchFor.getPath(), true);
            if (file != null) {
                return baseProject;
            }
        }
        Collection libraries = baseProject.getLibraries();
        Iterator iterator = libraries.iterator();
        while (iterator.hasNext() && !(prj = (CsmProject)iterator.next()).isArtificial()) {
            ProjectBase res = LibraryManager.searchInProjectFiles((ProjectBase)prj, searchFor, set);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private static ProjectBase searchInProjectFilesArtificial(List<CsmProject> libraries, ResolvedPath searchFor, Set<ProjectBase> antiLoop) {
        for (CsmProject prj : libraries) {
            if (!prj.isArtificial()) continue;
            antiLoop.clear();
            ProjectBase res = LibraryManager.searchInProjectFiles((ProjectBase)prj, searchFor, antiLoop);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private static ProjectBase searchInProjectRoots(ProjectBase baseProject, FileSystem fs, List<CharSequence> folders, Set<ProjectBase> set) {
        CsmProject prj;
        if (set.contains(baseProject)) {
            return null;
        }
        set.add(baseProject);
        if (baseProject.getFileSystem() == fs) {
            for (CharSequence folder : folders) {
                if (!baseProject.isMySource(folder)) continue;
                return baseProject;
            }
        }
        Collection libraries = baseProject.getLibraries();
        Iterator iterator = libraries.iterator();
        while (iterator.hasNext() && !(prj = (CsmProject)iterator.next()).isArtificial()) {
            ProjectBase res = LibraryManager.searchInProjectRoots((ProjectBase)prj, fs, folders, set);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    private static ProjectBase searchInProjectRootsArtificial(List<CsmProject> libraries, FileSystem fs, List<CharSequence> folders, Set<ProjectBase> set) {
        ProjectBase candidate = null;
        for (CsmProject prj : libraries) {
            if (!prj.isArtificial()) continue;
            set.clear();
            ProjectBase res = LibraryManager.searchInProjectRoots((ProjectBase)prj, fs, folders, set);
            if (res == null) continue;
            if (candidate == null) {
                candidate = res;
                continue;
            }
            CharSequence path1 = ((LibProjectImpl)candidate).getPath();
            CharSequence path2 = ((LibProjectImpl)res).getPath();
            if (path2.length() <= path1.length()) continue;
            candidate = res;
        }
        return candidate;
    }

    private LibProjectImpl getLibrary(ProjectImpl project, FileSystem fs, CharSequence folder) {
        CsmUID<CsmProject> projectUid = project.getUID();
        LibraryKey libraryKey = new LibraryKey(fs, folder);
        LibraryEntry entry = this.librariesEntries.get(libraryKey);
        if (entry == null) {
            if (!project.isValid()) {
                return null;
            }
            entry = this.getOrCreateLibrary(libraryKey);
        }
        if (!entry.containsProject((CsmUID<CsmProject>)projectUid)) {
            entry.addProject((CsmUID<CsmProject>)projectUid);
            Notificator.instance().registerChangedLibraryDependency(project);
            Notificator.instance().flush();
        }
        return (LibProjectImpl)entry.getLibrary().getObject();
    }

    private LibraryEntry getOrCreateLibrary(LibraryKey libraryKey) {
        LibraryEntry entry = this.librariesEntries.get(libraryKey);
        if (entry == null) {
            boolean needFire = false;
            entry = new LibraryEntry(libraryKey);
            LibraryEntry old = this.librariesEntries.putIfAbsent(libraryKey, entry);
            if (old == null) {
                needFire = true;
            } else {
                entry = old;
            }
            if (needFire) {
                final LibraryEntry passEntry = entry;
                ModelImpl.instance().enqueueModelTask(new Runnable(){

                    @Override
                    public void run() {
                        ListenersImpl.getImpl().fireProjectOpened((ProjectBase)passEntry.getLibrary().getObject());
                    }
                }, "postponed library opened " + libraryKey.folder);
            }
        }
        return entry;
    }

    public void onProjectPropertyChanged(ProjectBase project) {
        project.getGraph().clear();
        CsmUID<CsmProject> uid = project.getUID();
        boolean notify = false;
        for (LibraryEntry entry : this.librariesEntries.values()) {
            Boolean removed = entry.removeProject((CsmUID<CsmProject>)uid);
            if (removed == null) continue;
            project.invalidateLibraryStorage((CsmUID<CsmProject>)entry.libraryUID);
            notify = true;
        }
        if (notify) {
            Notificator.instance().registerChangedLibraryDependency(project);
            Notificator.instance().flush();
        }
    }

    public void onProjectClose(CsmUID<CsmProject> project, boolean cleanRepository) {
        ArrayList<LibraryEntry> toClose = new ArrayList<LibraryEntry>();
        for (LibraryEntry entry : this.librariesEntries.values()) {
            entry.removeProject((CsmUID<CsmProject>)project);
            if (!entry.isEmpty()) continue;
            toClose.add(entry);
        }
        if (toClose.size() > 0) {
            for (LibraryEntry entry : toClose) {
                this.librariesEntries.remove(entry.getKey());
            }
        }
        this.closeLibraries(toClose, cleanRepository);
    }

    static void cleanLibrariesData(Collection<LibProjectImpl> libs) {
        HashMap<Integer, ArrayList<LibProjectImpl>> map = new HashMap<Integer, ArrayList<LibProjectImpl>>();
        for (LibProjectImpl libProjectImpl : libs) {
            int unitID = libProjectImpl.getUnitId();
            int repoId = Repository.getLayeringSupport((int)unitID).getStorageID();
            ArrayList<LibProjectImpl> coll = (ArrayList<LibProjectImpl>)map.get(repoId);
            if (coll == null) {
                coll = new ArrayList<LibProjectImpl>();
                map.put(repoId, coll);
            }
            coll.add(libProjectImpl);
        }
        for (Map.Entry entry : map.entrySet()) {
            LibraryManager.getInstanceByRepositoryId((Integer)entry.getKey()).cleanLibrariesDataImpl((Collection)entry.getValue());
        }
    }

    private void cleanLibrariesDataImpl(Collection<LibProjectImpl> libs) {
        for (LibProjectImpl entry : libs) {
            this.librariesEntries.remove(new LibraryKey(entry.getFileSystem(), entry.getPath()));
            entry.dispose(true);
        }
    }

    private void closeLibraries(Collection<LibraryEntry> entries, boolean cleanRepository) {
        ModelImpl model = (ModelImpl)CsmModelAccessor.getModel();
        for (LibraryEntry entry : entries) {
            CsmUID uid = entry.getLibrary();
            ProjectBase lib = (ProjectBase)uid.getObject();
            assert (lib != null) : "Null project for UID " + uid;
            model.disposeProject(lib, cleanRepository);
        }
    }

    void writeProjectLibraries(CsmUID<CsmProject> project, RepositoryDataOutput aStream) throws IOException {
        assert (aStream != null);
        HashSet<LibraryKey> keys = new HashSet<LibraryKey>();
        for (Map.Entry<LibraryKey, LibraryEntry> entry : this.librariesEntries.entrySet()) {
            if (!entry.getValue().containsProject((CsmUID<CsmProject>)project)) continue;
            keys.add(entry.getKey());
        }
        aStream.writeInt(keys.size());
        for (LibraryKey libraryKey : keys) {
            libraryKey.write(aStream);
        }
    }

    void readProjectLibraries(CsmUID<CsmProject> project, RepositoryDataInput input) throws IOException {
        assert (input != null);
        int len = input.readInt();
        if (len != -1) {
            for (int i = 0; i < len; ++i) {
                LibraryKey key = new LibraryKey(input);
                LibraryEntry entry = this.getOrCreateLibrary(key);
                entry.addProject((CsmUID<CsmProject>)project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpInfo(PrintWriter printOut, boolean withContainers) {
        Collection<LibraryManager> list;
        Map<Integer, LibraryManager> map = instances;
        synchronized (map) {
            list = instances.values();
        }
        for (LibraryManager manager : list) {
            manager.dumpInfoImpl(printOut, withContainers);
        }
    }

    private void dumpInfoImpl(PrintWriter printOut, boolean withContainers) {
        printOut.printf("LibraryManager [%d]: libs=%d%n", this.repositoryId, this.librariesEntries.size());
        int ind = 1;
        for (Map.Entry<LibraryKey, LibraryEntry> entry : this.librariesEntries.entrySet()) {
            printOut.printf("Lib[%d] %s with LibEntry %s%n", ind++, entry.getKey(), entry.getValue());
            if (!withContainers) continue;
            CsmProject library = UIDCsmConverter.UIDtoProject((CsmUID<CsmProject>)entry.getValue().libraryUID);
            if (library == null) {
                printOut.printf("Library was NOT restored from repository%n", new Object[0]);
                continue;
            }
            if (library instanceof ProjectBase) {
                printOut.printf("[%d] disposing=%s%n", ind, ((ProjectBase)library).isDisposing());
                ProjectBase.dumpFileContainer(library, printOut);
                continue;
            }
            printOut.printf("Library's project has unexpected class type %s%n", library.getClass().getName());
        }
        printOut.flush();
    }

    private final class LibraryEntry {
        private final LibraryKey key;
        private volatile CsmUID<CsmProject> libraryUID;
        private final ConcurrentMap<CsmUID<CsmProject>, Boolean> dependentProjects;

        private LibraryEntry(LibraryKey folder) {
            this.key = folder;
            this.dependentProjects = new ConcurrentHashMap<CsmUID<CsmProject>, Boolean>();
        }

        private CharSequence getFolder() {
            return this.key.folder;
        }

        private FileSystem getFileSystem() {
            return this.key.fileSystem;
        }

        public LibraryKey getKey() {
            return this.key;
        }

        private CsmUID<CsmProject> getLibrary() {
            if (this.libraryUID == null) {
                this.createUID();
            }
            assert (this.libraryUID != null) : "libraryUID is null for folder " + this.getFolder();
            return this.libraryUID;
        }

        private synchronized void createUID() {
            if (this.libraryUID == null) {
                ModelImpl model = (ModelImpl)CsmModelAccessor.getModel();
                LibProjectImpl library = LibProjectImpl.createInstance(model, this.getFileSystem(), this.getFolder(), LibraryManager.this.repositoryId);
                this.libraryUID = library.getUID();
            }
        }

        private boolean isEmpty() {
            return this.dependentProjects.size() == 0;
        }

        private boolean containsProject(CsmUID<CsmProject> project) {
            return this.dependentProjects.containsKey(project);
        }

        private Collection<CsmUID<CsmProject>> getDependentProjects() {
            return this.dependentProjects.keySet();
        }

        private void addProject(CsmUID<CsmProject> project) {
            this.dependentProjects.put(project, Boolean.TRUE);
        }

        private Boolean removeProject(CsmUID<CsmProject> project) {
            return (Boolean)this.dependentProjects.remove(project);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("folder=").append(this.key).append(",\nlibraryUID=").append(this.libraryUID);
            if (this.dependentProjects.isEmpty()) {
                sb.append(" NO DEPENDENT PROJECTS!");
            } else {
                sb.append("\ndependentProjects=");
                for (CsmUID csmUID : this.dependentProjects.keySet()) {
                    sb.append("\n(").append(System.identityHashCode(csmUID)).append(")").append(csmUID);
                }
            }
            return sb.toString();
        }
    }

    private static final class LibraryKey {
        private final FileSystem fileSystem;
        private final CharSequence folder;

        public LibraryKey(FileSystem fileSystem, CharSequence folder) {
            Parameters.notNull((CharSequence)"fileSystem", (Object)fileSystem);
            this.fileSystem = fileSystem;
            this.folder = folder;
        }

        private LibraryKey(RepositoryDataInput input) throws IOException {
            this.fileSystem = PersistentUtils.readFileSystem(input);
            assert (this.fileSystem != null);
            this.folder = input.readFilePathForFileSystem(this.fileSystem);
        }

        private void write(RepositoryDataOutput out) throws IOException {
            PersistentUtils.writeFileSystem(this.fileSystem, out);
            out.writeFilePathForFileSystem(this.fileSystem, this.folder);
        }

        public int hashCode() {
            int hash = 3;
            hash = 17 * hash + Objects.hashCode(this.fileSystem);
            hash = 17 * hash + Objects.hashCode(this.folder);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LibraryKey other = (LibraryKey)obj;
            if (!Objects.equals(this.fileSystem, other.fileSystem)) {
                return false;
            }
            return Objects.equals(this.folder, other.folder);
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

