/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.BaseBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.Utils;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

final class BorderBuilders {
    BorderBuilders() {
    }

    static BorderBuilder fromField(Instance instance, String field, boolean uiresource, Heap heap) {
        Object _border = instance.getValueOfField(field);
        if (!(_border instanceof Instance)) {
            return null;
        }
        Instance border = (Instance)_border;
        if (DetailsUtils.isSubclassOf(border, BevelBorder.class.getName())) {
            return new BevelBorderBuilder(border, heap);
        }
        if (DetailsUtils.isSubclassOf(border, MatteBorder.class.getName())) {
            return new EmptyBorderBuilder(border, heap);
        }
        if (DetailsUtils.isSubclassOf(border, EmptyBorder.class.getName())) {
            return new MatteBorderBuilder(border, heap);
        }
        if (DetailsUtils.isSubclassOf(border, EtchedBorder.class.getName())) {
            return new EtchedBorderBuilder(border, heap);
        }
        if (DetailsUtils.isSubclassOf(border, LineBorder.class.getName())) {
            return new LineBorderBuilder(border, heap);
        }
        if (DetailsUtils.isSubclassOf(border, TitledBorder.class.getName())) {
            return new TitledBorderBuilder(border, heap);
        }
        if (DetailsUtils.isSubclassOf(border, CompoundBorder.class.getName())) {
            return new CompoundBorderBuilder(border, heap);
        }
        return null;
    }

    private static class CompoundBorderBuilder
    extends BorderBuilder {
        private final BorderBuilder outsideBorder;
        private final BorderBuilder insideBorder;

        CompoundBorderBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.outsideBorder = BorderBuilders.fromField(instance, "outsideBorder", true, heap);
            this.insideBorder = BorderBuilders.fromField(instance, "insideBorder", true, heap);
        }

        @Override
        protected Border createInstanceImpl() {
            Border inside;
            Border outside = this.outsideBorder == null || this.outsideBorder.isUIResource() ? null : (Border)this.outsideBorder.createInstance();
            Border border = inside = this.insideBorder == null || this.insideBorder.isUIResource() ? null : (Border)this.insideBorder.createInstance();
            if (outside == null && inside == null) {
                return BorderFactory.createEmptyBorder();
            }
            if (outside == null || inside == null) {
                if (outside == null) {
                    return inside;
                }
                return outside;
            }
            return BorderFactory.createCompoundBorder(outside, inside);
        }
    }

    private static class TitledBorderBuilder
    extends BorderBuilder {
        private final String title;
        private final BorderBuilder border;
        private final int titlePosition;
        private final int titleJustification;
        private final BaseBuilders.FontBuilder titleFont;
        private final BaseBuilders.ColorBuilder titleColor;

        TitledBorderBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.title = Utils.getFieldString(instance, "title");
            this.border = BorderBuilders.fromField(instance, "border", false, heap);
            this.titlePosition = DetailsUtils.getIntFieldValue(instance, "titlePosition", 0);
            this.titleJustification = DetailsUtils.getIntFieldValue(instance, "titleJustification", 4);
            this.titleFont = BaseBuilders.FontBuilder.fromField(instance, "titleFont", heap);
            this.titleColor = BaseBuilders.ColorBuilder.fromField(instance, "titleColor", heap);
        }

        @Override
        protected Border createInstanceImpl() {
            Font font = this.titleFont == null || this.titleFont.isUIResource() ? null : (Font)this.titleFont.createInstance();
            Color color = this.titleColor == null || this.titleColor.isUIResource() ? null : (Color)this.titleColor.createInstance();
            return new TitledBorder(this.border == null ? null : (Border)this.border.createInstance(), this.title, this.titleJustification, this.titlePosition, font, color);
        }
    }

    private static class LineBorderBuilder
    extends BorderBuilder {
        private final int thickness;
        private final BaseBuilders.ColorBuilder lineColor;
        private final boolean roundedCorners;

        LineBorderBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.thickness = DetailsUtils.getIntFieldValue(instance, "thickness", 1);
            this.lineColor = BaseBuilders.ColorBuilder.fromField(instance, "lineColor", heap);
            this.roundedCorners = DetailsUtils.getBooleanFieldValue(instance, "roundedCorners", false);
        }

        @Override
        protected Border createInstanceImpl() {
            Color c;
            Color color = c = this.lineColor == null ? null : (Color)this.lineColor.createInstance();
            if (c == null) {
                c = Color.BLACK;
            }
            if (this.roundedCorners) {
                return new LineBorder(c, this.thickness, this.roundedCorners);
            }
            if (this.thickness == 1) {
                return BorderFactory.createLineBorder(c);
            }
            return BorderFactory.createLineBorder(c, this.thickness);
        }
    }

    private static class EtchedBorderBuilder
    extends BorderBuilder {
        private final int etchType;
        private final BaseBuilders.ColorBuilder highlight;
        private final BaseBuilders.ColorBuilder shadow;

        EtchedBorderBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.etchType = DetailsUtils.getIntFieldValue(instance, "etchType", 1);
            this.highlight = BaseBuilders.ColorBuilder.fromField(instance, "highlight", heap);
            this.shadow = BaseBuilders.ColorBuilder.fromField(instance, "shadow", heap);
        }

        @Override
        protected Border createInstanceImpl() {
            if (this.highlight == null && this.shadow == null) {
                return BorderFactory.createEtchedBorder(this.etchType);
            }
            return BorderFactory.createEtchedBorder(this.etchType, this.highlight == null ? null : (Color)this.highlight.createInstance(), this.shadow == null ? null : (Color)this.shadow.createInstance());
        }
    }

    private static class MatteBorderBuilder
    extends BorderBuilder {
        private final BaseBuilders.InsetsBuilder insets;
        private final BaseBuilders.ColorBuilder color;
        private final BaseBuilders.IconBuilder tileIcon;

        MatteBorderBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.insets = new BaseBuilders.InsetsBuilder(instance, heap);
            this.color = BaseBuilders.ColorBuilder.fromField(instance, "color", heap);
            this.tileIcon = BaseBuilders.IconBuilder.fromField(instance, "tileIcon", heap);
        }

        @Override
        protected Border createInstanceImpl() {
            Insets i = (Insets)this.insets.createInstance();
            if (this.color == null) {
                return BorderFactory.createMatteBorder(i.top, i.left, i.bottom, i.right, this.tileIcon == null ? null : (Icon)this.tileIcon.createInstance());
            }
            return BorderFactory.createMatteBorder(i.top, i.left, i.bottom, i.right, (Color)this.color.createInstance());
        }
    }

    private static class EmptyBorderBuilder
    extends BorderBuilder {
        private final BaseBuilders.InsetsBuilder insets;

        EmptyBorderBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.insets = new BaseBuilders.InsetsBuilder(instance, heap);
        }

        @Override
        protected Border createInstanceImpl() {
            Insets i = (Insets)this.insets.createInstance();
            if (i.top == 0 && i.left == 0 && i.bottom == 0 && i.right == 0) {
                return BorderFactory.createEmptyBorder();
            }
            return BorderFactory.createEmptyBorder(i.top, i.left, i.bottom, i.right);
        }
    }

    private static class BevelBorderBuilder
    extends BorderBuilder {
        private final int bevelType;
        private final BaseBuilders.ColorBuilder highlightOuter;
        private final BaseBuilders.ColorBuilder highlightInner;
        private final BaseBuilders.ColorBuilder shadowInner;
        private final BaseBuilders.ColorBuilder shadowOuter;

        BevelBorderBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.bevelType = DetailsUtils.getIntFieldValue(instance, "bevelType", 1);
            this.highlightOuter = BaseBuilders.ColorBuilder.fromField(instance, "highlightOuter", heap);
            this.highlightInner = BaseBuilders.ColorBuilder.fromField(instance, "highlightInner", heap);
            this.shadowInner = BaseBuilders.ColorBuilder.fromField(instance, "shadowInner", heap);
            this.shadowOuter = BaseBuilders.ColorBuilder.fromField(instance, "shadowOuter", heap);
        }

        @Override
        protected Border createInstanceImpl() {
            if (this.highlightOuter == null && this.shadowInner == null) {
                if (this.highlightInner == null && this.shadowOuter == null) {
                    return BorderFactory.createBevelBorder(this.bevelType);
                }
                return BorderFactory.createBevelBorder(this.bevelType, (Color)this.highlightInner.createInstance(), (Color)this.shadowOuter.createInstance());
            }
            return BorderFactory.createBevelBorder(this.bevelType, (Color)this.highlightOuter.createInstance(), (Color)this.highlightInner.createInstance(), (Color)this.shadowOuter.createInstance(), (Color)this.shadowInner.createInstance());
        }
    }

    static abstract class BorderBuilder
    extends Utils.InstanceBuilder<Border> {
        private final boolean isUIResource;

        BorderBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.isUIResource = instance.getJavaClass().getName().startsWith("javax.swing.plaf.BorderUIResource$");
        }

        boolean isUIResource() {
            return this.isUIResource;
        }
    }
}

