/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.macroview;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionTopComponent;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionViewUtils;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.IndexingAwareParserResultTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.netbeans.modules.parsing.spi.support.CancelSupport;
import org.openide.filesystems.FileObject;

public final class MacroExpansionCaretAwareFactory
extends IndexingAwareParserResultTask<Parser.Result> {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.cnd.model.tasks");
    private final CancelSupport cancel = CancelSupport.create((SchedulerTask)this);
    private AtomicBoolean canceled = new AtomicBoolean(false);

    public MacroExpansionCaretAwareFactory(String mimeType) {
        super(TaskIndexingMode.ALLOWED_DURING_SCAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Parser.Result result, SchedulerEvent event) {
        MacroExpansionCaretAwareFactory macroExpansionCaretAwareFactory = this;
        synchronized (macroExpansionCaretAwareFactory) {
            this.canceled.set(true);
            this.canceled = new AtomicBoolean(false);
        }
        if (this.cancel.isCancelled()) {
            return;
        }
        if (!(event instanceof CursorMovedSchedulerEvent)) {
            return;
        }
        if (!MacroExpansionTopComponent.isMacroExpansionInitialized()) {
            return;
        }
        Document doc = result.getSnapshot().getSource().getDocument(false);
        if (!(doc instanceof StyledDocument)) {
            return;
        }
        CsmFile csmFile = CsmFileInfoQuery.getDefault().getCsmFile(result);
        if (csmFile == null) {
            csmFile = (CsmFile)doc.getProperty(CsmFile.class);
        }
        if (csmFile == null) {
            return;
        }
        if (this.canceled.get()) {
            return;
        }
        long time = 0L;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "MacroExpansionCaretAwareFactory started");
            time = System.currentTimeMillis();
        }
        this.runImpl((CursorMovedSchedulerEvent)event, csmFile, doc, this.canceled);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "MacroExpansionCaretAwareFactory finished for {0}ms", System.currentTimeMillis() - time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        MacroExpansionCaretAwareFactory macroExpansionCaretAwareFactory = this;
        synchronized (macroExpansionCaretAwareFactory) {
            this.canceled.set(true);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "MacroExpansionCaretAwareFactory cancelled");
        }
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public int getPriority() {
        return 400;
    }

    private void runImpl(final CursorMovedSchedulerEvent event, CsmFile csmFile, final Document doc, final AtomicBoolean canceled) {
        if (doc == null) {
            return;
        }
        Object obj = doc.getProperty("use-own-caret-position");
        if (obj != null && !((Boolean)obj).booleanValue()) {
            return;
        }
        Runnable syncPositions = new Runnable(){

            @Override
            public void run() {
                if (!canceled.get()) {
                    MacroExpansionCaretAwareFactory.this.syncRelatedDocumentCaretPosition(event, doc);
                }
            }
        };
        if (MacroExpansionCaretAwareFactory.isMacroExpansionDoc(doc)) {
            SwingUtilities.invokeLater(syncPositions);
        } else {
            MacroExpansionViewUtils.updateView(doc, event.getCaretOffset(), csmFile, canceled, syncPositions);
        }
    }

    private static boolean isMacroExpansionDoc(Document doc) {
        return doc.getProperty("macro-expansion-view-document") != null;
    }

    private void syncRelatedDocumentCaretPosition(CursorMovedSchedulerEvent event, Document doc) {
        Document doc2;
        if (!MacroExpansionTopComponent.isSyncCaretAndContext()) {
            return;
        }
        if (doc != null && (doc2 = (Document)doc.getProperty(Document.class)) != null) {
            FileObject file2;
            JTextComponent comp2 = null;
            for (JTextComponent comp : EditorRegistry.componentList()) {
                if (!doc2.equals(comp.getDocument())) continue;
                comp2 = comp;
                break;
            }
            if ((file2 = CsmUtilities.getFileObject((Document)doc2)) != null && comp2 != null) {
                int doc2CarretPosition = comp2.getCaretPosition();
                int docCarretPosition = event.getCaretOffset();
                int doc2CarretPositionFromDoc = MacroExpansionViewUtils.getDocumentOffset(doc2, MacroExpansionViewUtils.getFileOffset(doc, docCarretPosition));
                int docCarretPositionFromDoc2 = MacroExpansionViewUtils.getDocumentOffset(doc, MacroExpansionViewUtils.getFileOffset(doc2, doc2CarretPosition));
                if (doc2CarretPositionFromDoc >= 0 && doc2CarretPositionFromDoc < doc2.getLength()) {
                    JEditorPane ep = MacroExpansionViewUtils.getEditor(doc);
                    JEditorPane ep2 = MacroExpansionViewUtils.getEditor(doc2);
                    if (ep != null && ep2 != null && doc2CarretPosition != doc2CarretPositionFromDoc && docCarretPosition != docCarretPositionFromDoc2) {
                        ep2.setCaretPosition(doc2CarretPositionFromDoc);
                    }
                }
            }
        }
    }

    public static final class MacroExpansionCaretAwareFactoryImpl
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singletonList(new MacroExpansionCaretAwareFactory(snapshot.getMimeType()));
        }
    }
}

