/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring;

import java.util.Collections;
import java.util.Set;
import javax.swing.text.JTextComponent;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.ASTUtils;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.ElementUtils;
import org.netbeans.modules.groovy.editor.api.FindTypeUtils;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.groovy.refactoring.findusages.model.ClassRefactoringElement;
import org.netbeans.modules.groovy.refactoring.findusages.model.MethodRefactoringElement;
import org.netbeans.modules.groovy.refactoring.findusages.model.RefactoringElement;
import org.netbeans.modules.groovy.refactoring.findusages.model.VariableRefactoringElement;
import org.netbeans.modules.groovy.refactoring.utils.FindMethodUtils;
import org.netbeans.modules.groovy.refactoring.utils.FindPossibleMethods;
import org.netbeans.modules.groovy.refactoring.utils.GroovyProjectUtil;
import org.netbeans.modules.groovy.refactoring.utils.TypeResolver;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

public abstract class RefactoringTask
extends UserTask
implements Runnable {
    private RefactoringTask() {
    }

    public abstract boolean isValid();

    protected static abstract class NodeToElementTask
    extends RefactoringTask {
        private final FileObject fileObject;
        private RefactoringUI ui;

        protected NodeToElementTask(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        @Override
        public boolean isValid() {
            try {
                ParserManager.parse(Collections.singleton(Source.create((FileObject)this.fileObject)), (UserTask)this);
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            GroovyParserResult parserResult = ASTUtils.getParseResult((Parser.Result)resultIterator.getParserResult());
            ModuleNode root = ASTUtils.getRoot((ParserResult)parserResult);
            if (root == null) {
                return;
            }
            ClassRefactoringElement element = new ClassRefactoringElement(this.fileObject, (ASTNode)root);
            if (((RefactoringElement)element).getName() != null) {
                this.ui = this.createRefactoringUI(element, parserResult);
            }
            if (this.ui == null) {
                throw new IllegalStateException();
            }
        }

        @Override
        public final void run() {
            try {
                ParserManager.parse(Collections.singleton(Source.create((FileObject)this.fileObject)), (UserTask)this);
            }
            catch (Exception ex) {
                return;
            }
            UI.openRefactoringUI((RefactoringUI)this.ui);
        }

        protected abstract RefactoringUI createRefactoringUI(RefactoringElement var1, GroovyParserResult var2);
    }

    protected static abstract class TextComponentTask
    extends RefactoringTask {
        private final FileObject fileObject;
        private JTextComponent textC;
        private RefactoringUI ui;

        protected TextComponentTask(EditorCookie ec, FileObject fileObject) {
            this.textC = ec.getOpenedPanes()[0];
            this.fileObject = fileObject;
            assert (this.textC != null);
            assert (this.textC.getCaretPosition() != -1);
            assert (this.textC.getSelectionStart() != -1);
            assert (this.textC.getSelectionEnd() != -1);
        }

        @Override
        public boolean isValid() {
            try {
                ParserManager.parse(Collections.singleton(Source.create((FileObject)this.fileObject)), (UserTask)this);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
            catch (AssertionError error) {
                return false;
            }
        }

        public void run(ResultIterator resultIterator) throws Exception {
            AstPath path;
            ASTNode findingNode;
            GroovyParserResult parserResult = ASTUtils.getParseResult((Parser.Result)resultIterator.getParserResult());
            ModuleNode root = ASTUtils.getRoot((ParserResult)parserResult);
            if (root == null) {
                throw new IllegalStateException("Not possible to get correct AST!");
            }
            int caret = this.textC.getCaretPosition();
            int start = this.textC.getSelectionStart();
            int end = this.textC.getSelectionEnd();
            BaseDocument doc = GroovyProjectUtil.getDocument((ParserResult)parserResult, this.fileObject);
            ElementKind kind = (findingNode = FindTypeUtils.findCurrentNode((AstPath)(path = new AstPath((ASTNode)root, caret, doc)), (BaseDocument)doc, (int)caret)) instanceof PackageNode ? ElementKind.PACKAGE : ElementUtils.getKind((AstPath)path, (BaseDocument)doc, (int)caret);
            RefactoringElement element = this.createRefactoringElement(path, findingNode, kind);
            if (element == null || element.getName() == null || element.getFileObject() == null) {
                throw new IllegalStateException("RefactoringElement isn't initiated correctly!");
            }
            this.ui = this.createRefactoringUI(element, start, end, parserResult);
        }

        private RefactoringElement createRefactoringElement(AstPath path, ASTNode currentNode, ElementKind kind) {
            switch (kind) {
                case CLASS: 
                case INTERFACE: {
                    if (currentNode instanceof VariableExpression) {
                        return new ClassRefactoringElement(this.fileObject, (ASTNode)TypeResolver.resolveType(path, this.fileObject));
                    }
                    return new ClassRefactoringElement(this.fileObject, currentNode);
                }
                case METHOD: 
                case CONSTRUCTOR: {
                    ASTNode leaf = path.leaf();
                    ASTNode leafParent = path.leafParent();
                    if (leaf instanceof MethodNode || leaf instanceof ConstructorNode) {
                        return new MethodRefactoringElement(this.fileObject, leaf, ElementUtils.getDeclaringClass((ASTNode)leaf));
                    }
                    if (leaf instanceof ConstructorCallExpression) {
                        ConstructorCallExpression constructorCall = (ConstructorCallExpression)leaf;
                        return new ClassRefactoringElement(this.fileObject, (ASTNode)constructorCall.getType());
                    }
                    if (leaf instanceof ConstantExpression && leafParent instanceof MethodCallExpression) {
                        MethodNode methodNode = FindMethodUtils.findMethod(path, (MethodCallExpression)leafParent);
                        ClassNode methodType = FindMethodUtils.findMethodType(path, (MethodCallExpression)leafParent);
                        String methodName = ((ConstantExpression)leaf).getText();
                        if (methodType != null) {
                            if (methodNode != null) {
                                return new MethodRefactoringElement(this.fileObject, (ASTNode)methodNode, methodType);
                            }
                            Set<MethodNode> possibleMethods = FindPossibleMethods.findPossibleMethods(this.fileObject, methodType.getName(), methodName);
                            if (possibleMethods.size() > 0) {
                                return new MethodRefactoringElement(this.fileObject, (ASTNode)possibleMethods.iterator().next(), methodType);
                            }
                        } else {
                            return null;
                        }
                    }
                    assert (false);
                }
                case VARIABLE: {
                    ClassNode variableType = TypeResolver.resolveType(path, this.fileObject);
                    return new VariableRefactoringElement(this.fileObject, variableType, currentNode.getText());
                }
                case PROPERTY: 
                case FIELD: {
                    if (currentNode instanceof ClassNode) {
                        return new ClassRefactoringElement(this.fileObject, currentNode);
                    }
                    if (currentNode instanceof FieldNode) {
                        FieldNode field = (FieldNode)currentNode;
                        return new VariableRefactoringElement(this.fileObject, field.getOwner(), field.getName());
                    }
                    if (!(currentNode instanceof PropertyNode)) break;
                    FieldNode field = ((PropertyNode)currentNode).getField();
                    return new VariableRefactoringElement(this.fileObject, field.getOwner(), field.getName());
                }
            }
            throw new IllegalStateException("Unknown element kind. Refactoring shouldn't be enabled in this context !");
        }

        @Override
        public final void run() {
            try {
                ParserManager.parse(Collections.singleton(Source.create((FileObject)this.fileObject)), (UserTask)this);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)TopComponent.getRegistry().getActivated());
        }

        protected abstract RefactoringUI createRefactoringUI(RefactoringElement var1, int var2, int var3, GroovyParserResult var4);
    }
}

