/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.server.parser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.glassfish.tooling.logging.Logger;
import org.netbeans.modules.glassfish.tooling.server.parser.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class TreeParser
extends DefaultHandler {
    static final String PATH_SEPARATOR = "/";
    private static final Logger LOGGER = new Logger(TreeParser.class);
    private static final boolean isFinestLoggable = LOGGER.isLoggable(Level.FINEST);
    private static final boolean isFinerLoggable = LOGGER.isLoggable(Level.FINER);
    private static final EntityResolver DUMMY_RESOLVER = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String string, String string1) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    };
    private final Node root;
    private Node rover;
    private String skipping;
    private int depth;
    private NodeListener childNodeReader;

    public static boolean readXml(File xmlFile, XMLReader ... pathList) {
        return TreeParser.readXml(xmlFile, null, pathList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean readXml(File xmlFile, Charset charset, XMLReader ... pathList) {
        String METHOD = "readXml";
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            SAXParser saxParser = factory.newSAXParser();
            org.xml.sax.XMLReader reader = saxParser.getXMLReader();
            reader.setEntityResolver(DUMMY_RESOLVER);
            TreeParser handler = new TreeParser(pathList);
            reader.setContentHandler(handler);
            if (charset == null) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(xmlFile));
                try {
                    reader.parse(new InputSource(is));
                    boolean bl = true;
                    return bl;
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.INFO, "readXml", "cantClose", ex);
                    }
                }
            }
            InputStreamReader r = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(xmlFile)), charset);
            try {
                reader.parse(new InputSource(r));
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    ((Reader)r).close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, "readXml", "cantClose", ex);
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.log(Level.INFO, null, ex);
            return false;
        }
    }

    public static boolean readXml(URL xmlFile, XMLReader ... pathList) throws IllegalStateException {
        String METHOD = "readXml";
        boolean result = false;
        InputStream is = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            SAXParser saxParser = factory.newSAXParser();
            TreeParser handler = new TreeParser(pathList);
            is = new BufferedInputStream(xmlFile.openStream());
            saxParser.parse(new InputSource(is), (DefaultHandler)handler);
            result = true;
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, "readXml", "cantClose", ex);
                }
            }
        }
        return result;
    }

    private TreeParser(XMLReader[] readers) {
        ArrayList<Path> pathList = new ArrayList<Path>();
        for (XMLReader r : readers) {
            pathList.addAll(r.getPathsToListen());
        }
        this.root = TreeParser.buildTree(pathList);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.childNodeReader != null) {
            this.childNodeReader.readCData(this.skipping, ch, start, length);
        }
    }

    @Override
    public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
        String METHOD = "startElement";
        if (this.skipping != null) {
            ++this.depth;
            if (this.childNodeReader != null) {
                if (isFinerLoggable) {
                    LOGGER.log(Level.FINER, "startElement", "skipReading", qname);
                }
                this.childNodeReader.readChildren(qname, attributes);
            }
            if (isFinestLoggable) {
                LOGGER.log(Level.FINEST, "startElement", "skipDescend", new Object[]{this.depth, qname});
            }
        } else {
            Node child = this.rover.findChild(qname);
            if (child != null) {
                NodeListener reader;
                this.rover = child;
                if (isFinerLoggable) {
                    LOGGER.log(Level.FINER, "startElement", "roverDescend", this.rover);
                }
                if ((reader = this.rover.getReader()) != null) {
                    if (isFinerLoggable) {
                        LOGGER.log(Level.FINER, "startElement", "roverEnter", qname);
                    }
                    reader.readAttributes(qname, attributes);
                }
            } else {
                this.skipping = qname;
                this.depth = 1;
                this.childNodeReader = this.rover.getReader();
                if (this.childNodeReader != null) {
                    if (isFinerLoggable) {
                        LOGGER.log(Level.FINER, "startElement", "skipReading", qname);
                    }
                    this.childNodeReader.readChildren(qname, attributes);
                }
                if (isFinestLoggable) {
                    LOGGER.log(Level.FINEST, "startElement", "skipStart", new Object[]{this.depth, qname});
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localname, String qname) throws SAXException {
        String METHOD = "endElement";
        if (this.skipping != null) {
            if (this.childNodeReader != null) {
                this.childNodeReader.endNode(qname);
            }
            if (--this.depth == 0) {
                if (!this.skipping.equals(qname)) {
                    LOGGER.log(Level.WARNING, "endElement", "doesNotMatch", new Object[]{this.skipping, qname, this.depth});
                }
                this.skipping = null;
                this.childNodeReader = null;
            }
            LOGGER.log(Level.FINER, "endElement", "skipAscend", this.depth);
        } else {
            NodeListener reader = this.rover.getReader();
            if (reader != null) {
                if (isFinerLoggable) {
                    LOGGER.log(Level.FINER, "endElement", "roverEnter", qname);
                }
                reader.endNode(qname);
            }
            this.rover = this.rover.getParent();
            if (isFinerLoggable) {
                LOGGER.log(Level.FINER, "endElement", "roverAscend", this.rover);
            }
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.rover = this.root;
        this.skipping = null;
        this.depth = 0;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String string, String string1) throws IOException, SAXException {
        return super.resolveEntity(string, string1);
    }

    private static Node buildTree(List<Path> paths) {
        String METHOD = "buildTree";
        Node root = null;
        for (Path path : paths) {
            String[] parts = path.getPath().split(PATH_SEPARATOR);
            if (parts == null || parts.length == 0) {
                LOGGER.log(Level.WARNING, "buildTree", "invalidNoParts", path);
                continue;
            }
            if (parts[0] == null) {
                LOGGER.log(Level.WARNING, "buildTree", "invalidNullRoot", path);
                continue;
            }
            if (root == null) {
                if (isFinerLoggable) {
                    LOGGER.log(Level.FINER, "buildTree", "createdRootNode", parts[0]);
                }
                root = new Node(parts[0]);
            }
            Node rover = root;
            for (int i = 1; i < parts.length; ++i) {
                if (parts[i] != null && parts[i].length() > 0) {
                    Node existing = rover.findChild(parts[i]);
                    if (existing != null) {
                        if (isFinerLoggable) {
                            LOGGER.log(Level.FINER, "buildTree", "existing", new Object[]{parts[i], Integer.toString(i)});
                        }
                        rover = existing;
                        continue;
                    }
                    if (isFinerLoggable) {
                        LOGGER.log(Level.FINER, "buildTree", "add", new Object[]{parts[i], Integer.toString(i)});
                    }
                    rover = rover.addChild(parts[i]);
                    continue;
                }
                LOGGER.log(Level.WARNING, "buildTree", "broken", new Object[]{path, Integer.toString(i)});
            }
            if (rover == null) continue;
            rover.setReader(path.getReader());
        }
        return root;
    }

    private static class Node
    implements Comparable<Node> {
        private final String element;
        private final Map<String, Node> children;
        private Node parent;
        private NodeListener reader;

        public Node(String element) {
            this(element, null);
        }

        private Node(String element, Node parent) {
            this.element = element;
            this.children = new HashMap<String, Node>();
            this.parent = parent;
        }

        public Node addChild(String tag) {
            Node child = new Node(tag, this);
            this.children.put(tag, child);
            return child;
        }

        public Node findChild(String tag) {
            return this.children.get(tag);
        }

        public Node getParent() {
            return this.parent;
        }

        public NodeListener getReader() {
            return this.reader;
        }

        public void setReader(NodeListener reader) {
            this.reader = reader;
        }

        @Override
        public int compareTo(Node o) {
            return this.element.compareTo(o.element);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return this.element == other.element || this.element != null && this.element.equals(other.element);
        }

        public int hashCode() {
            int hash = 3;
            hash = 41 * hash + (this.element != null ? this.element.hashCode() : 0);
            return hash;
        }

        public String toString() {
            boolean comma = false;
            StringBuilder buf = new StringBuilder(500);
            buf.append("{ ");
            if (this.element != null && this.element.length() > 0) {
                buf.append(this.element);
                comma = true;
            }
            if (this.parent == null) {
                if (comma) {
                    buf.append(", ");
                }
                buf.append("root");
                comma = true;
            }
            if (this.children.size() > 0) {
                if (comma) {
                    buf.append(", ");
                }
                buf.append(this.children.size());
                buf.append(" sub(s)");
            }
            buf.append(" }");
            return buf.toString();
        }
    }

    public static class Path {
        private final String path;
        private final NodeListener reader;

        public Path(String path) {
            this(path, null);
        }

        public Path(String path, NodeListener reader) {
            this.path = path;
            this.reader = reader;
        }

        public String getPath() {
            return this.path;
        }

        public NodeListener getReader() {
            return this.reader;
        }

        public String toString() {
            return this.path;
        }
    }

    public static abstract class NodeListener {
        public void readAttributes(String qname, Attributes attributes) throws SAXException {
        }

        public void readChildren(String qname, Attributes attributes) throws SAXException {
        }

        public void readCData(String qname, char[] ch, int start, int length) throws SAXException {
        }

        public void endNode(String qname) throws SAXException {
        }
    }
}

