/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.server.state;

import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import org.netbeans.modules.glassfish.tooling.GlassFishStatus;
import org.netbeans.modules.glassfish.tooling.GlassFishStatusListener;
import org.netbeans.modules.glassfish.tooling.TaskEvent;
import org.netbeans.modules.glassfish.tooling.TaskState;
import org.netbeans.modules.glassfish.tooling.TaskStateListener;
import org.netbeans.modules.glassfish.tooling.admin.Command;
import org.netbeans.modules.glassfish.tooling.admin.CommandLocation;
import org.netbeans.modules.glassfish.tooling.admin.CommandVersion;
import org.netbeans.modules.glassfish.tooling.admin.Result;
import org.netbeans.modules.glassfish.tooling.admin.ResultMap;
import org.netbeans.modules.glassfish.tooling.admin.ResultString;
import org.netbeans.modules.glassfish.tooling.admin.Runner;
import org.netbeans.modules.glassfish.tooling.data.GlassFishStatusCheck;
import org.netbeans.modules.glassfish.tooling.data.GlassFishStatusCheckResult;
import org.netbeans.modules.glassfish.tooling.data.GlassFishStatusTask;
import org.netbeans.modules.glassfish.tooling.logging.Logger;
import org.netbeans.modules.glassfish.tooling.server.state.AbstractTask;
import org.netbeans.modules.glassfish.tooling.server.state.AdminPortTask;
import org.netbeans.modules.glassfish.tooling.server.state.GlassFishStatusEntity;
import org.netbeans.modules.glassfish.tooling.server.state.StatusJobState;
import org.netbeans.modules.glassfish.tooling.server.state.StatusResult;
import org.netbeans.modules.glassfish.tooling.server.state.StatusResultLocations;
import org.netbeans.modules.glassfish.tooling.server.state.StatusResultVersion;
import org.netbeans.modules.glassfish.tooling.server.state.StatusScheduler;
import org.netbeans.modules.glassfish.tooling.utils.LinkedList;

public class StatusJob {
    private static final Logger LOGGER = new Logger(StatusJob.class);
    private static final StatusJobState[][] portCheckTransition = new StatusJobState[][]{{StatusJobState.NO_CHECK, StatusJobState.NO_CHECK}, {StatusJobState.UNKNOWN_PORT, StatusJobState.OFFLINE}, {StatusJobState.UNKNOWN_PORT, StatusJobState.OFFLINE}, {StatusJobState.OFFLINE_PORT, StatusJobState.OFFLINE}, {StatusJobState.OFFLINE_PORT, StatusJobState.OFFLINE}, {StatusJobState.STARTUP_PORT, StatusJobState.STARTUP}, {StatusJobState.STARTUP_PORT, StatusJobState.OFFLINE}, {StatusJobState.ONLINE, StatusJobState.OFFLINE_PORT}, {StatusJobState.SHUTDOWN, StatusJobState.SHUTDOWN_PORT}, {StatusJobState.SHUTDOWN_PORT, StatusJobState.OFFLINE}};
    private static final StatusJobState[][] commandTransition = new StatusJobState[][]{{StatusJobState.NO_CHECK, StatusJobState.NO_CHECK}, {StatusJobState.ONLINE, StatusJobState.UNKNOWN}, {StatusJobState.ONLINE, StatusJobState.OFFLINE}, {StatusJobState.ONLINE, StatusJobState.OFFLINE}, {StatusJobState.ONLINE, StatusJobState.OFFLINE_PORT}, {StatusJobState.ONLINE, StatusJobState.STARTUP}, {StatusJobState.ONLINE, StatusJobState.STARTUP_PORT}, {StatusJobState.ONLINE, StatusJobState.OFFLINE_PORT}, {StatusJobState.SHUTDOWN, StatusJobState.SHUTDOWN_PORT}, {StatusJobState.SHUTDOWN, StatusJobState.SHUTDOWN_PORT}};
    private final GlassFishStatusEntity status;
    private StatusJobState state;
    private final Task portCheck;
    private final RunnerTask locations;
    private final RunnerTask version;
    private final LinkedList<GlassFishStatusListener>[] newStatusListeners;
    private final LinkedList<GlassFishStatusListener> currStatusListeners;
    private final LinkedList<GlassFishStatusListener> errorListeners;

    private static GlassFishStatusCheckResult checkResult(StatusJob job) {
        return GlassFishStatusCheckResult.and(job.portCheck.evalResult(), job.version.evalResult(), job.locations.evalResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void portCheckTransition(StatusJob job, GlassFishStatusTask task) {
        GlassFishStatus newState;
        GlassFishStatus oldState;
        String METHOD = "portCheckTransition";
        StatusJob statusJob = job;
        synchronized (statusJob) {
            StatusJobState oldInternalState = job.state;
            oldState = job.status.getStatus();
            job.state = portCheckTransition[job.state.ordinal()][job.portCheck.result.status.ordinal()];
            LOGGER.log(Level.FINE, "portCheckTransition", "transition", new String[]{job.portCheck.result.status.toString(), oldInternalState.toString(), job.state.toString()});
            if (oldInternalState != job.state) {
                StatusScheduler scheduler = StatusScheduler.getInstance();
                scheduler.remove(job);
                scheduler.reschedule(job);
            }
            if (oldState != (newState = job.state.toGlassFishStatus())) {
                job.status.setStatus(newState);
            }
        }
        if (job.portCheck.result.status == GlassFishStatusCheckResult.FAILED) {
            job.notifyErrorListeners(job.portCheck);
        }
        if (oldState != newState) {
            job.notifyNewStatusListeners(job.status.getStatus(), task);
        }
        job.notifyCurrStatusListeners(job.status.getStatus(), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void commandTransition(StatusJob job, GlassFishStatusTask task) {
        GlassFishStatus newState;
        GlassFishStatus oldState;
        String METHOD = "commandLocationsTransition";
        GlassFishStatusCheckResult status = StatusJob.checkResult(job);
        StatusJob statusJob = job;
        synchronized (statusJob) {
            StatusJobState oldInternalState = job.state;
            oldState = job.status.getStatus();
            job.state = commandTransition[job.state.ordinal()][status.ordinal()];
            LOGGER.log(Level.FINE, "commandLocationsTransition", "transition", new String[]{status.toString(), oldInternalState.toString(), job.state.toString()});
            if (oldInternalState != job.state) {
                StatusScheduler scheduler = StatusScheduler.getInstance();
                scheduler.remove(job);
                scheduler.reschedule(job);
            }
            if (oldState != (newState = job.state.toGlassFishStatus())) {
                job.status.setStatus(newState);
            }
        }
        if (oldState != newState) {
            job.notifyNewStatusListeners(job.status.getStatus(), task);
        }
        job.notifyCurrStatusListeners(job.status.getStatus(), task);
    }

    StatusJob(GlassFishStatusEntity status) {
        this.status = status;
        this.state = StatusJobState.UNKNOWN;
        this.portCheck = new Task(GlassFishStatusCheck.PORT, new ListenerPortCheck(this));
        this.locations = new RunnerTaskLocations(new ListenerLocations(this));
        this.version = new RunnerTaskVersion(new ListenerVersion(this));
        this.newStatusListeners = new LinkedList[GlassFishStatus.length];
        for (int i = 0; i < GlassFishStatus.length; ++i) {
            this.newStatusListeners[i] = new LinkedList();
        }
        this.currStatusListeners = new LinkedList();
        this.errorListeners = new LinkedList();
    }

    GlassFishStatusEntity getStatus() {
        return this.status;
    }

    StatusJobState getState() {
        return this.state;
    }

    void setState(StatusJobState state) {
        this.state = state;
    }

    Task getPortCheck() {
        return this.portCheck;
    }

    RunnerTask getLocations() {
        return this.locations;
    }

    RunnerTask getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean restartJob(StatusScheduler scheduler, GlassFishStatusListener listener) {
        boolean result;
        StatusJob statusJob = this;
        synchronized (statusJob) {
            switch (this.state) {
                case NO_CHECK: {
                    this.state = StatusJobState.UNKNOWN_PORT;
                    this.status.setStatus(this.state.toGlassFishStatus());
                    scheduler.remove(this);
                    scheduler.reschedule(this);
                    result = true;
                    if (listener == null) break;
                    this.addNewStatusListener(listener, GlassFishStatus.values());
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopJob(StatusScheduler scheduler) {
        StatusJob statusJob = this;
        synchronized (statusJob) {
            GlassFishStatus oldStatus = this.state.toGlassFishStatus();
            this.state = StatusJobState.NO_CHECK;
            this.status.setStatus(this.state.toGlassFishStatus());
            scheduler.remove(this);
            scheduler.reschedule(this);
            if (oldStatus != this.status.getStatus()) {
                this.notifyNewStatusListeners(this.status.getStatus(), null);
            }
        }
    }

    private void startStateImpl(StatusScheduler scheduler, GlassFishStatusListener listener, GlassFishStatus ... newState) {
        GlassFishStatus oldStatus = this.status.getStatus();
        this.state = StatusJobState.STARTUP;
        this.status.setStatus(this.state.toGlassFishStatus());
        scheduler.remove(this);
        scheduler.reschedule(this);
        if (oldStatus != this.status.getStatus()) {
            this.notifyNewStatusListeners(this.status.getStatus(), null);
        }
        if (listener != null) {
            this.addNewStatusListener(listener, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startState(StatusScheduler scheduler, boolean force, GlassFishStatusListener listener, GlassFishStatus ... newState) {
        boolean result;
        StatusJob statusJob = this;
        synchronized (statusJob) {
            switch (this.state) {
                case OFFLINE: 
                case OFFLINE_PORT: {
                    this.startStateImpl(scheduler, listener, newState);
                    result = true;
                    break;
                }
                case STARTUP: {
                    result = false;
                    break;
                }
                default: {
                    if (force) {
                        this.startStateImpl(scheduler, listener, newState);
                        result = true;
                        break;
                    }
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shutdownState(StatusScheduler scheduler) {
        boolean result;
        StatusJob statusJob = this;
        synchronized (statusJob) {
            switch (this.state) {
                case ONLINE: {
                    this.state = StatusJobState.SHUTDOWN;
                    this.status.setStatus(this.state.toGlassFishStatus());
                    scheduler.remove(this);
                    scheduler.reschedule(this);
                    result = true;
                    this.notifyNewStatusListeners(this.status.getStatus(), null);
                    break;
                }
                default: {
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleNew(StatusScheduler scheduler) {
        StatusJob statusJob = this;
        synchronized (statusJob) {
            scheduler.scheduleNew(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyNewStatusListeners(GlassFishStatus status, GlassFishStatusTask task) {
        int i = 0;
        Object[] objectArray = this.newStatusListeners;
        synchronized (this.newStatusListeners) {
            LinkedList<GlassFishStatusListener> listeners = this.newStatusListeners[status.ordinal()];
            GlassFishStatusListener[] call = new GlassFishStatusListener[listeners.size()];
            boolean isElement = listeners.first();
            while (isElement) {
                call[i++] = listeners.getCurrent();
                isElement = listeners.next();
            }
            // ** MonitorExit[var7_4] (shouldn't be in output)
            for (GlassFishStatusListener listener : call) {
                listener.newState(this.status.getServer(), status, task);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCurrStatusListeners(GlassFishStatus status, GlassFishStatusTask task) {
        int i = 0;
        GlassFishStatusListener[] glassFishStatusListenerArray = this.currStatusListeners;
        synchronized (this.currStatusListeners) {
            GlassFishStatusListener[] call = new GlassFishStatusListener[this.currStatusListeners.size()];
            boolean isElement = this.currStatusListeners.first();
            while (isElement) {
                call[i++] = this.currStatusListeners.getCurrent();
                isElement = this.currStatusListeners.next();
            }
            // ** MonitorExit[var6_4] (shouldn't be in output)
            for (GlassFishStatusListener listener : call) {
                listener.currentState(this.status.getServer(), status, task);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyErrorListeners(GlassFishStatusTask task) {
        int i = 0;
        GlassFishStatusListener[] glassFishStatusListenerArray = this.errorListeners;
        synchronized (this.errorListeners) {
            GlassFishStatusListener[] call = new GlassFishStatusListener[this.errorListeners.size()];
            boolean isElement = this.errorListeners.first();
            while (isElement) {
                call[i++] = this.errorListeners.getCurrent();
                isElement = this.errorListeners.next();
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            for (GlassFishStatusListener listener : call) {
                listener.error(this.status.getServer(), task);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCurrStatusListener(GlassFishStatusListener listener) {
        boolean added = false;
        boolean exists = false;
        LinkedList<GlassFishStatusListener> linkedList = this.currStatusListeners;
        synchronized (linkedList) {
            boolean isElement = this.currStatusListeners.first();
            while (isElement) {
                if (listener.equals(this.currStatusListeners.getCurrent())) {
                    exists = true;
                }
                isElement = this.currStatusListeners.next();
            }
            if (!exists) {
                this.currStatusListeners.addLast(listener);
                added = true;
            }
        }
        if (added && listener != null) {
            listener.added();
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNewStatusListener(GlassFishStatusListener listener, GlassFishStatus ... newState) {
        boolean added = false;
        LinkedList<GlassFishStatusListener>[] linkedListArray = this.newStatusListeners;
        synchronized (this.newStatusListeners) {
            for (GlassFishStatus stateToAdd : newState) {
                LinkedList<GlassFishStatusListener> listeners = this.newStatusListeners[stateToAdd.ordinal()];
                boolean exists = false;
                boolean isElement = listeners.first();
                while (isElement) {
                    if (listener.equals(listeners.getCurrent())) {
                        exists = true;
                    }
                    isElement = listeners.next();
                }
                if (exists) continue;
                listeners.addLast(listener);
                added = true;
            }
            // ** MonitorExit[var7_4] (shouldn't be in output)
            if (added && listener != null) {
                listener.added();
            }
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addErrorListener(GlassFishStatusListener listener) {
        boolean added = false;
        boolean exists = false;
        LinkedList<GlassFishStatusListener> linkedList = this.errorListeners;
        synchronized (linkedList) {
            boolean isElement = this.errorListeners.first();
            while (isElement) {
                if (listener.equals(this.errorListeners.getCurrent())) {
                    exists = true;
                }
                isElement = this.errorListeners.next();
            }
            if (!exists) {
                this.errorListeners.addLast(listener);
                added = true;
            }
        }
        if (added && listener != null) {
            listener.added();
        }
        return added;
    }

    public boolean addStatusListener(GlassFishStatusListener listener, boolean currentState, GlassFishStatus ... newState) {
        boolean added = currentState ? this.addCurrStatusListener(listener) : false;
        if (newState != null) {
            boolean bl = added = this.addNewStatusListener(listener, newState) || added;
        }
        if (added && listener != null) {
            listener.added();
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStatusListener(GlassFishStatusListener listener) {
        boolean isElement;
        boolean removed = false;
        LinkedList<GlassFishStatusListener> linkedList = this.currStatusListeners;
        synchronized (linkedList) {
            isElement = this.currStatusListeners.first();
            while (isElement) {
                if (listener.equals(this.currStatusListeners.getCurrent())) {
                    this.currStatusListeners.removeAndNext();
                    isElement = this.currStatusListeners.isCurrent();
                    removed = true;
                    continue;
                }
                isElement = this.currStatusListeners.next();
            }
        }
        Object object = this.newStatusListeners;
        synchronized (this.newStatusListeners) {
            for (GlassFishStatus stateToRemove : GlassFishStatus.values()) {
                LinkedList<GlassFishStatusListener> listeners = this.newStatusListeners[stateToRemove.ordinal()];
                isElement = listeners.first();
                while (isElement) {
                    if (listener.equals(listeners.getCurrent())) {
                        listeners.removeAndNext();
                        isElement = listeners.isCurrent();
                        removed = true;
                        continue;
                    }
                    isElement = listeners.next();
                }
            }
            // ** MonitorExit[var5_6 /* !! */ ] (shouldn't be in output)
            object = this.errorListeners;
            synchronized (object) {
                isElement = this.errorListeners.first();
                while (isElement) {
                    if (listener.equals(this.errorListeners.getCurrent())) {
                        this.errorListeners.removeAndNext();
                        isElement = this.errorListeners.isCurrent();
                        removed = true;
                        continue;
                    }
                    isElement = this.errorListeners.next();
                }
            }
            if (removed && listener != null) {
                listener.removed();
            }
            return removed;
        }
    }

    static class RunnerTaskVersion
    extends RunnerTask {
        private RunnerTaskVersion(Listener listener) {
            super(GlassFishStatusCheck.VERSION, new CommandVersion(), listener);
        }
    }

    static class RunnerTaskLocations
    extends RunnerTask {
        private RunnerTaskLocations(Listener listener) {
            super(GlassFishStatusCheck.LOCATIONS, new CommandLocation(), listener);
        }
    }

    static class RunnerTask
    extends Task {
        private final Command command;

        private RunnerTask(GlassFishStatusCheck type, Command cmd, Listener listener) {
            super(type, listener);
            this.command = cmd;
        }

        Command getCommand() {
            return this.command;
        }
    }

    static class Task
    implements GlassFishStatusTask {
        private Listener listener;
        StatusResult result;
        AbstractTask task;
        private ScheduledFuture future;
        private TaskStateListener[] listeners;
        private final GlassFishStatusCheck type;

        private Task(GlassFishStatusCheck type, Listener listener) {
            this.listener = listener;
            this.type = type;
            this.result = null;
            this.task = null;
            this.future = null;
            this.listeners = new TaskStateListener[]{listener};
        }

        Listener getListener() {
            return this.listener;
        }

        void setListener(Listener listener) {
            this.listener = listener;
        }

        @Override
        public GlassFishStatusCheck getType() {
            return this.type;
        }

        StatusResult getResult() {
            return this.result;
        }

        void setResult(StatusResult result) {
            this.result = result;
        }

        @Override
        public GlassFishStatusCheckResult getStatus() {
            return this.result != null ? this.result.status : null;
        }

        @Override
        public TaskEvent getEvent() {
            return this.result != null ? this.result.event : null;
        }

        AbstractTask getTask() {
            return this.task;
        }

        void setTask(AbstractTask task) {
            this.task = task;
        }

        TaskStateListener[] getListeners() {
            return this.listeners;
        }

        ScheduledFuture getFuture() {
            return this.future;
        }

        void setFuture(ScheduledFuture future) {
            this.future = future;
        }

        void setTaskFuture(AbstractTask task, ScheduledFuture future) {
            this.task = task;
            this.future = future;
        }

        void clearTaskFuture() {
            this.task = null;
            this.future = null;
        }

        GlassFishStatusCheckResult evalResult() {
            return this.task == null ? GlassFishStatusCheckResult.SUCCESS : (this.result == null ? GlassFishStatusCheckResult.FAILED : this.result.status);
        }
    }

    static class ListenerPortCheck
    extends Listener {
        private static final Logger LOGGER = new Logger(ListenerPortCheck.class);

        private ListenerPortCheck(StatusJob job) {
            super(job);
        }

        @Override
        public void operationStateChanged(TaskState newState, TaskEvent event, String ... args) {
            String METHOD = "operationStateChanged";
            AdminPortTask task = (AdminPortTask)this.job.portCheck.getTask();
            this.job.portCheck.setResult(task.getResult());
            LOGGER.log(Level.FINE, "operationStateChanged", "result", ((StatusJob)this.job).portCheck.getResult().status.toString());
            StatusJob.portCheckTransition(this.job, this.job.portCheck);
        }
    }

    static class ListenerVersion
    extends Listener {
        private static final Logger LOGGER = new Logger(ListenerVersion.class);

        private ListenerVersion(StatusJob job) {
            super(job);
        }

        private boolean verifyResult() {
            Result result = this.runner.getResult();
            if (result instanceof ResultString) {
                ResultString resultString = (ResultString)result;
                return CommandVersion.verifyResult(resultString, this.job.status.getServer());
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operationStateChanged(TaskState newState, TaskEvent event, String ... args) {
            String METHOD = "operationStateChanged";
            switch (newState) {
                case COMPLETED: 
                case FAILED: {
                    ResultString taskResult = (ResultString)this.runner.getResult();
                    if (args != null && args.length >= 3) {
                        String serverName = args[0];
                        String exceptionMeasage = args[2];
                    } else {
                        Object serverName = null;
                        Object exceptionMeasage = null;
                    }
                    boolean notifyError = false;
                    Object object = this.job.version;
                    synchronized (object) {
                        switch (newState) {
                            case COMPLETED: {
                                if (this.verifyResult()) {
                                    this.job.version.setResult(new StatusResultVersion(taskResult, GlassFishStatusCheckResult.SUCCESS, event));
                                    break;
                                }
                            }
                            case FAILED: {
                                this.job.version.setResult(new StatusResultVersion(taskResult, GlassFishStatusCheckResult.FAILED, event));
                                notifyError = true;
                            }
                        }
                    }
                    LOGGER.log(Level.FINE, "operationStateChanged", "result", ((StatusJob)this.job).version.getResult().status.toString());
                    if (notifyError) {
                        object = this.job;
                        synchronized (object) {
                            this.job.notifyErrorListeners(this.job.version);
                        }
                    }
                    StatusJob.commandTransition(this.job, this.job.version);
                }
            }
        }
    }

    static class ListenerLocations
    extends Listener {
        private static final Logger LOGGER = new Logger(ListenerLocations.class);

        private ListenerLocations(StatusJob job) {
            super(job);
        }

        private boolean verifyResult() {
            Result result = this.runner.getResult();
            if (result instanceof ResultMap) {
                ResultMap resultMap = (ResultMap)result;
                return CommandLocation.verifyResult(resultMap, this.job.status.getServer());
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operationStateChanged(TaskState newState, TaskEvent event, String ... args) {
            String METHOD = "operationStateChanged";
            switch (newState) {
                case COMPLETED: 
                case FAILED: {
                    ResultMap taskResult = (ResultMap)this.runner.getResult();
                    if (args != null && args.length >= 3) {
                        String serverName = args[0];
                        String exceptionMeasage = args[2];
                    } else {
                        Object serverName = null;
                        Object exceptionMeasage = null;
                    }
                    boolean notifyError = false;
                    Object object = this.job.locations;
                    synchronized (object) {
                        switch (newState) {
                            case COMPLETED: {
                                if (this.verifyResult()) {
                                    this.job.locations.setResult(new StatusResultLocations(taskResult, GlassFishStatusCheckResult.SUCCESS, event));
                                    break;
                                }
                            }
                            case FAILED: {
                                this.job.locations.setResult(new StatusResultLocations(taskResult, GlassFishStatusCheckResult.FAILED, event));
                                notifyError = true;
                            }
                        }
                    }
                    LOGGER.log(Level.FINE, "operationStateChanged", "result", ((StatusJob)this.job).locations.getResult().status.toString());
                    if (notifyError) {
                        object = this.job;
                        synchronized (object) {
                            this.job.notifyErrorListeners(this.job.locations);
                        }
                    }
                    StatusJob.commandTransition(this.job, this.job.locations);
                }
            }
        }
    }

    static abstract class Listener
    implements TaskStateListener {
        private static final Logger LOGGER = new Logger(Listener.class);
        Runner runner = null;
        final StatusJob job;

        private Listener(StatusJob job) {
            this.job = job;
        }

        void setRunner(Runner runner) {
            this.runner = runner;
        }

        void clearRunner() {
            this.runner = null;
        }
    }
}

