/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import org.testng.ISuite;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BaseMultiSuitePanel;
import org.testng.reporters.jq.Model;
import org.testng.xml.XmlTest;

public class TestPanel
extends BaseMultiSuitePanel {
    public TestPanel(Model model) {
        super(model);
    }

    public String getPrefix() {
        return "testlist-";
    }

    public String getHeader(ISuite suite) {
        return "Tests for " + suite.getName();
    }

    public String getContent(ISuite suite, XMLStringBuffer main) {
        XMLStringBuffer xsb = new XMLStringBuffer(main.getCurrentIndent());
        xsb.push("ul");
        for (XmlTest test : suite.getXmlSuite().getTests()) {
            xsb.push("li");
            int count = test.getXmlClasses().size();
            String name = test.getName() + " (" + TestPanel.pluralize(count, "class") + ")";
            xsb.addRequired("span", name, "class", "test-name");
            xsb.pop("li");
        }
        xsb.pop("ul");
        return xsb.toXML();
    }

    public String getNavigatorLink(ISuite suite) {
        return TestPanel.pluralize(suite.getXmlSuite().getTests().size(), "test");
    }

    public String getClassName() {
        return "test-stats";
    }
}

