/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.hints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.analysis.api.AnalyzerResponse;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.syntaxerr.AbstractCodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.AuditPreferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditFactory;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfoHintProvider;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.highlight.hints.ErrorInfoImpl;
import org.netbeans.modules.cnd.highlight.hints.SafeFix;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.api.ui.CsmRefactoringActionsFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class MissingGuardBlock
extends AbstractCodeAudit {
    private MissingGuardBlock(String id, String name, String description, String defaultSeverity, boolean defaultEnabled, AuditPreferences myPreferences) {
        super(id, name, description, defaultSeverity, defaultEnabled, myPreferences);
    }

    public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
        return kind == CsmErrorProvider.EditorEvent.FileBased;
    }

    public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        CsmFile file = request.getFile();
        if (file.isHeaderFile() && !CsmFileInfoQuery.getDefault().hasGuardBlock(file)) {
            Document doc_ = request.getDocument();
            if (doc_ == null) {
                CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((CsmFile)file);
                doc_ = CsmUtilities.openDocument((CloneableEditorSupport)ces);
            }
            final Document doc = doc_;
            final AtomicInteger startOffset = new AtomicInteger(0);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TokenSequence docTokenSequence = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)doc.getLength(), (boolean)false, (boolean)true);
                    if (docTokenSequence == null) {
                        return;
                    }
                    docTokenSequence.moveStart();
                    block3: while (docTokenSequence.moveNext()) {
                        if (!(docTokenSequence.token().id() instanceof CppTokenId)) continue;
                        CppTokenId tokenId = (CppTokenId)docTokenSequence.token().id();
                        switch (tokenId) {
                            case LINE_COMMENT: 
                            case NEW_LINE: 
                            case DOXYGEN_LINE_COMMENT: 
                            case BLOCK_COMMENT: 
                            case DOXYGEN_COMMENT: 
                            case WHITESPACE: 
                            case ESCAPED_WHITESPACE: 
                            case ESCAPED_LINE: {
                                continue block3;
                            }
                        }
                        startOffset.set(docTokenSequence.offset());
                        return;
                    }
                    docTokenSequence.moveEnd();
                    docTokenSequence.movePrevious();
                    startOffset.set(docTokenSequence.offset());
                }
            };
            doc.render(runnable);
            String message = NbBundle.getMessage(MissingGuardBlock.class, (String)"MissingGuardBlock.description");
            int start = startOffset.get();
            CsmErrorInfo.Severity severity = MissingGuardBlock.toSeverity((String)this.minimalSeverity());
            if (response instanceof AnalyzerResponse) {
                ((AnalyzerResponse)response).addError(AnalyzerResponse.AnalyzerSeverity.DetectedError, null, file.getFileObject(), (CsmErrorInfo)new MissingGuardBlockErrorInfoImpl(doc, file, "General", this.getID(), this.getName() + "\n" + message, severity, start));
            } else {
                response.addError((CsmErrorInfo)new MissingGuardBlockErrorInfoImpl(doc, file, "General", this.getID(), message, severity, start));
            }
        }
    }

    private static final class AddPragmaOnce
    extends SafeFix {
        private final BaseDocument doc;
        private final CsmFile file;
        private final int offset;

        public AddPragmaOnce(BaseDocument doc, CsmFile file, int offset) throws BadLocationException {
            this.doc = doc;
            this.file = file;
            this.offset = offset;
        }

        public String getText() {
            return NbBundle.getMessage(MissingGuardBlock.class, (String)"MissingGuardBlock.fix.pragma");
        }

        @Override
        public ChangeInfo performFix() throws BadLocationException, Exception {
            Position ifndefPosition = NbDocument.createPosition((Document)this.doc, (int)this.offset, (Position.Bias)Position.Bias.Forward);
            this.doc.insertString(ifndefPosition.getOffset(), "#pragma once\n\n", null);
            return null;
        }
    }

    private static final class AddGuardBlock
    extends SafeFix {
        private final BaseDocument doc;
        private final CsmFile file;
        private final int startOffset;

        public AddGuardBlock(BaseDocument doc, CsmFile file, int startOffset) throws BadLocationException {
            this.doc = doc;
            this.file = file;
            this.startOffset = startOffset;
        }

        public String getText() {
            return NbBundle.getMessage(MissingGuardBlock.class, (String)"MissingGuardBlock.fix.block");
        }

        @Override
        public ChangeInfo performFix() throws BadLocationException, Exception {
            String defName = this.file.getFileObject().getName().toUpperCase() + "_H\n";
            String ifndefMacro = "#ifndef ";
            String defineMacro = "#define ";
            String endifMacro = "#endif\t// ";
            String endifText = "#endif\t// " + defName + "\n";
            String openGuardBlockText = "#ifndef " + defName + "#define " + defName + "\n";
            int ifndefStartPos = this.startOffset + "#ifndef ".length();
            int ifndefEndPos = ifndefStartPos + defName.length();
            int defStartPos = ifndefEndPos + "#define ".length();
            int defEndPos = defStartPos + defName.length();
            Position ifndefPosition = NbDocument.createPosition((Document)this.doc, (int)this.startOffset, (Position.Bias)Position.Bias.Forward);
            this.doc.insertString(ifndefPosition.getOffset(), openGuardBlockText, null);
            Position endifPossition = NbDocument.createPosition((Document)this.doc, (int)this.file.getText().length(), (Position.Bias)Position.Bias.Backward);
            this.doc.insertString(endifPossition.getOffset(), "\n" + endifText, null);
            Position ifndefStart = NbDocument.createPosition((Document)this.doc, (int)ifndefStartPos, (Position.Bias)Position.Bias.Forward);
            Position ifndefEnd = NbDocument.createPosition((Document)this.doc, (int)(ifndefEndPos - 1), (Position.Bias)Position.Bias.Backward);
            Position defineStart = NbDocument.createPosition((Document)this.doc, (int)defStartPos, (Position.Bias)Position.Bias.Forward);
            Position defineEnd = NbDocument.createPosition((Document)this.doc, (int)(defEndPos - 1), (Position.Bias)Position.Bias.Backward);
            Position endifStart = NbDocument.createPosition((Document)this.doc, (int)(endifPossition.getOffset() + "#endif\t// ".length() + 1), (Position.Bias)Position.Bias.Forward);
            Position endifEnd = NbDocument.createPosition((Document)this.doc, (int)(endifPossition.getOffset() + "#endif\t// ".length() + defName.length()), (Position.Bias)Position.Bias.Backward);
            ChangeInfo changeInfo = new ChangeInfo();
            FileObject fo = this.file.getFileObject();
            changeInfo.add(fo, ifndefStart, ifndefEnd);
            changeInfo.add(fo, defineStart, defineEnd);
            changeInfo.add(fo, endifStart, endifEnd);
            CsmRefactoringActionsFactory.performInstantRenameAction((JTextComponent)EditorRegistry.lastFocusedComponent(), (ChangeInfo)changeInfo);
            return null;
        }
    }

    public static final class MissingGuardBlockFixProvider
    extends CsmErrorInfoHintProvider {
        protected List<Fix> doGetFixes(CsmErrorInfo info, List<Fix> alreadyFound) {
            if (info instanceof MissingGuardBlockErrorInfoImpl) {
                alreadyFound.addAll(this.createFixes((MissingGuardBlockErrorInfoImpl)info));
            }
            return alreadyFound;
        }

        private List<? extends Fix> createFixes(MissingGuardBlockErrorInfoImpl info) {
            try {
                ArrayList<SafeFix> fixes = new ArrayList<SafeFix>();
                fixes.add(new AddGuardBlock(info.doc, info.file, info.insertionStart));
                fixes.add(new AddPragmaOnce(info.doc, info.file, info.insertionStart));
                return fixes;
            }
            catch (BadLocationException ex) {
                return Collections.emptyList();
            }
        }
    }

    private static final class MissingGuardBlockErrorInfoImpl
    extends ErrorInfoImpl {
        private final BaseDocument doc;
        private final CsmFile file;
        private final int insertionStart;

        public MissingGuardBlockErrorInfoImpl(Document doc, CsmFile file, String providerName, String audutName, String message, CsmErrorInfo.Severity severity, int startOffset) {
            super(providerName, audutName, message, severity, 0, 0);
            this.doc = (BaseDocument)doc;
            this.file = file;
            this.insertionStart = startOffset;
        }
    }

    public static final class Factory
    implements CodeAuditFactory {
        public AbstractCodeAudit create(AuditPreferences preferences) {
            String id = NbBundle.getMessage(MissingGuardBlock.class, (String)"MissingGuardBlock.name");
            String description = NbBundle.getMessage(MissingGuardBlock.class, (String)"MissingGuardBlock.description");
            return new MissingGuardBlock(id, id, description, "warning", true, preferences);
        }
    }
}

