/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.security;

import org.netbeans.modules.cnd.analysis.api.AnalyzerResponse;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.syntaxerr.AbstractCodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.AuditPreferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectSupport;
import org.netbeans.modules.cnd.highlight.hints.ErrorInfoImpl;
import org.netbeans.modules.cnd.highlight.security.FunctionsXmlService;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.NbBundle;

public class FunctionUsageAudit
extends AbstractCodeAudit {
    private final FunctionsXmlService.Level level;
    private final FunctionsXmlService.Category category;
    private final String customType;

    public FunctionUsageAudit(FunctionsXmlService.Level level, FunctionsXmlService.Category category, String id, String name, String description, String defaultSeverity, String customType, boolean defaultEnabled, AuditPreferences myPreferences) {
        super(id, name, description, defaultSeverity, defaultEnabled, myPreferences);
        this.level = level;
        this.category = category;
        this.customType = customType;
    }

    public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
        return kind == CsmErrorProvider.EditorEvent.FileBased;
    }

    public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        CsmFile file = request.getFile();
        if (file != null) {
            if (request.isCancelled()) {
                return;
            }
            CsmFileReferences.getDefault().accept((CsmScope)request.getFile(), request.getDocument(), (CsmFileReferences.Visitor)new ReferenceVisitor(request, response, file), CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE);
        }
    }

    private boolean canBeUnsafe(CharSequence functionName) {
        for (FunctionsXmlService.RvsdFunction unsafeFunction : this.category.getFunctions()) {
            if (!CharSequenceUtils.contentEquals((CharSequence)functionName, (CharSequence)unsafeFunction.getName())) continue;
            return true;
        }
        return false;
    }

    private String getAlternativesIfUnsafe(Object function) {
        if (function instanceof CsmOffsetable && function instanceof CsmNamedElement) {
            CharSequence functionName = ((CsmNamedElement)function).getName();
            for (FunctionsXmlService.RvsdFunction unsafeFunction : this.category.getFunctions()) {
                if (!CharSequenceUtils.contentEquals((CharSequence)functionName, (CharSequence)unsafeFunction.getName())) continue;
                CsmFile srcFile = ((CsmOffsetable)function).getContainingFile();
                for (CsmInclude include : CsmFileInfoQuery.getDefault().getIncludeStack(srcFile)) {
                    if (!include.getIncludeName().toString().equals(unsafeFunction.getHeader())) continue;
                    return unsafeFunction.getAlternativesString();
                }
            }
        }
        return null;
    }

    private class ReferenceVisitor
    implements CsmFileReferences.Visitor {
        private final CsmErrorProvider.Request request;
        private final CsmErrorProvider.Response response;
        private final CsmFile file;

        public ReferenceVisitor(CsmErrorProvider.Request request, CsmErrorProvider.Response response, CsmFile file) {
            this.request = request;
            this.response = response;
            this.file = file;
        }

        public void visit(CsmReferenceContext context) {
            CsmReference reference = context.getReference();
            if (reference != null) {
                if (!FunctionUsageAudit.this.canBeUnsafe(reference.getText())) {
                    return;
                }
                CsmObject referencedObject = reference.getReferencedObject();
                String altText = null;
                if (CsmKindUtilities.isFunction((CsmObject)referencedObject)) {
                    altText = FunctionUsageAudit.this.getAlternativesIfUnsafe((CsmFunction)referencedObject);
                } else {
                    String platformName;
                    Object platformProject = this.file.getProject().getPlatformProject();
                    if (platformProject instanceof NativeProject && (platformName = NativeProjectSupport.getPlatformName((NativeProject)((NativeProject)platformProject))).equals("MacOSX") && CsmKindUtilities.isMacro((CsmObject)referencedObject)) {
                        altText = FunctionUsageAudit.this.getAlternativesIfUnsafe((CsmMacro)referencedObject);
                    }
                }
                if (altText != null) {
                    String description;
                    CsmErrorInfo.Severity severity = AbstractCodeAudit.toSeverity((String)FunctionUsageAudit.this.minimalSeverity());
                    String id = FunctionUsageAudit.this.level.getLevel() + FunctionUsageAudit.this.category.getName();
                    String name = "(" + (Object)((Object)FunctionUsageAudit.this.level) + ") " + ((CsmNamedElement)referencedObject).getName().toString();
                    String string = description = altText.isEmpty() ? FunctionUsageAudit.this.getDescription() : FunctionUsageAudit.this.getDescription() + NbBundle.getMessage(FunctionUsageAudit.class, (String)"FunctionUsageAudit.alternative", (Object)altText);
                    if (this.response instanceof AnalyzerResponse) {
                        ((AnalyzerResponse)this.response).addError(AnalyzerResponse.AnalyzerSeverity.DetectedError, null, this.file.getFileObject(), (CsmErrorInfo)new ErrorInfoImpl("Security", FunctionUsageAudit.this.getName(), id + "\n" + name + "\n" + description, severity, FunctionUsageAudit.this.customType, reference.getStartOffset(), reference.getEndOffset()));
                    } else {
                        this.response.addError((CsmErrorInfo)new ErrorInfoImpl("Security", FunctionUsageAudit.this.getName(), description, severity, FunctionUsageAudit.this.customType, reference.getStartOffset(), reference.getEndOffset()));
                    }
                }
            }
        }

        public boolean cancelled() {
            return this.request.isCancelled();
        }
    }
}

