/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.actions;

import java.util.HashSet;
import javax.swing.text.Document;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.refactoring.actions.RefactoringActionsProvider;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.cnd.refactoring.hints.infrastructure.Utilities;
import org.netbeans.modules.cnd.refactoring.spi.CsmActionsImplementationProvider;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.ui.ChangeParametersUI;
import org.netbeans.modules.cnd.refactoring.ui.EncapsulateFieldUI;
import org.netbeans.modules.cnd.refactoring.ui.InlineUI;
import org.netbeans.modules.cnd.utils.UIGesturesSupport;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class CsmRefactoringActionsProvider
extends CsmActionsImplementationProvider {
    private static final String CHANGE_PARAMETERS_TRACKING = "CHANGE_PARAMETERS";
    private static final String ENCAPSULATE_FIELDS_TRACKING = "ENCAPSULATE_FIELDS";
    private static final String INLINE_TRACKING = "INLINE_REFACTORING";

    @Override
    public boolean canChangeParameters(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if (nodes.size() != 1) {
            return false;
        }
        CsmObject ref = CsmRefactoringUtils.findContextObject(lookup);
        if (RefactoringActionsProvider.isFromEditor(lookup)) {
            CsmContext editorContext = CsmContext.create(lookup);
            if (editorContext != null) {
                CsmFunction fun = editorContext.getEnclosingFunction();
                return fun != null;
            }
            return false;
        }
        return CsmKindUtilities.isFunction((CsmObject)ref);
    }

    @Override
    public void doChangeParameters(Lookup lookup) {
        Runnable task = RefactoringActionsProvider.isFromEditor(lookup) ? new RefactoringActionsProvider.TextComponentTask(lookup){

            @Override
            protected RefactoringUI createRefactoringUI(CsmObject selectedElement, CsmContext editorContext) {
                UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{CsmRefactoringActionsProvider.CHANGE_PARAMETERS_TRACKING, "FROM_EDITOR"});
                return ChangeParametersUI.create(selectedElement, editorContext);
            }
        } : new RefactoringActionsProvider.NodeToElementTask(lookup){

            @Override
            protected RefactoringUI createRefactoringUI(CsmObject selectedElement) {
                UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{CsmRefactoringActionsProvider.CHANGE_PARAMETERS_TRACKING});
                return ChangeParametersUI.create(selectedElement, null);
            }
        };
        task.run();
    }

    @Override
    public boolean canEncapsulateFields(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if (nodes.size() != 1) {
            return false;
        }
        CsmObject ref = CsmRefactoringUtils.findContextObject(lookup);
        if (RefactoringActionsProvider.isFromEditor(lookup)) {
            CsmContext editorContext = CsmContext.create(lookup);
            if (editorContext != null) {
                CsmClass cls = Utilities.extractEnclosingClass(editorContext);
                return cls != null;
            }
            return false;
        }
        return CsmKindUtilities.isField((CsmObject)ref) || CsmKindUtilities.isClass((CsmObject)ref);
    }

    @Override
    public void doEncapsulateFields(Lookup lookup) {
        Runnable task = RefactoringActionsProvider.isFromEditor(lookup) ? new RefactoringActionsProvider.TextComponentTask(lookup){

            @Override
            protected RefactoringUI createRefactoringUI(CsmObject selectedElement, CsmContext editorContext) {
                UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{CsmRefactoringActionsProvider.ENCAPSULATE_FIELDS_TRACKING, "FROM_EDITOR"});
                return EncapsulateFieldUI.create(selectedElement, editorContext);
            }
        } : new RefactoringActionsProvider.NodeToElementTask(lookup){

            @Override
            protected RefactoringUI createRefactoringUI(CsmObject selectedElement) {
                UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{CsmRefactoringActionsProvider.ENCAPSULATE_FIELDS_TRACKING});
                return EncapsulateFieldUI.create(selectedElement, null);
            }
        };
        task.run();
    }

    @Override
    public boolean canPerformInlineRefactoring(Lookup lookup) {
        HashSet nodes = new HashSet(lookup.lookupAll(Node.class));
        if (nodes.size() != 1) {
            return false;
        }
        CsmObject obj = CsmRefactoringUtils.findContextObject(lookup);
        if (CsmKindUtilities.isOffsetable((Object)obj)) {
            Document doc = EditorRegistry.lastFocusedComponent().getDocument();
            CsmReference ref = CsmReferenceResolver.getDefault().findReference(doc, ((CsmOffsetable)obj).getStartOffset());
            if (CsmKindUtilities.isMacro((CsmObject)ref.getReferencedObject())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void doInlineRefactoring(Lookup lookup) {
        Runnable task = RefactoringActionsProvider.isFromEditor(lookup) ? new RefactoringActionsProvider.TextComponentTask(lookup){

            @Override
            protected RefactoringUI createRefactoringUI(CsmObject selectedElement, CsmContext editorContext) {
                UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{CsmRefactoringActionsProvider.INLINE_TRACKING, "FROM_EDITOR"});
                return InlineUI.create(selectedElement, editorContext);
            }
        } : new RefactoringActionsProvider.NodeToElementTask(lookup){

            @Override
            protected RefactoringUI createRefactoringUI(CsmObject selectedElement) {
                UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{CsmRefactoringActionsProvider.INLINE_TRACKING});
                return InlineUI.create(selectedElement, null);
            }
        };
        task.run();
    }
}

