/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.hints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmCaseStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmCondition;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExceptionHandler;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmForStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmTryCatchStatement;
import org.netbeans.modules.cnd.api.model.services.CsmExpressionResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.refactoring.hints.SuggestionFactoryTask;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class StatementFinder {
    private final Document doc;
    private final CsmFile file;
    private final int caretOffset;
    private final int selectionStart;
    private final int selectionEnd;
    private final AtomicBoolean canceled;
    private CsmStatement container;

    public StatementFinder(Document doc, CsmFile file, int caretOffset, int selectionStart, int selectionEnd, AtomicBoolean canceled) {
        this.doc = doc;
        this.file = file;
        this.caretOffset = caretOffset;
        this.selectionStart = selectionStart;
        this.selectionEnd = selectionEnd;
        this.canceled = canceled;
    }

    public CsmStatement findStatement() {
        this.container = this.findStatement(this.file.getDeclarations());
        return this.container;
    }

    private CsmStatement findStatement(Collection<? extends CsmOffsetableDeclaration> decls) {
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : decls) {
            if (this.canceled.get()) {
                return null;
            }
            if (csmOffsetableDeclaration.getStartOffset() >= this.selectionStart || this.selectionEnd >= csmOffsetableDeclaration.getEndOffset()) continue;
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmOffsetableDeclaration)) {
                CsmFunctionDefinition def = (CsmFunctionDefinition)csmOffsetableDeclaration;
                return this.findStatementInBody(def.getBody());
            }
            if (CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration)) {
                CsmNamespaceDefinition def = (CsmNamespaceDefinition)csmOffsetableDeclaration;
                return this.findStatement(def.getDeclarations());
            }
            if (!CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) continue;
            CsmClass cls = (CsmClass)csmOffsetableDeclaration;
            return this.findStatement(cls.getMembers());
        }
        return null;
    }

    private CsmStatement findStatementInBody(CsmCompoundStatement body) {
        if (body != null) {
            CsmStatement st;
            int startOffset;
            List statements = body.getStatements();
            for (int i = 0; i < statements.size() && !this.canceled.get() && (startOffset = (st = (CsmStatement)statements.get(i)).getStartOffset()) <= this.selectionStart; ++i) {
                int nexStartOffset = i + 1 < statements.size() ? ((CsmStatement)statements.get(i + 1)).getStartOffset() : body.getEndOffset();
                if (startOffset > this.selectionStart || this.selectionEnd >= nexStartOffset) continue;
                return this.findStatement(st, nexStartOffset);
            }
        }
        return null;
    }

    private CsmStatement findStatement(CsmStatement st, int nexStartOffset) {
        switch (st.getKind()) {
            case COMPOUND: {
                return this.findStatementInBody((CsmCompoundStatement)st);
            }
            case SWITCH: {
                int startOffset;
                CsmSwitchStatement switchStmt = (CsmSwitchStatement)st;
                CsmCondition condition = switchStmt.getCondition();
                if (condition != null && condition.getStartOffset() <= this.selectionStart && this.selectionEnd <= condition.getEndOffset()) {
                    return st;
                }
                CsmStatement body = switchStmt.getBody();
                if (body != null && (startOffset = body.getStartOffset()) <= this.selectionStart && this.selectionEnd < nexStartOffset) {
                    CsmStatement res = this.findStatement(body, nexStartOffset);
                    if (res == null && !this.canceled.get()) {
                        res = st;
                    }
                    return res;
                }
                return null;
            }
            case FOR: {
                int startOffset;
                CsmForStatement forStmt = (CsmForStatement)st;
                CsmStatement initStatement = forStmt.getInitStatement();
                if (initStatement != null && initStatement.getStartOffset() <= this.selectionStart && this.selectionEnd <= initStatement.getEndOffset()) {
                    return st;
                }
                CsmStatement body = forStmt.getBody();
                if (body != null && (startOffset = body.getStartOffset()) <= this.selectionStart && this.selectionEnd < nexStartOffset) {
                    CsmStatement res = this.findStatement(body, nexStartOffset);
                    if (res == null && !this.canceled.get()) {
                        res = st;
                    }
                    return res;
                }
                return null;
            }
            case WHILE: 
            case DO_WHILE: {
                CsmLoopStatement loopStmt = (CsmLoopStatement)st;
                CsmStatement body = loopStmt.getBody();
                if (body != null) {
                    CsmCondition condition;
                    int startOffset = body.getStartOffset();
                    int endOffset = nexStartOffset;
                    if (loopStmt.isPostCheck() && (condition = loopStmt.getCondition()) != null) {
                        endOffset = condition.getStartOffset();
                    }
                    if (startOffset <= this.selectionStart && this.selectionEnd < endOffset) {
                        CsmStatement res = this.findStatement(body, nexStartOffset);
                        if (res == null && !this.canceled.get()) {
                            res = st;
                        }
                        return res;
                    }
                }
                return null;
            }
            case TRY_CATCH: {
                CsmTryCatchStatement tryStmt = (CsmTryCatchStatement)st;
                CsmStatement tryBody = tryStmt.getTryStatement();
                List handlers = tryStmt.getHandlers();
                if (tryBody != null) {
                    int startOffset = tryBody.getStartOffset();
                    int endOffset = nexStartOffset;
                    if (handlers != null && handlers.size() > 0) {
                        endOffset = ((CsmExceptionHandler)handlers.get(0)).getStartOffset();
                    }
                    if (startOffset <= this.selectionStart && this.selectionEnd < endOffset) {
                        CsmStatement res = this.findStatement(tryBody, nexStartOffset);
                        if (res == null && !this.canceled.get()) {
                            res = st;
                        }
                        return res;
                    }
                }
                if (handlers != null) {
                    for (int i = 0; i < handlers.size(); ++i) {
                        CsmExceptionHandler handler = (CsmExceptionHandler)handlers.get(i);
                        int startOffset = handler.getStartOffset();
                        int endOffset = handler.getEndOffset();
                        if (startOffset > this.selectionStart || this.selectionEnd >= endOffset) continue;
                        CsmStatement res = this.findStatement((CsmStatement)handler, nexStartOffset);
                        if (res == null && !this.canceled.get()) {
                            res = st;
                        }
                        return res;
                    }
                }
                return null;
            }
            case IF: {
                int endOffset;
                int startOffset;
                CsmIfStatement ifStmt = (CsmIfStatement)st;
                CsmCondition condition = ifStmt.getCondition();
                if (condition != null && condition.getStartOffset() <= this.selectionStart && this.selectionEnd <= condition.getEndOffset()) {
                    return st;
                }
                CsmStatement thenStmt = ifStmt.getThen();
                CsmStatement elseStmt = ifStmt.getElse();
                if (thenStmt != null) {
                    startOffset = thenStmt.getStartOffset();
                    endOffset = thenStmt.getEndOffset();
                    if (elseStmt != null) {
                        endOffset = elseStmt.getStartOffset();
                    }
                    if (startOffset <= this.selectionStart && this.selectionEnd < endOffset) {
                        CsmStatement res = this.findStatement(thenStmt, nexStartOffset);
                        if (res == null && !this.canceled.get()) {
                            res = st;
                        }
                        return res;
                    }
                }
                if (elseStmt != null) {
                    startOffset = elseStmt.getStartOffset();
                    endOffset = nexStartOffset;
                    if (startOffset <= this.selectionStart && this.selectionEnd < endOffset) {
                        CsmStatement res = this.findStatement(elseStmt, nexStartOffset);
                        if (res == null && !this.canceled.get()) {
                            res = st;
                        }
                        return res;
                    }
                }
                return null;
            }
            case RETURN: {
                return st;
            }
            case DECLARATION: {
                CsmDeclarationStatement decls = (CsmDeclarationStatement)st;
                List declarators = decls.getDeclarators();
                for (CsmDeclaration decl : declarators) {
                    CsmExpression initialValue;
                    CsmVariable d;
                    if (!(decl instanceof CsmVariable) || (d = (CsmVariable)decl).getStartOffset() > this.selectionStart || this.selectionEnd > d.getEndOffset() || (initialValue = d.getInitialValue()) == null || initialValue.getStartOffset() > this.selectionStart || this.selectionEnd > initialValue.getEndOffset()) continue;
                    return st;
                }
                return null;
            }
            case EXPRESSION: {
                int startOffset = st.getStartOffset();
                int endOffset = st.getEndOffset();
                if (startOffset <= this.selectionStart && this.selectionEnd <= endOffset) {
                    return st;
                }
                return null;
            }
        }
        return null;
    }

    static class AddMissingCasesFixImpl
    implements Fix {
        private final CsmStatement st;
        private final FileObject fo;
        private final JTextComponent comp;
        private final BaseDocument doc;
        private final int caretOffset;

        AddMissingCasesFixImpl(CsmStatement st, Document doc, JTextComponent comp, FileObject fo, int caretOffset) {
            this.fo = fo;
            this.st = st;
            this.comp = comp;
            this.doc = (BaseDocument)doc;
            this.caretOffset = caretOffset;
        }

        public String getText() {
            return NbBundle.getMessage(SuggestionFactoryTask.class, (String)"FIX_AddMissingCases");
        }

        public ChangeInfo implement() throws Exception {
            CsmSwitchStatement sw = (CsmSwitchStatement)this.st;
            final CsmCondition condition = sw.getCondition();
            CsmStatement body = sw.getBody();
            final int endOfBody = body.getEndOffset() - 1;
            final AtomicBoolean hasDefault = new AtomicBoolean(false);
            final HashSet<CsmEnumerator> caseSet = new HashSet<CsmEnumerator>();
            final String scope = this.getCases(body, caseSet, hasDefault);
            final StringBuilder buf = new StringBuilder();
            CsmExpressionResolver.resolveType((CsmOffsetable)condition, null, (CsmExpressionResolver.ResolvedTypeHandler)new CsmExpressionResolver.ResolvedTypeHandler(){

                public void process(CsmType resolvedType) {
                    CsmClassifier classifier;
                    CsmScope sc;
                    CsmEnum en = null;
                    if (!caseSet.isEmpty() && CsmKindUtilities.isEnum((CsmObject)(sc = ((CsmEnumerator)caseSet.iterator().next()).getScope()))) {
                        en = (CsmEnum)sc;
                    }
                    if (en == null && resolvedType != null && CsmKindUtilities.isEnum((CsmObject)(classifier = CsmBaseUtilities.getClassifier((CsmType)resolvedType, (CsmFile)condition.getContainingFile(), (int)condition.getStartOffset(), (boolean)true)))) {
                        en = (CsmEnum)classifier;
                    }
                    if (en != null) {
                        String scopeToAdd = scope;
                        if (scopeToAdd == null) {
                            scopeToAdd = AddMissingCasesFixImpl.this.getQualifiedName(CsmBaseUtilities.getLastCommonScope((CsmScope)condition.getScope(), (CsmScope)en), (CsmScope)en);
                            if (scopeToAdd == null) {
                                scopeToAdd = "";
                            }
                            if (!scopeToAdd.isEmpty() && !scopeToAdd.endsWith("::")) {
                                scopeToAdd = scopeToAdd + "::";
                            }
                        }
                        if (en.isStronglyTyped()) {
                            scopeToAdd = scopeToAdd + en.getName() + "::";
                        }
                        for (CsmEnumerator e : en.getEnumerators()) {
                            if (caseSet.contains(e)) continue;
                            buf.append("case ");
                            buf.append(scopeToAdd);
                            buf.append(e.getName());
                            buf.append(':');
                            buf.append('\n');
                            buf.append("break;");
                            buf.append('\n');
                        }
                        if (!hasDefault.get()) {
                            buf.append("default:");
                            buf.append('\n');
                            buf.append("break;");
                            buf.append('\n');
                        }
                    }
                }
            });
            if (buf.length() == 0) {
                return null;
            }
            final ChangeInfo changeInfo = new ChangeInfo();
            this.doc.runAtomicAsUser(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        AddMissingCasesFixImpl.this.doc.insertString(endOfBody, buf.toString(), null);
                        Position start = NbDocument.createPosition((Document)AddMissingCasesFixImpl.this.doc, (int)endOfBody, (Position.Bias)Position.Bias.Forward);
                        Position end = NbDocument.createPosition((Document)AddMissingCasesFixImpl.this.doc, (int)(endOfBody + buf.length()), (Position.Bias)Position.Bias.Backward);
                        changeInfo.add(AddMissingCasesFixImpl.this.fo, start, end);
                        Indent indent = Indent.get((Document)AddMissingCasesFixImpl.this.doc);
                        indent.lock();
                        try {
                            indent.reindent(endOfBody, endOfBody + buf.length() + 1);
                        }
                        finally {
                            indent.unlock();
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            return changeInfo;
        }

        private String getQualifiedName(CsmScope from, CsmScope to) {
            ArrayList<CsmScope> scopes = new ArrayList<CsmScope>();
            while (!Objects.equals(from, to) && CsmKindUtilities.isScopeElement((CsmObject)to)) {
                scopes.add(0, to);
                to = ((CsmScopeElement)to).getScope();
            }
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            for (CsmScope scope : scopes) {
                CsmNamedElement named;
                if (CsmKindUtilities.isEnum((CsmObject)scope) || !CsmKindUtilities.isNamedElement((CsmObject)scope) || CharSequenceUtils.isNullOrEmpty((CharSequence)(named = (CsmNamedElement)scope).getName())) continue;
                if (!first) {
                    sb.append("::");
                } else {
                    first = false;
                }
                sb.append(named.getName());
            }
            return sb.toString();
        }

        private String getCases(CsmStatement body, Set<CsmEnumerator> caseSet, AtomicBoolean hasDefault) {
            String aScope = null;
            if (body != null && body.getKind() == CsmStatement.Kind.COMPOUND) {
                for (CsmStatement c : ((CsmCompoundStatement)body).getStatements()) {
                    if (c.getKind() == CsmStatement.Kind.CASE) {
                        CsmObject next;
                        CsmCaseStatement caseSt = (CsmCaseStatement)c;
                        CsmExpression caseEx = caseSt.getExpression();
                        if (caseEx == null) continue;
                        Collection resolveObjects = CsmExpressionResolver.resolveObjects((CsmOffsetable)caseEx, null);
                        if (resolveObjects != null && !resolveObjects.isEmpty() && CsmKindUtilities.isEnumerator((Object)(next = (CsmObject)resolveObjects.iterator().next()))) {
                            CsmEnumerator enumerator = (CsmEnumerator)next;
                            caseSet.add(enumerator);
                        }
                        if (aScope != null) continue;
                        String t = caseEx.getText().toString();
                        if (t.indexOf("::") >= 0) {
                            aScope = t.substring(0, t.lastIndexOf("::") + 2);
                            continue;
                        }
                        aScope = "";
                        continue;
                    }
                    if (c.getKind() != CsmStatement.Kind.DEFAULT) continue;
                    hasDefault.set(true);
                }
            }
            return aScope;
        }
    }
}

