/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObjectProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public abstract class Configuration
implements ProjectConfiguration {
    private FSPath fsPath;
    private String name;
    private boolean defaultConfiguration;
    private PropertyChangeSupport pcs = null;
    private final Map<String, ConfigurationAuxObject> auxObjectsMap = Collections.synchronizedSortedMap(new TreeMap());
    private Configuration cloneOf;
    private boolean valid = true;

    protected Configuration(String baseDir, String name) {
        this(new FSPath(CndFileUtils.getLocalFileSystem(), baseDir), name);
    }

    protected Configuration(FSPath fsPath, String name) {
        this.fsPath = fsPath;
        this.name = name;
        this.defaultConfiguration = false;
        this.pcs = new PropertyChangeSupport(this);
    }

    protected final void initAuxObjects() {
        ConfigurationAuxObjectProvider[] auxObjectProviders = ConfigurationDescriptorProvider.getAuxObjectProviders();
        for (int i = 0; i < auxObjectProviders.length; ++i) {
            ConfigurationAuxObject pao = auxObjectProviders[i].factoryCreate(this.fsPath.getPath(), this.pcs, this);
            pao.initialize();
            String id = pao.getId();
            if (this.auxObjectsMap.containsKey(id)) {
                System.err.println("Init duplicated ConfigurationAuxObject id=" + id);
            }
            this.auxObjectsMap.put(id, pao);
        }
    }

    public void setCloneOf(Configuration profile) {
        this.cloneOf = profile;
    }

    public Configuration getCloneOf() {
        return this.cloneOf;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBaseDir() {
        return this.fsPath.getPath();
    }

    public FileSystem getFileSystem() {
        return this.fsPath.getFileSystem();
    }

    public void setBaseDir(String baseDir) {
        CndUtils.assertTrue((boolean)CndFileUtils.isLocalFileSystem((FileSystem)this.fsPath.getFileSystem()), (String)"Setting baseDir for non-local configuration?!");
        this.fsPath = new FSPath(this.fsPath.getFileSystem(), baseDir);
    }

    public FSPath getBaseFSPath() {
        return this.fsPath;
    }

    public void setBaseFSPath(FSPath fsPath) {
        this.fsPath = fsPath;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public boolean isDefault() {
        return this.defaultConfiguration;
    }

    public void setDefault(boolean b) {
        this.defaultConfiguration = b;
    }

    public String toString() {
        if (this.isDefault()) {
            return this.getDisplayName() + " " + Configuration.getString("ActiveTxt");
        }
        return this.getDisplayName();
    }

    public void addAuxObject(ConfigurationAuxObject pao) {
        String id = pao.getId();
        if (this.auxObjectsMap.containsKey(id)) {
            System.err.println("Add duplicated ConfigurationAuxObject id=" + id);
        }
        this.auxObjectsMap.put(id, pao);
    }

    public ConfigurationAuxObject removeAuxObject(ConfigurationAuxObject pao) {
        return this.auxObjectsMap.remove(pao.getId());
    }

    public ConfigurationAuxObject removeAuxObject(String id) {
        return this.auxObjectsMap.remove(id);
    }

    public ConfigurationAuxObject getAuxObject(String id) {
        return this.auxObjectsMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationAuxObject[] getAuxObjects() {
        ArrayList<ConfigurationAuxObject> list;
        Map<String, ConfigurationAuxObject> map = this.auxObjectsMap;
        synchronized (map) {
            list = new ArrayList<ConfigurationAuxObject>(this.auxObjectsMap.values());
        }
        return list.toArray(new ConfigurationAuxObject[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, ConfigurationAuxObject> map = this.auxObjectsMap;
        synchronized (map) {
            this.auxObjectsMap.clear();
            this.valid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Map<String, ConfigurationAuxObject> map = this.auxObjectsMap;
        synchronized (map) {
            return this.valid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuxObjects(List<ConfigurationAuxObject> v) {
        Map<String, ConfigurationAuxObject> map = this.auxObjectsMap;
        synchronized (map) {
            this.auxObjectsMap.clear();
            v.forEach(object -> this.auxObjectsMap.put(object.getId(), (ConfigurationAuxObject)object));
        }
    }

    public abstract Configuration cloneConf();

    public abstract void assign(Configuration var1);

    public abstract Configuration copy();

    public void cloneConf(Configuration clone) {
        clone.setDefault(this.isDefault());
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public RunProfile getProfile() {
        return (RunProfile)this.getAuxObject("runprofile");
    }

    private static String getString(String s) {
        return NbBundle.getMessage(Configuration.class, (String)s);
    }
}

