/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.impl.spi;

import java.net.URI;
import java.net.URISyntaxException;

public final class LayerDescriptor {
    public static final String RO_FRAGMENT = "r/o";
    public static final String RW_FRAGMENT = "r/w";
    private final URI uri;
    private final boolean isWritable;

    public LayerDescriptor(URI uri) {
        this.uri = this.removeFragment(uri);
        boolean _isWritable = true;
        String fragment = uri.getFragment();
        if (fragment != null) {
            if (fragment.contains(RO_FRAGMENT)) {
                _isWritable = false;
            } else if (uri.getFragment().contains(RW_FRAGMENT)) {
                _isWritable = true;
            }
        }
        this.isWritable = _isWritable;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.uri != null ? this.uri.hashCode() : 0);
        hash = 37 * hash + (this.isWritable ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LayerDescriptor other = (LayerDescriptor)obj;
        if (!(this.uri == other.uri || this.uri != null && this.uri.equals(other.uri))) {
            return false;
        }
        return this.isWritable == other.isWritable;
    }

    public String toString() {
        return this.uri.toString() + (this.isWritable ? "#r/w" : "#r/o");
    }

    private URI removeFragment(URI uri) {
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null);
        }
        catch (URISyntaxException ex) {
            return uri;
        }
    }
}

