/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.diff;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.git.remote.cli.progress.NotificationListener;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.remote.ui.diff.ExportCommit;
import org.netbeans.modules.git.remote.ui.diff.ExportUncommittedChangesAction;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class ExportCommitAction
extends SingleRepositoryAction {
    @Override
    protected void performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        this.exportCommit(repository, "HEAD");
    }

    public void exportCommit(final VCSFileProxy repository, final String preselectedRevision) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                ExportCommit exportDiffSupport = new ExportCommit(repository, preselectedRevision){

                    public void writeDiffFile(final VCSFileProxy toFile) {
                        final String revStr = this.getSelectionRevision();
                        ExportCommitAction.saveFolderToPrefs(toFile);
                        GitProgressSupport support = new GitProgressSupport(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void perform() {
                                boolean success = false;
                                OutputStream out = null;
                                try {
                                    GitClient client = this.getClient();
                                    ExportCommitAction.ensureParentExists(toFile);
                                    out = new BufferedOutputStream(VCSFileProxySupport.getOutputStream((VCSFileProxy)toFile));
                                    client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(new VCSFileProxy[0]));
                                    this.setProgress(NbBundle.getMessage(ExportUncommittedChangesAction.class, (String)"MSG_ExportCommitAction.preparingDiff"));
                                    client.exportCommit(revStr, out, this.getProgressMonitor());
                                    if (!this.isCanceled()) {
                                        success = true;
                                    }
                                }
                                catch (Exception ex) {
                                    GitClientExceptionHandler.notifyException(ex, true);
                                }
                                finally {
                                    if (out != null) {
                                        try {
                                            out.flush();
                                            out.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (success && VCSFileProxySupport.length((VCSFileProxy)toFile) > 0L) {
                                        VCSFileProxySupport.openFile((VCSFileProxy)toFile);
                                    } else {
                                        VCSFileProxySupport.delete((VCSFileProxy)toFile);
                                    }
                                }
                            }
                        };
                        support.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(ExportCommitAction.class, (String)"LBL_ExportCommitAction_Progress")).waitFinished();
                    }
                };
                exportDiffSupport.export();
            }
        });
    }

    private static void saveFolderToPrefs(VCSFileProxy file) {
        if (file.getParentFile() != null) {
            GitModuleConfig.getDefault().getPreferences().put("ExportDiff.saveFolder", file.getParentFile().getPath());
        }
    }

    private static void ensureParentExists(VCSFileProxy destination) {
        VCSFileProxy parent = destination.getParentFile();
        if (parent != null) {
            VCSFileProxySupport.mkdirs((VCSFileProxy)parent);
        }
    }
}

