/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.history;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.GitTag;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.branch.CherryPickAction;
import org.netbeans.modules.git.remote.ui.checkout.CheckoutRevisionAction;
import org.netbeans.modules.git.remote.ui.checkout.RevertChangesAction;
import org.netbeans.modules.git.remote.ui.diff.ExportCommitAction;
import org.netbeans.modules.git.remote.ui.history.Bundle;
import org.netbeans.modules.git.remote.ui.history.RevisionNode;
import org.netbeans.modules.git.remote.ui.history.SearchExecutor;
import org.netbeans.modules.git.remote.ui.history.SummaryView;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.ui.revert.RevertCommitAction;
import org.netbeans.modules.git.remote.ui.tag.CreateTagAction;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class RepositoryRevision {
    private GitRevisionInfo message;
    private final List<Event> events = new ArrayList<Event>(5);
    private final List<Event> dummyEvents;
    private final Map<VCSFileProxy, String> commonAncestors = new HashMap<VCSFileProxy, String>();
    private final Set<GitTag> tags;
    private final Set<GitBranch> branches;
    private boolean eventsInitialized;
    private Search currentSearch;
    private final PropertyChangeSupport support;
    public static final String PROP_EVENTS_CHANGED = "eventsChanged";
    private final VCSFileProxy repositoryRoot;
    private final VCSFileProxy[] selectionRoots;
    private String preferredRevision;
    private final SearchExecutor.Mode mode;
    private static ViewAction viewAction = new ViewAction();
    private static ViewCurrentAction viewCurrentAction = new ViewCurrentAction();
    private static AnnotateAction annotateAction = new AnnotateAction();
    private static RevertAction revertAction = new RevertAction(0);

    RepositoryRevision(GitRevisionInfo message, VCSFileProxy repositoryRoot, VCSFileProxy[] selectionRoots, Set<GitTag> tags, Set<GitBranch> branches, VCSFileProxy dummyFile, String dummyFileRelativePath, SearchExecutor.Mode mode) {
        this.message = message;
        this.repositoryRoot = repositoryRoot;
        this.selectionRoots = selectionRoots;
        this.tags = tags;
        this.branches = branches;
        this.support = new PropertyChangeSupport(this);
        this.dummyEvents = new ArrayList<Event>(1);
        if (dummyFile != null && dummyFileRelativePath != null) {
            this.dummyEvents.add(new Event(dummyFile, dummyFileRelativePath));
        }
        this.mode = mode;
    }

    public Event[] getEvents() {
        return this.events.toArray(new Event[this.events.size()]);
    }

    Event[] getDummyEvents() {
        return this.dummyEvents.toArray(new Event[this.dummyEvents.size()]);
    }

    public GitRevisionInfo getLog() {
        return this.message;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(this.getLog().getRevision());
        text.append("\t");
        text.append(DateFormat.getDateTimeInstance().format(new Date(this.getLog().getCommitTime())));
        text.append("\t");
        text.append(this.getLog().getAuthor());
        text.append("\n");
        text.append(this.getLog().getFullMessage());
        return text.toString();
    }

    String getAncestorCommit(VCSFileProxy file, GitClient client, ProgressMonitor pm) throws GitException {
        String ancestorCommit = this.commonAncestors.get(file);
        if (ancestorCommit == null && !this.commonAncestors.containsKey(file)) {
            GitRevisionInfo info = null;
            if (this.getLog().getParents().length == 1) {
                info = client.getPreviousRevision(file, this.getLog().getRevision(), pm);
            } else if (this.getLog().getParents().length > 1) {
                info = client.getCommonAncestor(this.getLog().getParents(), pm);
            }
            ancestorCommit = info == null ? null : info.getRevision();
            this.commonAncestors.put(file, ancestorCommit);
        }
        return ancestorCommit;
    }

    public GitBranch[] getBranches() {
        return this.branches == null ? new GitBranch[]{} : this.branches.toArray(new GitBranch[this.branches.size()]);
    }

    public GitTag[] getTags() {
        return this.tags == null ? new GitTag[]{} : this.tags.toArray(new GitTag[this.tags.size()]);
    }

    boolean expandEvents() {
        Search s = this.currentSearch;
        if (s == null && !this.eventsInitialized) {
            this.currentSearch = new Search();
            this.currentSearch.start(Git.getInstance().getRequestProcessor(this.repositoryRoot), this.repositoryRoot);
            return true;
        }
        return !this.eventsInitialized;
    }

    void cancelExpand() {
        Search s = this.currentSearch;
        if (s != null) {
            s.cancel();
            this.currentSearch = null;
        }
    }

    boolean isEventsInitialized() {
        return this.eventsInitialized;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(propertyName, listener);
    }

    VCSFileProxy getRepositoryRoot() {
        return this.repositoryRoot;
    }

    String getShortRevision() {
        String revision = this.getLog().getRevision();
        if (revision.length() > 7) {
            revision = revision.substring(0, 7);
        }
        return revision;
    }

    Action[] getActions() {
        if (RepositoryInfo.getInstance(this.repositoryRoot) == null) {
            return new Action[0];
        }
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        final String revision = this.getPreferredRevision();
        actions.add(new AbstractAction(Bundle.LBL_Action_CheckoutRevision(revision)){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckoutRevisionAction action = (CheckoutRevisionAction)SystemAction.get(CheckoutRevisionAction.class);
                action.checkoutRevision(RepositoryRevision.this.repositoryRoot, revision, null, Bundle.MSG_CheckoutRevision_progress(revision));
            }
        });
        actions.add(new AbstractAction(NbBundle.getMessage(RepositoryRevision.class, (String)"CTL_SummaryView_TagCommit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateTagAction action = (CreateTagAction)SystemAction.get(CreateTagAction.class);
                action.createTag(RepositoryRevision.this.repositoryRoot, RepositoryRevision.this.getLog().getRevision());
            }
        });
        if (this.getLog().getParents().length < 2) {
            if (!this.isInCurrentBranch()) {
                actions.add(new AbstractAction(NbBundle.getMessage(CherryPickAction.class, (String)"LBL_CherryPickAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final String revision = RepositoryRevision.this.getLog().getRevision();
                        Utils.post((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ((CherryPickAction)SystemAction.get(CherryPickAction.class)).cherryPick(RepositoryRevision.this.repositoryRoot, revision);
                            }
                        });
                    }
                });
            }
            actions.add(new AbstractAction(NbBundle.getMessage(ExportCommitAction.class, (String)"LBL_ExportCommitAction_PopupName")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportCommitAction action = (ExportCommitAction)SystemAction.get(ExportCommitAction.class);
                    action.exportCommit(RepositoryRevision.this.repositoryRoot, RepositoryRevision.this.getLog().getRevision());
                }
            });
            if (this.mode != SearchExecutor.Mode.REMOTE_IN) {
                actions.add(new AbstractAction(NbBundle.getMessage(RevertCommitAction.class, (String)"LBL_RevertCommitAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RevertCommitAction action = (RevertCommitAction)SystemAction.get(RevertCommitAction.class);
                        action.revert(RepositoryRevision.this.repositoryRoot, RepositoryRevision.this.selectionRoots, RepositoryRevision.this.getLog().getRevision());
                    }
                });
            }
        }
        return actions.toArray(new Action[actions.size()]);
    }

    private String getPreferredRevision() {
        int n;
        int n2;
        GitBranch[] gitBranchArray;
        if (this.preferredRevision == null) {
            gitBranchArray = this.getBranches();
            n2 = gitBranchArray.length;
            for (n = 0; n < n2; ++n) {
                GitBranch branch = gitBranchArray[n];
                if (branch.getName() == "(no branch)") continue;
                if (!branch.isRemote()) {
                    this.preferredRevision = branch.getName();
                    break;
                }
                if (this.preferredRevision != null) continue;
                this.preferredRevision = branch.getName();
            }
        }
        if (this.preferredRevision == null && (n = 0) < (n2 = (gitBranchArray = this.getTags()).length)) {
            GitBranch tag = gitBranchArray[n];
            this.preferredRevision = tag.getTagName();
        }
        if (this.preferredRevision == null) {
            this.preferredRevision = this.getLog().getRevision();
            this.preferredRevision = this.preferredRevision.length() > 7 ? this.preferredRevision.substring(0, 7) : this.preferredRevision;
        }
        return this.preferredRevision;
    }

    private boolean isInCurrentBranch() {
        GitBranch activeBranch = RepositoryInfo.getInstance(this.repositoryRoot).getActiveBranch();
        for (GitBranch b : this.getLog().getBranches().values()) {
            if (!activeBranch.getName().equals(b.getName()) && !activeBranch.getId().equals(b.getId())) continue;
            return true;
        }
        return false;
    }

    private class Search
    extends GitProgressSupport {
        private Search() {
        }

        @Override
        protected void perform() {
            Map<VCSFileProxy, GitRevisionInfo.GitFileInfo> files;
            try {
                files = RepositoryRevision.this.getLog().getModifiedFiles();
            }
            catch (GitException ex) {
                GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                files = Collections.emptyMap();
            }
            final List<Event> logEvents = this.prepareEvents(files);
            if (!this.isCanceled()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!Search.this.isCanceled()) {
                            RepositoryRevision.this.events.clear();
                            RepositoryRevision.this.dummyEvents.clear();
                            RepositoryRevision.this.events.addAll(logEvents);
                            RepositoryRevision.this.eventsInitialized = true;
                            RepositoryRevision.this.currentSearch = null;
                            RepositoryRevision.this.support.firePropertyChange(RepositoryRevision.PROP_EVENTS_CHANGED, null, new ArrayList(RepositoryRevision.this.events));
                        }
                    }
                });
            }
        }

        @Override
        protected void finishProgress() {
        }

        @Override
        protected void startProgress() {
        }

        @Override
        protected ProgressHandle getProgressHandle() {
            return null;
        }

        private void start(RequestProcessor requestProcessor, VCSFileProxy repositoryRoot) {
            this.start(requestProcessor, repositoryRoot, null);
        }

        private List<Event> prepareEvents(Map<VCSFileProxy, GitRevisionInfo.GitFileInfo> files) {
            ArrayList<Event> logEvents = new ArrayList<Event>(files.size());
            HashSet<VCSFileProxy> renamedFilesOriginals = new HashSet<VCSFileProxy>(files.size());
            for (Map.Entry<VCSFileProxy, GitRevisionInfo.GitFileInfo> e : files.entrySet()) {
                if (e.getValue().getStatus() != GitRevisionInfo.GitFileInfo.Status.RENAMED) continue;
                renamedFilesOriginals.add(e.getValue().getOriginalFile());
            }
            for (Map.Entry<VCSFileProxy, GitRevisionInfo.GitFileInfo> e : files.entrySet()) {
                VCSFileProxy selectionRoot;
                VCSFileProxy f = e.getKey();
                if (renamedFilesOriginals.contains(f)) continue;
                GitRevisionInfo.GitFileInfo info = e.getValue();
                boolean underRoots = false;
                VCSFileProxy[] vCSFileProxyArray = RepositoryRevision.this.selectionRoots;
                int n = vCSFileProxyArray.length;
                for (int i = 0; i < n && !(underRoots = VersioningSupport.isFlat((VCSFileProxy)(selectionRoot = vCSFileProxyArray[i])) ? selectionRoot.equals((Object)f.getParentFile()) : VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)selectionRoot, (VCSFileProxy)f)); ++i) {
                }
                logEvents.add(new Event(info, underRoots));
            }
            Collections.sort(logEvents);
            return logEvents;
        }
    }

    static class RevertAction
    extends HistoryEventAction {
        private VCSFileProxy[] files;
        private String revision;
        private VCSFileProxy repositoryRoot;

        private RevertAction(int fileSize) {
            super(fileSize == 1 ? Bundle.RepositoryRevision_action_RevertTo_single() : Bundle.RepositoryRevision_action_RevertTo());
        }

        private RevertAction(VCSFileProxy repositoryRoot, VCSFileProxy[] files, String revision) {
            this(files.length);
            this.revision = revision;
            this.files = files;
            this.repositoryRoot = repositoryRoot;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((RevertChangesAction)SystemAction.get(RevertChangesAction.class)).revertFiles(this.repositoryRoot, this.files, this.revision, Bundle.RepositoryRevision_action_RevertTo_progress());
        }

        @Override
        protected Action createAction(VCSFileProxy repositoryRoot, Event ... events) {
            String rev = null;
            ArrayList<VCSFileProxy> fileList = new ArrayList<VCSFileProxy>(events.length);
            for (Event e : events) {
                String eventRevision = e.getLogInfoHeader().getShortRevision();
                if (rev == null) {
                    rev = eventRevision;
                } else if (!rev.equals(eventRevision)) {
                    rev = null;
                    break;
                }
                if (!e.isViewEnabled()) continue;
                fileList.add(e.getFile());
            }
            final boolean enbl = rev != null;
            return new RevertAction(repositoryRoot, fileList.toArray(new VCSFileProxy[fileList.size()]), rev){

                @Override
                public boolean isEnabled() {
                    return enbl;
                }
            };
        }
    }

    private static class AnnotateAction
    extends HistoryEventAction {
        Event[] events;
        private VCSFileProxy repositoryRoot;

        private AnnotateAction() {
            super(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_ShowAnnotations"));
        }

        private AnnotateAction(VCSFileProxy repositoryRoot, Event ... events) {
            this();
            this.events = events;
            this.repositoryRoot = repositoryRoot;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new GitProgressSupport(){

                @Override
                protected void perform() {
                    for (Event ev : AnnotateAction.this.events) {
                        ev.openFile(true, this.getProgressMonitor());
                    }
                }
            }.start(Git.getInstance().getRequestProcessor(), this.repositoryRoot, NbBundle.getMessage(SummaryView.class, (String)"MSG_SummaryView.openingFilesFromHistory"));
        }

        @Override
        protected Action createAction(VCSFileProxy repositoryRoot, Event ... events) {
            return new AnnotateAction(repositoryRoot, events);
        }
    }

    private static class ViewCurrentAction
    extends HistoryEventAction {
        VCSFileProxy[] files;

        private ViewCurrentAction() {
            super(Bundle.CTL_Action_ViewCurrent_name());
        }

        private ViewCurrentAction(VCSFileProxy ... files) {
            this();
            this.files = files;
        }

        @Override
        public boolean isEnabled() {
            return this.files.length > 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Utils.post((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (VCSFileProxy f : ViewCurrentAction.this.files) {
                        VCSFileProxySupport.openFile((VCSFileProxy)f.normalizeFile());
                    }
                }
            });
        }

        @Override
        protected Action createAction(VCSFileProxy repositoryRoot, Event ... events) {
            HashSet<VCSFileProxy> fileSet = new HashSet<VCSFileProxy>(events.length);
            for (Event e : events) {
                if (!e.isViewEnabled()) continue;
                fileSet.add(e.getFile());
            }
            return new ViewCurrentAction(fileSet.toArray(new VCSFileProxy[fileSet.size()]));
        }
    }

    private static class ViewAction
    extends HistoryEventAction {
        Event[] events;
        private VCSFileProxy repositoryRoot;

        private ViewAction() {
            super(NbBundle.getMessage(SummaryView.class, (String)"CTL_SummaryView_View"));
        }

        private ViewAction(VCSFileProxy repositoryRoot, Event ... events) {
            this();
            this.events = events;
            this.repositoryRoot = repositoryRoot;
        }

        @Override
        public boolean isEnabled() {
            return this.events.length > 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new GitProgressSupport(){

                @Override
                protected void perform() {
                    for (Event ev : ViewAction.this.events) {
                        if (!ev.isViewEnabled()) continue;
                        ev.openFile(false, this.getProgressMonitor());
                    }
                }
            }.start(Git.getInstance().getRequestProcessor(), this.repositoryRoot, NbBundle.getMessage(SummaryView.class, (String)"MSG_SummaryView.openingFilesFromHistory"));
        }

        @Override
        protected Action createAction(VCSFileProxy repositoryRoot, Event ... events) {
            return new ViewAction(repositoryRoot, events);
        }
    }

    private static abstract class HistoryEventAction
    extends AbstractAction
    implements ContextAwareAction {
        public HistoryEventAction(String name) {
            super(name);
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            return this.createAction(actionContext.lookupAll(RevisionNode.class));
        }

        private Action createAction(Collection<? extends RevisionNode> nodes) {
            ArrayList<Event> events = new ArrayList<Event>(nodes.size());
            VCSFileProxy root = null;
            for (RevisionNode revisionNode : nodes) {
                root = revisionNode.getEvent().getLogInfoHeader().getRepositoryRoot();
                if (!revisionNode.getEvent().isViewEnabled()) continue;
                events.add(revisionNode.getEvent());
            }
            return this.createAction(root, events.toArray(new Event[events.size()]));
        }

        protected abstract Action createAction(VCSFileProxy var1, Event ... var2);
    }

    public class Event
    implements Comparable<Event> {
        private final VCSFileProxy file;
        private final String path;
        private final GitRevisionInfo.GitFileInfo.Status status;
        private boolean underRoots;
        private final VCSFileProxy originalFile;
        private final String originalPath;

        public Event(GitRevisionInfo.GitFileInfo changedPath, boolean underRoots) {
            this.path = changedPath.getRelativePath();
            this.file = changedPath.getFile();
            this.originalPath = changedPath.getOriginalPath() == null ? this.path : changedPath.getOriginalPath();
            this.originalFile = changedPath.getOriginalFile() == null ? this.file : changedPath.getOriginalFile();
            this.status = changedPath.getStatus();
            this.underRoots = underRoots;
        }

        private Event(VCSFileProxy dummyFile, String dummyPath) {
            this.path = dummyPath;
            this.file = dummyFile;
            this.originalPath = dummyPath;
            this.originalFile = dummyFile;
            this.status = GitRevisionInfo.GitFileInfo.Status.UNKNOWN;
            this.underRoots = true;
        }

        public RepositoryRevision getLogInfoHeader() {
            return RepositoryRevision.this;
        }

        public VCSFileProxy getFile() {
            return this.file;
        }

        public VCSFileProxy getOriginalFile() {
            return this.originalFile;
        }

        public String getName() {
            return this.getFile().getName();
        }

        public String getPath() {
            return this.path;
        }

        public char getAction() {
            switch (this.status) {
                case ADDED: {
                    return 'A';
                }
                case MODIFIED: {
                    return 'M';
                }
                case RENAMED: {
                    return 'R';
                }
                case COPIED: {
                    return 'C';
                }
                case REMOVED: {
                    return 'D';
                }
            }
            return '?';
        }

        public String toString() {
            return this.path;
        }

        @Override
        public int compareTo(Event other) {
            int retval = this.status.compareTo((Enum)other.status);
            if (retval == 0) {
                retval = this.path.compareTo(other.path);
            }
            return retval;
        }

        boolean isUnderRoots() {
            return this.underRoots;
        }

        String getOriginalPath() {
            return this.originalPath;
        }

        Action[] getActions(boolean forNodes) {
            ArrayList<Action> actions = new ArrayList<Action>();
            if (this.isViewEnabled()) {
                actions.add(this.getViewAction(forNodes ? null : this));
                actions.add(this.getAnnotateAction(forNodes ? null : this));
                actions.add(this.getRevertAction(forNodes ? null : this));
                actions.add(this.getViewCurrentAction(forNodes ? null : this));
            }
            return actions.toArray(new Action[actions.size()]);
        }

        void openFile(boolean showAnnotations, ProgressMonitor pm) {
            try {
                String revision = this.getLogInfoHeader().getLog().getRevision();
                GitUtils.openInRevision(this.getFile(), -1, revision, showAnnotations, pm);
            }
            catch (IOException ex) {
                Logger.getLogger(RepositoryRevision.class.getName()).log(Level.FINE, null, ex);
            }
        }

        private Action getViewAction(Event event) {
            if (event == null) {
                return viewAction;
            }
            return new ViewAction(RepositoryRevision.this.repositoryRoot, new Event[]{event});
        }

        private Action getViewCurrentAction(Event event) {
            if (event == null) {
                return viewCurrentAction;
            }
            return new ViewCurrentAction(new VCSFileProxy[]{event.getFile()});
        }

        private Action getAnnotateAction(Event event) {
            if (event == null) {
                return annotateAction;
            }
            return new AnnotateAction(RepositoryRevision.this.repositoryRoot, new Event[]{event});
        }

        RevertAction getRevertAction(Event event) {
            if (event == null) {
                return revertAction;
            }
            return new RevertAction(RepositoryRevision.this.repositoryRoot, new VCSFileProxy[]{event.getFile()}, event.getLogInfoHeader().getShortRevision());
        }

        private boolean isViewEnabled() {
            return this.getFile() != null && this.getAction() != 'D';
        }
    }
}

