/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.reset;

import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitClient;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.progress.NotificationListener;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.GitAction;
import org.netbeans.modules.git.remote.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.remote.ui.reset.Reset;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.util.NbBundle;

public class ResetAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(ResetAction.class.getName());

    @Override
    protected void performAction(final VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        final Reset reset = new Reset(repository, roots);
        if (reset.show() && (reset.getType() != GitClient.ResetType.SOFT || !reset.getRevision().equals("HEAD"))) {
            GitProgressSupport supp = new GitProgressSupport(){

                @Override
                protected void perform() {
                    block7: {
                        try {
                            final GitClient client = this.getClient();
                            if (reset.getType() == GitClient.ResetType.HARD) {
                                client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(new VCSFileProxy[]{repository}));
                            }
                            client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(new VCSFileProxy[]{repository}));
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "Reset head, revision: {0}", reset.getRevision());
                            }
                            if (reset.getType() == GitClient.ResetType.HARD) {
                                GitUtils.runWithoutIndexing(new Callable<Void>(){

                                    @Override
                                    public Void call() throws Exception {
                                        client.reset(reset.getRevision(), reset.getType(), this.getProgressMonitor());
                                        return null;
                                    }
                                }, repository);
                                break block7;
                            }
                            client.reset(reset.getRevision(), reset.getType(), this.getProgressMonitor());
                        }
                        catch (GitException ex) {
                            try {
                                GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                            }
                            catch (Throwable throwable) {
                                this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                                Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.getRepositoryRoot(), Git.getInstance().getSeenRoots(repository)));
                                GitUtils.headChanged(repository);
                                throw throwable;
                            }
                            this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                            Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.getRepositoryRoot(), Git.getInstance().getSeenRoots(repository)));
                            GitUtils.headChanged(repository);
                        }
                    }
                    this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                    Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(this.getRepositoryRoot(), Git.getInstance().getSeenRoots(repository)));
                    GitUtils.headChanged(repository);
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(ResetAction.class, (String)"LBL_Reset.progressName"));
        }
    }
}

