/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.platform.installer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.netbeans.modules.javacard.common.GuiUtils;
import org.netbeans.modules.javacard.common.KeysAndValues;
import org.netbeans.modules.javacard.ri.platform.installer.DevicePropertiesPanel;
import org.netbeans.validation.api.AbstractValidator;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ValidatorUtils;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidators;
import org.netbeans.validation.api.conversion.Converter;
import org.netbeans.validation.api.ui.swing.SwingValidationGroup;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class NewDevicePanel
extends JPanel {
    private final DevicePropertiesPanel pnl = new DevicePropertiesPanel();
    private JTextField displayNameField;
    private JLabel jLabel1;
    private JPanel jPanel1;

    public NewDevicePanel(FileObject targetFolder) {
        this.initComponents();
        this.jPanel1.add((Component)this.pnl, "Center");
        SwingValidationGroup group = this.pnl.getValidationGroup();
        Converter c = Converter.find(String.class, Document.class);
        Validator v = c.convert(new Validator[]{ValidatorUtils.merge((Validator[])new Validator[]{StringValidators.REQUIRE_NON_EMPTY_STRING, StringValidators.MAY_NOT_START_WITH_DIGIT, StringValidators.REQUIRE_VALID_FILENAME}), new NonDuplicateFileValidator(targetFolder)});
        group.add((Object)this.displayNameField, v);
        this.displayNameField.setName(this.jLabel1.getText());
        GuiUtils.prepareContainer((Container)this);
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.javacard.AddNewDevice");
    }

    public SwingValidationGroup getValidationGroup() {
        return this.pnl.getValidationGroup();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.displayNameField = new JTextField();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText(NbBundle.getMessage(NewDevicePanel.class, (String)"NewDevicePanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 5, 5);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.displayNameField.setText(NbBundle.getMessage(NewDevicePanel.class, (String)"NewDevicePanel.displayNameField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 5, 12);
        this.add((Component)this.displayNameField, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 12));
        this.jPanel1.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    public void read(KeysAndValues<?> data) {
        this.pnl.read(data);
    }

    public void write(KeysAndValues<?> data) {
        this.pnl.write(data);
        data.put("javacard.device.name", this.displayNameField.getText());
    }

    public String getDeviceName() {
        return this.displayNameField.getText().trim();
    }

    private static final class NonDuplicateFileValidator
    extends AbstractValidator<String> {
        private final FileObject targetFolder;

        NonDuplicateFileValidator(FileObject targetFolder) {
            super(String.class);
            this.targetFolder = targetFolder;
        }

        public void validate(Problems p, String compName, String model) {
            boolean result;
            boolean bl = result = this.targetFolder.getFileObject(model.trim(), "jcard") == null;
            if (!result) {
                p.add(NbBundle.getMessage(NewDevicePanel.class, (String)"ERR_DEVICE_EXISTS", (Object)model));
            }
        }
    }
}

