/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remotefs.versioning.api;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileObject;

public class FileObjectIndexingBridgeProvider {
    private static final Logger LOG = Logger.getLogger(FileObjectIndexingBridgeProvider.class.getName());
    private static FileObjectIndexingBridgeProvider instance;

    public static synchronized FileObjectIndexingBridgeProvider getInstance() {
        if (instance == null) {
            instance = new FileObjectIndexingBridgeProvider();
        }
        return instance;
    }

    private FileObjectIndexingBridgeProvider() {
    }

    public <T> T runWithoutIndexing(final Callable<T> operation, VCSFileProxy ... files) throws Exception {
        if (LOG.isLoggable(Level.FINE)) {
            StringBuffer sb = new StringBuffer();
            if (files != null) {
                for (VCSFileProxy file : files) {
                    sb.append("\n");
                    sb.append(file.getPath());
                }
            }
            LOG.fine("running vcs operaton without scheduling for files:" + sb.toString());
        }
        final ArrayList<FileObject> fos = new ArrayList<FileObject>();
        for (VCSFileProxy f : files) {
            FileObject fo = f.normalizeFile().toFileObject();
            if (fo == null) continue;
            fos.add(fo);
        }
        return (T)IndexingManager.getDefault().runProtected(new Callable<T>(){

            @Override
            public T call() throws Exception {
                IndexingManager.getDefault().refreshAllIndices(false, false, fos.toArray(new FileObject[fos.size()]));
                return operation.call();
            }
        });
    }

    public boolean isIndexingInProgress() {
        return IndexingManager.getDefault().isIndexing();
    }
}

