/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.subversion;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.ui.api.HudsonSCMHelper;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

class SubversionHyperlink
implements OutputListener {
    private static final Logger LOG = Logger.getLogger(SubversionHyperlink.class.getName());
    private final String module;
    private final String path;
    private final int startRev;
    private final int endRev;
    private final HudsonJob job;
    private static Set<String> knownRepos = new HashSet<String>();

    SubversionHyperlink(String module, String path, int startRev, int endRev, HudsonJob job) {
        this.module = module;
        this.path = path;
        this.startRev = startRev;
        this.endRev = endRev;
        this.job = job;
    }

    public void outputLineAction(OutputEvent ev) {
        HudsonSCMHelper.noteWillShowDiff((String)this.path);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                String repo = SubversionHyperlink.this.findRepo(SubversionHyperlink.this.module);
                if (repo == null) {
                    return;
                }
                try {
                    StreamSource before = SubversionHyperlink.this.makeSource(repo, SubversionHyperlink.this.path, SubversionHyperlink.this.startRev);
                    StreamSource after = SubversionHyperlink.this.makeSource(repo, SubversionHyperlink.this.path, SubversionHyperlink.this.endRev);
                    HudsonSCMHelper.showDiff((StreamSource)before, (StreamSource)after, (String)SubversionHyperlink.this.path);
                }
                catch (IOException x) {
                    LOG.log(Level.INFO, null, x);
                }
            }
        });
    }

    public void outputLineSelected(OutputEvent ev) {
    }

    public void outputLineCleared(OutputEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String findRepo(String module) {
        for (String string : knownRepos) {
            if (!module.startsWith(string)) continue;
            return string;
        }
        LOG.log(Level.FINER, "looking for repo from {0}", module);
        try {
            block6: while (true) {
                InputStream is = new ConnectionBuilder().job(this.job).url(module).connection().getInputStream();
                try {
                    String line;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
                    while ((line = bufferedReader.readLine()) != null) {
                        if (!line.equals("  <li><a href=\"../\">..</a></li>")) continue;
                        module = module.replaceFirst("/[^/]+$", "");
                        continue block6;
                    }
                }
                finally {
                    is.close();
                    continue;
                }
                break;
            }
            LOG.log(Level.FINER, "  => {0}", module);
            knownRepos.add(module);
            return module;
        }
        catch (IOException x) {
            LOG.log(Level.FINE, "trying to find repo for " + module, x);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StreamSource makeSource(String repo, String path, int rev) throws IOException {
        StringReader r;
        if (rev == 0) {
            r = new StringReader("");
        } else {
            InputStream is = new URL(repo + "/!svn/ver/" + rev + path).openStream();
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FileUtil.copy((InputStream)is, (OutputStream)baos);
                r = new StringReader(baos.toString());
            }
            finally {
                is.close();
            }
        }
        String mimeType = "text/plain";
        String name = path;
        String title = NbBundle.getMessage(SubversionHyperlink.class, (String)"SubversionHyperlink.title", (Object)path.replaceFirst(".+/", ""), (Object)rev);
        return StreamSource.createSource((String)name, (String)title, (String)mimeType, (Reader)r);
    }
}

