/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.text.MessageFormat;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitConfig;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.Utils;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class InitRepositoryCommand
extends GitCommand {
    private final VCSFileProxy workDir;
    private final ProgressMonitor monitor;
    private final boolean isBare;

    public InitRepositoryCommand(JGitRepository repository, GitClassFactory gitFactory, boolean isBare, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.monitor = monitor;
        this.isBare = isBare;
        this.workDir = this.getRepository().getLocation();
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean repositoryExists = this.getRepository().getMetadataLocation().exists();
        if (repositoryExists) {
            String message = MessageFormat.format(Utils.getBundle(InitRepositoryCommand.class).getString("MSG_Error_RepositoryExists"), this.getRepository().getLocation(), this.getRepository().getMetadataLocation());
            this.monitor.preparationsFailed(message);
            throw new GitException(message);
        }
        this.prepare();
        return true;
    }

    @Override
    protected void run() throws GitException {
        block4: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                    }
                }.runCLI();
                JGitConfig cfg = this.getRepository().getConfig();
                cfg.setBoolean("core", null, "bare", false);
                cfg.unset("core", null, "autocrlf");
                cfg.save();
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block4;
                throw new GitException(t);
            }
        }
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "init");
        if (this.isBare) {
            this.addArgument(0, "--bare");
        }
        this.addArgument(0, this.workDir.getPath());
    }
}

