/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRefUpdateResult;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.openide.util.Cancellable;

public class UpdateRefCommand
extends GitCommand {
    private final String revision;
    private final String refName;
    private final ProgressMonitor monitor;
    private GitRefUpdateResult result;

    public UpdateRefCommand(JGitRepository repository, GitClassFactory gitFactory, String refName, String revision, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.refName = refName;
        this.monitor = monitor;
        this.revision = revision;
    }

    public GitRefUpdateResult getResult() {
        return this.result;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "update-ref");
        this.addArgument(0, this.refName);
        this.addArgument(0, this.revision);
    }

    @Override
    protected void run() throws GitException {
        block4: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        UpdateRefCommand.this.result = GitRefUpdateResult.OK;
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        UpdateRefCommand.this.result = GitRefUpdateResult.NOT_ATTEMPTED;
                    }
                }.runCLI();
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block4;
                throw new GitException(t);
            }
        }
    }
}

