/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.Exceptions;

public final class PlatformInfo {
    private ArrayList<String> list = new ArrayList();
    private String pathName;
    private final ExecutionEnvironment executionEnvironment;
    private final int platform;
    private HostInfo hostinfo;
    private static final Map<ExecutionEnvironment, PlatformInfo> map = new HashMap<ExecutionEnvironment, PlatformInfo>();

    private PlatformInfo(ExecutionEnvironment execEnv) {
        this.executionEnvironment = execEnv;
        try {
            this.hostinfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (ConnectionManager.CancellationException ex) {
            // empty catch block
        }
        if (this.hostinfo != null) {
            block1 : switch (this.hostinfo.getOSFamily()) {
                case SUNOS: {
                    switch (this.hostinfo.getCpuFamily()) {
                        case SPARC: {
                            this.platform = 0;
                            break block1;
                        }
                        case X86: {
                            this.platform = 1;
                            break block1;
                        }
                    }
                    this.platform = 5;
                    break;
                }
                case LINUX: {
                    this.platform = 2;
                    break;
                }
                case WINDOWS: {
                    this.platform = 3;
                    break;
                }
                case MACOSX: {
                    this.platform = 4;
                    break;
                }
                case FREEBSD: {
                    this.platform = 5;
                    break;
                }
                default: {
                    this.platform = 5;
                    break;
                }
            }
        } else {
            this.platform = 6;
        }
        String path = this.getEnv().get(this.getPathName());
        if (Boolean.getBoolean("cnd.debug.use_altpath")) {
            path = System.getProperty("cnd.debug.altpath", path);
        }
        if (path != null) {
            StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String dir = st.nextToken();
                this.list.add(dir);
            }
        } else if (this.isUnix()) {
            this.list.add("/bin");
            this.list.add("/usr/bin");
            this.list.add("/sbin");
            this.list.add("/usr/sbin");
        } else if (this.isWindows()) {
            this.list.add("C:/WINDOWS/System32");
            this.list.add("C:/WINDOWS");
            this.list.add("C:/WINDOWS/System32/WBem");
        } else {
            System.err.println("PlatformInfo: Path is empty for host " + this.executionEnvironment);
        }
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public void setPath(ArrayList<String> newPath) {
        this.list = newPath;
    }

    public ArrayList<String> getPath() {
        return this.list;
    }

    public String getPathAsString() {
        if (this.list.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (String dir : this.list) {
            buf.append(dir);
            buf.append(this.pathSeparator());
        }
        return buf.substring(0, buf.length() - 1);
    }

    public String getPathAsStringWith(String newDir) {
        if (newDir == null || newDir.length() == 0) {
            return this.getPathName() + '=' + this.getPathAsString();
        }
        return this.getPathName() + '=' + newDir + this.pathSeparator() + this.getPathAsString();
    }

    public void add(int pos, String dir) throws IndexOutOfBoundsException {
        this.list.add(pos, dir);
    }

    public void remove(int pos) throws IndexOutOfBoundsException {
        this.list.remove(pos);
    }

    public String getPathName() {
        if (this.pathName == null) {
            if (this.isWindows()) {
                for (String key : this.getEnv().keySet()) {
                    if (!key.toLowerCase(Locale.getDefault()).equals("path")) continue;
                    this.pathName = key.substring(0, 4);
                    return this.pathName;
                }
            }
            this.pathName = "PATH";
        }
        return this.pathName;
    }

    public String findCommand(String cmd) {
        if (cmd != null && cmd.length() > 0) {
            int i = cmd.replace('\\', '/').lastIndexOf(47);
            if (i >= 0) {
                return null;
            }
            ArrayList<String> dirlist = this.getPath();
            for (String dir : dirlist) {
                String path = this.findCommand(dir, cmd);
                if (path == null) continue;
                return path;
            }
        }
        return null;
    }

    public String findCommand(String dir, String cmd) {
        String path2;
        String path = dir + this.separator() + cmd;
        if (this.fileExists(path)) {
            return path;
        }
        if (this.isWindows() && cmd.endsWith(".exe") && this.fileExists(path2 = dir + this.separator() + cmd + ".lnk")) {
            return path;
        }
        if (this.isWindows() && !cmd.endsWith(".exe")) {
            String cmd2 = cmd + ".exe";
            path = dir + this.separator() + cmd2;
            if (this.fileExists(path)) {
                return path;
            }
            String path22 = dir + this.separator() + cmd + ".lnk";
            if (this.fileExists(path22)) {
                return path;
            }
        }
        return null;
    }

    public String separator() {
        return this.isWindows() ? "\\" : "/";
    }

    public String pathSeparator() {
        return this.isWindows() ? ";" : ":";
    }

    public int getPlatform() {
        return this.platform;
    }

    public boolean isWindows() {
        return this.platform == 3;
    }

    public boolean isUnix() {
        return this.platform == 1 || this.platform == 0 || this.platform == 2 || this.platform == 4;
    }

    public boolean isLinux() {
        return this.platform == 2;
    }

    public boolean isMac() {
        return this.platform == 4;
    }

    public boolean isSolaris() {
        return this.platform == 1 || this.platform == 0;
    }

    public boolean isLocalhost() {
        return this.executionEnvironment.isLocal();
    }

    public Map<String, String> getEnv() {
        return HostInfoProvider.getEnv((ExecutionEnvironment)this.executionEnvironment);
    }

    public boolean fileExists(String path) {
        return HostInfoProvider.fileExists((ExecutionEnvironment)this.executionEnvironment, (String)path);
    }

    public File[] listFiles(File file) {
        String files;
        if (this.executionEnvironment.isLocal()) {
            return file.listFiles();
        }
        ProcessUtils.ExitStatus res = ProcessUtils.execute((ExecutionEnvironment)this.executionEnvironment, (String)"ls", (String[])new String[]{"-A1"});
        if (res.isOK() && (files = res.getOutputString()) != null) {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(files));
            ArrayList<File> lines = new ArrayList<File>();
            try {
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    lines.add(new File(line));
                }
                bufferedReader.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
            return lines.toArray(new File[lines.size()]);
        }
        return null;
    }

    public boolean fileIsDirectory(File file) {
        if (this.executionEnvironment.isLocal()) {
            return file.isDirectory();
        }
        return ProcessUtils.execute((ExecutionEnvironment)this.executionEnvironment, (String)"test", (String[])new String[]{"-d", "\"" + file.getPath() + "\""}).isOK();
    }

    public boolean fileIsFile(File file) {
        if (this.executionEnvironment.isLocal()) {
            return file.isFile();
        }
        return ProcessUtils.execute((ExecutionEnvironment)this.executionEnvironment, (String)"test", (String[])new String[]{"-f", "\"" + file.getPath() + "\""}).isOK();
    }

    public boolean fileCanRead(File file) {
        if (this.executionEnvironment.isLocal()) {
            return file.canRead();
        }
        return ProcessUtils.execute((ExecutionEnvironment)this.executionEnvironment, (String)"test", (String[])new String[]{"-r", "\"" + file.getPath() + "\""}).isOK();
    }

    public static synchronized PlatformInfo getDefault(ExecutionEnvironment execEnv) {
        PlatformInfo pi = map.get(execEnv);
        if (pi == null) {
            pi = new PlatformInfo(execEnv);
            map.put(execEnv, pi);
        }
        return pi;
    }

    public static PlatformInfo localhost() {
        return PlatformInfo.getDefault(ExecutionEnvironmentFactory.getLocal());
    }
}

