/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dbws;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.servlet.ServletContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.eclipse.persistence.dbws.DBWSModelProject;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DBWSException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.dbws.DBWSAdapter;
import org.eclipse.persistence.internal.dbws.SOAPResponseWriter;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.xr.Invocation;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.internal.xr.ValueObject;
import org.eclipse.persistence.internal.xr.XRServiceAdapter;
import org.eclipse.persistence.internal.xr.XRServiceFactory;
import org.eclipse.persistence.internal.xr.XRServiceModel;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentUnmarshaller;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sessions.Project;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProviderHelper
extends XRServiceFactory {
    public static final QName SENDER_QNAME = new QName("http://www.w3.org/2003/05/soap-envelope", "Sender");
    public static final QName CLIENT_QNAME = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client");
    protected static final String XSL_PREAMBLE = "<?xml version=\"1.0\"?> <xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\" > <xsl:output method=\"xml\" encoding=\"UTF-8\"/> ";
    protected static final String XSL_POSTSCRIPT = "</xsl:stylesheet>";
    public static final String MATCH_SCHEMA = "<?xml version=\"1.0\"?> <xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\" > <xsl:output method=\"xml\" encoding=\"UTF-8\"/> <xsl:template match=\"/\"><xsl:apply-templates/></xsl:template><xsl:template match=\"//xsd:schema\"><xsl:copy-of select=\".\"/></xsl:template></xsl:stylesheet>";
    public SOAPResponseWriter responseWriter = null;
    protected boolean mtomEnabled;
    protected MessageContext mc;

    protected void setMessageContext(MessageContext mc) {
        this.mc = mc;
    }

    protected InputStream initXRServiceStream(ClassLoader parentClassLoader, ServletContext sc) {
        InputStream xrServiceStream = null;
        String[] stringArray = Util.META_INF_PATHS;
        int n = Util.META_INF_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String searchPath = stringArray[n2];
            String path = String.valueOf(searchPath) + "eclipselink-dbws.xml";
            xrServiceStream = parentClassLoader.getResourceAsStream(path);
            if (xrServiceStream != null) break;
            ++n2;
        }
        if (xrServiceStream == null) {
            throw new WebServiceException((Throwable)DBWSException.couldNotLocateFile("eclipselink-dbws.xml"));
        }
        return xrServiceStream;
    }

    protected InputStream initXRSchemaStream(ClassLoader parentClassLoader, ServletContext sc) {
        InputStream xrSchemaStream = null;
        String path = "wsdl/eclipselink-dbws-schema.xsd";
        if (sc != null) {
            path = "/WEB-INF/" + path;
            xrSchemaStream = sc.getResourceAsStream(path);
        } else {
            xrSchemaStream = parentClassLoader.getResourceAsStream(path);
        }
        if (xrSchemaStream == null) {
            throw new WebServiceException((Throwable)DBWSException.couldNotLocateFile("eclipselink-dbws-schema.xsd"));
        }
        return xrSchemaStream;
    }

    protected InputStream initWSDLInputStream(ClassLoader parentClassLoader, ServletContext sc) {
        InputStream wsdlInputStream = null;
        String path = "wsdl/eclipselink-dbws.wsdl";
        if (sc != null) {
            path = "/WEB-INF/" + path;
            wsdlInputStream = sc.getResourceAsStream(path);
        } else {
            wsdlInputStream = parentClassLoader.getResourceAsStream(path);
        }
        if (wsdlInputStream == null) {
            throw new WebServiceException((Throwable)DBWSException.couldNotLocateFile("eclipselink-dbws.wsdl"));
        }
        return wsdlInputStream;
    }

    public void init(ClassLoader parentClassLoader, ServletContext sc, boolean mtomEnabled) {
        DBWSAdapter dbwsAdapter;
        block22: {
            XRServiceModel xrServiceModel;
            this.parentClassLoader = parentClassLoader;
            this.mtomEnabled = mtomEnabled;
            InputStream xrServiceStream = this.initXRServiceStream(parentClassLoader, sc);
            DBWSModelProject xrServiceModelProject = new DBWSModelProject();
            XMLContext xmlContext = new XMLContext(xrServiceModelProject);
            XMLUnmarshaller unmarshaller = xmlContext.createUnmarshaller();
            try {
                try {
                    xrServiceModel = (XRServiceModel)unmarshaller.unmarshal(xrServiceStream);
                }
                catch (XMLMarshalException xMLMarshalException) {
                    throw new WebServiceException((Throwable)DBWSException.couldNotParseDBWSFile());
                }
            }
            catch (Throwable throwable) {
                try {
                    xrServiceStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                xrServiceStream.close();
            }
            catch (IOException iOException) {}
            this.xrSchemaStream = this.initXRSchemaStream(parentClassLoader, sc);
            try {
                this.buildService(xrServiceModel);
            }
            catch (Exception e) {
                throw new WebServiceException((Throwable)e);
            }
            dbwsAdapter = (DBWSAdapter)this.xrService;
            InputStream wsdlInputStream = this.initWSDLInputStream(parentClassLoader, sc);
            try {
                try {
                    StringWriter sw = new StringWriter();
                    StreamSource wsdlStreamSource = new StreamSource(wsdlInputStream);
                    Transformer t = TransformerFactory.newInstance().newTransformer(new StreamSource(new StringReader(MATCH_SCHEMA)));
                    StreamResult streamResult = new StreamResult(sw);
                    t.transform(wsdlStreamSource, streamResult);
                    sw.toString();
                    wsdlInputStream.close();
                    SchemaModelProject schemaProject = new SchemaModelProject();
                    XMLContext xmlContext2 = new XMLContext(schemaProject);
                    unmarshaller = xmlContext2.createUnmarshaller();
                    Schema extendedSchema = (Schema)unmarshaller.unmarshal(new StringReader(sw.toString()));
                    dbwsAdapter.setExtendedSchema(extendedSchema);
                }
                catch (Exception exception) {
                    try {
                        wsdlInputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    wsdlInputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                wsdlInputStream.close();
            }
            catch (IOException iOException) {}
        }
        String tns = dbwsAdapter.getExtendedSchema().getTargetNamespace();
        Project oxProject = dbwsAdapter.getOXSession().getProject();
        XMLDescriptor invocationDescriptor = new XMLDescriptor();
        invocationDescriptor.setJavaClass(Invocation.class);
        NamespaceResolver nr = new NamespaceResolver();
        invocationDescriptor.setNamespaceResolver(nr);
        nr.put("srvc", tns);
        nr.setDefaultNamespaceURI(tns);
        XMLAnyCollectionMapping parametersMapping = new XMLAnyCollectionMapping();
        parametersMapping.setAttributeName("parameters");
        parametersMapping.setAttributeAccessor(new AttributeAccessor(){
            Project oxProject;
            DBWSAdapter dbwsAdapter;

            @Override
            public Object getAttributeValueFromObject(Object object) {
                return ((Invocation)object).getParameters();
            }

            /*
             * Could not resolve type clashes
             */
            @Override
            public void setAttributeValueInObject(Object object, Object value) {
                Invocation invocation = (Invocation)object;
                Vector values = (Vector)value;
                block4: for (Object o : values) {
                    String key;
                    if (o instanceof Element) {
                        Element e = (Element)o;
                        key = e.getLocalName();
                        if ("theInstance".equals(key)) {
                            NodeList nl = e.getChildNodes();
                            int j = 0;
                            while (j < nl.getLength()) {
                                Node n = nl.item(j);
                                if (n.getNodeType() == 1) {
                                    try {
                                        Object theInstance = this.dbwsAdapter.getXMLContext().createUnmarshaller().unmarshal(n);
                                        if (theInstance instanceof XMLRoot) {
                                            theInstance = ((XMLRoot)theInstance).getObject();
                                        }
                                        invocation.setParameter(key, theInstance);
                                        continue block4;
                                    }
                                    catch (XMLMarshalException xmlMarshallException) {
                                        throw new WebServiceException((Throwable)xmlMarshallException);
                                    }
                                }
                                ++j;
                            }
                            continue;
                        }
                        ClassDescriptor desc = null;
                        for (XMLDescriptor xdesc : this.oxProject.getOrderedDescriptors()) {
                            XMLSchemaReference schemaReference = xdesc.getSchemaReference();
                            if (schemaReference == null || !schemaReference.getSchemaContext().equalsIgnoreCase(key)) continue;
                            desc = xdesc;
                            break;
                        }
                        if (desc != null) {
                            try {
                                Object theObject = this.dbwsAdapter.getXMLContext().createUnmarshaller().unmarshal(e, desc.getJavaClass());
                                if (theObject instanceof XMLRoot) {
                                    theObject = ((XMLRoot)theObject).getObject();
                                }
                                invocation.setParameter(key, theObject);
                                continue;
                            }
                            catch (XMLMarshalException xmlMarshallException) {
                                throw new WebServiceException((Throwable)xmlMarshallException);
                            }
                        }
                        String serviceName = e.getParentNode().getLocalName();
                        boolean found = false;
                        for (Operation op : this.dbwsAdapter.getOperationsList()) {
                            if (op.getName().equals(serviceName)) {
                                for (Parameter p : op.getParameters()) {
                                    if (!p.getName().equals(key)) continue;
                                    desc = this.dbwsAdapter.getDescriptorsByQName().get(p.getType());
                                    if (desc == null) break;
                                    found = true;
                                    break;
                                }
                            }
                            if (found) break;
                        }
                        if (found) {
                            Object theObject = this.dbwsAdapter.getXMLContext().createUnmarshaller().unmarshal(e, desc.getJavaClass());
                            if (theObject instanceof XMLRoot) {
                                theObject = ((XMLRoot)theObject).getObject();
                            }
                            invocation.setParameter(key, theObject);
                            continue;
                        }
                        StringBuffer sb = new StringBuffer();
                        NodeList childNodes = e.getChildNodes();
                        int idx = 0;
                        while (idx < childNodes.getLength()) {
                            if (childNodes.item(idx).getNodeType() == 3) {
                                sb.append(childNodes.item(idx).getNodeValue());
                            }
                            ++idx;
                        }
                        invocation.setParameter(key, sb.toString());
                        continue;
                    }
                    XMLDescriptor descriptor = (XMLDescriptor)this.oxProject.getDescriptor(o.getClass());
                    key = descriptor.getDefaultRootElement();
                    int idx = key.indexOf(58);
                    if (idx != -1) {
                        key = key.substring(idx + 1);
                    }
                    invocation.setParameter(key, o);
                }
            }

            public AttributeAccessor setProjectAndAdapter(Project oxProject, DBWSAdapter dbwsAdapter) {
                this.oxProject = oxProject;
                this.dbwsAdapter = dbwsAdapter;
                return this;
            }
        }.setProjectAndAdapter(oxProject, dbwsAdapter));
        parametersMapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
        invocationDescriptor.addMapping(parametersMapping);
        oxProject.addDescriptor(invocationDescriptor);
        ((DatabaseSessionImpl)dbwsAdapter.getOXSession()).initializeDescriptorIfSessionAlive(invocationDescriptor);
        dbwsAdapter.getXMLContext().storeXMLDescriptorByQName(invocationDescriptor);
        this.responseWriter = new SOAPResponseWriter(dbwsAdapter);
        this.responseWriter.initialize();
    }

    public SOAPMessage invoke(SOAPMessage request) {
        ComplexType complexType;
        SOAPElement body;
        Map attachments = null;
        if (this.mtomEnabled) {
            attachments = (Map)this.mc.get((Object)"javax.xml.ws.binding.attachments.inbound");
        }
        SOAPMessage response = null;
        boolean usesSOAP12 = false;
        DBWSAdapter dbwsAdapter = (DBWSAdapter)this.xrService;
        SOAPEnvelope envelope = null;
        try {
            envelope = request.getSOAPPart().getEnvelope();
        }
        catch (SOAPException se) {
            throw new WebServiceException(se.getMessage(), (Throwable)se);
        }
        String namespaceURI = envelope.getNamespaceURI();
        usesSOAP12 = namespaceURI.equals("http://www.w3.org/2003/05/soap-envelope");
        try {
            body = ProviderHelper.getSOAPBodyElement(envelope);
        }
        catch (SOAPException se) {
            throw new WebServiceException(se.getMessage(), (Throwable)se);
        }
        if (body == null) {
            SOAPFault soapFault = null;
            try {
                SOAPFactory soapFactory = null;
                soapFactory = usesSOAP12 ? SOAPFactory.newInstance((String)"SOAP 1.2 Protocol") : SOAPFactory.newInstance();
                QName faultCodeQName = null;
                faultCodeQName = usesSOAP12 ? SENDER_QNAME : CLIENT_QNAME;
                soapFault = soapFactory.createFault("SOAPMessage request format error - missing body element", faultCodeQName);
            }
            catch (SOAPException sOAPException) {}
            throw new SOAPFaultException(soapFault);
        }
        XMLRoot xmlRoot = null;
        try {
            XMLContext xmlContext = dbwsAdapter.getXMLContext();
            XMLUnmarshaller unmarshaller = xmlContext.createUnmarshaller();
            if (attachments != null && attachments.size() > 0) {
                unmarshaller.setAttachmentUnmarshaller(new XMLAttachmentUnmarshaller(){
                    Map<String, DataHandler> attachments;

                    public XMLAttachmentUnmarshaller setAttachments(Map<String, DataHandler> attachments) {
                        this.attachments = attachments;
                        return this;
                    }

                    @Override
                    public boolean isXOPPackage() {
                        return true;
                    }

                    @Override
                    public DataHandler getAttachmentAsDataHandler(String id) {
                        String attachmentRefId = id;
                        if (attachmentRefId.startsWith("cid:")) {
                            attachmentRefId = attachmentRefId.substring(4);
                        }
                        return this.attachments.get(attachmentRefId);
                    }

                    @Override
                    public byte[] getAttachmentAsByteArray(String id) {
                        DataHandler dh;
                        ByteArrayOutputStream out;
                        block5: {
                            out = null;
                            dh = this.attachments.get(id);
                            if (dh != null) break block5;
                            return null;
                        }
                        try {
                            int len;
                            InputStream in = dh.getInputStream();
                            out = new ByteArrayOutputStream(1024);
                            byte[] buf = new byte[1024];
                            while ((len = in.read(buf)) > 0) {
                                out.write(buf, 0, len);
                            }
                        }
                        catch (IOException iOException) {}
                        if (out != null) {
                            return out.toByteArray();
                        }
                        return null;
                    }
                }.setAttachments(attachments));
                dbwsAdapter.setCurrentAttachmentUnmarshaller(unmarshaller.getAttachmentUnmarshaller());
            }
            xmlRoot = (XMLRoot)unmarshaller.unmarshal((Node)body, Invocation.class);
        }
        catch (Exception e) {
            SOAPFault soapFault = null;
            try {
                SOAPFactory soapFactory = null;
                soapFactory = usesSOAP12 ? SOAPFactory.newInstance((String)"SOAP 1.2 Protocol") : SOAPFactory.newInstance();
                QName faultCodeQName = null;
                faultCodeQName = usesSOAP12 ? SENDER_QNAME : CLIENT_QNAME;
                Throwable e1 = e;
                if (e.getCause() != null) {
                    e1 = e.getCause();
                }
                soapFault = soapFactory.createFault("SOAPMessage request format error - " + e1, faultCodeQName);
            }
            catch (SOAPException sOAPException) {}
            throw new SOAPFaultException(soapFault);
        }
        Invocation invocation = (Invocation)xmlRoot.getObject();
        invocation.setName(xmlRoot.getLocalName());
        Operation op = dbwsAdapter.getOperation(invocation.getName());
        org.eclipse.persistence.internal.oxm.schema.model.Element invocationElement = (org.eclipse.persistence.internal.oxm.schema.model.Element)dbwsAdapter.getExtendedSchema().getTopLevelElements().get(invocation.getName());
        String typeName = invocationElement.getType();
        int idx = typeName.indexOf(58);
        if (idx != -1) {
            typeName = typeName.substring(idx + 1);
        }
        if ((complexType = (ComplexType)dbwsAdapter.getExtendedSchema().getTopLevelComplexTypes().get(typeName)).getSequence() != null) {
            for (org.eclipse.persistence.internal.oxm.schema.model.Element e : complexType.getSequence().getOrderedElements()) {
                QName argQName;
                Class<?> clz;
                String argName = e.getName();
                Object argValue = invocation.getParameter(argName);
                String argType = e.getType();
                if (argType == null) continue;
                String argTypePrefix = null;
                String nameSpaceURI = null;
                idx = argType.indexOf(58);
                if (idx != -1) {
                    argTypePrefix = argType.substring(0, idx);
                    argType = argType.substring(idx + 1);
                    nameSpaceURI = dbwsAdapter.getSchema().getNamespaceResolver().resolveNamespacePrefix(argTypePrefix);
                }
                if ((clz = Util.SCHEMA_2_CLASS.get(argQName = argTypePrefix == null ? new QName(nameSpaceURI, argType) : new QName(nameSpaceURI, argType, argTypePrefix))) == null) continue;
                argValue = ((XMLConversionManager)dbwsAdapter.getOXSession().getDatasourcePlatform().getConversionManager()).convertObject(argValue, clz, argQName);
                invocation.setParameter(argName, argValue);
            }
        }
        Object result = null;
        try {
            result = op.invoke(dbwsAdapter, invocation);
            if (result instanceof ValueObject) {
                result = ((ValueObject)result).value;
            }
            response = this.responseWriter.generateResponse(op, usesSOAP12, result);
        }
        catch (SOAPException se) {
            throw new WebServiceException(se.getMessage(), (Throwable)se);
        }
        catch (Exception e) {
            try {
                response = this.responseWriter.generateResponse(op, usesSOAP12, e);
            }
            catch (SOAPException sOAPException) {
                SOAPFault soapFault = null;
                try {
                    SOAPFactory soapFactory = null;
                    soapFactory = usesSOAP12 ? SOAPFactory.newInstance((String)"SOAP 1.2 Protocol") : SOAPFactory.newInstance();
                    QName faultCodeQName = null;
                    faultCodeQName = usesSOAP12 ? SOAPResponseWriter.RECEIVER_QNAME : SOAPResponseWriter.SERVER_QNAME;
                    soapFault = soapFactory.createFault("SOAPMessage response error - " + e.getMessage(), faultCodeQName);
                }
                catch (SOAPException sOAPException2) {}
                throw new SOAPFaultException(soapFault);
            }
        }
        return response;
    }

    public void destroy() {
        this.logoutSessions();
        this.responseWriter = null;
        try {
            this.xrSchemaStream.close();
        }
        catch (IOException iOException) {}
        this.xrSchemaStream = null;
        this.parentClassLoader = null;
        this.xrService.setXMLContext(null);
        this.xrService = null;
    }

    @Override
    public XRServiceAdapter buildService(XRServiceModel xrServiceModel) {
        this.xrService = new DBWSAdapter();
        DBWSAdapter dbws = (DBWSAdapter)this.xrService;
        dbws.setName(xrServiceModel.getName());
        dbws.setSessionsFile(xrServiceModel.getSessionsFile());
        dbws.setOperations(xrServiceModel.getOperations());
        this.initializeService(this.parentClassLoader, this.xrSchemaStream);
        return dbws;
    }

    public static SOAPElement getSOAPBodyElement(SOAPEnvelope envelope) throws SOAPException {
        Iterator it = envelope.getBody().getChildElements();
        while (it.hasNext()) {
            Object node = it.next();
            if (!(node instanceof SOAPBodyElement)) continue;
            return (SOAPElement)node;
        }
        return null;
    }
}

