/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DoesExistQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.QueryRedirector;

public class WriteObjectQuery
extends ObjectLevelModifyQuery {
    public WriteObjectQuery() {
    }

    public WriteObjectQuery(Object objectToWrite) {
        this();
        this.setObject(objectToWrite);
    }

    public WriteObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    @Override
    public Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException {
        if (this.getObjectChangeSet() != null) {
            return this.getQueryMechanism().executeWriteWithChangeSet();
        }
        return this.getQueryMechanism().executeWrite();
    }

    public void executeCommit() throws DatabaseException, OptimisticLockException {
        boolean doesExist;
        if (this.getSession().isUnitOfWork()) {
            boolean bl = doesExist = !((UnitOfWorkImpl)this.getSession()).isCloneNewObject(this.getObject());
            if (doesExist) {
                doesExist = ((UnitOfWorkImpl)this.getSession()).isObjectRegistered(this.getObject());
            }
        } else {
            DoesExistQuery existQuery = (DoesExistQuery)this.descriptor.getQueryManager().getDoesExistQuery().clone();
            existQuery.setObject(this.getObject());
            existQuery.setPrimaryKey(this.getPrimaryKey());
            existQuery.setDescriptor(this.descriptor);
            existQuery.setTranslationRow(this.getTranslationRow());
            doesExist = (Boolean)this.getSession().executeQuery(existQuery);
        }
        if (doesExist) {
            this.getQueryMechanism().updateObjectForWrite();
        } else {
            this.getQueryMechanism().insertObjectForWrite();
        }
    }

    public void executeCommitWithChangeSet() throws DatabaseException, OptimisticLockException {
        if (!this.getObjectChangeSet().isNew()) {
            if (!this.getSession().getCommitManager().isCommitInPreModify(this.getObject())) {
                this.getQueryMechanism().updateObjectForWriteWithChangeSet();
            }
        } else if (this.getSession().getCommitManager().isCommitInPreModify(this.getObject())) {
            this.dontCascadeParts();
            this.getQueryMechanism().insertObjectForWrite();
            this.getSession().getCommitManager().markShallowCommit(this.object);
        } else {
            this.getQueryMechanism().insertObjectForWrite();
        }
    }

    @Override
    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultQueryRedirector();
    }

    @Override
    public boolean isWriteObjectQuery() {
        return true;
    }

    @Override
    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (!this.isInsertObjectQuery() && (this.getTranslationRow() == null || this.getTranslationRow().isEmpty())) {
            this.setTranslationRow(this.descriptor.getObjectBuilder().buildRowForTranslation(this.getObject(), this.getSession()));
        }
    }
}

