/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.configurations;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.DefaultListModel;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.remote.ui.RemoteFileChooserUtil;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.MakeProject;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MakeArtifactChooser
extends JPanel
implements PropertyChangeListener {
    private final ArtifactType artifactType;
    private static final RequestProcessor RP = new RequestProcessor("MakeArtifactChooser", 1);
    private ModelUpdater modelUpdater;
    private final Object modelUpdaterLock = new Object();
    private final FSPath baseDir;
    private JLabel libFilesLabel;
    private JList listArtifacts;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JScrollPane scrollPane1;

    public MakeArtifactChooser(ArtifactType artifactType, JFileChooser chooser, FSPath baseDir) {
        this.artifactType = artifactType;
        this.baseDir = baseDir;
        this.initComponents();
        this.listArtifacts.setModel(new MyDefaultListModel(false));
        chooser.addPropertyChangeListener(this);
        this.listArtifacts.getAccessibleContext().setAccessibleDescription(MakeArtifactChooser.getString("PROJECT_LIBRARY_FILES_AD"));
    }

    private void initComponents() {
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.libFilesLabel = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.listArtifacts = new JList();
        this.setLayout(new GridBagLayout());
        this.projectLabel.setLabelFor(this.projectTextField);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/configurations/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)bundle.getString("PROJECT_NAME_TXT"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.libFilesLabel.setLabelFor(this.listArtifacts);
        Mnemonics.setLocalizedText((JLabel)this.libFilesLabel, (String)bundle.getString("PROJECT_LIBRARY_FILES_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 2, 0);
        this.add((Component)this.libFilesLabel, gridBagConstraints);
        this.scrollPane1.setViewportView(this.listArtifacts);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.scrollPane1, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("SelectedFileChangedProperty".equals(e.getPropertyName())) {
            JFileChooser chooser = (JFileChooser)e.getSource();
            File dir = chooser.getSelectedFile();
            if (SwingUtilities.isEventDispatchThread()) {
                this.listArtifacts.setModel(new MyDefaultListModel(true));
            }
            if (dir != null) {
                Object object = this.modelUpdaterLock;
                synchronized (object) {
                    if (this.modelUpdater != null) {
                        this.modelUpdater.cancel();
                    }
                    this.modelUpdater = new ModelUpdater(dir);
                    RP.post((Runnable)this.modelUpdater);
                }
            }
        }
    }

    public static MakeArtifact[] showDialog(ArtifactType artifactType, Project master, FSPath baseDir, Component parent) {
        MakeProject mprj;
        ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)baseDir.getFileSystem());
        String chooser_key = "MakeArtifactChooser";
        String seed = RemoteFileChooserUtil.getCurrentChooserFile((String)"MakeArtifactChooser", (ExecutionEnvironment)env);
        JFileChooser chooser = RemoteFileChooserUtil.createProjectChooser((ExecutionEnvironment)env, (String)MakeArtifactChooser.getString("ADD_PROJECT_DIALOG_TITLE"), (String)MakeArtifactChooser.getString("ADD_PROJECT_DIALOG_AD"), (String)MakeArtifactChooser.getString("ADD_BUTTON_TXT"), (String)seed);
        MakeArtifactChooser accessory = new MakeArtifactChooser(artifactType, chooser, baseDir);
        chooser.setAccessory(accessory);
        chooser.setPreferredSize(new Dimension(650, 380));
        int option = chooser.showOpenDialog(parent);
        if (option != 0) {
            return null;
        }
        RemoteFileChooserUtil.setCurrentChooserFile((String)"MakeArtifactChooser", (String)chooser.getCurrentDirectory().getAbsolutePath(), (ExecutionEnvironment)env);
        MyDefaultListModel model = (MyDefaultListModel)accessory.listArtifacts.getModel();
        Project selectedProject = model.getProject();
        if (selectedProject == null) {
            return null;
        }
        if (selectedProject.getProjectDirectory().equals(master.getProjectDirectory())) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MakeArtifactChooser.getString("ADD_ITSELF_ERROR"), 1));
            return null;
        }
        if (master instanceof MakeProject && (mprj = (MakeProject)master).getActiveConfiguration() != null && mprj.getActiveConfiguration().getConfigurationType().getValue() != 0 && ProjectUtils.hasSubprojectCycles((Project)master, (Project)selectedProject)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MakeArtifactChooser.getString("ADD_CYCLIC_ERROR"), 1));
            return null;
        }
        Object[] tmp = new Object[model.getSize()];
        int count = 0;
        for (int i = 0; i < tmp.length; ++i) {
            Object elementAt;
            if (!accessory.listArtifacts.isSelectedIndex(i) || !((elementAt = model.getElementAt(i)) instanceof MakeArtifact)) continue;
            tmp[count] = elementAt;
            ++count;
        }
        MakeArtifact[] artifactItems = new MakeArtifact[count];
        System.arraycopy(tmp, 0, artifactItems, 0, count);
        return artifactItems;
    }

    private static String getString(String s) {
        return NbBundle.getBundle(MakeArtifactChooser.class).getString(s);
    }

    private List<MakeArtifact> findArtifacts(File dir, AtomicInteger def, AtomicReference<Project> project, AtomicBoolean cancelled) {
        if (dir == null) {
            return Collections.emptyList();
        }
        String projectAbsPath = dir.getAbsolutePath();
        if (projectAbsPath == null) {
            return Collections.emptyList();
        }
        if (cancelled.get()) {
            return Collections.emptyList();
        }
        try {
            FileObject fo = this.baseDir.getFileSystem().findResource(CndFileUtils.normalizeAbsolutePath((FileSystem)this.baseDir.getFileSystem(), (String)projectAbsPath));
            if (fo != null && fo.isValid()) {
                project.set(ProjectManager.getDefault().findProject(fo));
            }
        }
        catch (IOException | IllegalArgumentException e) {
            e.printStackTrace(System.err);
        }
        if (project.get() == null) {
            return Collections.emptyList();
        }
        MakeArtifact[] artifacts = MakeArtifact.getMakeArtifacts((Project)project.get());
        if (artifacts == null) {
            return Collections.emptyList();
        }
        ArrayList<MakeArtifact> result = new ArrayList<MakeArtifact>(artifacts.length);
        for (int i = 0; i < artifacts.length; ++i) {
            if (cancelled.get()) {
                return Collections.emptyList();
            }
            if (this.artifactType == ArtifactType.LIBRARY) {
                if (artifacts[i].getConfigurationType() == 0 && (artifacts[i].getOutput().endsWith(".a") || artifacts[i].getOutput().endsWith(".so") || artifacts[i].getOutput().endsWith(".dylib") || artifacts[i].getOutput().endsWith(".lib") || artifacts[i].getOutput().endsWith(".dll")) || artifacts[i].getConfigurationType() == 2 || artifacts[i].getConfigurationType() == 10 || artifacts[i].getConfigurationType() == 3 || artifacts[i].getConfigurationType() == 5 || artifacts[i].getConfigurationType() == 6) {
                    result.add(artifacts[i]);
                }
            } else if (this.artifactType == ArtifactType.PROJECT) {
                result.add(artifacts[i]);
            } else assert (false);
            if (!artifacts[i].getActive()) continue;
            def.set(i);
        }
        return result;
    }

    private static final class MyDefaultListModel
    extends DefaultListModel {
        private final Project project;
        private final int def;

        private MyDefaultListModel(boolean loading) {
            this.project = null;
            this.def = -1;
            if (loading) {
                this.addElement(MakeArtifactChooser.getString("LOADING_PROJECT"));
            }
        }

        private MyDefaultListModel(Project project, List<MakeArtifact> artifacts, int def) {
            this.project = project;
            this.def = def;
            artifacts.forEach(a -> this.addElement(a));
        }

        private Project getProject() {
            return this.project;
        }

        public int getDef() {
            return this.def;
        }
    }

    private class ModelUpdater
    implements Runnable {
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private final File dir;
        private MyDefaultListModel model;

        public ModelUpdater(File dir) {
            this.dir = dir;
        }

        public void cancel() {
            this.cancelled.set(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                if (!this.cancelled.get() && this.model != null) {
                    MakeArtifactChooser.this.listArtifacts.setModel(this.model);
                    Project project = this.model.getProject();
                    MakeArtifactChooser.this.projectTextField.setText(project == null ? "" : ProjectUtils.getInformation((Project)project).getDisplayName());
                    MakeArtifactChooser.this.listArtifacts.setModel(this.model);
                    if (this.model.getDef() >= 0) {
                        MakeArtifactChooser.this.listArtifacts.setSelectionInterval(this.model.getDef(), this.model.getDef());
                    }
                }
            } else if (!this.cancelled.get()) {
                AtomicInteger def = new AtomicInteger(-1);
                AtomicReference<Object> project = new AtomicReference<Object>(null);
                List artifacts = MakeArtifactChooser.this.findArtifacts(this.dir, def, project, this.cancelled);
                ModelUpdater modelUpdater = this;
                synchronized (modelUpdater) {
                    this.model = new MyDefaultListModel(project.get(), artifacts, def.get());
                }
                SwingUtilities.invokeLater(this);
            }
        }
    }

    public static enum ArtifactType {
        PROJECT,
        LIBRARY;

    }
}

