/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.util.ArrayList;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.AssemblerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.ui.configurations.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.configurations.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.customizer.BasicCompilerCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.SharedItemConfiguration;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class AssemblerCustomizerNode
extends CustomizerNode {
    public AssemblerCustomizerNode(String name, String displayName, CustomizerNode[] children, Lookup lookup) {
        super(name, displayName, children, lookup);
    }

    @Override
    public Sheet[] getSheets(Configuration configuration) {
        if (((MakeConfiguration)configuration).isCompileConfiguration()) {
            SharedItemConfiguration[] itemConfigurations = this.getContext().getItems();
            ArrayList<Sheet> out = new ArrayList<Sheet>();
            if (itemConfigurations != null) {
                for (SharedItemConfiguration cfg : itemConfigurations) {
                    ItemConfiguration itemConfiguration;
                    if (cfg == null || (itemConfiguration = cfg.getItemConfiguration(configuration)) == null) continue;
                    out.add(AssemblerCustomizerNode.getGeneralSheet((MakeConfiguration)configuration, itemConfiguration.getAssemblerConfiguration()));
                }
            } else {
                out.add(AssemblerCustomizerNode.getGeneralSheet((MakeConfiguration)configuration, ((MakeConfiguration)configuration).getAssemblerConfiguration()));
            }
            return out.isEmpty() ? null : out.toArray(new Sheet[out.size()]);
        }
        return null;
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx("ProjectPropsCompiling");
    }

    private static String getString(String s) {
        return NbBundle.getMessage(AssemblerCustomizerNode.class, (String)s);
    }

    private static Sheet getGeneralSheet(MakeConfiguration conf, AssemblerConfiguration ac) {
        Sheet sheet = new Sheet();
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        AbstractCompiler assemblerCompiler = compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.Assembler);
        Sheet.Set basicSet = BasicCompilerCustomizerNode.getBasicSet((BasicCompilerConfiguration)ac);
        basicSet.remove("StripSymbols");
        sheet.put(basicSet);
        if (ac.getMaster() != null) {
            sheet.put(BasicCompilerCustomizerNode.getInputSet((BasicCompilerConfiguration)ac));
        }
        Sheet.Set set4 = new Sheet.Set();
        set4.setName("Tool");
        set4.setDisplayName(AssemblerCustomizerNode.getString("ToolTxt1"));
        set4.setShortDescription(AssemblerCustomizerNode.getString("ToolHint1"));
        if (assemblerCompiler != null) {
            set4.put((Node.Property)new StringNodeProp(ac.getTool(), assemblerCompiler.getName(), false, "Tool", AssemblerCustomizerNode.getString("ToolTxt2"), AssemblerCustomizerNode.getString("ToolHint2")));
        }
        sheet.put(set4);
        String[] texts = new String[]{AssemblerCustomizerNode.getString("AdditionalOptionsTxt1"), AssemblerCustomizerNode.getString("AdditionalOptionsHint"), AssemblerCustomizerNode.getString("AdditionalOptionsTxt2"), AssemblerCustomizerNode.getString("AllOptionsTxt")};
        Sheet.Set set2 = new Sheet.Set();
        set2.setName("CommandLine");
        set2.setDisplayName(AssemblerCustomizerNode.getString("CommandLineTxt"));
        set2.setShortDescription(AssemblerCustomizerNode.getString("CommandLineHint"));
        if (assemblerCompiler != null) {
            set2.put((Node.Property)new OptionsNodeProp(ac.getCommandLineConfiguration(), null, (AllOptionsProvider)ac, assemblerCompiler, null, texts));
        }
        sheet.put(set2);
        return sheet;
    }
}

