/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.spi.configurations.CompileOptionsProvider;
import org.netbeans.modules.cnd.makeproject.ui.configurations.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.configurations.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.configurations.StringRONodeProp;
import org.netbeans.modules.cnd.makeproject.ui.customizer.BasicCompilerCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.CCCCompilerCustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.customizer.SharedItemConfiguration;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class CCCompilerCustomizerNode
extends CustomizerNode {
    public CCCompilerCustomizerNode(String name, String displayName, CustomizerNode[] children, Lookup lookup) {
        super(name, displayName, children, lookup);
    }

    @Override
    public Sheet[] getSheets(Configuration configuration) {
        switch (this.getContext().getKind()) {
            case Item: {
                SharedItemConfiguration[] configurations = this.getContext().getItems();
                ArrayList<Sheet> itemSheets = new ArrayList<Sheet>();
                for (SharedItemConfiguration cfg : configurations) {
                    ItemConfiguration itemConfiguration = cfg.getItemConfiguration(configuration);
                    if (itemConfiguration == null) continue;
                    Item item = cfg.getItem();
                    itemSheets.add(this.getSheet((MakeConfiguration)configuration, null, item, itemConfiguration.getCCCompilerConfiguration()));
                }
                return itemSheets.toArray(new Sheet[itemSheets.size()]);
            }
            case Folder: {
                Folder[] folders = this.getContext().getFolders();
                ArrayList<Sheet> folderSheets = new ArrayList<Sheet>();
                for (Folder folder : folders) {
                    Sheet sheet = this.getSheet((MakeConfiguration)configuration, folder, null, folder.getFolderConfiguration(configuration).getCCCompilerConfiguration());
                    folderSheets.add(sheet);
                }
                return folderSheets.toArray(new Sheet[folderSheets.size()]);
            }
            case Project: {
                return new Sheet[]{this.getSheet((MakeConfiguration)configuration, null, null, ((MakeConfiguration)configuration).getCCCompilerConfiguration())};
            }
        }
        return null;
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getContext().isCompilerConfiguration() ? "ProjectPropsCompiling" : "ProjectPropsParser");
    }

    private static String getString(String s) {
        return NbBundle.getMessage(CCCompilerCustomizerNode.class, (String)s);
    }

    private Sheet getSheet(MakeConfiguration conf, Folder folder, Item item, final CCCompilerConfiguration cconf) {
        String compileLine;
        AllOptionsProvider options;
        Sheet sheet = new Sheet();
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        AbstractCompiler ccCompiler = compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
        IntNodeProp standardProp = new IntNodeProp(cconf.getCppStandard(), true, "CPPStandard", CCCompilerCustomizerNode.getString("CPPStandardTxt"), CCCompilerCustomizerNode.getString("CPPStandardHint")){

            @Override
            public PropertyEditor getPropertyEditor() {
                if (this.intEditor == null) {
                    this.intEditor = new NewIntEditor();
                }
                return this.intEditor;
            }

            class NewIntEditor
            extends IntNodeProp.IntEditor {
                NewIntEditor() {
                }

                @Override
                public String getAsText() {
                    if (cconf.getCppStandard().getValue() == 4) {
                        return NbBundle.getMessage(CCCompilerCustomizerNode.class, (String)"STANDARD_INHERITED_WITH_VALUE", (Object)cconf.getCppStandard().getNames()[cconf.getInheritedCppStandard()]);
                    }
                    return super.getAsText();
                }
            }
        };
        Sheet.Set set0 = CCCCompilerCustomizerNode.getSet(null, folder, item, (CCCCompilerConfiguration)cconf);
        sheet.put(set0);
        if (conf.isCompileConfiguration()) {
            Sheet.Set set2;
            if (folder == null) {
                Sheet.Set bset = BasicCompilerCustomizerNode.getBasicSet((BasicCompilerConfiguration)cconf);
                sheet.put(bset);
                if (compilerSet != null && compilerSet.getCompilerFlavor().isSunStudioCompiler()) {
                    set2 = new Sheet.Set();
                    set2.setName("OtherOptions");
                    set2.setDisplayName(CCCompilerCustomizerNode.getString("OtherOptionsTxt"));
                    set2.setShortDescription(CCCompilerCustomizerNode.getString("OtherOptionsHint"));
                    set2.put((Node.Property)new IntNodeProp(cconf.getMTLevel(), cconf.getMaster() == null, "MultithreadingLevel", CCCompilerCustomizerNode.getString("MultithreadingLevelTxt"), CCCompilerCustomizerNode.getString("MultithreadingLevelHint")));
                    set2.put((Node.Property)new IntNodeProp(cconf.getLibraryLevel(), cconf.getMaster() == null, "LibraryLevel", CCCompilerCustomizerNode.getString("LibraryLevelTxt"), CCCompilerCustomizerNode.getString("LibraryLevelHint")));
                    set2.put((Node.Property)new IntNodeProp(cconf.getStandardsEvolution(), cconf.getMaster() == null, "StandardsEvolution", CCCompilerCustomizerNode.getString("StandardsEvolutionTxt"), CCCompilerCustomizerNode.getString("StandardsEvolutionHint")));
                    set2.put((Node.Property)new IntNodeProp(cconf.getLanguageExt(), cconf.getMaster() == null, "LanguageExtensions", CCCompilerCustomizerNode.getString("LanguageExtensionsTxt"), CCCompilerCustomizerNode.getString("LanguageExtensionsHint")));
                    sheet.put(set2);
                }
                if (CCCCompilerConfiguration.STANDARDS_SUPPORT) {
                    bset.put((Node.Property)standardProp);
                }
                if (cconf.getMaster() != null) {
                    sheet.put(BasicCompilerCustomizerNode.getInputSet((BasicCompilerConfiguration)cconf));
                }
                Sheet.Set set4 = new Sheet.Set();
                set4.setName("Tool");
                set4.setDisplayName(CCCompilerCustomizerNode.getString("ToolTxt1"));
                set4.setShortDescription(CCCompilerCustomizerNode.getString("ToolHint1"));
                if (ccCompiler != null) {
                    set4.put((Node.Property)new StringNodeProp(cconf.getTool(), ccCompiler.getName(), false, "Tool", CCCompilerCustomizerNode.getString("ToolTxt2"), CCCompilerCustomizerNode.getString("ToolHint2")));
                }
                sheet.put(set4);
            }
            String[] texts = new String[]{CCCompilerCustomizerNode.getString("AdditionalOptionsTxt1"), CCCompilerCustomizerNode.getString("AdditionalOptionsHint"), CCCompilerCustomizerNode.getString("AdditionalOptionsTxt2"), CCCompilerCustomizerNode.getString("AllOptionsTxt")};
            set2 = new Sheet.Set();
            set2.setName("CommandLine");
            set2.setDisplayName(CCCompilerCustomizerNode.getString("CommandLineTxt"));
            set2.setShortDescription(CCCompilerCustomizerNode.getString("CommandLineHint"));
            if (ccCompiler != null) {
                set2.put((Node.Property)new OptionsNodeProp(cconf.getCommandLineConfiguration(), null, (AllOptionsProvider)cconf, ccCompiler, null, texts));
            }
            sheet.put(set2);
        } else if (conf.getConfigurationType().getValue() == 0 && item != null && ccCompiler != null && (options = CompileOptionsProvider.getDefault().getOptions(item)) != null && (compileLine = options.getAllOptions((Tool)ccCompiler)) != null) {
            int hasPath = compileLine.indexOf(35);
            if (hasPath >= 0) {
                set0.put((Node.Property)new StringRONodeProp(CCCompilerCustomizerNode.getString("CommandLineTxt"), CCCompilerCustomizerNode.getString("CommandLineHint"), compileLine.substring(hasPath + 1)));
                set0.put((Node.Property)new StringRONodeProp(CCCompilerCustomizerNode.getString("CompileFolderTxt"), CCCompilerCustomizerNode.getString("CompileFolderHint"), compileLine.substring(0, hasPath)));
            } else {
                set0.put((Node.Property)new StringRONodeProp(CCCompilerCustomizerNode.getString("CommandLineTxt"), CCCompilerCustomizerNode.getString("CommandLineHint"), compileLine));
            }
        }
        if (conf.getConfigurationType().getValue() == 0 && CCCCompilerConfiguration.STANDARDS_SUPPORT) {
            set0.put((Node.Property)standardProp);
        }
        if ((conf.getConfigurationType().getValue() == 4 || conf.getConfigurationType().getValue() == 5 || conf.getConfigurationType().getValue() == 6) && CCCCompilerConfiguration.STANDARDS_SUPPORT) {
            set0.put((Node.Property)standardProp);
        }
        return sheet;
    }
}

