/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.launchers.actions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class LaunchersConfig {
    private final Project project;
    private final TreeMap<Integer, LauncherConfig> map = new TreeMap();
    private final ArrayList<String> commentsPublic = new ArrayList();
    private final ArrayList<String> commentsPrivate = new ArrayList();
    private static final int COMMON_PUBLIC_INDEX = -1;
    private static final int COMMON_PRIVATE_INDEX = -2;

    public LaunchersConfig(Project project) {
        this.project = project;
    }

    public List<LauncherConfig> getLaunchers() {
        ArrayList<LauncherConfig> res = new ArrayList<LauncherConfig>();
        this.map.entrySet().forEach(e -> res.add(((LauncherConfig)e.getValue()).clone()));
        return res;
    }

    public void load() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        FileObject nbProjectFolder = projectDirectory.getFileObject("nbproject");
        if (nbProjectFolder == null || !nbProjectFolder.isValid()) {
            return;
        }
        FileObject publicLaunchers = nbProjectFolder.getFileObject("launcher.properties");
        FileObject privateNbFolder = projectDirectory.getFileObject("nbproject/private");
        FileObject privateLaunchers = privateNbFolder != null && privateNbFolder.isValid() ? privateNbFolder.getFileObject("launcher.properties") : null;
        this.map.put(-1, new LauncherConfig(-1, true));
        this.map.put(-2, new LauncherConfig(-2, false));
        if (publicLaunchers != null && publicLaunchers.isValid()) {
            this.load(publicLaunchers, true);
        }
        if (privateLaunchers != null && privateLaunchers.isValid()) {
            this.load(privateLaunchers, false);
        }
    }

    private void load(FileObject config, boolean pub) {
        try {
            int id = pub ? -1 : -2;
            LauncherConfig l = this.map.get(id);
            if (l == null) {
                l = new LauncherConfig(id, pub);
                this.map.put(id, l);
            }
            ArrayList asLines = new ArrayList(config.asLines("UTF-8"));
            Iterator it = asLines.iterator();
            boolean initComments = true;
            while (it.hasNext()) {
                String line = (String)it.next();
                int i = line.indexOf(35);
                if (i >= 0) {
                    if (i == 0) {
                        if (!initComments) continue;
                        if (pub) {
                            this.commentsPublic.add(line);
                            continue;
                        }
                        this.commentsPrivate.add(line);
                        continue;
                    }
                    line = line.substring(0, i);
                }
                line = line.replace('\t', ' ');
                if ((line = line.trim()).isEmpty()) continue;
                while (it.hasNext() && line.endsWith("\\")) {
                    String next = (String)it.next();
                    next = next.replace('\t', ' ');
                    line = line.substring(0, line.length() - 1) + next;
                }
                i = line.indexOf(61);
                if (i <= 0) continue;
                String key = line.substring(0, i).trim();
                String value = line.substring(i + 1).trim();
                this.add(key, value, pub);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private void add(String key, String value, boolean pub) {
        int i;
        if (key.startsWith("common.")) {
            String subkey;
            int id = pub ? -1 : -2;
            LauncherConfig l = this.map.get(id);
            if (l == null) {
                l = new LauncherConfig(id, pub);
                this.map.put(id, l);
            }
            if ((subkey = key.substring(7)).equals("runDir")) {
                l.runDir = value;
            } else if (subkey.equals("symbolFiles")) {
                l.symbolFiles = value;
            } else if (subkey.startsWith("env.")) {
                String var = subkey.substring(4);
                l.env.put(var, value);
            }
        } else if (key.startsWith("launcher") && (i = key.indexOf(46)) > 0) {
            try {
                int id = Integer.parseInt(key.substring("launcher".length(), i));
                LauncherConfig l = this.map.get(id);
                if (l == null) {
                    l = new LauncherConfig(id, pub);
                    this.map.put(id, l);
                } else if (l.pub != pub) {
                    l.pub = pub;
                }
                String subkey = key.substring(i + 1);
                if (subkey.equals("displayName")) {
                    l.name = value;
                } else if (subkey.equals("hide")) {
                    l.hide = "true".equals(value);
                } else if (subkey.equals("runInOwnTab")) {
                    l.runInOwnTab = !"false".equals(value);
                } else if (subkey.equals("runCommand")) {
                    l.command = value;
                } else if (subkey.equals("buildCommand")) {
                    l.buildCommand = value;
                } else if (subkey.equals("runDir")) {
                    l.runDir = value;
                } else if (subkey.equals("symbolFiles")) {
                    l.symbolFiles = value;
                } else if (subkey.startsWith("env.")) {
                    String var = subkey.substring("env".length() + 1);
                    l.env.put(var, value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private boolean isModified(ArrayList<LauncherConfig> launchers, boolean pub) {
        ArrayList origin = new ArrayList();
        for (Map.Entry<Integer, LauncherConfig> e : this.map.entrySet()) {
            if (e.getValue().pub != pub) continue;
            origin.add(e.getValue());
        }
        ArrayList<LauncherConfig> saved = new ArrayList<LauncherConfig>();
        for (LauncherConfig l : launchers) {
            if (l.pub != pub) continue;
            saved.add(l);
        }
        if (origin.size() != saved.size()) {
            return true;
        }
        for (int i = 0; i < origin.size(); ++i) {
            LauncherConfig l2;
            LauncherConfig l1 = (LauncherConfig)origin.get(i);
            if (l1.equals(l2 = (LauncherConfig)saved.get(i))) continue;
            return true;
        }
        return false;
    }

    public void save(ArrayList<LauncherConfig> launchers) {
        int max = -3;
        boolean monotonius = true;
        for (LauncherConfig launcherConfig : launchers) {
            if (launcherConfig.id > max) {
                max = launcherConfig.id;
                continue;
            }
            monotonius = false;
            break;
        }
        if (!monotonius) {
            int i = 0;
            for (LauncherConfig launcherConfig : launchers) {
                if (launcherConfig.id < 0) continue;
                if (launcherConfig.pub) {
                    i = (i + 1000) / 1000;
                    launcherConfig.id = (i *= 1000);
                    continue;
                }
                i = (i + 10) / 10;
                launcherConfig.id = (i *= 10);
            }
        }
        boolean hasPrivateConfig = false;
        boolean bl = false;
        for (LauncherConfig l : launchers) {
            if (l.id >= 0) {
                if (l.pub) {
                    n |= !l.name.isEmpty() || !l.command.isEmpty() || l.buildCommand.isEmpty() || !l.env.isEmpty() || !l.runDir.isEmpty() || !l.symbolFiles.isEmpty() ? 1 : 0;
                    continue;
                }
                hasPrivateConfig |= !l.name.isEmpty() || !l.command.isEmpty() || l.buildCommand.isEmpty() || !l.env.isEmpty() || !l.runDir.isEmpty() || !l.symbolFiles.isEmpty();
                continue;
            }
            if (l.pub) {
                n |= !l.env.isEmpty() || !l.runDir.isEmpty() || !l.symbolFiles.isEmpty() ? 1 : 0;
                continue;
            }
            hasPrivateConfig |= !l.env.isEmpty() || !l.runDir.isEmpty() || !l.symbolFiles.isEmpty();
        }
        FileObject fileObject = this.project.getProjectDirectory();
        FileObject nbProjectFolder = fileObject.getFileObject("nbproject");
        if (nbProjectFolder == null || !nbProjectFolder.isValid()) {
            return;
        }
        if (this.isModified(launchers, false)) {
            FileObject privateNbFolder = fileObject.getFileObject("nbproject/private");
            FileObject privateLaunchers = null;
            if (privateNbFolder != null && privateNbFolder.isValid()) {
                privateLaunchers = privateNbFolder.getFileObject("launcher.properties");
                if (hasPrivateConfig) {
                    if (privateLaunchers == null || !privateLaunchers.isValid()) {
                        try {
                            privateLaunchers = privateNbFolder.createData("launcher.properties");
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    this.save(launchers, privateLaunchers, false);
                } else if (privateLaunchers != null && privateLaunchers.isValid()) {
                    this.save(launchers, privateLaunchers, false);
                }
            }
        }
        if (this.isModified(launchers, true)) {
            int n;
            FileObject publicLaunchers = nbProjectFolder.getFileObject("launcher.properties");
            if (n != 0) {
                if (publicLaunchers == null || !publicLaunchers.isValid()) {
                    try {
                        publicLaunchers = nbProjectFolder.createData("launcher.properties");
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                this.save(launchers, publicLaunchers, true);
            } else if (publicLaunchers != null && publicLaunchers.isValid()) {
                this.save(launchers, publicLaunchers, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(ArrayList<LauncherConfig> launchers, FileObject config, boolean pub) {
        if (config == null) {
            return;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(config.getOutputStream(), "UTF-8")){

                @Override
                public void newLine() throws IOException {
                    this.write("\n");
                }
            };
            ArrayList<String> c = pub ? this.commentsPublic : this.commentsPrivate;
            for (String s : c) {
                bw.write(s);
                bw.newLine();
            }
            boolean addNewLine = !c.isEmpty();
            for (LauncherConfig l : launchers) {
                if (l.pub != pub) continue;
                if (l.id < 0) {
                    if (!(l.runDir.isEmpty() && l.symbolFiles.isEmpty() && l.env.isEmpty() || !addNewLine)) {
                        bw.newLine();
                    }
                    if (!l.runDir.isEmpty()) {
                        bw.write("common.");
                        bw.write("runDir");
                        bw.write("=" + l.runDir);
                        bw.newLine();
                        addNewLine = true;
                    }
                    if (!l.symbolFiles.isEmpty()) {
                        bw.write("common.");
                        bw.write("symbolFiles");
                        bw.write("=" + l.symbolFiles);
                        bw.newLine();
                        addNewLine = true;
                    }
                    for (Map.Entry e : l.env.entrySet()) {
                        bw.write("common.");
                        bw.write("env.");
                        bw.write((String)e.getKey() + "=");
                        bw.write((String)e.getValue());
                        bw.newLine();
                        addNewLine = true;
                    }
                    continue;
                }
                if (addNewLine) {
                    bw.newLine();
                }
                if (!l.name.isEmpty()) {
                    bw.write("launcher" + l.id + ".");
                    bw.write("displayName");
                    bw.write("=" + l.name);
                    bw.newLine();
                    addNewLine = true;
                }
                if (l.hide) {
                    bw.write("launcher" + l.id + ".");
                    bw.write("hide");
                    bw.write("=true");
                    bw.newLine();
                    addNewLine = true;
                }
                if (!l.runInOwnTab) {
                    bw.write("launcher" + l.id + ".");
                    bw.write("runInOwnTab");
                    bw.write("=false");
                    bw.newLine();
                    addNewLine = true;
                }
                if (!l.command.isEmpty()) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("launcher" + l.id + ".");
                    buf.append("runCommand");
                    buf.append("=" + l.command);
                    this.writeWrapLine(buf.toString(), bw);
                    addNewLine = true;
                }
                if (!l.buildCommand.isEmpty()) {
                    bw.write("launcher" + l.id + ".");
                    bw.write("buildCommand");
                    bw.write("=" + l.buildCommand);
                    bw.newLine();
                    addNewLine = true;
                }
                if (!l.runDir.isEmpty()) {
                    bw.write("launcher" + l.id + ".");
                    bw.write("runDir");
                    bw.write("=" + l.runDir);
                    bw.newLine();
                    addNewLine = true;
                }
                if (!l.symbolFiles.isEmpty()) {
                    bw.write("launcher" + l.id + ".");
                    bw.write("symbolFiles");
                    bw.write("=" + l.symbolFiles);
                    bw.newLine();
                    addNewLine = true;
                }
                for (Map.Entry e : l.env.entrySet()) {
                    bw.write("launcher" + l.id + ".");
                    bw.write("env.");
                    bw.write((String)e.getKey() + "=");
                    bw.write((String)e.getValue());
                    bw.newLine();
                    addNewLine = true;
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeWrapLine(String s, BufferedWriter bw) throws IOException {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            buf.append(c);
            if (c != ' ' || buf.length() <= 80 || i + 1 >= s.length()) continue;
            buf.append("\\");
            bw.write(buf.toString());
            bw.newLine();
            buf.setLength(0);
        }
        bw.write(buf.toString());
        bw.newLine();
    }

    public static final class LauncherConfig {
        private int id;
        private boolean pub;
        private String name = "";
        private String command = "";
        private String buildCommand = "";
        private String runDir = "";
        private String symbolFiles = "";
        private Map<String, String> env = new TreeMap<String, String>();
        private boolean hide = false;
        private boolean runInOwnTab = true;
        private boolean isModified = false;

        public LauncherConfig(int id, boolean pub) {
            this.id = id;
            this.pub = pub;
        }

        public boolean isModified() {
            return this.isModified;
        }

        public int getID() {
            return this.id;
        }

        void setID(int id) {
            this.isModified |= id != this.id;
            this.id = id;
        }

        public boolean getPublic() {
            return this.pub;
        }

        void setPublic(boolean pub) {
            this.isModified |= pub != this.pub;
            this.pub = pub;
        }

        public String getName() {
            return this.name;
        }

        void setName(String name) {
            this.isModified |= !name.equals(this.name);
            this.name = name;
        }

        public String getCommand() {
            return this.command;
        }

        void setCommand(String command) {
            this.isModified |= !command.equals(this.command);
            this.command = command;
        }

        public String getBuildCommand() {
            return this.buildCommand;
        }

        public void setBuildCommand(String buildCommand) {
            this.isModified |= !buildCommand.equals(this.buildCommand);
            this.buildCommand = buildCommand;
        }

        public String getRunDir() {
            return this.runDir;
        }

        void setRunDir(String runDir) {
            this.isModified |= !runDir.equals(this.runDir);
            this.runDir = runDir;
        }

        public Map<String, String> getEnv() {
            return this.env;
        }

        void putEnv(String key, String value) {
            this.env.put(key, value);
        }

        public String getSymbolFiles() {
            return this.symbolFiles;
        }

        void setSymbolFiles(String symbolFiles) {
            this.symbolFiles = symbolFiles;
        }

        public boolean isHide() {
            return this.hide;
        }

        public void setHide(boolean isHide) {
            this.isModified |= isHide != this.hide;
            this.hide = isHide;
        }

        public boolean runInOwnTab() {
            return this.runInOwnTab;
        }

        public void setrunInOwnTab(boolean runInOwnTab) {
            this.isModified |= runInOwnTab != this.runInOwnTab;
            this.runInOwnTab = runInOwnTab;
        }

        public String getDisplayedName() {
            return this.name == null || this.name.isEmpty() ? this.command : this.name;
        }

        public LauncherConfig copy(int newID) {
            LauncherConfig res = new LauncherConfig(newID, this.pub);
            res.command = this.command;
            res.name = this.name;
            res.hide = this.hide;
            res.runInOwnTab = this.runInOwnTab;
            res.buildCommand = this.buildCommand;
            res.runDir = this.runDir;
            res.symbolFiles = this.symbolFiles;
            res.env = new TreeMap<String, String>(this.env);
            return res;
        }

        public LauncherConfig clone() {
            LauncherConfig res = new LauncherConfig(this.id, this.pub);
            res.command = this.command;
            res.name = this.name;
            res.hide = this.hide;
            res.runInOwnTab = this.runInOwnTab;
            res.buildCommand = this.buildCommand;
            res.runDir = this.runDir;
            res.symbolFiles = this.symbolFiles;
            res.env = new TreeMap<String, String>(this.env);
            return res;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LauncherConfig other = (LauncherConfig)obj;
            if (this.id != other.id) {
                return false;
            }
            if (this.pub != other.pub) {
                return false;
            }
            if (this.hide != other.hide) {
                return false;
            }
            if (this.runInOwnTab != other.runInOwnTab) {
                return false;
            }
            if (this.isModified != other.isModified) {
                return false;
            }
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            if (!Objects.equals(this.command, other.command)) {
                return false;
            }
            if (!Objects.equals(this.buildCommand, other.buildCommand)) {
                return false;
            }
            if (!Objects.equals(this.runDir, other.runDir)) {
                return false;
            }
            if (!Objects.equals(this.symbolFiles, other.symbolFiles)) {
                return false;
            }
            return Objects.equals(this.env, other.env);
        }

        public String toString() {
            return this.getDisplayedName();
        }
    }
}

