/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.remote.ui.RemoteFileChooserUtil;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectModePanel;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class FileListEditorPanel
extends JPanel {
    private final List<String> data = new ArrayList<String>();
    private final ExecutionEnvironment env;
    private final FileSystem fileSystem;
    private JButton addButton;
    private JButton addFolderButton;
    private JButton editButton;
    private JList fileList;
    private JLabel fileListLabel;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JButton removeButton;

    public FileListEditorPanel(String files, ExecutionEnvironment env, FileSystem fileSystem) {
        this.initComponents();
        for (String s : files.split(";")) {
            if (s.isEmpty()) continue;
            this.data.add(s);
        }
        this.env = env;
        this.fileSystem = fileSystem;
        this.fileList.setModel(new MyModel(this.data));
        this.fileList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.checkSelection();
        });
        if (this.data.size() > 0) {
            this.fileList.setSelectedIndex(0);
        }
    }

    public List<String> getFileList() {
        return new ArrayList<String>(this.data);
    }

    private void checkSelection() {
        this.checkSelection(this.getSelectedIndex());
    }

    private synchronized int getSelectedIndex() {
        int index = this.fileList.getSelectedIndex();
        if (index >= 0 && index < this.data.size()) {
            return index;
        }
        return 0;
    }

    protected synchronized void checkSelection(int i) {
        if (i >= 0 && this.data.size() > 0) {
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.fileListLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fileList = new JList();
        this.addButton = new JButton();
        this.addFolderButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.fileListLabel, (String)NbBundle.getMessage(FileListEditorPanel.class, (String)"FileListEditorPanel.fileListLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 6, 0);
        this.add((Component)this.fileListLabel, gridBagConstraints);
        this.fileList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.fileList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 6);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(FileListEditorPanel.class, (String)"FileListEditorPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileListEditorPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.add((Component)this.addButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addFolderButton, (String)NbBundle.getMessage(FileListEditorPanel.class, (String)"FileListEditorPanel.addFolderButton.text"));
        this.addFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileListEditorPanel.this.addFolderButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 10);
        this.add((Component)this.addFolderButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(FileListEditorPanel.class, (String)"FileListEditorPanel.editButton.text"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileListEditorPanel.this.editButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 10);
        this.add((Component)this.editButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(FileListEditorPanel.class, (String)"FileListEditorPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileListEditorPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 10);
        this.add((Component)this.removeButton, gridBagConstraints);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addButtonActionPerformed(ActionEvent evt) {
        FileFilter[] filters = FileFilterFactory.getBinaryFilters((FileSystem)this.fileSystem);
        String path = "";
        int index = this.fileList.getSelectedIndex();
        if (index >= 0 && index < this.data.size()) {
            path = this.data.get(index);
        }
        if (path.isEmpty()) {
            path = SelectModePanel.getDefaultDirectory(this.env);
        }
        JFileChooser fileChooser = RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)this.env, (String)NbBundle.getMessage(FileListEditorPanel.class, (String)"SelectBinaryPanelVisual.Browse.Multi.Title"), (String)NbBundle.getMessage(FileListEditorPanel.class, (String)"SelectBinaryPanelVisual.Browse.Multi.Select"), (int)0, (FileFilter[])filters, (String)path, (boolean)false);
        fileChooser.setMultiSelectionEnabled(true);
        int ret = fileChooser.showOpenDialog(this);
        try {
            if (ret == 1) {
                return;
            }
            File[] selected = fileChooser.getSelectedFiles();
            if (selected == null || selected.length == 0) {
                return;
            }
            ArrayList<String> toAdd = new ArrayList<String>();
            if (selected.length == 1) {
                if (!this.data.contains(selected[0].getPath())) {
                    toAdd.add(selected[0].getPath());
                }
            } else {
                for (File f : selected) {
                    if (this.data.contains(f.getPath())) continue;
                    toAdd.add(f.getPath());
                }
            }
            if (!toAdd.isEmpty()) {
                int addAtIndex = this.data.size();
                this.data.addAll(toAdd);
                this.fileList.setModel(new MyModel(this.data));
                this.fileList.setSelectedIndex(addAtIndex);
                this.fileList.ensureIndexIsVisible(addAtIndex);
                this.checkSelection();
            }
        }
        finally {
            this.addButton.requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editButtonActionPerformed(ActionEvent evt) {
        FileFilter[] filters = FileFilterFactory.getBinaryFilters((FileSystem)this.fileSystem);
        String path = "";
        int index = this.fileList.getSelectedIndex();
        if (index < 0 || index >= this.data.size()) {
            return;
        }
        path = this.data.get(index);
        if (path.isEmpty()) {
            path = SelectModePanel.getDefaultDirectory(this.env);
        }
        JFileChooser fileChooser = RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)this.env, (String)NbBundle.getMessage(FileListEditorPanel.class, (String)"SelectBinaryPanelVisual.Browse.Title"), (String)NbBundle.getMessage(FileListEditorPanel.class, (String)"SelectBinaryPanelVisual.Browse.Select"), (int)0, (FileFilter[])filters, (String)path, (boolean)false);
        int ret = fileChooser.showOpenDialog(this);
        try {
            if (ret == 1) {
                return;
            }
            path = fileChooser.getSelectedFile().getPath();
            if (this.data.contains(path)) {
                return;
            }
            this.data.set(index, path);
            this.fileList.setModel(new MyModel(this.data));
            this.fileList.setSelectedIndex(index);
            this.fileList.ensureIndexIsVisible(index);
            this.checkSelection();
        }
        finally {
            this.editButton.requestFocus();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int newSelectedIndex;
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        if (selectedIndex >= this.data.size()) {
            return;
        }
        this.data.remove(selectedIndex);
        this.fileList.setModel(new MyModel(this.data));
        int n = newSelectedIndex = selectedIndex >= this.data.size() ? selectedIndex - 1 : selectedIndex;
        if (newSelectedIndex >= 0) {
            this.fileList.ensureIndexIsVisible(newSelectedIndex);
            this.checkSelection(newSelectedIndex);
            this.fileList.setSelectedIndex(newSelectedIndex);
        } else {
            this.checkSelection();
        }
        if (this.removeButton.isEnabled()) {
            this.removeButton.requestFocus();
        } else {
            this.addButton.requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFolderButtonActionPerformed(ActionEvent evt) {
        String path = "";
        int index = this.fileList.getSelectedIndex();
        if (index >= 0 && index < this.data.size()) {
            path = this.data.get(index);
        }
        if (path.isEmpty()) {
            path = SelectModePanel.getDefaultDirectory(this.env);
        }
        JFileChooser fileChooser = RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)this.env, (String)NbBundle.getMessage(FileListEditorPanel.class, (String)"SelectBinaryPanelVisual.Browse.Folder.Title"), (String)NbBundle.getMessage(FileListEditorPanel.class, (String)"SelectBinaryPanelVisual.Browse.Folder.Select"), (int)1, null, (String)path, (boolean)true);
        int ret = fileChooser.showOpenDialog(this);
        try {
            if (ret == 1) {
                return;
            }
            File selected = fileChooser.getSelectedFile();
            if (selected == null) {
                return;
            }
            FSPath fsPath = new FSPath(this.fileSystem, selected.getPath());
            FileObject fo = fsPath.getFileObject();
            if (fo != null && fo.isValid() && fo.isFolder()) {
                ArrayList<String> toAdd = new ArrayList<String>();
                for (FileObject f : fo.getChildren()) {
                    if (this.data.contains(f.getPath()) || !MIMENames.isBinary((String)f.getMIMEType())) continue;
                    toAdd.add(f.getPath());
                }
                if (!toAdd.isEmpty()) {
                    int addAtIndex = this.data.size();
                    this.data.addAll(toAdd);
                    this.fileList.setModel(new MyModel(this.data));
                    this.fileList.setSelectedIndex(addAtIndex);
                    this.fileList.ensureIndexIsVisible(addAtIndex);
                    this.checkSelection();
                }
            }
        }
        finally {
            this.addFolderButton.requestFocus();
        }
    }

    private static final class MyModel<String>
    extends AbstractListModel {
        private final List<String> listData;

        private MyModel(List<String> listData) {
            this.listData = listData;
        }

        @Override
        public int getSize() {
            return this.listData.size();
        }

        @Override
        public String getElementAt(int i) {
            return this.listData.get(i);
        }
    }
}

