/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.remote.ui.RemoteFileChooserUtil;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.ui.wizard.IteratorExtension;
import org.netbeans.modules.cnd.makeproject.api.ui.wizard.WizardConstants;
import org.netbeans.modules.cnd.makeproject.api.wizards.CommonUtilities;
import org.netbeans.modules.cnd.makeproject.ui.utils.ExpandableEditableComboBox;
import org.netbeans.modules.cnd.makeproject.ui.wizards.FileListEditorPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.NewProjectWizardUtils;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectBinaryPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectModePanel;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.ui.DocumentAdapter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class SelectBinaryPanelVisual
extends JPanel {
    private final SelectBinaryPanel controller;
    private static final RequestProcessor RP = new RequestProcessor("Binary Artifact Discovery", 1);
    private final AtomicInteger checking = new AtomicInteger(0);
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.cnd.discovery.projectimport.ImportExecutable");
    private DefaultTableModel tableModel;
    private static final String BINARY_FILE_KEY = "binaryField";
    private final List<AtomicBoolean> cancelable = new ArrayList<AtomicBoolean>();
    private final Object lock = new Lock();
    private final AtomicBoolean searching = new AtomicBoolean(false);
    private ExecutionEnvironment env;
    private FileSystem fileSystem;
    private JButton binaryButton;
    private JComboBox binaryField;
    private JLabel binaryLabel;
    private JButton cancelSearch;
    private JComboBox dependeciesComboBox;
    private JLabel dependenciesLabel;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JButton sourcesButton;
    private JTextField sourcesField;
    private JLabel sourcesLabel;
    private JTable table;
    private JComboBox viewComboBox;
    private JLabel viewLabel;
    private static final int BUTTON_WIDTH = 20;

    public SelectBinaryPanelVisual(SelectBinaryPanel controller) {
        this.controller = controller;
        this.initComponents();
        this.dependeciesComboBox.removeAllItems();
        this.dependeciesComboBox.addItem(new ProjectKindItem(IteratorExtension.ProjectKind.Minimal));
        this.dependeciesComboBox.addItem(new ProjectKindItem(IteratorExtension.ProjectKind.IncludeDependencies));
        this.dependeciesComboBox.addItem(new ProjectKindItem(IteratorExtension.ProjectKind.CreateDependencies));
        this.dependeciesComboBox.setSelectedIndex(1);
        this.viewComboBox.removeAllItems();
        this.viewComboBox.addItem(new ProjectView(false));
        this.viewComboBox.addItem(new ProjectView(true));
        this.addListeners();
    }

    private void addListeners() {
        ((ExpandableEditableComboBox)((Object)this.binaryField)).addChangeListener(e -> {
            String path = ((ExpandableEditableComboBox)((Object)((Object)this.binaryField))).getText().trim();
            this.controller.getWizardStorage().setBinaryPath(this.fileSystem, path);
            this.updateRoot();
        });
        this.sourcesField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void update(DocumentEvent e) {
                String path = SelectBinaryPanelVisual.this.sourcesField.getText().trim();
                SelectBinaryPanelVisual.this.controller.getWizardStorage().setSourceFolderPath(new FSPath(SelectBinaryPanelVisual.this.fileSystem, path));
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int clickedLine = SelectBinaryPanelVisual.this.table.rowAtPoint(e.getPoint());
                if (clickedLine != -1 && e.getModifiers() == 16 && e.getClickCount() == 1) {
                    SelectBinaryPanelVisual.this.onClickAction(e);
                }
            }
        });
        this.dependeciesComboBox.addItemListener(e -> this.validateController());
        this.updateRoot();
    }

    private void validateController() {
        this.controller.getWizardStorage().validate();
    }

    private void updateRoot() {
        this.sourcesField.setEnabled(false);
        this.sourcesButton.setEnabled(false);
        this.dependeciesComboBox.setEnabled(false);
        this.viewComboBox.setEnabled(false);
        this.table.setModel(new DefaultTableModel(0, 0));
        String path = ((ExpandableEditableComboBox)((Object)this.binaryField)).getText().trim();
        RP.post(() -> {
            if (this.validBinary()) {
                if (this.env.isRemote()) {
                    // empty if block
                }
                this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)"");
                this.checking.incrementAndGet();
                this.validateController();
                IteratorExtension extension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
                HashMap<String, Object> map = new HashMap<String, Object>();
                List<FSPath> binaries = this.controller.getWizardStorage().getBinaryPath();
                if (binaries.size() == 1) {
                    WizardConstants.DISCOVERY_BUILD_RESULT.toMap(map, binaries.get(0).getPath());
                } else {
                    WizardConstants.DISCOVERY_BUILD_RESULT.toMap(map, binaries.get(0).getPath());
                    StringBuilder buf = new StringBuilder();
                    for (int i = 1; i < binaries.size(); ++i) {
                        if (buf.length() > 0) {
                            buf.append(';');
                        }
                        buf.append(binaries.get(i).getPath());
                    }
                    WizardConstants.DISCOVERY_LIBRARIES.toMap(map, buf.toString());
                }
                WizardConstants.DISCOVERY_RESOLVE_LINKS.toMap(map, MakeProjectOptions.getResolveSymbolicLinks());
                if (this.env.isRemote()) {
                    WizardConstants.DISCOVERY_BINARY_FILESYSTEM.toMap(map, this.fileSystem);
                }
                if (extension != null) {
                    extension.discoverArtifacts(map);
                    List<String> dlls = WizardConstants.DISCOVERY_BINARY_DEPENDENCIES.fromMap(map);
                    String root = WizardConstants.DISCOVERY_ROOT_FOLDER.fromMap(map);
                    if (root == null) {
                        root = "";
                    }
                    List<String> searchPaths = WizardConstants.DISCOVERY_BINARY_SEARCH_PATH.fromMap(map);
                    Map<String, String> resolvedDlls = this.searchingTable(dlls);
                    this.updateArtifacts(root, map, resolvedDlls);
                    this.checkDll(resolvedDlls, root, searchPaths, this.controller.getWizardStorage().getBinaryPath());
                }
            } else if (!path.isEmpty() && this.controller.getWizardDescriptor() != null) {
                if (CndPathUtilities.isPathAbsolute((CharSequence)path)) {
                    String nPath = CndFileUtils.normalizeAbsolutePath((String)path);
                    FileObject fo = CndFileUtils.toFileObject((CharSequence)nPath);
                    if (fo == null || !fo.isValid()) {
                        this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.FileNotFound", nPath));
                    } else {
                        this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.Unsupported.Binary", nPath));
                    }
                } else {
                    this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.FileNotFound", path));
                }
            }
        });
    }

    private void updateArtifacts(String root, Map<String, Object> map, Map<String, String> dlls) {
        SwingUtilities.invokeLater(() -> {
            if (this.env.isLocal()) {
                List<String> errors;
                CompilerSet compiler = this.detectCompilerSet(WizardConstants.DISCOVERY_COMPILER.fromMap(map));
                if (compiler != null) {
                    WizardConstants.PROPERTY_TOOLCHAIN.put(this.controller.getWizardDescriptor(), compiler);
                    WizardConstants.PROPERTY_HOST_UID.put(this.controller.getWizardDescriptor(), ExecutionEnvironmentFactory.getLocal().getHost());
                    WizardConstants.PROPERTY_READ_ONLY_TOOLCHAIN.put(this.controller.getWizardDescriptor(), Boolean.FALSE);
                } else {
                    WizardConstants.PROPERTY_READ_ONLY_TOOLCHAIN.put(this.controller.getWizardDescriptor(), Boolean.FALSE);
                }
                this.sourcesField.setText(root);
                int i = this.checking.decrementAndGet();
                if (i == 0) {
                    boolean validBinary = this.validBinary();
                    List<FSPath> validBinaryPath = this.getValidBinaryPath();
                    this.sourcesField.setEnabled(validBinary);
                    this.sourcesButton.setEnabled(validBinary);
                    this.dependeciesComboBox.setEnabled(validBinary);
                    this.viewComboBox.setEnabled(validBinary);
                    if (validBinary && validBinaryPath != null) {
                        String binaryRoot = CndPathUtilities.getDirName((String)validBinaryPath.get(0).getPath());
                        if (binaryRoot != null && (binaryRoot.startsWith(root) || root.startsWith(binaryRoot))) {
                            binaryRoot = null;
                        }
                        this.updateTableModel(dlls, root, binaryRoot, true);
                    } else {
                        this.updateTableModel(Collections.emptyMap(), root, null, true);
                    }
                }
                if ((errors = WizardConstants.DISCOVERY_ERRORS.fromMap(map)) != null && errors.size() > 0) {
                    this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)errors.get(0));
                } else {
                    this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)"");
                }
            } else {
                this.sourcesField.setText(root);
                int i = this.checking.decrementAndGet();
                if (i == 0) {
                    boolean validBinary = this.validBinary();
                    List<FSPath> validBinaryPath = this.getValidBinaryPath();
                    this.sourcesField.setEnabled(validBinary);
                    this.sourcesButton.setEnabled(validBinary);
                    this.dependeciesComboBox.setEnabled(true);
                    this.viewComboBox.setEnabled(validBinary);
                    if (validBinary && validBinaryPath != null) {
                        String binaryRoot = CndPathUtilities.getDirName((String)validBinaryPath.get(0).getPath());
                        if (binaryRoot != null && (binaryRoot.startsWith(root) || root.startsWith(binaryRoot))) {
                            binaryRoot = null;
                        }
                        this.updateTableModel(dlls, root, binaryRoot, true);
                    } else {
                        this.updateTableModel(Collections.emptyMap(), root, null, true);
                    }
                }
                this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)"");
            }
            this.validateController();
        });
    }

    private void updateDllArtifacts(String root, Map<String, String> checkDll, boolean searching) {
        SwingUtilities.invokeLater(() -> {
            int i = this.checking.get();
            if (i == 0) {
                boolean validBinary = this.validBinary();
                List<FSPath> validBinaryPath = this.getValidBinaryPath();
                if (validBinary && validBinaryPath != null) {
                    String binaryRoot = CndPathUtilities.getDirName((String)validBinaryPath.get(0).getPath());
                    if (binaryRoot != null && (binaryRoot.startsWith(root) || root.startsWith(binaryRoot))) {
                        binaryRoot = null;
                    }
                    this.updateTableModel(checkDll, root, binaryRoot, searching);
                } else {
                    this.updateTableModel(Collections.emptyMap(), root, null, searching);
                }
            }
            this.validateController();
        });
    }

    private void updateTableModel(Map<String, String> dlls, String root, String binaryRoot, boolean searching) {
        this.tableModel = new MyDefaultTableModel(this, dlls, root, binaryRoot, searching);
        this.table.setModel(this.tableModel);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.table.getColumnModel().getColumn(0).setMinWidth(15);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxCellRenderer());
        this.table.getColumnModel().getColumn(0).setCellEditor(new CheckBoxTableCellEditor());
        this.table.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(1).setMinWidth(50);
        if (this.table.getWidth() > 200) {
            this.table.getColumnModel().getColumn(2).setPreferredWidth(this.table.getWidth() - 100);
        } else {
            this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        }
        this.table.getColumnModel().getColumn(2).setCellRenderer(new PathCellRenderer(this.fileSystem));
    }

    private void cancelSearch() {
        this.cancelable.forEach(cancel -> cancel.set(true));
    }

    private Map<String, String> searchingTable(List<String> dlls) {
        TreeMap<String, String> dllPaths = new TreeMap<String, String>();
        if (dlls != null) {
            dlls.forEach(dll -> dllPaths.put((String)dll, (String)null));
        }
        return dllPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDll(Map<String, String> dllPaths, String root, List<String> searchPaths, List<FSPath> binary) {
        this.cancelSearch();
        if (this.validBinary()) {
            this.searching.set(true);
            this.validateController();
            Object object = this.lock;
            synchronized (object) {
                AtomicBoolean cancel = new AtomicBoolean(false);
                this.cancelable.add(cancel);
                ActionListener actionListener = e -> cancel.set(true);
                this.cancelSearch.addActionListener(actionListener);
                SwingUtilities.invokeLater(() -> this.cancelSearch.setEnabled(true));
                this.processDlls(searchPaths, binary, dllPaths, cancel, root);
                this.cancelSearch.removeActionListener(actionListener);
                SwingUtilities.invokeLater(() -> this.cancelSearch.setEnabled(false));
            }
            this.searching.set(false);
            this.validateController();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void processDlls(List<String> searchPaths, List<FSPath> binaries, Map<String, String> dllPaths, AtomicBoolean cancel, String root) {
        HashSet<String> checkedDll = new HashSet<String>();
        for (FSPath binary : binaries) {
            ArrayList<String> secondary;
            void var11_11;
            void var12_16;
            checkedDll.add(binary.getPath());
            String ldLibPath = CommonUtilities.getLdLibraryPath((ExecutionEnvironment)this.env);
            ldLibPath = CommonUtilities.addSearchPaths((String)ldLibPath, searchPaths, (String)binary.getPath());
            for (String string : dllPaths.keySet()) {
                if (cancel.get()) break;
                String string2 = this.findLocation(string, ldLibPath);
                if (string2 != null) {
                    dllPaths.put(string, string2);
                    continue;
                }
                dllPaths.put(string, null);
            }
            do {
                secondary = new ArrayList<String>();
                for (Map.Entry<String, String> entry : dllPaths.entrySet()) {
                    if (cancel.get()) break;
                    if (entry.getValue() == null || checkedDll.contains(entry.getValue())) continue;
                    checkedDll.add(entry.getValue());
                    IteratorExtension extension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    WizardConstants.DISCOVERY_BUILD_RESULT.toMap(map, entry.getValue());
                    WizardConstants.DISCOVERY_RESOLVE_LINKS.toMap(map, Boolean.TRUE);
                    if (this.env.isRemote()) {
                        WizardConstants.DISCOVERY_BINARY_FILESYSTEM.toMap(map, this.fileSystem);
                    }
                    if (extension == null) continue;
                    extension.discoverArtifacts(map);
                    List<String> dlls = WizardConstants.DISCOVERY_BINARY_DEPENDENCIES.fromMap(map);
                    if (dlls == null) continue;
                    for (String so : dlls) {
                        if (dllPaths.containsKey(so)) continue;
                        secondary.add(so);
                    }
                }
                for (String string : secondary) {
                    if (cancel.get()) break;
                    dllPaths.put(string, this.findLocation(string, ldLibPath));
                }
                boolean bl = false;
                for (Map.Entry<String, String> entry : dllPaths.entrySet()) {
                    if (entry.getValue() != null) continue;
                    ++var11_11;
                }
                this.updateDllArtifacts(root, dllPaths, var11_11 > 0);
                if (!cancel.get() && var11_11 > 0 && root.length() > 1) {
                    ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)SelectBinaryPanelVisual.getString("SearchForUnresolvedDLL"));
                    progressHandle.start();
                    try {
                        this.gatherSubFolders(this.fileSystem.findResource(root), new HashSet<String>(), dllPaths, cancel);
                    }
                    finally {
                        progressHandle.finish();
                    }
                    this.updateDllArtifacts(root, dllPaths, false);
                }
                boolean bl2 = false;
                for (Map.Entry<String, String> entry : dllPaths.entrySet()) {
                    if (entry.getValue() != null) continue;
                    ++var12_16;
                }
            } while (var12_16 != var11_11 || !secondary.isEmpty());
        }
    }

    private void gatherSubFolders(FileObject startRoot, HashSet<String> set, Map<String, String> result, AtomicBoolean cancel) {
        ArrayList<FileObject> down = new ArrayList<FileObject>();
        down.add(startRoot);
        while (!down.isEmpty()) {
            ArrayList<FileObject> next = new ArrayList<FileObject>();
            for (FileObject folder : down) {
                String path;
                if (cancel.get()) {
                    return;
                }
                if (folder == null || !folder.isFolder() || !folder.canRead()) continue;
                try {
                    path = FileSystemProvider.getCanonicalPath((FileObject)folder);
                }
                catch (IOException ex) {
                    continue;
                }
                if (set.contains(path = path.replace('\\', '/'))) continue;
                set.add(path);
                FileObject[] fileList = folder.getChildren();
                if (fileList == null) continue;
                for (int i = 0; i < fileList.length; ++i) {
                    if (cancel.get()) {
                        return;
                    }
                    String ffPath = fileList[i].getPath();
                    if (set.contains(ffPath)) continue;
                    if (fileList[i].isFolder()) {
                        next.add(fileList[i]);
                        continue;
                    }
                    String name = fileList[i].getNameExt();
                    if (!result.containsKey(name)) continue;
                    result.put(name, ffPath);
                    boolean finished = true;
                    for (Map.Entry<String, String> entry : result.entrySet()) {
                        if (entry.getValue() != null) continue;
                        finished = false;
                        break;
                    }
                    if (!finished) continue;
                    return;
                }
            }
            down = next;
        }
    }

    private String findLocation(String dll, String ldPath) {
        if (ldPath != null) {
            String pathSepararor = ":";
            if (ldPath.indexOf(59) > 0) {
                pathSepararor = ";";
            }
            HashSet<String> visited = new HashSet<String>();
            for (String search : ldPath.split(pathSepararor)) {
                if (visited.contains(search)) continue;
                visited.add(search);
                FileObject file = this.fileSystem.findResource(search + "/" + dll);
                if (file == null || !file.isValid() || !file.isData()) continue;
                String path = file.getPath();
                return path.replace('\\', '/');
            }
        }
        return null;
    }

    private CompilerSet detectCompilerSet(String compiler) {
        boolean isSunStudio = true;
        if (compiler != null) {
            isSunStudio = compiler.contains("Sun");
        }
        CompilerSetManager manager = CompilerSetManager.get((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
        if (isSunStudio) {
            CompilerSet def = manager.getDefaultCompilerSet();
            if (def != null && def.getCompilerFlavor().isSunStudioCompiler()) {
                return def;
            }
            def = null;
            for (CompilerSet set : manager.getCompilerSets()) {
                if (!set.getCompilerFlavor().isSunStudioCompiler()) continue;
                if ("OracleSolarisStudio".equals(set.getName())) {
                    def = set;
                }
                if (def != null) continue;
                def = set;
            }
            return def;
        }
        CompilerSet def = manager.getDefaultCompilerSet();
        if (def != null && !def.getCompilerFlavor().isSunStudioCompiler()) {
            return def;
        }
        def = null;
        for (CompilerSet set : manager.getCompilerSets()) {
            if (set.getCompilerFlavor().isSunStudioCompiler() || def != null) continue;
            def = set;
        }
        return def;
    }

    private void initComponents() {
        this.binaryLabel = new JLabel();
        this.binaryButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.sourcesLabel = new JLabel();
        this.sourcesField = new JTextField();
        this.sourcesButton = new JButton();
        this.dependenciesLabel = new JLabel();
        this.dependeciesComboBox = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.viewLabel = new JLabel();
        this.viewComboBox = new JComboBox();
        this.binaryField = new ExpandableEditableComboBox();
        this.cancelSearch = new JButton();
        this.setPreferredSize(new Dimension(450, 350));
        this.setLayout(new GridBagLayout());
        this.binaryLabel.setLabelFor(this.binaryField);
        Mnemonics.setLocalizedText((JLabel)this.binaryLabel, (String)NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)"SelectBinaryPanelVisual.binaryLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.binaryLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.binaryButton, (String)NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)"SelectBinaryPanelVisual.binaryButton.text"));
        this.binaryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectBinaryPanelVisual.this.binaryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.binaryButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 3;
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.sourcesLabel.setLabelFor(this.sourcesField);
        Mnemonics.setLocalizedText((JLabel)this.sourcesLabel, (String)NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)"SelectBinaryPanelVisual.sourcesLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.sourcesLabel, gridBagConstraints);
        this.sourcesField.setText(NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)"SelectBinaryPanelVisual.sourcesField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.sourcesField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.sourcesButton, (String)NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)"SelectBinaryPanelVisual.sourcesButton.text"));
        this.sourcesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectBinaryPanelVisual.this.sourcesButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.sourcesButton, gridBagConstraints);
        this.dependenciesLabel.setLabelFor(this.dependeciesComboBox);
        Mnemonics.setLocalizedText((JLabel)this.dependenciesLabel, (String)NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)"SelectBinaryPanelVisual.dependenciesLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.dependenciesLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.dependeciesComboBox, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 200));
        this.table.setModel(new DefaultTableModel());
        this.jScrollPane1.setViewportView(this.table);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.viewLabel.setLabelFor(this.viewComboBox);
        Mnemonics.setLocalizedText((JLabel)this.viewLabel, (String)NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)"SelectBinaryPanelVisual.viewLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.viewLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.viewComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.binaryField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelSearch, (String)NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)"SelectBinaryPanelVisual.cancelSearch.text"));
        this.cancelSearch.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.cancelSearch, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void binaryButtonActionPerformed(ActionEvent evt) {
        String oldPath = ((ExpandableEditableComboBox)((Object)this.binaryField)).getText();
        FileListEditorPanel panel = new FileListEditorPanel(oldPath, this.env, this.fileSystem);
        JButton jOK = new JButton(NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)"SelectBinaryPanelVisual.Browse.OK.Button"));
        panel.setPreferredSize(new Dimension(450, 200));
        DialogDescriptor dd = new DialogDescriptor((Object)panel, SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.Browse.Multi.Title"), true, new Object[]{jOK, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        try {
            dialog.setVisible(true);
        }
        finally {
            dialog.dispose();
        }
        if (dd.getValue() == jOK) {
            StringBuilder buf = new StringBuilder();
            panel.getFileList().forEach(s -> {
                if (buf.length() > 0) {
                    buf.append(';');
                }
                buf.append((String)s);
            });
            ((ExpandableEditableComboBox)((Object)this.binaryField)).setText(buf.toString());
        }
    }

    private void sourcesButtonActionPerformed(ActionEvent evt) {
        String seed = this.sourcesField.getText();
        JFileChooser fileChooser = RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)this.env, (String)SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.Source.Browse.Title"), (String)SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.Source.Browse.Select"), (int)1, null, (String)seed, (boolean)false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        File selectedFile = fileChooser.getSelectedFile();
        if (selectedFile != null) {
            String path = selectedFile.getPath();
            this.sourcesField.setText(path);
        }
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.env = WizardConstants.PROPERTY_REMOTE_FILE_SYSTEM_ENV.get(wizardDescriptor);
        if (this.env == null) {
            this.env = ExecutionEnvironmentFactory.getLocal();
        } else {
            WizardConstants.PROPERTY_HOST_UID.put(wizardDescriptor, ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.env));
        }
        this.fileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)this.env);
        ((ExpandableEditableComboBox)((Object)this.binaryField)).setStorage(BINARY_FILE_KEY, NbPreferences.forModule(SelectBinaryPanelVisual.class));
        ((ExpandableEditableComboBox)((Object)this.binaryField)).setEnv(this.env);
        String binary = WizardConstants.PROPERTY_BUILD_RESULT.get(wizardDescriptor);
        if (binary == null) {
            binary = "";
        }
        ((ExpandableEditableComboBox)((Object)this.binaryField)).read(binary);
    }

    void store(WizardDescriptor wizardDescriptor) {
        this.cancelSearch();
        String binary = ((ExpandableEditableComboBox)((Object)this.binaryField)).getText().trim();
        WizardConstants.PROPERTY_BUILD_RESULT.put(wizardDescriptor, binary);
        String[] split = binary.split(";");
        String aBinary = binary;
        if (split.length > 0) {
            aBinary = split[0];
        }
        WizardConstants.PROPERTY_PREFERED_PROJECT_NAME.put(wizardDescriptor, CndPathUtilities.getBaseName((String)aBinary));
        WizardConstants.PROPERTY_SOURCE_FOLDER_PATH.put(wizardDescriptor, this.sourcesField.getText().trim());
        WizardConstants.PROPERTY_DEPENDENCY_KIND.put(wizardDescriptor, ((ProjectKindItem)this.dependeciesComboBox.getSelectedItem()).kind);
        WizardConstants.PROPERTY_DEPENDENCIES.put(wizardDescriptor, this.getDlls());
        WizardConstants.PROPERTY_TRUE_SOURCE_ROOT.put(wizardDescriptor, ((ProjectView)this.viewComboBox.getSelectedItem()).isSourceRoot);
        ((ExpandableEditableComboBox)((Object)this.binaryField)).setStorage(BINARY_FILE_KEY, NbPreferences.forModule(SelectBinaryPanelVisual.class));
        ((ExpandableEditableComboBox)((Object)this.binaryField)).store();
        if (WizardConstants.PROPERTY_REMOTE_FILE_SYSTEM_ENV.get(wizardDescriptor) != null) {
            WizardConstants.PROPERTY_READ_ONLY_TOOLCHAIN.put(wizardDescriptor, Boolean.TRUE);
        }
        WizardConstants.PROPERTY_USER_MAKEFILE_PATH.put(wizardDescriptor, "");
    }

    private ArrayList<String> getDlls() {
        ArrayList<String> dlls = new ArrayList<String>();
        if (((ProjectKindItem)this.dependeciesComboBox.getSelectedItem()).kind == IteratorExtension.ProjectKind.Minimal) {
            return dlls;
        }
        for (int i = 0; i < this.table.getModel().getRowCount(); ++i) {
            if (!((Boolean)this.table.getModel().getValueAt(i, 0)).booleanValue()) continue;
            dlls.add((String)this.table.getModel().getValueAt(i, 2));
        }
        return dlls;
    }

    boolean valid() {
        return !this.searching.get() && this.checking.get() == 0 && this.validBinary() && this.validSourceRoot() && this.validDlls();
    }

    private List<FSPath> getValidBinaryPath() {
        List<FSPath> binaries = this.controller.getWizardStorage().getBinaryPath();
        if (binaries == null || binaries.isEmpty()) {
            return null;
        }
        ArrayList<FSPath> res = new ArrayList<FSPath>();
        for (FSPath path : binaries) {
            if (!CndPathUtilities.isAbsolute((FileSystem)path.getFileSystem(), (String)path.getPath())) {
                return null;
            }
            res.add(new FSPath(this.fileSystem, CndFileUtils.normalizeAbsolutePath((FileSystem)path.getFileSystem(), (String)path.getPath())));
        }
        return res;
    }

    private boolean validBinary() {
        List<FSPath> validBinaryPath = this.getValidBinaryPath();
        if (validBinaryPath != null) {
            for (FSPath fsPath : validBinaryPath) {
                FileObject fo = fsPath.getFileObject();
                if (fo != null && fo.isValid() && MIMENames.isBinary((String)fo.getMIMEType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean validSourceRoot() {
        String path = this.sourcesField.getText().trim();
        if (path.isEmpty()) {
            return false;
        }
        if (CndPathUtilities.isPathAbsolute((CharSequence)path)) {
            FileObject fo = this.fileSystem.findResource(CndFileUtils.normalizeAbsolutePath((String)path));
            if (fo == null || !fo.isValid()) {
                return false;
            }
            return fo.isFolder();
        }
        return false;
    }

    private boolean validDlls() {
        for (String dll : this.getDlls()) {
            FileObject fo = this.fileSystem.findResource(dll);
            if (fo != null && fo.isValid()) continue;
            return false;
        }
        return true;
    }

    private void onClickAction(MouseEvent e) {
        TableColumnModel columnModel;
        int viewColumn;
        int col;
        int rowIndex = this.table.rowAtPoint(e.getPoint());
        if (rowIndex >= 0 && (col = this.table.convertColumnIndexToModel(viewColumn = (columnModel = this.table.getColumnModel()).getColumnIndexAtX(e.getX()))) == 2) {
            Rectangle rect = this.table.getCellRect(rowIndex, viewColumn, false);
            Point point = new Point(e.getPoint().x - rect.x, e.getPoint().y - rect.y);
            if (rect.width - 20 <= point.x && point.x <= rect.width) {
                this.tableButtonActionPerformed(rowIndex);
            }
        }
    }

    private String selectBinaryFile(String path, boolean muliSelection) {
        int ret;
        FileFilter[] filters = FileFilterFactory.getBinaryFilters((FileSystem)this.fileSystem);
        if (path.isEmpty()) {
            path = SelectModePanel.getDefaultDirectory(this.env);
        } else if (path.startsWith("\"")) {
            int i = path.indexOf(34, 0);
            int j = path.indexOf(34, 1);
            if (i >= 0 && j > i) {
                path = path.substring(i + 1, j);
            }
        }
        JFileChooser fileChooser = NewProjectWizardUtils.createFileChooser(this.controller.getWizardDescriptor(), muliSelection ? SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.Browse.Multi.Title") : SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.Browse.Title"), muliSelection ? SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.Browse.Multi.Select") : SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.Browse.Select"), 0, filters, path, false);
        if (muliSelection) {
            fileChooser.setMultiSelectionEnabled(true);
        }
        if ((ret = fileChooser.showOpenDialog(this)) == 1) {
            return null;
        }
        if (!muliSelection) {
            return fileChooser.getSelectedFile().getPath();
        }
        File[] selected = fileChooser.getSelectedFiles();
        if (selected == null || selected.length == 0) {
            return null;
        }
        if (selected.length == 1) {
            return selected[0].getPath();
        }
        StringBuilder buf = new StringBuilder();
        for (File f : selected) {
            if (buf.length() > 0) {
                buf.append(';');
            }
            buf.append(f.getPath());
        }
        return buf.toString();
    }

    private void tableButtonActionPerformed(int row) {
        String path = this.selectBinaryFile((String)this.table.getModel().getValueAt(row, 2), false);
        if (path == null) {
            return;
        }
        this.table.getModel().setValueAt(path, row, 2);
    }

    private static String getString(String key) {
        return NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)key);
    }

    private static String getString(String key, String arg) {
        return NbBundle.getMessage(SelectBinaryPanelVisual.class, (String)key, (Object)arg);
    }

    private static final class MyDefaultTableModel
    extends DefaultTableModel {
        private final List<Boolean> uses = new ArrayList<Boolean>();
        private final List<String> names = new ArrayList<String>();
        private final List<String> paths = new ArrayList<String>();
        private final SelectBinaryPanelVisual parent;
        private final boolean searching;

        private MyDefaultTableModel(SelectBinaryPanelVisual parent, Map<String, String> dlls, String root, String binaryRoot, boolean searching) {
            super(new String[]{SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.col0"), SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.col1"), SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.col2")}, 0);
            this.searching = searching;
            for (Map.Entry<String, String> entry : dlls.entrySet()) {
                String dll = entry.getKey();
                this.names.add(dll);
                String path = entry.getValue();
                if (path == null) {
                    this.uses.add(Boolean.FALSE);
                    if (searching) {
                        this.paths.add(SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.col.searching"));
                        continue;
                    }
                    this.paths.add(SelectBinaryPanelVisual.getString("SelectBinaryPanelVisual.col.notfound"));
                    continue;
                }
                if (this.isMyDll(path, root) || this.isMyDll(path, binaryRoot)) {
                    this.uses.add(Boolean.TRUE);
                } else {
                    this.uses.add(Boolean.FALSE);
                }
                this.paths.add(path);
            }
            this.parent = parent;
        }

        private boolean isMyDll(String path, String root) {
            if (root == null) {
                return false;
            }
            path = path.replace('\\', '/');
            root = root.replace('\\', '/');
            if (path.startsWith("/usr/lib/")) {
                return false;
            }
            if (path.startsWith("/lib/")) {
                return false;
            }
            if (path.startsWith("/usr/local/lib/")) {
                return false;
            }
            if (path.startsWith(root)) {
                return true;
            }
            String[] p1 = path.split("/");
            String[] p2 = root.split("/");
            for (int i = 0; i < Math.min(p1.length - 1, p2.length); ++i) {
                if (!p1[i].equals(p2[i])) {
                    return i > 3;
                }
                if (i <= 3) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return this.uses.get(row);
                }
                case 1: {
                    return this.names.get(row);
                }
                case 2: {
                    return this.paths.get(row);
                }
            }
            return super.getValueAt(row, column);
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            switch (column) {
                case 0: {
                    this.uses.set(row, (Boolean)value);
                    this.parent.validateController();
                    return;
                }
                case 1: {
                    this.names.set(row, (String)value);
                    return;
                }
                case 2: {
                    this.paths.set(row, (String)value);
                    this.parent.validateController();
                    return;
                }
            }
            super.setValueAt(value, row, column);
        }

        @Override
        public Class<?> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return super.getColumnClass(column);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            if (this.uses == null) {
                return 0;
            }
            return this.uses.size();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (this.searching) {
                return false;
            }
            return col != 1;
        }
    }

    private static final class CheckBoxTableCellEditor
    extends DefaultCellEditor {
        private CheckBoxTableCellEditor() {
            super(new JCheckBox());
            ((JCheckBox)this.getEditorComponent()).setHorizontalAlignment(0);
            ((JCheckBox)this.getEditorComponent()).setBorderPainted(true);
        }

        public final JComponent getEditorComponent() {
            return this.editorComponent;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private static final class PathCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private static final Border noFocusButtonBorder = new LineBorder(Color.GRAY, 1);
        private final JTextField field = new JTextField();
        private final JButton button = new JButton("...");
        private final Color textFieldColor;
        private final Color redTextFieldColor;
        private final FileSystem fileSystem;

        public PathCellRenderer(FileSystem fileSystem) {
            this.setLayout(new BorderLayout());
            this.add((Component)this.field, "Center");
            this.field.setBorder(noFocusBorder);
            this.textFieldColor = this.field.getForeground();
            this.redTextFieldColor = new Color(this.field.getBackground().getRed(), this.textFieldColor.getGreen(), this.textFieldColor.getBlue());
            this.add((Component)this.button, "East");
            this.button.setPreferredSize(new Dimension(20, 5));
            this.button.setMaximumSize(new Dimension(20, 20));
            this.button.setBorder(noFocusButtonBorder);
            this.fileSystem = fileSystem;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.field.setText(value.toString());
            if (table.getModel().isCellEditable(row, column)) {
                this.field.setEnabled(true);
                this.button.setEnabled(true);
            } else {
                this.field.setEnabled(false);
                this.button.setEnabled(false);
            }
            FileObject dll = this.fileSystem.findResource(value.toString());
            if (dll != null && dll.isValid()) {
                this.field.setForeground(this.textFieldColor);
            } else {
                this.field.setForeground(this.redTextFieldColor);
            }
            this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.setBorder(hasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : noFocusBorder);
            return this;
        }
    }

    private static final class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private final JLabel emptyLabel = new JLabel();

        public CheckBoxCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
            this.emptyLabel.setBorder(noFocusBorder);
            this.emptyLabel.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent result;
            if (value == null) {
                result = this.emptyLabel;
            } else {
                this.setSelected((Boolean)value);
                this.setEnabled(table.getModel().isCellEditable(row, column));
                result = this;
            }
            result.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            result.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            result.setBorder(hasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : noFocusBorder);
            return result;
        }
    }

    private static final class ProjectView {
        private boolean isSourceRoot;

        ProjectView(boolean isSourceRoot) {
            this.isSourceRoot = isSourceRoot;
        }

        public String toString() {
            if (this.isSourceRoot) {
                return SelectBinaryPanelVisual.getString("ProjectViewSource");
            }
            return SelectBinaryPanelVisual.getString("ProjectViewLogical");
        }
    }

    private static final class ProjectKindItem {
        private final IteratorExtension.ProjectKind kind;

        ProjectKindItem(IteratorExtension.ProjectKind kind) {
            this.kind = kind;
        }

        public String toString() {
            return SelectBinaryPanelVisual.getString("ProjectItemKind_" + (Object)((Object)this.kind));
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

