/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.completion;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.Cache;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.NavUtils;
import org.netbeans.modules.php.editor.actions.IconsUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.QualifiedNameKind;
import org.netbeans.modules.php.editor.api.elements.AliasedElement;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ConstantElement;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.FullyQualifiedElement;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.NamespaceElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TraitElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.netbeans.modules.php.editor.api.elements.TypeNameResolver;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.api.elements.VariableElement;
import org.netbeans.modules.php.editor.codegen.CodegenUtils;
import org.netbeans.modules.php.editor.completion.Bundle;
import org.netbeans.modules.php.editor.completion.CompletionContextFinder;
import org.netbeans.modules.php.editor.completion.PHPCodeCompletion;
import org.netbeans.modules.php.editor.elements.ParameterElementImpl;
import org.netbeans.modules.php.editor.elements.TypeNameResolverImpl;
import org.netbeans.modules.php.editor.indent.CodeStyle;
import org.netbeans.modules.php.editor.index.PredefinedSymbolElement;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.options.CodeCompletionPanel;
import org.netbeans.modules.php.editor.options.OptionsUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.project.api.PhpLanguageProperties;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public abstract class PHPCompletionItem
implements CompletionProposal {
    private static final String PHP_KEYWORD_ICON = "org/netbeans/modules/php/editor/resources/php16Key.png";
    protected static final ImageIcon KEYWORD_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/php/editor/resources/php16Key.png"));
    final CompletionRequest request;
    private final ElementHandle element;
    private QualifiedNameKind generateAs;
    private static ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private static final Cache<FileObject, PhpLanguageProperties> PROPERTIES_CACHE = new Cache(new WeakHashMap());
    private final boolean isPlatform;
    private final boolean isDeprecated;

    PHPCompletionItem(ElementHandle element, CompletionRequest request, QualifiedNameKind generateAs) {
        this.request = request;
        this.element = element;
        this.generateAs = generateAs;
        if (element instanceof PhpElement) {
            PhpElement phpElement = (PhpElement)element;
            this.isPlatform = phpElement.isPlatform();
            this.isDeprecated = phpElement.isDeprecated();
        } else {
            this.isPlatform = false;
            this.isDeprecated = false;
        }
    }

    PHPCompletionItem(ElementHandle element, CompletionRequest request) {
        this(element, request, null);
    }

    public int getAnchorOffset() {
        return this.request.anchor;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getSortText() {
        return this.getName();
    }

    public int getSortPrioOverride() {
        return 0;
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        formatter.name(this.getKind(), true);
        String name = this.getName();
        if (CodeUtils.isSyntheticTypeName(name)) {
            name = "{}";
        }
        if (this.isDeprecated()) {
            formatter.deprecated(true);
            formatter.appendText(name);
            formatter.deprecated(false);
        } else {
            formatter.appendText(name);
        }
        formatter.name(this.getKind(), false);
        return formatter.getText();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        Set emptyModifiers = Collections.emptySet();
        ElementHandle handle = this.getElement();
        return handle != null ? handle.getModifiers() : emptyModifiers;
    }

    public String getFileNameURL() {
        ElementHandle elem = this.getElement();
        return elem instanceof PhpElement ? ((PhpElement)elem).getFilenameUrl() : "";
    }

    public boolean isSmart() {
        return this.element instanceof AliasedElement || this.request.currentlyEditedFileURL != null && this.request.currentlyEditedFileURL.equals(this.getFileNameURL());
    }

    protected boolean isDeprecated() {
        return this.isDeprecated;
    }

    private static NamespaceDeclaration findEnclosingNamespace(PHPParseResult info, int offset) {
        Program program = info.getProgram();
        List<ASTNode> nodes = NavUtils.underCaret(info, Math.min(program != null ? program.getEndOffset() : offset, offset));
        for (ASTNode node : nodes) {
            if (!(node instanceof NamespaceDeclaration)) continue;
            return (NamespaceDeclaration)node;
        }
        return null;
    }

    public String getCustomInsertTemplate() {
        return null;
    }

    public String getInsertPrefix() {
        MethodElement method;
        StringBuilder template = new StringBuilder();
        ElementHandle elem = this.getElement();
        if (elem instanceof MethodElement && (method = (MethodElement)elem).isConstructor() && this.request.context.equals((Object)CompletionContextFinder.CompletionContext.NEW_CLASS)) {
            elem = method.getType();
        }
        if (elem instanceof FullyQualifiedElement) {
            FullyQualifiedElement ifq = (FullyQualifiedElement)elem;
            QualifiedName qn = QualifiedName.create(this.request.prefix);
            FileObject fileObject = this.request.result.getSnapshot().getSource().getFileObject();
            PhpLanguageProperties props = PROPERTIES_CACHE.get(fileObject);
            if (props == null) {
                props = PhpLanguageProperties.forFileObject((FileObject)fileObject);
                PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)new PhpVersionChangeListener(fileObject), (Object)props);
                props.addPropertyChangeListener(propertyChangeListener);
                PROPERTIES_CACHE.save(fileObject, props);
            }
            if (props.getPhpVersion() != PhpVersion.PHP_5) {
                if (this.generateAs == null) {
                    CodeCompletionPanel.CodeCompletionType codeCompletionType = OptionsUtils.codeCompletionType();
                    switch (codeCompletionType) {
                        case FULLY_QUALIFIED: {
                            template.append(ifq.getFullyQualifiedName());
                            return template.toString();
                        }
                        case UNQUALIFIED: {
                            template.append(this.getName());
                            return template.toString();
                        }
                        case SMART: {
                            this.generateAs = qn.getKind();
                            break;
                        }
                        default: {
                            assert (false) : codeCompletionType;
                            {
                                break;
                            }
                        }
                    }
                }
            } else {
                template.append(this.getName());
                return template.toString();
            }
            switch (this.generateAs) {
                case FULLYQUALIFIED: {
                    template.append(ifq.getFullyQualifiedName());
                    break;
                }
                case QUALIFIED: {
                    String fqn = ifq.getFullyQualifiedName().toString();
                    int indexOf = fqn.toLowerCase().indexOf(qn.toNamespaceName().toString().toLowerCase());
                    if (indexOf != -1) {
                        template.append(fqn.substring(indexOf == 0 ? 1 : indexOf));
                        break;
                    }
                }
                case UNQUALIFIED: {
                    boolean isUnqualified;
                    String enclosingScopeName = ifq.getIn();
                    boolean fncOrConstFromDefaultNamespace = !(!(ifq instanceof FunctionElement) && !(ifq instanceof ConstantElement) || enclosingScopeName != null && !enclosingScopeName.isEmpty() || !"".equals(ifq.getNamespaceName().toString()));
                    boolean bl = isUnqualified = ifq.isAliased() && ifq instanceof AliasedElement && ((AliasedElement)ifq).isNameAliased();
                    if (!fncOrConstFromDefaultNamespace && !isUnqualified) {
                        Model model = this.request.result.getModel();
                        NamespaceDeclaration namespaceDeclaration = PHPCompletionItem.findEnclosingNamespace(this.request.result, this.request.anchor);
                        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(namespaceDeclaration, model.getFileScope());
                        if (namespaceScope != null) {
                            QualifiedName suffix;
                            LinkedList<String> segments = ifq.getFullyQualifiedName().getSegments();
                            QualifiedName fqna = QualifiedName.create(false, segments);
                            if (!(namespaceScope.isDefaultNamespace() && fqna.getKind().isUnqualified() || (suffix = VariousUtils.getPreferredName(fqna, namespaceScope)) == null)) {
                                template.append(suffix.toString());
                                break;
                            }
                        }
                    }
                    template.append(this.getName());
                    break;
                }
                default: {
                    assert (false) : this.generateAs;
                    break;
                }
            }
            String tpl = template.toString();
            String extraPrefix = this.request.extraPrefix;
            if (StringUtils.hasText((String)extraPrefix)) {
                if (tpl.startsWith(extraPrefix)) {
                    tpl = tpl.substring(extraPrefix.length());
                } else assert (false) : "[" + tpl + "] should start with [" + extraPrefix + "]";
            }
            return tpl;
        }
        return this.getName();
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        if (this.element instanceof TypeMemberElement) {
            TypeMemberElement classMember = (TypeMemberElement)this.element;
            TypeElement type = classMember.getType();
            String name = type.getName();
            if (CodeUtils.isSyntheticTypeName(name)) {
                formatter.appendText("{}");
                return formatter.getText();
            }
            QualifiedName qualifiedName = type.getNamespaceName();
            if (qualifiedName.isDefaultNamespace()) {
                formatter.appendText(name);
                return formatter.getText();
            }
            formatter.appendText(type.getFullyQualifiedName().toString());
            return formatter.getText();
        }
        String in = this.element.getIn();
        if (in != null && in.length() > 0) {
            formatter.appendText(in);
            return formatter.getText();
        }
        if (this.element instanceof PhpElement) {
            PhpElement ie = (PhpElement)this.element;
            if (this.isPlatform) {
                return NbBundle.getMessage(PHPCompletionItem.class, (String)"PHPPlatform");
            }
            String filename = ie.getFilenameUrl();
            int index = filename.lastIndexOf(47);
            if (index != -1) {
                filename = filename.substring(index + 1);
            }
            formatter.appendText(filename);
            return formatter.getText();
        }
        return null;
    }

    public static boolean insertOnlyMethodsName(CompletionRequest request) {
        if (request.insertOnlyMethodsName != null) {
            return request.insertOnlyMethodsName;
        }
        boolean result = false;
        TokenHierarchy tokenHierarchy = request.result.getSnapshot().getTokenHierarchy();
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        if (tokenSequence != null) {
            VariableScope variableScope = request.result.getModel().getVariableScope(request.anchor);
            if (variableScope != null) {
                tokenSequence = tokenSequence.subSequence(request.anchor, variableScope.getBlockRange().getEnd());
            }
            boolean wasWhitespace = false;
            while (tokenSequence.moveNext()) {
                Token token = tokenSequence.token();
                PHPTokenId id = (PHPTokenId)token.id();
                if (PHPTokenId.PHP_STRING.equals((Object)id)) {
                    if (!wasWhitespace) continue;
                    break;
                }
                if (PHPTokenId.WHITESPACE.equals((Object)id)) {
                    wasWhitespace = true;
                    continue;
                }
                if (!PHPTokenId.PHP_TOKEN.equals((Object)id) || !TokenUtilities.textEquals((CharSequence)token.text(), (CharSequence)"(")) break;
                result = true;
                break;
            }
        }
        return result;
    }

    public static ImageIcon getInterfaceIcon() {
        return InterfaceItem.icon();
    }

    private static void scheduleShowingCompletion() {
        if (OptionsUtils.autoCompletionTypes()) {
            service.schedule(new Runnable(){

                @Override
                public void run() {
                    Completion.get().showCompletion();
                }
            }, 750L, TimeUnit.MILLISECONDS);
        }
    }

    private static class PhpVersionChangeListener
    implements PropertyChangeListener {
        private final WeakReference<FileObject> fileObjectReference;

        public PhpVersionChangeListener(FileObject fileObject) {
            this.fileObjectReference = new WeakReference<FileObject>(fileObject);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FileObject fileObject;
            if (PhpLanguageProperties.PROP_PHP_VERSION.equals(evt.getPropertyName()) && (fileObject = (FileObject)this.fileObjectReference.get()) != null) {
                PROPERTIES_CACHE.save(fileObject, PhpLanguageProperties.forFileObject((FileObject)fileObject));
            }
        }
    }

    public static class CompletionRequest {
        public int anchor;
        public PHPParseResult result;
        public ParserResult info;
        public String prefix;
        public String extraPrefix;
        public Boolean insertOnlyMethodsName;
        public String currentlyEditedFileURL;
        public CompletionContextFinder.CompletionContext context;
        ElementQuery.Index index;
    }

    static class TagItem
    extends KeywordItem {
        private int sortKey;

        public TagItem(String tag, int sortKey, CompletionRequest request) {
            super(tag, request);
            this.sortKey = sortKey;
        }

        @Override
        public String getSortText() {
            return "" + this.sortKey + this.getName();
        }
    }

    static class LanguageConstructWithSemicolonItem
    extends LanguageConstructItem {
        public LanguageConstructWithSemicolonItem(String fncName, CompletionRequest request) {
            super(fncName, request);
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getName());
            builder.append(" ${cursor};");
            return builder.toString();
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            this.prependName(formatter);
            formatter.appendText(" ;");
            return formatter.getText();
        }
    }

    static class LanguageConstructWithParenthesesItem
    extends LanguageConstructItem {
        public LanguageConstructWithParenthesesItem(String fncName, CompletionRequest request) {
            super(fncName, request);
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getName());
            builder.append("(${cursor})");
            return builder.toString();
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            this.prependName(formatter);
            formatter.appendText("()");
            return formatter.getText();
        }
    }

    static class LanguageConstructWithQuotesItem
    extends LanguageConstructItem {
        public LanguageConstructWithQuotesItem(String fncName, CompletionRequest request) {
            super(fncName, request);
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getName());
            builder.append(" '${cursor}';");
            return builder.toString();
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            this.prependName(formatter);
            formatter.appendText(" '';");
            return formatter.getText();
        }
    }

    static abstract class LanguageConstructItem
    extends KeywordItem {
        private static final String SORT_AFTER_KEYWORDS = "z";

        public LanguageConstructItem(String fncName, CompletionRequest request) {
            super(fncName, request);
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            formatter.appendText(Bundle.LBL_LANGUAGE_CONSTRUCT());
            return formatter.getText();
        }

        @Override
        public String getSortText() {
            return SORT_AFTER_KEYWORDS + super.getSortText();
        }

        protected void prependName(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
        }
    }

    static class VariableItem
    extends PHPCompletionItem {
        VariableItem(VariableElement variable, CompletionRequest request) {
            super(variable, request);
        }

        VariableElement getVariable() {
            return (VariableElement)this.getElement();
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.type(true);
            formatter.appendText(this.getTypeName());
            formatter.type(false);
            formatter.appendText(" ");
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
            return formatter.getText();
        }

        public ElementKind getKind() {
            return ElementKind.VARIABLE;
        }

        @Override
        public String getInsertPrefix() {
            Completion.get().showToolTip();
            return this.getName();
        }

        protected String getTypeName() {
            QualifiedName qualifiedName;
            TypeResolver typeResolver;
            String typeName;
            Set types = this.getVariable().getInstanceTypes();
            String string = types.isEmpty() ? "?" : (typeName = types.size() > 1 ? "mixed" : "?");
            if (types.size() == 1 && (typeResolver = (TypeResolver)types.iterator().next()).isResolved() && (qualifiedName = typeResolver.getTypeName(false)) != null) {
                typeName = CodeUtils.isSyntheticTypeName(qualifiedName.getName()) ? "{}" : qualifiedName.toString();
            }
            return typeName;
        }
    }

    static class InterfaceItem
    extends PHPCompletionItem {
        private static final String PHP_INTERFACE_ICON = "org/netbeans/modules/php/editor/resources/interface.png";
        private static ImageIcon interfaceIcon = null;
        private final boolean endWithDoubleColon;

        InterfaceItem(InterfaceElement iface, CompletionRequest request, boolean endWithDoubleColon) {
            super(iface, request);
            this.endWithDoubleColon = endWithDoubleColon;
        }

        InterfaceItem(InterfaceElement iface, CompletionRequest request, QualifiedNameKind generateAs, boolean endWithDoubleColon) {
            super(iface, request, generateAs);
            this.endWithDoubleColon = endWithDoubleColon;
        }

        public ElementKind getKind() {
            return ElementKind.CLASS;
        }

        private static ImageIcon icon() {
            if (interfaceIcon == null) {
                interfaceIcon = new ImageIcon(ImageUtilities.loadImage((String)PHP_INTERFACE_ICON));
            }
            return interfaceIcon;
        }

        @Override
        public ImageIcon getIcon() {
            return InterfaceItem.icon();
        }

        @Override
        public String getInsertPrefix() {
            return this.getName();
        }

        @Override
        public String getCustomInsertTemplate() {
            String superTemplate = super.getInsertPrefix();
            if (this.endWithDoubleColon) {
                StringBuilder builder = new StringBuilder();
                builder.append(superTemplate);
                builder.append("::${cursor}");
                PHPCompletionItem.scheduleShowingCompletion();
                return builder.toString();
            }
            return superTemplate;
        }
    }

    static class ClassItem
    extends PHPCompletionItem {
        private boolean endWithDoubleColon;

        ClassItem(ClassElement clazz, CompletionRequest request, boolean endWithDoubleColon, QualifiedNameKind generateAs) {
            super(clazz, request, generateAs);
            this.endWithDoubleColon = endWithDoubleColon;
        }

        public ElementKind getKind() {
            return ElementKind.CLASS;
        }

        @Override
        public String getInsertPrefix() {
            return this.getName();
        }

        @Override
        public String getCustomInsertTemplate() {
            String superTemplate = super.getInsertPrefix();
            if (this.endWithDoubleColon) {
                StringBuilder builder = new StringBuilder();
                builder.append(superTemplate);
                boolean includeDoubleColumn = true;
                if (EditorRegistry.lastFocusedComponent() != null) {
                    Document doc = EditorRegistry.lastFocusedComponent().getDocument();
                    int caret = EditorRegistry.lastFocusedComponent().getCaretPosition();
                    try {
                        if (caret + 2 < doc.getLength() && "::".equals(doc.getText(caret, 2))) {
                            includeDoubleColumn = false;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                if (includeDoubleColumn) {
                    builder.append("::");
                }
                builder.append("${cursor}");
                PHPCompletionItem.scheduleShowingCompletion();
                return builder.toString();
            }
            if (CompletionContextFinder.CompletionContext.NEW_CLASS.equals((Object)this.request.context)) {
                PHPCompletionItem.scheduleShowingCompletion();
            }
            return superTemplate;
        }
    }

    static class TraitItem
    extends PHPCompletionItem {
        private static final ImageIcon ICON = IconsUtils.getElementIcon(PhpElementKind.TRAIT);

        TraitItem(TraitElement element, CompletionRequest request) {
            super(element, request);
        }

        @Override
        public ImageIcon getIcon() {
            return ICON;
        }

        public ElementKind getKind() {
            return ElementKind.CLASS;
        }
    }

    static class ConstantItem
    extends PHPCompletionItem {
        ConstantItem(ConstantElement constant, CompletionRequest request) {
            this(constant, request, (QualifiedNameKind)null);
        }

        ConstantItem(ConstantElement constant, CompletionRequest request, QualifiedNameKind generateAs) {
            super(constant, request, generateAs);
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            ElementHandle element = this.getElement();
            assert (element != null);
            String value = ((ConstantElement)element).getValue();
            formatter.name(this.getKind(), true);
            if (this.emphasisName()) {
                formatter.emphasis(true);
                formatter.appendText(this.getName());
                formatter.emphasis(false);
            } else {
                formatter.appendText(this.getName());
            }
            formatter.name(this.getKind(), false);
            formatter.appendText(" ");
            formatter.type(true);
            formatter.appendText(value != null ? value : "?");
            formatter.type(false);
            return formatter.getText();
        }

        protected boolean emphasisName() {
            return true;
        }

        public ElementKind getKind() {
            return ElementKind.CONSTANT;
        }
    }

    static class NamespaceItem
    extends PHPCompletionItem {
        private Boolean isSmart;

        NamespaceItem(NamespaceElement namespace, CompletionRequest request, QualifiedNameKind generateAs) {
            super(namespace, request, generateAs);
        }

        @Override
        public String getInsertPrefix() {
            return this.getName();
        }

        @Override
        public String getCustomInsertTemplate() {
            return super.getInsertPrefix();
        }

        @Override
        public int getSortPrioOverride() {
            return this.isSmart() ? -10001 : super.getSortPrioOverride();
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
            return formatter.getText();
        }

        @Override
        public String getName() {
            return this.getNamespaceElement().getName();
        }

        NamespaceElement getNamespaceElement() {
            return (NamespaceElement)this.getElement();
        }

        public ElementKind getKind() {
            return ElementKind.PACKAGE;
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            QualifiedName namespaceName = this.getNamespaceElement().getNamespaceName();
            if (namespaceName != null && !namespaceName.isDefaultNamespace()) {
                formatter.appendText(namespaceName.toString());
                return formatter.getText();
            }
            return null;
        }

        @Override
        public boolean isSmart() {
            if (this.isSmart == null && this.getElement() instanceof AliasedElement) {
                this.isSmart = true;
            }
            if (this.isSmart == null) {
                QualifiedName namespaceName = this.getNamespaceElement().getNamespaceName();
                this.isSmart = namespaceName != null && namespaceName.isDefaultNamespace();
                if (!this.isSmart.booleanValue()) {
                    NamespaceScope namespaceScope;
                    FileScope fileScope = this.request.result.getModel().getFileScope();
                    NamespaceScope namespaceScope2 = namespaceScope = fileScope != null ? ModelUtils.getNamespaceScope(fileScope, this.request.anchor) : null;
                    if (namespaceScope != null) {
                        NamespaceElement ifq = this.getNamespaceElement();
                        LinkedList<String> segments = ifq.getFullyQualifiedName().getSegments();
                        QualifiedName fqna = QualifiedName.create(false, segments);
                        Collection<QualifiedName> relativeUses = VariousUtils.getRelativesToUses(namespaceScope, fqna);
                        for (QualifiedName qualifiedName : relativeUses) {
                            if (qualifiedName.getSegments().size() != 1) continue;
                            this.isSmart = true;
                            break;
                        }
                        if (!this.isSmart.booleanValue()) {
                            relativeUses = VariousUtils.getRelativesToNamespace(namespaceScope, fqna);
                            for (QualifiedName qualifiedName : relativeUses) {
                                if (qualifiedName.getSegments().size() != 1) continue;
                                this.isSmart = true;
                                break;
                            }
                        }
                    }
                }
            }
            return this.isSmart;
        }
    }

    static class SuperGlobalItem
    extends PHPCompletionItem {
        private String name;

        public SuperGlobalItem(CompletionRequest request, String name) {
            super(new PredefinedSymbolElement(name), request);
            this.name = name;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            formatter.emphasis(true);
            formatter.appendText(this.getName());
            formatter.emphasis(false);
            formatter.name(this.getKind(), false);
            return formatter.getText();
        }

        @Override
        public String getName() {
            return "$" + this.name;
        }

        @Override
        public String getInsertPrefix() {
            return this.getName();
        }

        public ElementKind getKind() {
            return ElementKind.VARIABLE;
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            formatter.appendText(NbBundle.getMessage(PHPCompletionItem.class, (String)"PHPPlatform"));
            return formatter.getText();
        }

        public String getDocumentation() {
            return null;
        }

        @Override
        public ImageIcon getIcon() {
            return KEYWORD_ICON;
        }
    }

    static class KeywordItem
    extends PHPCompletionItem {
        String keyword = null;
        private static final List<String> CLS_KEYWORDS = Arrays.asList(PHPCodeCompletion.PHP_CLASS_KEYWORDS);

        KeywordItem(String keyword, CompletionRequest request) {
            super(null, request);
            this.keyword = keyword;
        }

        @Override
        public String getName() {
            return this.keyword;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            formatter.appendText(this.getName());
            formatter.name(this.getKind(), false);
            return formatter.getText();
        }

        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            return null;
        }

        @Override
        public ImageIcon getIcon() {
            return KEYWORD_ICON;
        }

        @Override
        public boolean isSmart() {
            return CLS_KEYWORDS.contains(this.getName()) ? true : super.isSmart();
        }

        @Override
        public String getInsertPrefix() {
            return this.getName();
        }

        @Override
        public String getCustomInsertTemplate() {
            CompletionContextFinder.KeywordCompletionType type;
            StringBuilder builder = new StringBuilder();
            if (CLS_KEYWORDS.contains(this.getName())) {
                PHPCompletionItem.scheduleShowingCompletion();
            }
            if ((type = PHPCodeCompletion.PHP_KEYWORDS.get(this.getName())) == null) {
                return this.getName();
            }
            CodeStyle codeStyle = CodeStyle.get(EditorRegistry.lastFocusedComponent().getDocument());
            boolean appendSpace = true;
            switch (type) {
                case SIMPLE: {
                    return null;
                }
                case ENDS_WITH_SPACE: {
                    builder.append(this.getName());
                    builder.append(" ${cursor}");
                    break;
                }
                case CURSOR_INSIDE_BRACKETS: {
                    String name = this.getName();
                    builder.append(name);
                    boolean appendBrackets = true;
                    switch (name) {
                        case "foreach": 
                        case "for": {
                            appendSpace = codeStyle.spaceBeforeForParen();
                            break;
                        }
                        case "if": {
                            appendSpace = codeStyle.spaceBeforeIfParen();
                            break;
                        }
                        case "switch": {
                            appendSpace = codeStyle.spaceBeforeSwitchParen();
                            break;
                        }
                        case "array": {
                            if (this.request.context == CompletionContextFinder.CompletionContext.TYPE_NAME) {
                                appendBrackets = false;
                                appendSpace = false;
                                break;
                            }
                            appendSpace = codeStyle.spaceBeforeArrayDeclParen();
                            break;
                        }
                        case "while": {
                            appendSpace = codeStyle.spaceBeforeWhileParen();
                            break;
                        }
                        case "catch": {
                            appendSpace = codeStyle.spaceBeforeCatchParen();
                            break;
                        }
                    }
                    if (appendSpace) {
                        builder.append(" ");
                    }
                    if (!appendBrackets) break;
                    builder.append("(${cursor})");
                    break;
                }
                case ENDS_WITH_CURLY_BRACKETS: {
                    String name = this.getName();
                    builder.append(name);
                    switch (name) {
                        case "try": {
                            appendSpace = codeStyle.spaceBeforeTryLeftBrace();
                            break;
                        }
                        case "do": {
                            appendSpace = codeStyle.spaceBeforeDoLeftBrace();
                            break;
                        }
                        case "else": {
                            appendSpace = codeStyle.spaceBeforeElseLeftBrace();
                            break;
                        }
                    }
                    if (appendSpace) {
                        builder.append(" ");
                    }
                    builder.append("{${cursor}}");
                    if (!"try".equals(name)) break;
                    builder.append("catch (Exception $ex) {}");
                    break;
                }
                case ENDS_WITH_BRACKETS_AND_CURLY_BRACKETS: {
                    String name = this.getName();
                    builder.append(name);
                    if (name.equals("elseif")) {
                        appendSpace = codeStyle.spaceBeforeIfParen();
                    }
                    if (appendSpace) {
                        builder.append(" ");
                    }
                    builder.append("(${cursor})");
                    if (name.equals("elseif")) {
                        appendSpace = codeStyle.spaceBeforeIfLeftBrace();
                    }
                    if (appendSpace) {
                        builder.append(" ");
                    }
                    builder.append("{}");
                    break;
                }
                case ENDS_WITH_SEMICOLON: {
                    builder.append(this.getName());
                    CharSequence text = this.request.info.getSnapshot().getText();
                    int index = this.request.anchor + this.request.prefix.length();
                    if (index != text.length() && ';' == text.charAt(index)) break;
                    builder.append(";");
                    break;
                }
                case ENDS_WITH_COLON: {
                    builder.append(this.getName());
                    builder.append(" ${cursor}:");
                    break;
                }
                case CURSOR_BEFORE_ENDING_SEMICOLON: {
                    builder.append(this.getName());
                    builder.append(" ${cursor};");
                    break;
                }
                default: {
                    assert (false) : type.toString();
                    break;
                }
            }
            return builder.toString();
        }
    }

    static class ClassScopeKeywordItem
    extends KeywordItem {
        private final String className;

        ClassScopeKeywordItem(String className, String keyword, CompletionRequest request) {
            super(keyword, request);
            this.className = className;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            if (this.keyword.startsWith("$")) {
                if (this.className != null) {
                    formatter.type(true);
                    formatter.appendText(CodeUtils.isSyntheticTypeName(this.className) ? "{}" : this.className);
                    formatter.type(false);
                }
                formatter.appendText(" ");
            }
            return super.getLhsHtml(formatter);
        }
    }

    public static class MethodDeclarationItem
    extends MethodElementItem {
        public static MethodDeclarationItem getDeclarationItem(MethodElement methodElement, CompletionRequest request) {
            return new MethodDeclarationItem(new FunctionElementItem(methodElement, request, methodElement.getParameters()));
        }

        public static MethodDeclarationItem forIntroduceHint(MethodElement methodElement, CompletionRequest request) {
            return new MethodDeclarationItem(new FunctionElementItem(methodElement, request, methodElement.getParameters())){

                @Override
                protected String getFunctionBodyForTemplate() {
                    return "\n";
                }
            };
        }

        public static MethodDeclarationItem forMethodName(MethodElement methodElement, CompletionRequest request) {
            return new MethodDeclarationItem(new FunctionElementItem(methodElement, request, methodElement.getParameters())){

                @Override
                public String getCustomInsertTemplate() {
                    return 2.insertOnlyMethodsName(this.request) ? super.getInsertPrefix() : super.getNameAndFunctionBodyForTemplate();
                }
            };
        }

        public static MethodDeclarationItem forIntroduceInterfaceHint(MethodElement methodElement, CompletionRequest request) {
            return new MethodDeclarationItem(new FunctionElementItem(methodElement, request, methodElement.getParameters())){

                @Override
                protected String getBodyPart() {
                    return ";";
                }
            };
        }

        private MethodDeclarationItem(FunctionElementItem functionItem) {
            super(functionItem);
        }

        public MethodElement getMethod() {
            return (MethodElement)this.getBaseFunctionElement();
        }

        @Override
        public boolean isSmart() {
            return !this.isMagic();
        }

        @Override
        protected boolean emphasisName() {
            return this.isMagic() ? false : super.emphasisName();
        }

        public boolean isMagic() {
            return ((MethodElement)this.getBaseFunctionElement()).isMagic();
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder template = new StringBuilder();
            String modifierStr = BodyDeclaration.Modifier.toString(this.getBaseFunctionElement().getFlags());
            if (modifierStr.length() != 0) {
                modifierStr = modifierStr.replace("abstract", "").trim();
                template.append(modifierStr);
            }
            template.append(" ").append("function");
            template.append(this.getNameAndFunctionBodyForTemplate());
            return template.toString();
        }

        protected String getNameAndFunctionBodyForTemplate() {
            StringBuilder template = new StringBuilder();
            TypeNameResolver typeNameResolver = this.getBaseFunctionElement().getParameters().isEmpty() || this.request == null ? TypeNameResolverImpl.forNull() : CodegenUtils.createSmarterTypeNameResolver(this.getBaseFunctionElement(), this.request.result.getModel(), this.request.anchor);
            template.append(this.getBaseFunctionElement().asString(BaseFunctionElement.PrintAs.NameAndParamsDeclaration, typeNameResolver));
            template.append(this.getBodyPart());
            return template.toString();
        }

        protected String getBodyPart() {
            StringBuilder template = new StringBuilder();
            template.append(" ").append("{\n");
            template.append(this.getFunctionBodyForTemplate());
            template.append("}");
            return template.toString();
        }

        protected String getFunctionBodyForTemplate() {
            StringBuilder template = new StringBuilder();
            MethodElement method = (MethodElement)this.getBaseFunctionElement();
            TypeElement type = method.getType();
            if (this.isMagic() || type.isInterface() || method.isAbstract()) {
                template.append("${cursor};\n");
            } else {
                template.append("${cursor}parent::").append(this.getSignature().replace("&$", "$")).append(";\n");
            }
            return template.toString();
        }

        private String getSignature() {
            StringBuilder retval = new StringBuilder();
            retval.append(this.getBaseFunctionElement().getName());
            retval.append("(");
            StringBuilder parametersInfo = new StringBuilder();
            List<ParameterElement> parameters = this.getBaseFunctionElement().getParameters();
            for (ParameterElement parameter : parameters) {
                if (parametersInfo.length() > 0) {
                    parametersInfo.append(", ");
                }
                parametersInfo.append(parameter.getName());
            }
            retval.append((CharSequence)parametersInfo);
            retval.append(")");
            return retval.toString();
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            StringBuilder sb = new StringBuilder();
            sb.append(super.getLhsHtml(formatter));
            sb.append(' ');
            if (this.getMethod().isAbstract() || this.isMagic()) {
                sb.append(Bundle.Generate());
            } else {
                sb.append(Bundle.Override());
            }
            return sb.toString();
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            if (this.isMagic()) {
                String message = Bundle.MagicMethod();
                formatter.appendText(message);
                return formatter.getText();
            }
            return super.getRhsHtml(formatter);
        }
    }

    static class TypeConstantItem
    extends PHPCompletionItem {
        public static TypeConstantItem getItem(TypeConstantElement constant, CompletionRequest request) {
            return new TypeConstantItem(constant, request);
        }

        private TypeConstantItem(TypeConstantElement constant, CompletionRequest request) {
            super(constant, request);
        }

        TypeConstantElement getConstant() {
            return (TypeConstantElement)this.getElement();
        }

        public ElementKind getKind() {
            return ElementKind.CONSTANT;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.name(this.getKind(), true);
            if (this.isDeprecated()) {
                formatter.deprecated(true);
                formatter.appendText(this.getName());
                formatter.deprecated(false);
            } else {
                formatter.appendText(this.getName());
            }
            formatter.name(this.getKind(), false);
            formatter.appendText(" ");
            String value = this.getConstant().getValue();
            formatter.type(true);
            formatter.appendText(value != null ? value : "?");
            formatter.type(false);
            return formatter.getText();
        }

        @Override
        public String getName() {
            return this.getConstant().getName();
        }

        @Override
        public String getInsertPrefix() {
            Completion.get().showToolTip();
            return this.getName();
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            if (this.getConstant().isMagic()) {
                formatter.appendText(Bundle.MagicConstant());
                return formatter.getText();
            }
            return super.getRhsHtml(formatter);
        }
    }

    static class FieldItem
    extends BasicFieldItem {
        private final boolean forceDollared;

        public static FieldItem getItem(FieldElement field, CompletionRequest request) {
            return FieldItem.getItem(field, request, false);
        }

        public static FieldItem getItem(FieldElement field, CompletionRequest request, boolean forceDollared) {
            return new FieldItem(field, request, forceDollared);
        }

        private FieldItem(FieldElement field, CompletionRequest request, boolean forceDollared) {
            super(field, null, request);
            this.forceDollared = forceDollared;
        }

        FieldElement getField() {
            return (FieldElement)this.getElement();
        }

        @Override
        public String getName() {
            FieldElement field = this.getField();
            return field.getName(this.forceDollared || field.isStatic());
        }

        @Override
        protected String getTypeName() {
            QualifiedName qualifiedName;
            TypeResolver typeResolver;
            String typeName;
            Set<TypeResolver> types = this.getField().getInstanceTypes();
            String string = types.isEmpty() ? "?" : (typeName = types.size() > 1 ? "mixed" : "?");
            if (types.size() == 1 && (typeResolver = types.iterator().next()).isResolved() && (qualifiedName = typeResolver.getTypeName(false)) != null) {
                typeName = qualifiedName.toString();
            }
            return typeName;
        }
    }

    static class BasicFieldItem
    extends PHPCompletionItem {
        private String typeName;

        public static BasicFieldItem getItem(PhpElement field, String type, CompletionRequest request) {
            return new BasicFieldItem(field, type, request);
        }

        private BasicFieldItem(PhpElement field, String typeName, CompletionRequest request) {
            super(field, request);
            this.typeName = typeName;
        }

        @Override
        public String getInsertPrefix() {
            Completion.get().showToolTip();
            return this.getName();
        }

        public ElementKind getKind() {
            return ElementKind.VARIABLE;
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            formatter.type(true);
            formatter.appendText(this.getTypeName() == null ? "" : this.getTypeName());
            formatter.type(false);
            formatter.appendText(" ");
            formatter.name(this.getKind(), true);
            if (this.isDeprecated()) {
                formatter.deprecated(true);
            }
            formatter.appendText(this.getName());
            if (this.isDeprecated()) {
                formatter.deprecated(false);
            }
            formatter.name(this.getKind(), false);
            return formatter.getText();
        }

        @Override
        public String getName() {
            ElementHandle element = this.getElement();
            assert (element != null);
            String name = element.getName();
            return name.startsWith("$") ? name.substring(1) : name;
        }

        protected String getTypeName() {
            return this.typeName;
        }
    }

    static class FunctionElementItem
    extends PHPCompletionItem {
        private List<ParameterElement> parameters;

        static List<FunctionElementItem> getItems(BaseFunctionElement function, CompletionRequest request) {
            return FunctionElementItem.getItems(function, request, null);
        }

        static List<FunctionElementItem> getItems(BaseFunctionElement function, CompletionRequest request, QualifiedNameKind generateAs) {
            ArrayList<FunctionElementItem> retval = new ArrayList<FunctionElementItem>();
            ArrayList<ParameterElement> parameters = new ArrayList<ParameterElement>();
            for (ParameterElement param : function.getParameters()) {
                if (!param.isMandatory()) {
                    if (retval.isEmpty()) {
                        retval.add(new FunctionElementItem(function, request, parameters, generateAs));
                    }
                    parameters.add(param);
                    retval.add(new FunctionElementItem(function, request, parameters, generateAs));
                    continue;
                }
                parameters.add(param);
            }
            if (retval.isEmpty()) {
                retval.add(new FunctionElementItem(function, request, parameters, generateAs));
            }
            return retval;
        }

        FunctionElementItem(BaseFunctionElement function, CompletionRequest request, List<ParameterElement> parameters) {
            this(function, request, parameters, null);
        }

        FunctionElementItem(BaseFunctionElement function, CompletionRequest request, List<ParameterElement> parameters, QualifiedNameKind generateAs) {
            super(function, request, generateAs);
            this.parameters = new ArrayList<ParameterElement>(parameters);
        }

        public BaseFunctionElement getBaseFunctionElement() {
            return (BaseFunctionElement)this.getElement();
        }

        public ElementKind getKind() {
            return this.getBaseFunctionElement().getPhpElementKind().getElementKind();
        }

        @Override
        public String getInsertPrefix() {
            return this.getName();
        }

        @Override
        public String getCustomInsertTemplate() {
            StringBuilder template = new StringBuilder();
            template.append(super.getInsertPrefix());
            if (!FunctionElementItem.insertOnlyMethodsName(this.request)) {
                template.append("(");
                List<String> params = this.getInsertParams();
                for (int i = 0; i < params.size(); ++i) {
                    String param = params.get(i);
                    if (param.startsWith("&")) {
                        param = param.substring(1);
                    }
                    template.append(String.format("${php-cc-%d  default=\"%s\"}", i, param));
                    if (i >= params.size() - 1) continue;
                    template.append(", ");
                }
                template.append(')');
            }
            return template.toString();
        }

        @Override
        public String getLhsHtml(HtmlFormatter formatter) {
            ElementKind kind = this.getKind();
            formatter.name(kind, true);
            if (this.emphasisName()) {
                formatter.emphasis(true);
                if (this.isDeprecated()) {
                    formatter.deprecated(true);
                    formatter.appendText(this.getName());
                    formatter.deprecated(false);
                } else {
                    formatter.appendText(this.getName());
                }
                formatter.emphasis(false);
            } else if (this.isDeprecated()) {
                formatter.deprecated(true);
                formatter.appendText(this.getName());
                formatter.deprecated(false);
            } else {
                formatter.appendText(this.getName());
            }
            formatter.name(kind, false);
            formatter.appendHtml("(");
            formatter.parameters(true);
            this.appendParamsStr(formatter);
            formatter.parameters(false);
            formatter.appendHtml(")");
            return formatter.getText();
        }

        protected boolean emphasisName() {
            return true;
        }

        public List<String> getInsertParams() {
            LinkedList<String> insertParams = new LinkedList<String>();
            ExistingVariableResolver existingVariableResolver = new ExistingVariableResolver(this.request);
            for (ParameterElement parameter : this.parameters) {
                insertParams.add(existingVariableResolver.resolveVariable(parameter).getName());
            }
            return insertParams;
        }

        @Override
        public String getSortText() {
            return this.getName() + this.parameters.size();
        }

        private void appendParamsStr(HtmlFormatter formatter) {
            List<ParameterElement> allParameters = this.parameters;
            for (int i = 0; i < allParameters.size(); ++i) {
                ParameterElement parameter = allParameters.get(i);
                if (i != 0) {
                    formatter.appendText(", ");
                }
                String paramTpl = parameter.asString(ParameterElement.OutputType.SHORTEN_DECLARATION);
                if (!parameter.isMandatory()) {
                    formatter.appendText(paramTpl);
                    continue;
                }
                formatter.emphasis(true);
                formatter.appendText(paramTpl);
                formatter.emphasis(false);
            }
        }
    }

    private static class ExistingVariableResolver {
        private final CompletionRequest request;
        private final int caretOffset;
        private final List<VariableName> usedVariables = new LinkedList<VariableName>();
        private static final RequestProcessor RP = new RequestProcessor("ExistingVariableResolver");
        private static final Logger LOGGER = Logger.getLogger(ExistingVariableResolver.class.getName());
        private static final int RESOLVING_TIMEOUT = 300;

        public ExistingVariableResolver(CompletionRequest request) {
            this.request = request;
            this.caretOffset = request.anchor;
        }

        public ParameterElement resolveVariable(final ParameterElement param) {
            if (OptionsUtils.codeCompletionSmartParametersPreFilling()) {
                Future futureVariableToUse = RP.submit((Callable)new Callable<VariableName>(){

                    @Override
                    public VariableName call() throws Exception {
                        Collection declaredVariables = this.getDeclaredVariables();
                        VariableName variableToUse = null;
                        if (declaredVariables != null) {
                            int oldOffset = 0;
                            for (VariableName variable : declaredVariables) {
                                if (usedVariables.contains(variable) || variable.representsThis() || !this.isPreviousVariable(variable) || !this.hasCorrectType(variable, param.getTypes())) continue;
                                if (variable.getName().equals(param.getName())) {
                                    variableToUse = variable;
                                    break;
                                }
                                int newOffset = variable.getNameRange().getStart();
                                if (newOffset <= oldOffset) continue;
                                oldOffset = newOffset;
                                variableToUse = variable;
                            }
                        }
                        return variableToUse;
                    }
                });
                VariableName variableToUseName = null;
                try {
                    variableToUseName = (VariableName)futureVariableToUse.get(300L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.FINE, "Resolving of existing variables has been interrupted.");
                }
                catch (ExecutionException ex) {
                    LOGGER.log(Level.SEVERE, "Exception has been thrown during resolving of existing variables.", ex);
                }
                catch (TimeoutException ex) {
                    LOGGER.log(Level.FINE, "Timeout for resolving existing variables has been exceed: {0}", 300);
                }
                if (variableToUseName != null) {
                    this.usedVariables.add(variableToUseName);
                    return new ParameterElementImpl(variableToUseName.getName(), param.getDefaultValue(), param.getOffset(), param.getTypes(), param.isMandatory(), param.hasDeclaredType(), param.isReference(), param.isVariadic());
                }
            }
            return param;
        }

        private Collection<? extends VariableName> getDeclaredVariables() {
            VariableScope variableScope = this.request.result.getModel().getVariableScope(this.caretOffset);
            if (variableScope != null) {
                return variableScope.getDeclaredVariables();
            }
            return null;
        }

        private boolean isPreviousVariable(VariableName variable) {
            int offsetDiff = this.caretOffset - variable.getNameRange().getStart();
            return offsetDiff > 0;
        }

        private boolean hasCorrectType(VariableName variable, Set<TypeResolver> possibleTypes) {
            Collection typeNames = variable.getTypeNames(this.caretOffset);
            if (!typeNames.isEmpty()) {
                for (TypeResolver type : possibleTypes) {
                    if (!typeNames.contains(type.getRawTypeName()) && !"mixed".equals(type.getRawTypeName()) && (!typeNames.contains("real") || !"float".equals(type.getRawTypeName())) && (!typeNames.contains("int") || !"integer".equals(type.getRawTypeName()))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class MethodElementItem
    extends FunctionElementItem {
        static List<MethodElementItem> getItems(MethodElement methodElement, CompletionRequest request) {
            ArrayList<MethodElementItem> retval = new ArrayList<MethodElementItem>();
            List<FunctionElementItem> items = FunctionElementItem.getItems(methodElement, request);
            for (FunctionElementItem functionElementItem : items) {
                retval.add(new MethodElementItem(functionElementItem));
            }
            return retval;
        }

        MethodElementItem(FunctionElementItem function) {
            super(function.getBaseFunctionElement(), function.request, function.parameters);
        }
    }

    static class NewClassItem
    extends MethodElementItem {
        static List<NewClassItem> getNewClassItems(MethodElement methodElement, CompletionRequest request) {
            ArrayList<NewClassItem> retval = new ArrayList<NewClassItem>();
            List<FunctionElementItem> items = FunctionElementItem.getItems(methodElement, request);
            for (FunctionElementItem functionElementItem : items) {
                retval.add(new NewClassItem(functionElementItem));
            }
            return retval;
        }

        private NewClassItem(FunctionElementItem function) {
            super(function);
        }

        @Override
        public String getRhsHtml(HtmlFormatter formatter) {
            String namespaceName;
            ElementHandle element = this.getElement();
            if (element != null && element.getIn() != null && (namespaceName = ((MethodElement)element).getType().getNamespaceName().toString()) != null && !"".equals(namespaceName)) {
                formatter.appendText(namespaceName);
                return formatter.getText();
            }
            return super.getRhsHtml(formatter);
        }

        @Override
        public String getName() {
            ElementHandle element = this.getElement();
            String in = element == null ? null : element.getIn();
            return in != null ? in : super.getName();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CONSTRUCTOR;
        }

        @Override
        public boolean isSmart() {
            return this.getElement() instanceof AliasedElement ? true : super.isSmart();
        }
    }
}

