/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.openide.filesystems.FileObject;
import org.openide.util.Union2;

abstract class ScopeImpl
extends ModelElementImpl
implements Scope {
    private OffsetRange blockRange = null;
    private List<ModelElementImpl> elements = null;

    ScopeImpl(Scope inScope, ASTNodeInfo info, PhpModifiers modifiers, Block block, boolean isDeprecated) {
        super(inScope, info, modifiers, isDeprecated);
        if (block != null) {
            this.blockRange = new OffsetRange(block.getStartOffset(), block.getEndOffset());
        }
    }

    ScopeImpl(Scope inScope, PhpElement element, PhpElementKind kind) {
        super(inScope, element, kind);
    }

    ScopeImpl(Scope inScope, String name, Union2<String, FileObject> file, OffsetRange offsetRange, PhpElementKind kind, boolean isDeprecated) {
        super(inScope, name, file, offsetRange, kind, isDeprecated);
        assert (ScopeImpl.isScopeKind(kind)) : kind.toString();
    }

    ScopeImpl(Scope inScope, String name, Union2<String, FileObject> file, OffsetRange offsetRange, PhpElementKind kind, PhpModifiers modifier, boolean isDeprecated) {
        super(inScope, name, file, offsetRange, kind, modifier, isDeprecated);
        assert (ScopeImpl.isScopeKind(kind)) : kind.toString();
    }

    private static boolean isScopeKind(PhpElementKind kind) {
        boolean result;
        switch (kind) {
            case PROGRAM: 
            case NAMESPACE_DECLARATION: 
            case INDEX: 
            case CLASS: 
            case FUNCTION: 
            case IFACE: 
            case METHOD: 
            case VARIABLE: 
            case FIELD: 
            case USE_STATEMENT: 
            case GROUP_USE_STATEMENT: 
            case TRAIT: {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public synchronized List<? extends ModelElementImpl> getElements() {
        return this.elements == null ? Collections.EMPTY_LIST : new ArrayList<ModelElementImpl>(this.elements);
    }

    synchronized void addElement(ModelElementImpl element) {
        if (this.elements == null) {
            this.elements = new ArrayList<ModelElementImpl>();
        }
        this.elements.add(element);
    }

    static <T extends ModelElement> Collection<? extends T> filter(Collection<? extends ModelElement> original, ElementFilter<T> filter) {
        HashSet<ModelElement> retval = new HashSet<ModelElement>();
        for (ModelElement modelElement : original) {
            boolean accepted = filter.isAccepted(modelElement);
            if (!accepted) continue;
            retval.add(modelElement);
        }
        return retval;
    }

    void setBlockRange(ASTNode program) {
        this.blockRange = new OffsetRange(program.getStartOffset(), program.getEndOffset());
    }

    @Override
    public OffsetRange getBlockRange() {
        return this.blockRange;
    }

    static interface ElementFilter<T extends ModelElement> {
        public boolean isAccepted(ModelElement var1);
    }
}

