/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.profiler;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.profiler.api.JavaPlatform;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.nbimpl.project.JavaProjectProfilingSupportProvider;
import org.openide.filesystems.FileObject;

public class MavenProjectProfilingSupportProvider
extends JavaProjectProfilingSupportProvider {
    private final Set<String> supportedJ2eePTypes = new HashSet<String>(){
        {
            this.add("war");
            this.add("ejb");
        }
    };
    private final Set<String> supportedPTypes = new HashSet<String>(){
        {
            this.add("jar");
            this.addAll(MavenProjectProfilingSupportProvider.this.supportedJ2eePTypes);
            this.add("nbm");
            this.add("nbm-application");
            this.add("bundle");
        }
    };

    public JavaPlatform resolveProjectJavaPlatform() {
        return JavaPlatform.getDefaultPlatform();
    }

    public boolean isProfilingSupported() {
        NbMavenProject mproject = this.getMavenProject();
        return mproject == null ? false : this.supportedPTypes.contains(mproject.getPackagingType());
    }

    public boolean checkProjectCanBeProfiled(FileObject file) {
        if (this.isJ2EEProject(this.getMavenProject())) {
            return true;
        }
        return super.checkProjectCanBeProfiled(file);
    }

    public boolean isFileObjectSupported(FileObject file) {
        if (this.isJ2EEProject(this.getMavenProject())) {
            return this.isHttpServlet(file) || this.isJSP(file);
        }
        return super.isFileObjectSupported(file);
    }

    private boolean isHttpServlet(FileObject fo) {
        JavaProfilerSource src = JavaProfilerSource.createFrom((FileObject)fo);
        return src != null && src.isInstanceOf("javax.servlet.http.HttpServlet");
    }

    private boolean isJSP(FileObject fo) {
        return "jsp".equals(fo.getExt());
    }

    private boolean isJ2EEProject(NbMavenProject mproject) {
        return this.supportedJ2eePTypes.contains(mproject.getPackagingType());
    }

    private NbMavenProject getMavenProject() {
        return (NbMavenProject)this.getProject().getLookup().lookup(NbMavenProject.class);
    }

    public MavenProjectProfilingSupportProvider(Project project) {
        super(project);
    }
}

