/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public abstract class AbstractProjectClassPathImpl
implements ClassPathImplementation {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private List<PathResourceImplementation> resources;
    private NbMavenProjectImpl project;

    protected AbstractProjectClassPathImpl(NbMavenProjectImpl proj) {
        this.project = proj;
        NbMavenProject.addPropertyChangeListener(proj, new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("RESOURCES".equals(evt.getPropertyName()) || "MavenProject".equals(evt.getPropertyName())) {
                    boolean hasChanged;
                    List oldvalue;
                    if (AbstractProjectClassPathImpl.this.project.getProjectWatcher().isUnloadable()) {
                        return;
                    }
                    List newValues = AbstractProjectClassPathImpl.this.getPath();
                    AbstractProjectClassPathImpl abstractProjectClassPathImpl = AbstractProjectClassPathImpl.this;
                    synchronized (abstractProjectClassPathImpl) {
                        oldvalue = AbstractProjectClassPathImpl.this.resources;
                        hasChanged = AbstractProjectClassPathImpl.this.hasChanged(oldvalue, newValues);
                        if (hasChanged) {
                            AbstractProjectClassPathImpl.this.resources = newValues;
                        }
                    }
                    if (hasChanged) {
                        AbstractProjectClassPathImpl.this.support.firePropertyChange("resources", oldvalue, newValues);
                    }
                }
            }
        });
    }

    private boolean hasChanged(List<PathResourceImplementation> oldValues, List<PathResourceImplementation> newValues) {
        if (oldValues == null) {
            return newValues != null;
        }
        Iterator<PathResourceImplementation> it = oldValues.iterator();
        ArrayList<PathResourceImplementation> nl = new ArrayList<PathResourceImplementation>();
        nl.addAll(newValues);
        while (it.hasNext()) {
            PathResourceImplementation res = it.next();
            URL oldUrl = res.getRoots()[0];
            boolean found = false;
            if (nl.isEmpty()) {
                return true;
            }
            Iterator inner = nl.iterator();
            while (inner.hasNext()) {
                PathResourceImplementation res2 = (PathResourceImplementation)inner.next();
                URL newUrl = res2.getRoots()[0];
                if (!newUrl.equals(oldUrl)) continue;
                inner.remove();
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return !nl.isEmpty();
    }

    protected final NbMavenProjectImpl getMavenProject() {
        return this.project;
    }

    protected final void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.support.firePropertyChange(propName, oldValue, newValue);
    }

    public synchronized List<PathResourceImplementation> getResources() {
        if (this.resources == null) {
            this.resources = this.getPath();
        }
        return this.resources;
    }

    abstract URI[] createPath();

    private List<PathResourceImplementation> getPath() {
        List<PathResourceImplementation> base = AbstractProjectClassPathImpl.getPath(this.createPath(), new Includer(){

            @Override
            public boolean includes(URL root, String resource) {
                return AbstractProjectClassPathImpl.this.includes(root, resource);
            }
        });
        return Collections.unmodifiableList(base);
    }

    protected boolean includes(URL root, String resource) {
        return true;
    }

    public static List<PathResourceImplementation> getPath(URI[] pieces, final Includer includer) {
        ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
        for (int i = 0; i < pieces.length; ++i) {
            try {
                final URL entry = FileUtil.urlForArchiveOrDir((File)Utilities.toFile((URI)pieces[i]));
                if (entry == null) continue;
                result.add((PathResourceImplementation)new FilteringPathResourceImplementation(){

                    public boolean includes(URL root, String resource) {
                        return includer != null ? includer.includes(root, resource) : true;
                    }

                    public URL[] getRoots() {
                        return new URL[]{entry};
                    }

                    public ClassPathImplementation getContent() {
                        return null;
                    }

                    public void addPropertyChangeListener(PropertyChangeListener listener) {
                    }

                    public void removePropertyChangeListener(PropertyChangeListener listener) {
                    }
                });
                continue;
            }
            catch (IllegalArgumentException exc) {
                Logger.getLogger(AbstractProjectClassPathImpl.class.getName()).log(Level.INFO, "Cannot use uri " + pieces[i] + " for classpath", exc);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.support;
        synchronized (propertyChangeSupport) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.support;
        synchronized (propertyChangeSupport) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public final boolean equals(Object obj) {
        return this.getClass().isInstance(obj) && this.project.equals(((AbstractProjectClassPathImpl)obj).project);
    }

    public final int hashCode() {
        return this.project.hashCode() ^ this.getClass().hashCode();
    }

    public static interface Includer {
        public boolean includes(URL var1, String var2);
    }
}

