/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.PackBitmapIndexV1;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;

public abstract class PackBitmapIndex {
    public static final int FLAG_REUSE = 1;
    byte[] packChecksum;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PackBitmapIndex open(File idxFile, PackIndex packIndex, PackReverseIndex reverseIndex) throws IOException {
        PackBitmapIndex packBitmapIndex;
        FileInputStream fd = new FileInputStream(idxFile);
        try {
            try {
                packBitmapIndex = PackBitmapIndex.read(fd, packIndex, reverseIndex);
                Object var8_6 = null;
            }
            catch (IOException ioe) {
                String path = idxFile.getAbsolutePath();
                IOException err = new IOException(MessageFormat.format(JGitText.get().unreadablePackIndex, path));
                err.initCause(ioe);
                throw err;
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                fd.close();
                throw throwable;
            }
            catch (IOException err2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException err2) {
            // empty catch block
            return packBitmapIndex;
        }
        fd.close();
        return packBitmapIndex;
    }

    public static PackBitmapIndex read(InputStream fd, PackIndex packIndex, PackReverseIndex reverseIndex) throws IOException {
        return new PackBitmapIndexV1(fd, packIndex, reverseIndex);
    }

    public abstract int findPosition(AnyObjectId var1);

    public abstract ObjectId getObject(int var1) throws IllegalArgumentException;

    public abstract EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap var1, int var2);

    public abstract EWAHCompressedBitmap getBitmap(AnyObjectId var1);

    public abstract int getObjectCount();
}

