/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core.net;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.eclipse.mylyn.commons.core.net.SslCertificateException;
import org.eclipse.osgi.util.NLS;

public class SslSupport {
    private static final String KEY_STORE_FILE_NAME = "javax.net.ssl.keyStore";
    private static final String KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    private final String keyStoreFileName;
    private final String keyStorePassword;
    private final String keyStoreType;
    private SSLSocketFactory socketFactory;
    private final TrustManager[] trustManagers;

    public SslSupport(TrustManager[] trustManagers) {
        this(trustManagers, System.getProperty(KEY_STORE_FILE_NAME), System.getProperty(KEY_STORE_PASSWORD), System.getProperty(KEY_STORE_TYPE));
    }

    public SslSupport(TrustManager[] trustManagers, String keyStoreFileName, String keyStorePassword, String keyStoreType) {
        this.trustManagers = trustManagers;
        this.keyStoreFileName = keyStoreFileName;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SslSupport other = (SslSupport)obj;
        if (this.keyStoreFileName == null ? other.keyStoreFileName != null : !this.keyStoreFileName.equals(other.keyStoreFileName)) {
            return false;
        }
        if (this.keyStorePassword == null ? other.keyStorePassword != null : !this.keyStorePassword.equals(other.keyStorePassword)) {
            return false;
        }
        return !(this.keyStoreType == null ? other.keyStoreType != null : !this.keyStoreType.equals(other.keyStoreType));
    }

    public synchronized SSLSocketFactory getSocketFactory() throws IOException {
        if (this.socketFactory == null) {
            KeyManager[] keyManagers = null;
            if (this.keyStoreFileName != null && this.keyStorePassword != null) {
                try {
                    if (this.keyStoreType != null) {
                        keyManagers = this.openKeyStore(this.keyStoreType);
                    } else {
                        try {
                            keyManagers = this.openKeyStore(KeyStore.getDefaultType());
                        }
                        catch (Exception exception) {
                            keyManagers = this.openKeyStore("pkcs12");
                        }
                    }
                }
                catch (Exception cause) {
                    SslCertificateException e = new SslCertificateException(NLS.bind((String)"Error accessing keystore: {0}", (Object)cause.getMessage()));
                    e.initCause(cause);
                    throw e;
                }
            }
            try {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                sslContext.init(keyManagers, this.trustManagers, null);
                this.socketFactory = sslContext.getSocketFactory();
            }
            catch (Exception cause) {
                SslCertificateException e = new SslCertificateException();
                e.initCause(cause);
                throw e;
            }
        }
        return this.socketFactory;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.keyStoreFileName == null ? 0 : this.keyStoreFileName.hashCode());
        result = 31 * result + (this.keyStorePassword == null ? 0 : this.keyStorePassword.hashCode());
        result = 31 * result + (this.keyStoreType == null ? 0 : this.keyStoreType.hashCode());
        return result;
    }

    private KeyManager[] openKeyStore(String type) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance(type);
        char[] password = this.keyStorePassword.toCharArray();
        keyStore.load(new FileInputStream(this.keyStoreFileName), password);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, password);
        return keyManagerFactory.getKeyManagers();
    }
}

