/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.ui.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.php.api.ui.options.FrameworksOptionsPanelController;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

@SuppressWarnings(value={"SE_BAD_FIELD_STORE"})
final class FrameworksPanel
extends JPanel {
    private final Lookup masterLookup;
    private final FrameworksOptionsPanelController masterController;
    private final List<AdvancedOption> options;
    private final Map<AdvancedOption, OptionsPanelController> option2controller;
    private final Map<AdvancedOption, List<String>> option2keywords;
    private final PropertyChangeListener changeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FrameworksPanel.this.masterController.fireChange(evt);
        }
    };
    volatile int selectedCategoryIndex = 0;
    private JList<String> listCategories;
    private JPanel panelContent;
    private JScrollPane scrollCategories;

    FrameworksPanel(FrameworksOptionsPanelController masterController, Lookup masterLookup, List<AdvancedOption> options) {
        assert (EventQueue.isDispatchThread());
        this.masterLookup = masterLookup;
        this.masterController = masterController;
        this.sortOptions(options);
        this.options = new CopyOnWriteArrayList<AdvancedOption>(options);
        this.option2controller = new ConcurrentHashMap<AdvancedOption, OptionsPanelController>(options.size() * 2);
        this.option2keywords = new HashMap<AdvancedOption, List<String>>(options.size() * 2);
        this.initComponents();
        this.init();
    }

    private void sortOptions(List<AdvancedOption> options) {
        final Collator collator = Collator.getInstance();
        Collections.sort(options, new Comparator<AdvancedOption>(){

            @Override
            public int compare(AdvancedOption o1, AdvancedOption o2) {
                return collator.compare(o1.getDisplayName(), o2.getDisplayName());
            }
        });
    }

    private void init() {
        assert (EventQueue.isDispatchThread());
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (AdvancedOption ao : this.options) {
            model.addElement(ao.getDisplayName());
        }
        this.listCategories.setModel(model);
        this.listCategories.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FrameworksPanel.this.switchPanel();
            }
        });
        this.listCategories.setSelectedIndex(this.selectedCategoryIndex);
        this.listCategories.setCellRenderer(new NameListCellRenderer(this.listCategories.getCellRenderer()));
        this.listCategories.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FrameworksPanel.this.selectedCategoryIndex = FrameworksPanel.this.listCategories.getSelectedIndex();
            }
        });
    }

    private void initComponents() {
        this.scrollCategories = new JScrollPane();
        this.listCategories = new JList();
        this.panelContent = new JPanel();
        this.listCategories.setSelectionMode(0);
        this.scrollCategories.setViewportView(this.listCategories);
        this.panelContent.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.scrollCategories, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelContent, -1, 141, Short.MAX_VALUE).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollCategories, -1, 300, Short.MAX_VALUE).addComponent(this.panelContent, -1, -1, Short.MAX_VALUE))));
    }

    @CheckForNull
    OptionsPanelController getSelectedController() {
        AdvancedOption option = this.getSelectedOption();
        if (option == null) {
            return null;
        }
        return this.option2controller.get(option);
    }

    @CheckForNull
    private AdvancedOption getSelectedOption() {
        if (this.selectedCategoryIndex < 0) {
            return null;
        }
        return this.options.get(this.selectedCategoryIndex);
    }

    void switchPanel() {
        OptionsPanelController selection;
        assert (EventQueue.isDispatchThread());
        this.panelContent.removeAll();
        AdvancedOption selOption = this.getSelectedOption();
        if (selOption != null) {
            OptionsPanelController controller = this.getController(selOption);
            controller.update();
        }
        if ((selection = this.getSelectedController()) != null) {
            this.panelContent.add((Component)selection.getComponent(Lookup.EMPTY), "Center");
        }
        this.panelContent.invalidate();
        this.panelContent.revalidate();
        this.panelContent.repaint();
        this.masterController.fireChange(new PropertyChangeEvent(this, "helpCtx", null, null));
    }

    private OptionsPanelController getController(AdvancedOption option) {
        assert (EventQueue.isDispatchThread());
        OptionsPanelController controller = this.option2controller.get(option);
        if (controller == null) {
            controller = option.create();
            controller.getComponent(this.masterLookup);
            this.option2controller.put(option, controller);
            controller.addPropertyChangeListener(this.changeListener);
        }
        return controller;
    }

    void handleSearch(List<String> matchedKeywords) {
        assert (EventQueue.isDispatchThread());
        for (AdvancedOption option : this.options) {
            List<String> keywords = this.option2keywords.get(option);
            if (keywords == null) {
                keywords = this.loadKeywords(option);
                this.option2keywords.put(option, keywords);
            }
            for (String kw : matchedKeywords) {
                if (!keywords.contains(kw)) continue;
                this.setSelecteOption(option);
                return;
            }
        }
    }

    private List<String> loadKeywords(AdvancedOption option) {
        OptionsPanelController controller = this.getController(option);
        JComponent panel = controller.getComponent(this.masterLookup);
        String id = "OptionsDialog/Keywords/" + panel.getClass().getName();
        ArrayList<String> res = new ArrayList<String>(20);
        FileObject keywordsFO = FileUtil.getConfigFile((String)id);
        if (keywordsFO != null) {
            Enumeration attributes = keywordsFO.getAttributes();
            while (attributes.hasMoreElements()) {
                String attribute = (String)attributes.nextElement();
                if (!attribute.startsWith("keywords")) continue;
                String word = keywordsFO.getAttribute(attribute).toString();
                res.add(word.toUpperCase());
            }
        }
        return res;
    }

    void update() {
        for (OptionsPanelController controller : this.option2controller.values()) {
            controller.update();
        }
    }

    void applyChanges() {
        for (OptionsPanelController controller : this.option2controller.values()) {
            controller.applyChanges();
        }
    }

    void cancel() {
        for (OptionsPanelController controller : this.option2controller.values()) {
            controller.cancel();
        }
    }

    boolean isControllerValid() {
        for (OptionsPanelController controller : this.option2controller.values()) {
            if (controller.isValid()) continue;
            return false;
        }
        return true;
    }

    boolean isChanged() {
        for (OptionsPanelController controller : this.option2controller.values()) {
            if (!controller.isChanged()) continue;
            return true;
        }
        return false;
    }

    void setSelecteOption(AdvancedOption option) {
        int index = this.options.indexOf(option);
        if (index >= 0) {
            this.listCategories.setSelectedIndex(index);
        }
    }

    private static final class NameListCellRenderer
    implements ListCellRenderer<String> {
        private final ListCellRenderer<? super String> defaultCellRenderer;

        NameListCellRenderer(ListCellRenderer<? super String> defaultCellRenderer) {
            assert (defaultCellRenderer != null);
            this.defaultCellRenderer = defaultCellRenderer;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            assert (EventQueue.isDispatchThread());
            value = value + "   ";
            return this.defaultCellRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

