/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.markdown.core.block;

import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.markdown.core.block.NestableBlock;

public class InlineHtmlBlock
extends NestableBlock {
    private static final Pattern AUTOMATIC_LINK_PATTERN = Pattern.compile("<((?:https?|ftp):[^'\">\\s]+)>");

    public boolean canStart(String line, int lineOffset) {
        return line.substring(lineOffset).trim().startsWith("<") && !AUTOMATIC_LINK_PATTERN.matcher(line).matches();
    }

    protected int processLineContent(String line, int offset) {
        String text = line.substring(offset);
        if (this.markupLanguage.isEmptyLine(text)) {
            this.setClosed(true);
            return offset;
        }
        this.builder.charactersUnescaped(text);
        return -1;
    }
}

