/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.actions;

import java.net.URL;
import java.util.concurrent.Callable;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.GrailsServerState;
import org.netbeans.modules.groovy.grailsproject.actions.Bundle;
import org.netbeans.modules.groovy.grailsproject.actions.ConfigurationSupport;
import org.netbeans.modules.groovy.grailsproject.commands.GrailsCommandChooser;
import org.netbeans.modules.groovy.grailsproject.commands.GrailsCommandSupport;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;

public class GrailsCommandAction
extends CallableSystemAction {
    public void performAction() {
        ExecutionDescriptor descriptor;
        Callable callable;
        GrailsPlatform runtime = GrailsPlatform.getDefault();
        if (!runtime.isConfigured()) {
            ConfigurationSupport.showConfigurationWarning(runtime);
            return;
        }
        final GrailsProject project = GrailsCommandAction.inferGrailsProject();
        if (project == null) {
            return;
        }
        GrailsCommandChooser.CommandDescriptor commandDescriptor = GrailsCommandChooser.select(project);
        if (commandDescriptor == null) {
            return;
        }
        ProjectInformation inf = ProjectUtils.getInformation((Project)project);
        String displayName = inf.getDisplayName() + " (" + commandDescriptor.getGrailsCommand().getCommand() + ")";
        final String[] params = commandDescriptor.getCommandParams() != null && !"".equals(commandDescriptor.getCommandParams().trim()) ? new String[]{commandDescriptor.getCommandParams()} : new String[]{};
        final boolean debug = commandDescriptor.isDebug();
        if ("run-app".equals(commandDescriptor.getGrailsCommand().getCommand())) {
            GrailsServerState serverState = (GrailsServerState)project.getLookup().lookup(GrailsServerState.class);
            Process process = null;
            if (serverState != null && serverState.isRunning()) {
                if (!debug) {
                    URL url = serverState.getRunningUrl();
                    if (url != null) {
                        GrailsCommandSupport.showURL(url, debug, project);
                    }
                    return;
                }
                process = serverState.getProcess();
                if (process != null) {
                    process.destroy();
                }
            }
            final Process oldProcess = process;
            callable = new Callable<Process>(){

                @Override
                public Process call() throws Exception {
                    if (oldProcess != null) {
                        oldProcess.waitFor();
                    }
                    Callable inner = ExecutionSupport.getInstance().createRunApp(GrailsProjectConfig.forProject((Project)project), debug, params);
                    Process process = (Process)inner.call();
                    GrailsServerState serverState = (GrailsServerState)project.getLookup().lookup(GrailsServerState.class);
                    if (serverState != null) {
                        serverState.setProcess(process);
                        serverState.setDebug(debug);
                    }
                    return process;
                }
            };
            descriptor = project.getCommandSupport().getRunDescriptor(debug);
        } else {
            callable = ExecutionSupport.getInstance().createSimpleCommand(commandDescriptor.getGrailsCommand().getCommand(), debug, GrailsProjectConfig.forProject((Project)project), params);
            descriptor = project.getCommandSupport().getDescriptor(commandDescriptor.getGrailsCommand().getCommand(), debug);
        }
        ExecutionService service = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)descriptor, (String)displayName);
        service.run();
    }

    private static GrailsProject inferGrailsProject() {
        Lookup globalContext;
        GrailsProject result;
        Node[] activatedNodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        if (activatedNodes != null) {
            for (Node n : activatedNodes) {
                GrailsProject result2 = GrailsCommandAction.lookupGrailsProject(n.getLookup());
                if (result2 == null) continue;
                return result2;
            }
        }
        if ((result = GrailsCommandAction.lookupGrailsProject(globalContext = Utilities.actionsGlobalContext())) != null) {
            return result;
        }
        FileObject fo = (FileObject)globalContext.lookup(FileObject.class);
        if (fo != null && (result = GrailsCommandAction.lookupGrailsProject(FileOwnerQuery.getOwner((FileObject)fo))) != null) {
            return result;
        }
        OpenProjects projects = OpenProjects.getDefault();
        result = GrailsCommandAction.lookupGrailsProject(projects.getMainProject());
        if (result != null) {
            return result;
        }
        for (Project project : projects.getOpenProjects()) {
            result = GrailsCommandAction.lookupGrailsProject(project);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static GrailsProject lookupGrailsProject(Project project) {
        if (project != null) {
            return GrailsCommandAction.lookupGrailsProject(project.getLookup());
        }
        return null;
    }

    private static GrailsProject lookupGrailsProject(Lookup lookup) {
        GrailsProject result = (GrailsProject)lookup.lookup(GrailsProject.class);
        if (result != null) {
            return result;
        }
        Project project = (Project)lookup.lookup(Project.class);
        if (project != null && (result = (GrailsProject)project.getLookup().lookup(GrailsProject.class)) != null) {
            return result;
        }
        return null;
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return Bundle.CTL_GrailsCommandAction();
    }
}

