/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.mixeddev.java.jni.ui;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.mixeddev.java.jni.ui.JPFCRootChildFactory;
import org.netbeans.modules.cnd.mixeddev.java.jni.ui.NativeProjectNode;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class JProjectFileChooser
extends JDialog
implements ExplorerManager.Provider {
    private final ExplorerManager manager = new ExplorerManager();
    private final BeanTreeView view;
    private Project chosenProject;
    private FileObject chosenFile;
    private JButton collapseAllButton;
    private JButton expandAllButton;
    private JButton selectButton;
    private JScrollPane treeView;

    public JProjectFileChooser(Frame parent, boolean modal, List<NativeProject> projects) {
        super(parent, modal);
        this.initComponents();
        this.setTitle(NbBundle.getMessage(JProjectFileChooser.class, (String)"JProjectFileChooser.title"));
        this.selectButton.setEnabled(false);
        this.view = (BeanTreeView)this.treeView;
        this.view.setRootVisible(false);
        this.manager.setRootContext((Node)new AbstractNode(Children.create((ChildFactory)new JPFCRootChildFactory(projects), (boolean)false)));
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    JProjectFileChooser.this.selectButton.setEnabled(JProjectFileChooser.this.isAcceptableNode(JProjectFileChooser.this.getSelectedNode()));
                }
            }
        });
    }

    public Project getChosenProject() {
        return this.chosenProject;
    }

    public FileObject getChosenFile() {
        return this.chosenFile;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void initComponents() {
        this.expandAllButton = new JButton();
        this.collapseAllButton = new JButton();
        this.selectButton = new JButton();
        this.treeView = new BeanTreeView();
        this.setDefaultCloseOperation(2);
        Mnemonics.setLocalizedText((AbstractButton)this.expandAllButton, (String)NbBundle.getMessage(JProjectFileChooser.class, (String)"JProjectFileChooser.expandAllButton.text"));
        this.expandAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JProjectFileChooser.this.expandAllButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.collapseAllButton, (String)NbBundle.getMessage(JProjectFileChooser.class, (String)"JProjectFileChooser.collapseAllButton.text"));
        this.collapseAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JProjectFileChooser.this.collapseAllButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.selectButton, (String)NbBundle.getMessage(JProjectFileChooser.class, (String)"JProjectFileChooser.selectButton.text"));
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JProjectFileChooser.this.selectButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.treeView).addGroup(layout.createSequentialGroup().addComponent(this.expandAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.collapseAllButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 360, Short.MAX_VALUE).addComponent(this.selectButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.treeView, -2, 275, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.expandAllButton).addComponent(this.collapseAllButton).addComponent(this.selectButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void expandAllButtonActionPerformed(ActionEvent evt) {
        this.view.expandAll();
    }

    private void collapseAllButtonActionPerformed(ActionEvent evt) {
        for (Node node : this.manager.getRootContext().getChildren().getNodes()) {
            this.view.collapseNode(node);
        }
    }

    private void selectButtonActionPerformed(ActionEvent evt) {
        Node selectedNode = this.getSelectedNode();
        if (this.isAcceptableNode(selectedNode)) {
            this.chosenFile = this.getNodeFile(selectedNode);
            this.chosenProject = this.getNodeProject(selectedNode);
            this.setVisible(false);
        }
    }

    private Node getSelectedNode() {
        Node[] selectedNodes = this.manager.getSelectedNodes();
        return selectedNodes != null && selectedNodes.length > 0 ? selectedNodes[0] : null;
    }

    private boolean isAcceptableNode(Node node) {
        return node.getLookup().lookup(FileObject.class) != null;
    }

    private FileObject getNodeFile(Node selectedNode) {
        if (this.isAcceptableNode(selectedNode)) {
            return (FileObject)selectedNode.getLookup().lookup(FileObject.class);
        }
        return null;
    }

    private Project getNodeProject(Node selectedNode) {
        if (this.isAcceptableNode(selectedNode)) {
            for (Node current = selectedNode; current != null; current = current.getParentNode()) {
                if (!(current instanceof NativeProjectNode)) continue;
                NativeProjectNode projectNode = (NativeProjectNode)current;
                NativeProject nativeProject = projectNode.getNativeProject();
                return (Project)nativeProject.getProject().getLookup().lookup(Project.class);
            }
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(JProjectFileChooser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(JProjectFileChooser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(JProjectFileChooser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(JProjectFileChooser.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JProjectFileChooser dialog = new JProjectFileChooser((Frame)new JFrame(), true, null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

