/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.DefaultCaret;
import org.jdesktop.swingx.renderer.JRendererCheckBox;
import org.netbeans.modules.db.dataview.util.DataViewUtils;

public class ResultSetTableCellEditor
extends DefaultCellEditor {
    protected Object val;
    protected JTable table;
    protected static final boolean suppressEditorBorder;

    public ResultSetTableCellEditor(final JTextField textField) {
        super(textField);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                ResultSetTableCellEditor.this.val = value;
                textField.setText(value != null ? value.toString() : "");
            }

            @Override
            public boolean isCellEditable(EventObject evt) {
                if (evt instanceof MouseEvent) {
                    return ((MouseEvent)evt).getClickCount() >= 2;
                }
                return true;
            }

            @Override
            public Object getCellEditorValue() {
                String txtVal = textField.getText();
                if (ResultSetTableCellEditor.this.val == null && txtVal.equals("")) {
                    return null;
                }
                return txtVal;
            }
        };
        textField.addActionListener(this.delegate);
        textField.setCaret(new DefaultCaret());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (DataViewUtils.isSQLConstantString(value, null)) {
            value = "";
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public ResultSetTableCellEditor(final JRendererCheckBox checkBox) {
        super((JCheckBox)checkBox);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                ResultSetTableCellEditor.this.val = value;
                checkBox.setSelected(value != null ? checkBox.isSelected() : false);
            }

            @Override
            public boolean isCellEditable(EventObject evt) {
                if (evt instanceof MouseEvent) {
                    return ((MouseEvent)evt).getClickCount() >= 2;
                }
                return true;
            }

            @Override
            public Object getCellEditorValue() {
                Boolean bolVal = checkBox.isSelected();
                if (ResultSetTableCellEditor.this.val == null && !checkBox.isSelected()) {
                    return null;
                }
                return bolVal;
            }
        };
        checkBox.addActionListener((ActionListener)this.delegate);
    }

    static {
        boolean suppressBorder = false;
        suppressBorder |= "GTK".equals(UIManager.getLookAndFeel().getID());
        suppressEditorBorder = suppressBorder |= "Nimbus".equals(UIManager.getLookAndFeel().getName());
    }
}

