/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.beanvalidation.impl;

import java.io.IOException;
import java.util.HashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.javaee.beanvalidation.api.BeanValidationConfig;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class BeanValidationConfigImpl
implements BeanValidationConfig {
    private FileObject configFile;
    private BaseDocument document = null;
    private int insertOffset = 0;

    public BeanValidationConfigImpl(FileObject configFile) {
        this.configFile = configFile;
    }

    @Override
    public String getName() {
        return this.configFile.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<FileObject, BeanValidationConfig.ConstraintMapping> getConstraintMappings() {
        HashMap<FileObject, BeanValidationConfig.ConstraintMapping> constraintMap = new HashMap<FileObject, BeanValidationConfig.ConstraintMapping>();
        this.getDocument();
        this.insertOffset = 0;
        if (this.document != null) {
            try {
                this.document.readLock();
                TokenHierarchy hi = TokenHierarchy.get((Document)this.document);
                TokenSequence ts = hi.tokenSequence();
                boolean started = false;
                boolean ended = false;
                boolean findInsertPoint = false;
                int startOffset = 0;
                int endOffset = 0;
                FileObject constraintFile = null;
                while (ts.moveNext()) {
                    Token t = ts.token();
                    if (t.id() == XMLTokenId.TAG && t.text().equals("<validation-config")) {
                        findInsertPoint = true;
                    }
                    if (findInsertPoint && t.id() == XMLTokenId.TAG && t.text().equals(">")) {
                        this.insertOffset = t.offset(hi) + t.length();
                        findInsertPoint = false;
                    }
                    if (!started && t.id() == XMLTokenId.TAG && t.text().equals("<constraint-mapping")) {
                        startOffset = t.offset(hi);
                        endOffset = startOffset + t.length();
                        started = true;
                        ended = true;
                    }
                    if (started && t.id() == XMLTokenId.TEXT) {
                        endOffset += t.length();
                        String value = t.text().toString();
                        WebModule wm = WebModule.getWebModule((FileObject)this.configFile);
                        constraintFile = wm.getDocumentBase().getFileObject(value);
                    }
                    if (started && t.id() == XMLTokenId.TAG && t.text().equals("</constraint-mapping")) {
                        endOffset += t.length() + 1;
                        ended = true;
                        started = false;
                    }
                    if (ended && t.id() == XMLTokenId.TAG && t.text().equals(">")) {
                        endOffset += t.length();
                        ended = false;
                    }
                    if (started || ended || constraintFile == null) continue;
                    ConstraintMappingImpl constraintMapping = new ConstraintMappingImpl(constraintFile, startOffset, endOffset);
                    constraintMap.put(constraintFile, constraintMapping);
                    constraintFile = null;
                }
            }
            finally {
                this.document.readUnlock();
            }
        }
        return constraintMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseDocument getDocument() {
        if (this.document == null) {
            try {
                DataObject dataObject;
                DataObject dataObject2 = dataObject = DataObject.find((FileObject)this.configFile);
                synchronized (dataObject2) {
                    EditorCookie editor = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
                    if (editor != null) {
                        this.document = (BaseDocument)editor.getDocument();
                        if (this.document != null) {
                            return this.document;
                        }
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this.document;
    }

    private int getInsertOffset() {
        return this.insertOffset;
    }

    @Override
    public void addConstraintMapping(FileObject fileObject) {
        if (!this.getConstraintMappings().containsKey(fileObject)) {
            try {
                WebModule wm = WebModule.getWebModule((FileObject)fileObject);
                if (wm != null) {
                    String str = "\n<constraint-mapping>" + FileUtil.getRelativePath((FileObject)wm.getDocumentBase(), (FileObject)fileObject) + "</constraint-mapping>";
                    this.getDocument().insertString(this.getInsertOffset(), str, null);
                    this.reformat();
                    this.saveConfig();
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void reformat() {
        final Reformat reformat = Reformat.get((Document)this.document);
        reformat.lock();
        try {
            this.document.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        reformat.reformat(0, BeanValidationConfigImpl.this.document.getLength());
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
        finally {
            reformat.unlock();
        }
    }

    private void saveConfig() {
        try {
            DataObject dataObject = DataObject.find((FileObject)this.configFile);
            SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
            if (saveCookie != null) {
                saveCookie.save();
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void removeConstraintMapping(FileObject fileObject) {
        BeanValidationConfig.ConstraintMapping constraintMapping = this.getConstraintMappings().get(fileObject);
        if (constraintMapping != null) {
            try {
                this.getDocument().remove(constraintMapping.getStartOffset(), constraintMapping.getEndOffset() - constraintMapping.getStartOffset());
                this.reformat();
                this.saveConfig();
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    class ConstraintMappingImpl
    implements BeanValidationConfig.ConstraintMapping {
        FileObject fileObject;
        int startOffset;
        int endOffset;

        public ConstraintMappingImpl(FileObject fileObject, int startOffset, int endOffset) {
            this.fileObject = fileObject;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        @Override
        public FileObject getFileObject() {
            return this.fileObject;
        }

        @Override
        public int getStartOffset() {
            return this.startOffset;
        }

        @Override
        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

