/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.WSSAssertion;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wss10
extends PolicyAssertion
implements WSSAssertion,
SecurityAssertionValidator {
    Set<String> requiredPropSet;
    String version = "1.0";
    QName name;
    boolean populated = false;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private SecurityPolicyVersion spVersion;

    public Wss10() {
        this.spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    }

    public Wss10(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
    }

    public void addRequiredProperty(String requirement) {
        if (this.requiredPropSet == null) {
            this.requiredPropSet = new HashSet<String>();
        }
        this.requiredPropSet.add(requirement);
    }

    @Override
    public Set<String> getRequiredProperties() {
        this.populate();
        return this.requiredPropSet;
    }

    @Override
    public String getType() {
        return this.version;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy = this.getNestedPolicy();
            if (policy == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet as = policy.getAssertionSet();
            for (PolicyAssertion pa : as) {
                if (PolicyUtil.isWSS10PolicyContent(pa, this.spVersion)) {
                    this.addRequiredProperty(pa.getName().getLocalPart().intern());
                    continue;
                }
                if (pa.isOptional()) continue;
                Constants.log_invalid_assertion(pa, isServer, "Wss10");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            this.populated = true;
        }
        return this.fitness;
    }
}

