/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.queues;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.queues.PatchSeriesPanel;
import org.netbeans.modules.mercurial.remote.ui.queues.QPatch;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class FinishPatch {
    private final VCSFileProxy repository;
    private final PatchSeriesPanel panel;
    private HgProgressSupport support;
    private static final String GETTING_PATCHES = NbBundle.getMessage(FinishPatch.class, (String)"LBL_FinishPatch.loadingPatches");
    private static final String NO_PATCHES = NbBundle.getMessage(FinishPatch.class, (String)"LBL_FinishPatch.noPatches");
    private QPatch onTopPatch;

    public FinishPatch(VCSFileProxy repository) {
        this.repository = repository;
        this.panel = new PatchSeriesPanel();
        this.panel.lstPatches.setCellRenderer(new PatchRenderer());
    }

    public boolean showDialog() {
        final JButton okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)okButton, (String)NbBundle.getMessage(FinishPatch.class, (String)"CTL_FinishPatch.ok.text"));
        DialogDescriptor dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(FinishPatch.class, (String)"LBL_FinishPatchPanel.title", (Object)this.repository.getName()), true, new Object[]{okButton, DialogDescriptor.CANCEL_OPTION}, (Object)okButton, 0, new HelpCtx(FinishPatch.class), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        okButton.setEnabled(false);
        this.setInfo(null);
        this.panel.lstPatches.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object selectedPatch = ((FinishPatch)FinishPatch.this).panel.lstPatches.getSelectedValue();
                    okButton.setEnabled(selectedPatch instanceof QPatch);
                    if (FinishPatch.this.onTopPatch == null) {
                        FinishPatch.this.setInfo(NbBundle.getMessage(FinishPatch.class, (String)"PatchSeriesPanel.lblInfo.noAppliedPatches"));
                    } else if (selectedPatch instanceof QPatch) {
                        FinishPatch.this.setInfo(NbBundle.getMessage(FinishPatch.class, (String)"FinishPatchPanel.lblInfo.toFinishPatches", (Object)((QPatch)selectedPatch).getId()));
                    } else {
                        FinishPatch.this.setInfo(null);
                    }
                }
            }
        });
        this.panel.lstPatches.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick((MouseEvent)e) && okButton.isEnabled()) {
                    okButton.doClick();
                }
            }
        });
        this.loadPatches();
        dialog.setVisible(true);
        HgProgressSupport supp = this.support;
        if (supp != null) {
            supp.cancel();
        }
        return dd.getValue() == okButton;
    }

    private void setInfo(String message) {
        if (message == null || message.isEmpty()) {
            this.panel.lblInfo.setVisible(false);
        } else {
            this.panel.lblInfo.setText(message);
            this.panel.lblInfo.setVisible(true);
        }
    }

    private void loadPatches() {
        this.panel.lstPatches.setListData(new String[]{GETTING_PATCHES});
        this.panel.lstPatches.setEnabled(false);
        this.support = new HgProgressSupport(){

            @Override
            protected void perform() {
                QPatch[] qPatches2;
                QPatch[] patches = null;
                try {
                    qPatches2 = patches = HgCommand.qListSeries(FinishPatch.this.repository);
                }
                catch (HgException qPatches2) {
                    QPatch[] qPatches3 = patches;
                    EventQueue.invokeLater(new Runnable(qPatches3){
                        final /* synthetic */ QPatch[] val$qPatches;
                        {
                            this.val$qPatches = qPatchArray;
                        }

                        @Override
                        public void run() {
                            FinishPatch.this.displayPatches(this.val$qPatches);
                        }
                    });
                }
                catch (Throwable throwable) {
                    QPatch[] qPatches4 = patches;
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        this.support.start(Mercurial.getInstance().getRequestProcessor(this.repository), this.repository, GETTING_PATCHES);
    }

    private void displayPatches(QPatch[] patches) {
        ArrayList<QPatch> toAdd;
        ArrayList<QPatch> arrayList = toAdd = patches == null ? Collections.emptyList() : new ArrayList<QPatch>(patches.length);
        if (patches != null) {
            QPatch p;
            for (int i = 0; i < patches.length && (p = patches[i]).isApplied(); ++i) {
                this.onTopPatch = p;
                toAdd.add(p);
            }
        }
        if (toAdd.isEmpty()) {
            this.panel.lstPatches.setListData(new String[]{NO_PATCHES});
        } else {
            this.panel.lstPatches.setListData(toAdd.toArray(new QPatch[toAdd.size()]));
            this.panel.lstPatches.setEnabled(true);
        }
    }

    String getSelectedPatch() {
        String retval = null;
        Object selected = this.panel.lstPatches.getSelectedValue();
        if (selected instanceof QPatch) {
            retval = ((QPatch)selected).getId();
        }
        return retval;
    }

    private static class PatchRenderer
    extends DefaultListCellRenderer {
        private PatchRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp;
            String tooltip = null;
            if (value instanceof QPatch) {
                QPatch patch = (QPatch)value;
                value = patch.getId();
                if (!patch.getMessage().trim().isEmpty()) {
                    tooltip = patch.getMessage();
                }
            }
            if ((comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus)) instanceof JComponent) {
                ((JComponent)comp).setToolTipText(tooltip);
            }
            return comp;
        }
    }
}

