/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.compilers;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.remote.compilers.CompilerSetScriptManager;
import org.netbeans.modules.cnd.remote.utils.RemoteUtil;
import org.netbeans.modules.cnd.spi.toolchain.CompilerSetProvider;
import org.netbeans.modules.cnd.spi.toolchain.ToolchainScriptGenerator;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;

public class RemoteCompilerSetProvider
implements CompilerSetProvider {
    private CompilerSetScriptManager manager;
    private final ExecutionEnvironment env;
    private final AtomicBoolean canceled = new AtomicBoolean(false);

    RemoteCompilerSetProvider(ExecutionEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException("ExecutionEnvironment should not be null");
        }
        this.env = env;
    }

    public void init() {
        this.manager = new CompilerSetScriptManager(this.env);
        if (!this.canceled.get()) {
            this.manager.runScript();
        }
    }

    public boolean cancel() {
        this.canceled.set(true);
        CompilerSetScriptManager aManager = this.manager;
        if (aManager != null) {
            return aManager.cancel();
        }
        return false;
    }

    public int getPlatform() {
        String platform = this.manager.getPlatform();
        if (platform == null || platform.length() == 0) {
            RemoteUtil.LOGGER.warning("RCSP.getPlatform: Got null response on platform");
            platform = "";
        }
        if (platform.startsWith("Windows") || platform.startsWith("PLATFORM_WINDOWS")) {
            return 3;
        }
        if (platform.startsWith("Linux") || platform.startsWith("PLATFORM_LINUX")) {
            return 2;
        }
        if (platform.startsWith("SunOS")) {
            return platform.contains("86") ? 1 : 0;
        }
        if (platform.startsWith("PLATFORM_SOLARIS_INTEL")) {
            return 1;
        }
        if (platform.startsWith("PLATFORM_SOLARIS_SPARC")) {
            return 0;
        }
        if (platform.toLowerCase(Locale.getDefault()).startsWith("mac") || platform.startsWith("PLATFORM_MACOSX")) {
            return 4;
        }
        return 5;
    }

    public boolean hasMoreCompilerSets() {
        if (this.canceled.get()) {
            return false;
        }
        return this.manager.hasMoreCompilerSets();
    }

    public String getNextCompilerSetData() {
        return this.manager.getNextCompilerSetData();
    }

    public String[] getCompilerSetData(String path) {
        try {
            NativeProcessBuilder pb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.env);
            HostInfo hinfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.env);
            pb.setExecutable(hinfo.getShell()).setArguments(new String[]{"-s"});
            ProcessUtils.ExitStatus res = ProcessUtils.execute((NativeProcessBuilder)pb, (byte[])ToolchainScriptGenerator.generateScript((String)path, (HostInfo)hinfo).getBytes("UTF-8"));
            List lines = res.getOutputLines();
            if (res.isOK()) {
                return lines.toArray(new String[lines.size()]);
            }
            RemoteUtil.LOGGER.log(Level.WARNING, "CSSM.runScript: FAILURE {0}", res.exitCode);
            ProcessUtils.logError((Level)Level.ALL, (Logger)RemoteUtil.LOGGER, (ProcessUtils.ExitStatus)res);
        }
        catch (ConnectionManager.CancellationException pb) {
        }
        catch (IOException ex) {
            RemoteUtil.LOGGER.log(Level.WARNING, "CSSM.runScript: IOException [{0}]", ex.getMessage());
        }
        return null;
    }
}

