/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.s3.internal.Constants;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.BucketLoggingConfiguration;
import com.amazonaws.services.s3.model.BucketNotificationConfiguration;
import com.amazonaws.services.s3.model.BucketVersioningConfiguration;
import com.amazonaws.services.s3.model.BucketWebsiteConfiguration;
import com.amazonaws.services.s3.model.CanonicalGrantee;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.EmailAddressGrantee;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.GroupGrantee;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.MultipartUpload;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.Owner;
import com.amazonaws.services.s3.model.PartListing;
import com.amazonaws.services.s3.model.PartSummary;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.model.S3VersionSummary;
import com.amazonaws.services.s3.model.VersionListing;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlResponsesSaxParser {
    private static final Log log = LogFactory.getLog(XmlResponsesSaxParser.class);
    private XMLReader xr = null;
    private boolean sanitizeXmlDocument = true;

    public XmlResponsesSaxParser() throws AmazonClientException {
        try {
            this.xr = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
            try {
                this.xr = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e2) {
                throw new AmazonClientException("Couldn't initialize a sax driver for the XMLReader");
            }
        }
    }

    protected void parseXmlInputStream(DefaultHandler handler, InputStream inputStream) throws AmazonClientException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing XML response document with handler: " + handler.getClass()));
            }
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            this.xr.setContentHandler(handler);
            this.xr.setErrorHandler(handler);
            this.xr.parse(new InputSource(breader));
        }
        catch (Throwable t) {
            block5: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Unable to close response InputStream up after XML parse failure", (Throwable)e);
                }
            }
            throw new AmazonClientException("Failed to parse XML document with handler " + handler.getClass(), t);
        }
    }

    protected InputStream sanitizeXmlDocument(DefaultHandler handler, InputStream inputStream) throws AmazonClientException {
        if (!this.sanitizeXmlDocument) {
            return inputStream;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sanitizing XML document destined for handler " + handler.getClass()));
        }
        ByteArrayInputStream sanitizedInputStream = null;
        try {
            StringBuilder listingDocBuffer = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            char[] buf = new char[8192];
            int read = -1;
            while ((read = br.read(buf)) != -1) {
                listingDocBuffer.append(buf, 0, read);
            }
            br.close();
            String listingDoc = listingDocBuffer.toString().replaceAll("\r", "&#013;");
            sanitizedInputStream = new ByteArrayInputStream(listingDoc.getBytes(Constants.DEFAULT_ENCODING));
        }
        catch (Throwable t) {
            block7: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block7;
                    log.error((Object)"Unable to close response InputStream after failure sanitizing XML document", (Throwable)e);
                }
            }
            throw new AmazonClientException("Failed to sanitize XML document destined for handler " + handler.getClass(), t);
        }
        return sanitizedInputStream;
    }

    private String checkForEmptyString(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    private int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            log.error((Object)("Unable to parse integer value '" + s + "'"), (Throwable)nfe);
            return -1;
        }
    }

    private long parseLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException nfe) {
            log.error((Object)("Unable to parse long value '" + s + "'"), (Throwable)nfe);
            return -1L;
        }
    }

    public ListBucketHandler parseListBucketObjectsResponse(InputStream inputStream) throws AmazonClientException {
        ListBucketHandler handler = new ListBucketHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ListVersionsHandler parseListVersionsResponse(InputStream inputStream) throws AmazonClientException {
        ListVersionsHandler handler = new ListVersionsHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public ListAllMyBucketsHandler parseListMyBucketsResponse(InputStream inputStream) throws AmazonClientException {
        ListAllMyBucketsHandler handler = new ListAllMyBucketsHandler();
        this.parseXmlInputStream(handler, this.sanitizeXmlDocument(handler, inputStream));
        return handler;
    }

    public AccessControlListHandler parseAccessControlListResponse(InputStream inputStream) throws AmazonClientException {
        AccessControlListHandler handler = new AccessControlListHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketLoggingConfigurationHandler parseLoggingStatusResponse(InputStream inputStream) throws AmazonClientException {
        BucketLoggingConfigurationHandler handler = new BucketLoggingConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public String parseBucketLocationResponse(InputStream inputStream) throws AmazonClientException {
        BucketLocationHandler handler = new BucketLocationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler.getLocation();
    }

    public BucketVersioningConfigurationHandler parseVersioningConfigurationResponse(InputStream inputStream) throws AmazonClientException {
        BucketVersioningConfigurationHandler handler = new BucketVersioningConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketWebsiteConfigurationHandler parseWebsiteConfigurationResponse(InputStream inputStream) throws AmazonClientException {
        BucketWebsiteConfigurationHandler handler = new BucketWebsiteConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public BucketNotificationConfigurationHandler parseNotificationConfigurationResponse(InputStream inputStream) throws AmazonClientException {
        BucketNotificationConfigurationHandler handler = new BucketNotificationConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public CopyObjectResultHandler parseCopyObjectResponse(InputStream inputStream) throws AmazonClientException {
        CopyObjectResultHandler handler = new CopyObjectResultHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public CompleteMultipartUploadHandler parseCompleteMultipartUploadResponse(InputStream inputStream) throws AmazonClientException {
        CompleteMultipartUploadHandler handler = new CompleteMultipartUploadHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public InitiateMultipartUploadHandler parseInitiateMultipartUploadResponse(InputStream inputStream) throws AmazonClientException {
        InitiateMultipartUploadHandler handler = new InitiateMultipartUploadHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public ListMultipartUploadsHandler parseListMultipartUploadsResponse(InputStream inputStream) throws AmazonClientException {
        ListMultipartUploadsHandler handler = new ListMultipartUploadsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public ListPartsHandler parseListPartsResponse(InputStream inputStream) throws AmazonClientException {
        ListPartsHandler handler = new ListPartsHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler;
    }

    public boolean parseRequestPaymentConfigurationResponse(InputStream inputStream) throws AmazonClientException {
        RequestPaymentConfigurationHandler handler = new RequestPaymentConfigurationHandler();
        this.parseXmlInputStream(handler, inputStream);
        return handler.isRequesterPays();
    }

    private static String findAttributeValue(String qnameToFind, Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String qname = attrs.getQName(i);
            if (!qname.trim().equalsIgnoreCase(qnameToFind.trim())) continue;
            return attrs.getValue(i);
        }
        return null;
    }

    public class BucketNotificationConfigurationHandler
    extends DefaultHandler {
        private BucketNotificationConfiguration configuration = new BucketNotificationConfiguration();
        private StringBuilder text;
        private List<BucketNotificationConfiguration.TopicConfiguration> topicConfigurations;
        private String topic;
        private String event;

        public BucketNotificationConfiguration getConfiguration() {
            return this.configuration;
        }

        public void startDocument() {
            this.text = new StringBuilder();
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("NotificationConfiguration")) {
                this.topicConfigurations = new ArrayList<BucketNotificationConfiguration.TopicConfiguration>(1);
            } else if (name.equals("TopicConfiguration")) {
                this.topic = null;
                this.event = null;
            } else if (name.equals("Topic")) {
                this.text.setLength(0);
            } else if (name.equals("Event")) {
                this.text.setLength(0);
            } else {
                log.warn((Object)("Ignoring unexpected tag <" + name + ">"));
            }
        }

        public void endElement(String uri, String name, String qName) throws SAXException {
            if (name.equals("Topic")) {
                this.topic = this.text.toString();
            } else if (name.equals("Event")) {
                this.event = this.text.toString();
            } else if (name.equals("TopicConfiguration")) {
                if (this.topic != null && this.event != null) {
                    this.topicConfigurations.add(new BucketNotificationConfiguration.TopicConfiguration(this.topic, this.event));
                }
            } else if (name.equals("NotificationConfiguration")) {
                this.configuration.setTopicConfigurations(this.topicConfigurations);
            }
            this.text.setLength(0);
        }

        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class ListPartsHandler
    extends DefaultHandler {
        private StringBuilder text;
        private PartListing result;
        private Owner currentOwner;
        private Owner currentInitiator;
        private PartSummary currentPart;

        public PartListing getListPartsResult() {
            return this.result;
        }

        public void startDocument() {
            this.text = new StringBuilder();
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("ListPartsResult")) {
                this.result = new PartListing();
            } else if (!(name.equals("Bucket") || name.equals("Key") || name.equals("UploadId"))) {
                if (name.equals("Owner")) {
                    this.currentOwner = new Owner();
                } else if (name.equals("Initiator")) {
                    this.currentInitiator = new Owner();
                } else if (!(name.equals("ID") || name.equals("DisplayName") || name.equals("StorageClass") || name.equals("PartNumberMarker") || name.equals("NextPartNumberMarker") || name.equals("MaxParts") || name.equals("IsTruncated"))) {
                    if (name.equals("Part")) {
                        this.currentPart = new PartSummary();
                    } else if (name.equals("PartNumber") || name.equals("LastModified") || name.equals("ETag") || name.equals("Size")) {
                        // empty if block
                    }
                }
            }
            this.text.setLength(0);
        }

        private Integer parseInteger(String text) {
            if ((text = XmlResponsesSaxParser.this.checkForEmptyString(text.toString())) == null) {
                return null;
            }
            return Integer.parseInt(text);
        }

        public void endElement(String uri, String name, String qName) throws SAXException {
            if (!name.equals("ListPartsResult")) {
                if (name.equals("Bucket")) {
                    this.result.setBucketName(this.text.toString());
                } else if (name.equals("Key")) {
                    this.result.setKey(this.text.toString());
                } else if (name.equals("UploadId")) {
                    this.result.setUploadId(this.text.toString());
                } else if (name.equals("Owner")) {
                    this.result.setOwner(this.currentOwner);
                    this.currentOwner = null;
                } else if (name.equals("Initiator")) {
                    this.result.setInitiator(this.currentInitiator);
                    this.currentInitiator = null;
                } else if (name.equals("ID") && this.currentOwner != null) {
                    this.currentOwner.setId(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("DisplayName") && this.currentOwner != null) {
                    this.currentOwner.setDisplayName(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("ID") && this.currentInitiator != null) {
                    this.currentInitiator.setId(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("DisplayName") && this.currentInitiator != null) {
                    this.currentInitiator.setDisplayName(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("StorageClass")) {
                    this.result.setStorageClass(this.text.toString());
                } else if (name.equals("PartNumberMarker")) {
                    this.result.setPartNumberMarker(this.parseInteger(this.text.toString()));
                } else if (name.equals("NextPartNumberMarker")) {
                    this.result.setNextPartNumberMarker(this.parseInteger(this.text.toString()));
                } else if (name.equals("MaxParts")) {
                    this.result.setMaxParts(this.parseInteger(this.text.toString()));
                } else if (name.equals("IsTruncated")) {
                    this.result.setTruncated(Boolean.parseBoolean(this.text.toString()));
                } else if (name.equals("Part")) {
                    this.result.getParts().add(this.currentPart);
                } else if (name.equals("PartNumber")) {
                    this.currentPart.setPartNumber(Integer.parseInt(this.text.toString()));
                } else if (name.equals("LastModified")) {
                    try {
                        this.currentPart.setLastModified(ServiceUtils.parseIso8601Date(this.text.toString()));
                    }
                    catch (ParseException e) {
                        throw new SAXException("Non-ISO8601 date for LastModified in list parts result: " + this.text.toString(), e);
                    }
                } else if (name.equals("ETag")) {
                    this.currentPart.setETag(ServiceUtils.removeQuotes(this.text.toString()));
                } else if (name.equals("Size")) {
                    this.currentPart.setSize(Long.parseLong(this.text.toString()));
                }
            }
        }

        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class ListMultipartUploadsHandler
    extends DefaultHandler {
        private StringBuilder text;
        private MultipartUploadListing result;
        private MultipartUpload currentMultipartUpload;
        private Owner currentOwner;
        private Owner currentInitiator;
        boolean inCommonPrefixes = false;

        public MultipartUploadListing getListMultipartUploadsResult() {
            return this.result;
        }

        public void startDocument() {
            this.text = new StringBuilder();
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("ListMultipartUploadsResult")) {
                this.result = new MultipartUploadListing();
            } else if (!(name.equals("Bucket") || name.equals("KeyMarker") || name.equals("Delimiter") || name.equals("UploadIdMarker") || name.equals("NextKeyMarker") || name.equals("NextUploadIdMarker") || name.equals("MaxUploads") || name.equals("IsTruncated"))) {
                if (name.equals("Upload")) {
                    this.currentMultipartUpload = new MultipartUpload();
                } else if (!name.equals("Key") && !name.equals("UploadId")) {
                    if (name.equals("Owner")) {
                        this.currentOwner = new Owner();
                    } else if (name.equals("Initiator")) {
                        this.currentInitiator = new Owner();
                    } else if (!(name.equals("ID") || name.equals("DisplayName") || name.equals("StorageClass") || name.equals("Initiated") || !name.equals("CommonPrefixes"))) {
                        this.inCommonPrefixes = true;
                    }
                }
            }
            this.text.setLength(0);
        }

        public void endElement(String uri, String name, String qName) throws SAXException {
            if (!name.equals("ListMultipartUploadsResult")) {
                if (name.equals("Bucket")) {
                    this.result.setBucketName(this.text.toString());
                } else if (name.equals("KeyMarker")) {
                    this.result.setKeyMarker(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("Delimiter")) {
                    this.result.setDelimiter(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("Prefix") && !this.inCommonPrefixes) {
                    this.result.setPrefix(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("Prefix") && this.inCommonPrefixes) {
                    this.result.getCommonPrefixes().add(this.text.toString());
                } else if (name.equals("UploadIdMarker")) {
                    this.result.setUploadIdMarker(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("NextKeyMarker")) {
                    this.result.setNextKeyMarker(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("NextUploadIdMarker")) {
                    this.result.setNextUploadIdMarker(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("MaxUploads")) {
                    this.result.setMaxUploads(Integer.parseInt(this.text.toString()));
                } else if (name.equals("IsTruncated")) {
                    this.result.setTruncated(Boolean.parseBoolean(this.text.toString()));
                } else if (name.equals("Upload")) {
                    this.result.getMultipartUploads().add(this.currentMultipartUpload);
                } else if (name.equals("Key")) {
                    this.currentMultipartUpload.setKey(this.text.toString());
                } else if (name.equals("UploadId")) {
                    this.currentMultipartUpload.setUploadId(this.text.toString());
                } else if (name.equals("Owner")) {
                    this.currentMultipartUpload.setOwner(this.currentOwner);
                    this.currentOwner = null;
                } else if (name.equals("Initiator")) {
                    this.currentMultipartUpload.setInitiator(this.currentInitiator);
                    this.currentInitiator = null;
                } else if (name.equals("ID") && this.currentOwner != null) {
                    this.currentOwner.setId(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("DisplayName") && this.currentOwner != null) {
                    this.currentOwner.setDisplayName(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("ID") && this.currentInitiator != null) {
                    this.currentInitiator.setId(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("DisplayName") && this.currentInitiator != null) {
                    this.currentInitiator.setDisplayName(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
                } else if (name.equals("StorageClass")) {
                    this.currentMultipartUpload.setStorageClass(this.text.toString());
                } else if (name.equals("Initiated")) {
                    try {
                        this.currentMultipartUpload.setInitiated(ServiceUtils.parseIso8601Date(this.text.toString()));
                    }
                    catch (ParseException e) {
                        throw new SAXException("Non-ISO8601 date for Initiated in initiate multipart upload result: " + this.text.toString(), e);
                    }
                } else if (name.equals("CommonPrefixes")) {
                    this.inCommonPrefixes = false;
                }
            }
        }

        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class InitiateMultipartUploadHandler
    extends DefaultHandler {
        private StringBuilder text;
        private InitiateMultipartUploadResult result;

        public InitiateMultipartUploadResult getInitiateMultipartUploadResult() {
            return this.result;
        }

        public void startDocument() {
            this.text = new StringBuilder();
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("InitiateMultipartUploadResult")) {
                this.result = new InitiateMultipartUploadResult();
            } else if (name.equals("Bucket") || name.equals("Key") || name.equals("UploadId")) {
                // empty if block
            }
            this.text.setLength(0);
        }

        public void endElement(String uri, String name, String qName) throws SAXException {
            if (!name.equals("InitiateMultipartUploadResult")) {
                if (name.equals("Bucket")) {
                    this.result.setBucketName(this.text.toString());
                } else if (name.equals("Key")) {
                    this.result.setKey(this.text.toString());
                } else if (name.equals("UploadId")) {
                    this.result.setUploadId(this.text.toString());
                }
            }
        }

        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class CompleteMultipartUploadHandler
    extends DefaultHandler {
        private StringBuilder text;
        private CompleteMultipartUploadResult result;
        private AmazonS3Exception ase;
        private String hostId;
        private String requestId;
        private String errorCode;

        public CompleteMultipartUploadResult getCompleteMultipartUploadResult() {
            return this.result;
        }

        public AmazonS3Exception getAmazonS3Exception() {
            return this.ase;
        }

        public void startDocument() {
            this.text = new StringBuilder();
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("CompleteMultipartUploadResult")) {
                this.result = new CompleteMultipartUploadResult();
            } else if (name.equals("Location") || name.equals("Bucket") || name.equals("Key") || name.equals("ETag")) {
                // empty if block
            }
            if (name.equals("Error") || name.equals("Code") || name.equals("Message") || name.equals("RequestId") || name.equals("HostId")) {
                // empty if block
            }
            this.text.setLength(0);
        }

        public void endElement(String uri, String name, String qName) throws SAXException {
            if (this.result != null) {
                if (!name.equals("CompleteMultipartUploadResult")) {
                    if (name.equals("Location")) {
                        this.result.setLocation(this.text.toString());
                    } else if (name.equals("Bucket")) {
                        this.result.setBucketName(this.text.toString());
                    } else if (name.equals("Key")) {
                        this.result.setKey(this.text.toString());
                    } else if (name.equals("ETag")) {
                        this.result.setETag(ServiceUtils.removeQuotes(this.text.toString()));
                    }
                }
            } else if (name.equals("Error")) {
                this.ase.setErrorCode(this.errorCode);
                this.ase.setRequestId(this.requestId);
                this.ase.setExtendedRequestId(this.hostId);
            } else if (name.equals("Code")) {
                this.errorCode = this.text.toString();
            } else if (name.equals("Message")) {
                this.ase = new AmazonS3Exception(this.text.toString());
            } else if (name.equals("RequestId")) {
                this.requestId = this.text.toString();
            } else if (name.equals("HostId")) {
                this.hostId = this.text.toString();
            }
        }

        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class BucketVersioningConfigurationHandler
    extends DefaultHandler {
        private BucketVersioningConfiguration configuration = new BucketVersioningConfiguration();
        private StringBuilder text;

        public BucketVersioningConfiguration getConfiguration() {
            return this.configuration;
        }

        public void startDocument() {
            this.text = new StringBuilder();
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (!name.equals("VersioningConfiguration")) {
                if (name.equals("Status")) {
                    this.text.setLength(0);
                } else if (name.equals("MfaDelete")) {
                    this.text.setLength(0);
                } else {
                    log.warn((Object)("Ignoring unexpected tag <" + name + ">"));
                }
            }
        }

        public void endElement(String uri, String name, String qName) throws SAXException {
            if (name.equals("Status")) {
                this.configuration.setStatus(this.text.toString());
            } else if (name.equals("MfaDelete")) {
                String mfaDeleteStatus = this.text.toString();
                if (mfaDeleteStatus.equals("Disabled")) {
                    this.configuration.setMfaDeleteEnabled(false);
                } else if (mfaDeleteStatus.equals("Enabled")) {
                    this.configuration.setMfaDeleteEnabled(true);
                } else {
                    this.configuration.setMfaDeleteEnabled(null);
                }
            }
            this.text.setLength(0);
        }

        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class BucketWebsiteConfigurationHandler
    extends DefaultHandler {
        private BucketWebsiteConfiguration configuration = new BucketWebsiteConfiguration(null);
        private StringBuilder text;
        boolean inIndexDocumentElement = false;
        boolean inErrorDocumentElement = false;

        public BucketWebsiteConfiguration getConfiguration() {
            return this.configuration;
        }

        public void startDocument() {
            this.text = new StringBuilder();
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (!name.equals("WebsiteConfiguration")) {
                if (name.equals("IndexDocument")) {
                    this.inIndexDocumentElement = true;
                } else if (!name.equals("Suffix") || !this.inIndexDocumentElement) {
                    if (name.equals("ErrorDocument")) {
                        this.inErrorDocumentElement = true;
                    } else if (!name.equals("Key") || !this.inErrorDocumentElement) {
                        log.warn((Object)("Ignoring unexpected tag <" + name + ">"));
                    }
                }
            }
        }

        public void endElement(String uri, String name, String qName) throws SAXException {
            if (!name.equals("WebsiteConfiguration")) {
                if (name.equals("IndexDocument")) {
                    this.inIndexDocumentElement = false;
                } else if (name.equals("Suffix") && this.inIndexDocumentElement) {
                    this.configuration.setIndexDocumentSuffix(this.text.toString());
                } else if (name.equals("ErrorDocument")) {
                    this.inErrorDocumentElement = false;
                } else if (name.equals("Key") && this.inErrorDocumentElement) {
                    this.configuration.setErrorDocument(this.text.toString());
                }
            }
            this.text.setLength(0);
        }

        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class ListVersionsHandler
    extends DefaultHandler {
        private VersionListing versionListing;
        private List<S3VersionSummary> versionSummaries;
        private S3VersionSummary currentVersionSummary;
        private Owner owner;
        private StringBuilder text;
        private boolean insideCommonPrefixes = false;

        public VersionListing getListing() {
            return this.versionListing;
        }

        public void startDocument() {
            this.versionListing = new VersionListing();
            this.versionSummaries = new ArrayList<S3VersionSummary>();
            this.text = new StringBuilder();
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (!name.equals("ListVersionsResult")) {
                if (name.equals("CommonPrefixes")) {
                    this.insideCommonPrefixes = true;
                } else if (!(name.equals("Name") || name.equals("Prefix") || name.equals("Delimiter") || name.equals("KeyMarker") || name.equals("VersionIdMarker") || name.equals("MaxKeys") || name.equals("NextKeyMarker") || name.equals("NextVersionIdMarker") || name.equals("IsTruncated"))) {
                    if (name.equals("Version")) {
                        this.currentVersionSummary = new S3VersionSummary();
                        this.currentVersionSummary.setBucketName(this.versionListing.getBucketName());
                    } else if (name.equals("DeleteMarker")) {
                        this.currentVersionSummary = new S3VersionSummary();
                        this.currentVersionSummary.setBucketName(this.versionListing.getBucketName());
                        this.currentVersionSummary.setIsDeleteMarker(true);
                    } else if (!(name.equals("Key") || name.equals("VersionId") || name.equals("IsLatest") || name.equals("LastModified") || name.equals("ETag") || name.equals("Size"))) {
                        if (name.equals("Owner")) {
                            this.owner = new Owner();
                        } else if (!(name.equals("StorageClass") || name.equals("ID") || name.equals("DisplayName"))) {
                            log.warn((Object)("Ignoring unexpected tag <" + name + ">"));
                        }
                    }
                }
            }
            this.text.setLength(0);
        }

        public void endElement(String uri, String name, String qName) throws SAXException {
            if (name.equals("ListVersionsResult")) {
                this.versionListing.setVersionSummaries(this.versionSummaries);
            } else if (name.equals("Name")) {
                this.versionListing.setBucketName(this.text.toString());
            } else if (!this.insideCommonPrefixes && name.equals("Prefix")) {
                this.versionListing.setPrefix(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
            } else if (this.insideCommonPrefixes && name.equals("Prefix")) {
                this.versionListing.getCommonPrefixes().add(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
            } else if (name.equals("CommonPrefixes")) {
                this.insideCommonPrefixes = false;
            } else if (name.equals("KeyMarker")) {
                this.versionListing.setKeyMarker(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
            } else if (name.equals("VersionIdMarker")) {
                this.versionListing.setVersionIdMarker(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
            } else if (name.equals("MaxKeys")) {
                this.versionListing.setMaxKeys(Integer.parseInt(this.text.toString()));
            } else if (name.equals("Delimiter")) {
                this.versionListing.setDelimiter(XmlResponsesSaxParser.this.checkForEmptyString(this.text.toString()));
            } else if (name.equals("NextKeyMarker")) {
                this.versionListing.setNextKeyMarker(this.text.toString());
            } else if (name.equals("NextVersionIdMarker")) {
                this.versionListing.setNextVersionIdMarker(this.text.toString());
            } else if (name.equals("IsTruncated")) {
                this.versionListing.setTruncated("true".equals(this.text.toString()));
            } else if (name.equals("Version")) {
                assert (this.currentVersionSummary != null);
                this.versionSummaries.add(this.currentVersionSummary);
                this.currentVersionSummary = null;
            } else if (name.equals("DeleteMarker")) {
                assert (this.currentVersionSummary != null);
                this.versionSummaries.add(this.currentVersionSummary);
                this.currentVersionSummary = null;
            } else if (name.equals("Key")) {
                assert (this.currentVersionSummary != null);
                this.currentVersionSummary.setKey(this.text.toString());
            } else if (name.equals("VersionId")) {
                assert (this.currentVersionSummary != null);
                this.currentVersionSummary.setVersionId(this.text.toString());
            } else if (name.equals("IsLatest")) {
                assert (this.currentVersionSummary != null);
                this.currentVersionSummary.setIsLatest("true".equals(this.text.toString()));
            } else if (name.equals("LastModified")) {
                assert (this.currentVersionSummary != null);
                try {
                    this.currentVersionSummary.setLastModified(ServiceUtils.parseIso8601Date(this.text.toString()));
                }
                catch (ParseException e) {
                    throw new SAXException("Non-ISO8601 date for LastModified in copy object output: " + this.text.toString(), e);
                }
            } else if (name.equals("ETag")) {
                assert (this.currentVersionSummary != null);
                assert (!this.currentVersionSummary.isDeleteMarker());
                this.currentVersionSummary.setETag(ServiceUtils.removeQuotes(this.text.toString()));
            } else if (name.equals("Size")) {
                assert (this.currentVersionSummary != null);
                assert (!this.currentVersionSummary.isDeleteMarker());
                this.currentVersionSummary.setSize(Long.parseLong(this.text.toString()));
            } else if (name.equals("Owner")) {
                this.currentVersionSummary.setOwner(this.owner);
                this.owner = null;
            } else if (name.equals("StorageClass")) {
                assert (this.currentVersionSummary != null);
                assert (!this.currentVersionSummary.isDeleteMarker());
                this.currentVersionSummary.setStorageClass(this.text.toString());
            } else if (name.equals("ID")) {
                assert (this.owner != null);
                this.owner.setId(this.text.toString());
            } else if (name.equals("DisplayName")) {
                assert (this.owner != null);
                this.owner.setDisplayName(this.text.toString());
            } else {
                log.warn((Object)("Ignoring unexpected tag <" + name + ">"));
            }
            this.text.setLength(0);
        }

        public void characters(char[] ch, int start, int length) {
            this.text.append(ch, start, length);
        }
    }

    public class RequestPaymentConfigurationHandler
    extends DefaultHandler {
        private String payer = null;
        private StringBuilder currText = new StringBuilder();

        public boolean isRequesterPays() {
            return "Requester".equals(this.payer);
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("RequestPaymentConfiguration")) {
                // empty if block
            }
        }

        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("Payer")) {
                this.payer = elementText;
            }
            this.currText = new StringBuilder();
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class CopyObjectResultHandler
    extends DefaultHandler {
        private String etag = null;
        private Date lastModified = null;
        private String versionId = null;
        private String errorCode = null;
        private String errorMessage = null;
        private String errorRequestId = null;
        private String errorHostId = null;
        private boolean receivedErrorResponse = false;
        private StringBuilder currText = new StringBuilder();

        public Date getLastModified() {
            return this.lastModified;
        }

        public String getVersionId() {
            return this.versionId;
        }

        public void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public String getETag() {
            return this.etag;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getErrorHostId() {
            return this.errorHostId;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getErrorRequestId() {
            return this.errorRequestId;
        }

        public boolean isErrorResponse() {
            return this.receivedErrorResponse;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("CopyObjectResult")) {
                this.receivedErrorResponse = false;
            } else if (name.equals("Error")) {
                this.receivedErrorResponse = true;
            }
        }

        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("LastModified")) {
                try {
                    this.lastModified = ServiceUtils.parseIso8601Date(elementText);
                }
                catch (ParseException e) {
                    throw new RuntimeException("Non-ISO8601 date for LastModified in copy object output: " + elementText, e);
                }
            } else if (name.equals("ETag")) {
                this.etag = ServiceUtils.removeQuotes(elementText);
            } else if (name.equals("Code")) {
                this.errorCode = elementText;
            } else if (name.equals("Message")) {
                this.errorMessage = elementText;
            } else if (name.equals("RequestId")) {
                this.errorRequestId = elementText;
            } else if (name.equals("HostId")) {
                this.errorHostId = elementText;
            }
            this.currText = new StringBuilder();
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class BucketLocationHandler
    extends DefaultHandler {
        private String location = null;
        private StringBuilder currText = new StringBuilder();

        public String getLocation() {
            return this.location;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("CreateBucketConfiguration")) {
                // empty if block
            }
        }

        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("LocationConstraint")) {
                this.location = elementText.length() == 0 ? null : elementText;
            }
            this.currText = new StringBuilder();
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class BucketLoggingConfigurationHandler
    extends DefaultHandler {
        private BucketLoggingConfiguration bucketLoggingConfiguration = null;
        private String targetBucket = null;
        private String targetPrefix = null;
        private StringBuilder currText = new StringBuilder();

        public BucketLoggingConfiguration getBucketLoggingConfiguration() {
            return this.bucketLoggingConfiguration;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("BucketLoggingStatus")) {
                this.bucketLoggingConfiguration = new BucketLoggingConfiguration();
            }
        }

        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("TargetBucket")) {
                this.targetBucket = elementText;
            } else if (name.equals("TargetPrefix")) {
                this.targetPrefix = elementText;
            } else if (name.equals("LoggingEnabled")) {
                this.bucketLoggingConfiguration.setDestinationBucketName(this.targetBucket);
                this.bucketLoggingConfiguration.setLogFilePrefix(this.targetPrefix);
            }
            this.currText = new StringBuilder();
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    public class AccessControlListHandler
    extends DefaultHandler {
        private AccessControlList accessControlList = null;
        private Owner owner = null;
        private Grantee currentGrantee = null;
        private Permission currentPermission = null;
        private StringBuilder currText = new StringBuilder();
        private boolean insideACL = false;

        public AccessControlList getAccessControlList() {
            return this.accessControlList;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Owner")) {
                this.owner = new Owner();
            } else if (name.equals("AccessControlList")) {
                this.accessControlList = new AccessControlList();
                this.accessControlList.setOwner(this.owner);
                this.insideACL = true;
            } else if (name.equals("Grantee")) {
                String type = XmlResponsesSaxParser.findAttributeValue("xsi:type", attrs);
                if ("AmazonCustomerByEmail".equals(type)) {
                    this.currentGrantee = new EmailAddressGrantee(null);
                } else if ("CanonicalUser".equals(type)) {
                    this.currentGrantee = new CanonicalGrantee(null);
                } else if ("Group".equals(type)) {
                    // empty if block
                }
            }
        }

        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("ID") && !this.insideACL) {
                this.owner.setId(elementText);
            } else if (name.equals("DisplayName") && !this.insideACL) {
                this.owner.setDisplayName(elementText);
            } else if (name.equals("ID")) {
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("EmailAddress")) {
                this.currentGrantee.setIdentifier(elementText);
            } else if (name.equals("URI")) {
                this.currentGrantee = GroupGrantee.parseGroupGrantee(elementText);
            } else if (name.equals("DisplayName")) {
                ((CanonicalGrantee)this.currentGrantee).setDisplayName(elementText);
            } else if (name.equals("Permission")) {
                this.currentPermission = Permission.parsePermission(elementText);
            } else if (name.equals("Grant")) {
                this.accessControlList.grantPermission(this.currentGrantee, this.currentPermission);
                this.currentGrantee = null;
                this.currentPermission = null;
            } else if (name.equals("AccessControlList")) {
                this.insideACL = false;
            }
            this.currText = new StringBuilder();
        }

        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ListAllMyBucketsHandler
    extends DefaultHandler {
        private Owner bucketsOwner = null;
        private Bucket currentBucket = null;
        private StringBuilder currText = null;
        private List<Bucket> buckets = new ArrayList<Bucket>();

        public ListAllMyBucketsHandler() {
            this.currText = new StringBuilder();
        }

        public List<Bucket> getBuckets() {
            return this.buckets;
        }

        public Owner getOwner() {
            return this.bucketsOwner;
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Bucket")) {
                this.currentBucket = new Bucket();
            } else if (name.equals("Owner")) {
                this.bucketsOwner = new Owner();
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("ID")) {
                this.bucketsOwner.setId(elementText);
            } else if (name.equals("DisplayName")) {
                this.bucketsOwner.setDisplayName(elementText);
            } else if (name.equals("Bucket")) {
                this.currentBucket.setOwner(this.bucketsOwner);
                this.buckets.add(this.currentBucket);
            } else if (name.equals("Name")) {
                this.currentBucket.setName(elementText);
            } else if (name.equals("CreationDate")) {
                elementText = elementText + ".000Z";
                try {
                    this.currentBucket.setCreationDate(ServiceUtils.parseIso8601Date(elementText));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Non-ISO8601 date for CreationDate in list buckets output: " + elementText, e);
                }
            }
            this.currText = new StringBuilder();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ListBucketHandler
    extends DefaultHandler {
        private S3ObjectSummary currentObject = null;
        private Owner currentOwner = null;
        private StringBuilder currText = null;
        private boolean insideCommonPrefixes = false;
        private ObjectListing objectListing = new ObjectListing();
        private List<String> commonPrefixes = new ArrayList<String>();
        private String bucketName = null;
        private String requestPrefix = null;
        private String requestMarker = null;
        private int requestMaxKeys = 0;
        private String requestDelimiter = null;
        private boolean listingTruncated = false;
        private String lastKey = null;
        private String nextMarker = null;

        public ListBucketHandler() {
            this.currText = new StringBuilder();
        }

        public ObjectListing getObjectListing() {
            this.objectListing.setBucketName(this.bucketName);
            this.objectListing.setCommonPrefixes(this.commonPrefixes);
            this.objectListing.setDelimiter(this.requestDelimiter);
            this.objectListing.setMarker(this.requestMarker);
            this.objectListing.setMaxKeys(this.requestMaxKeys);
            this.objectListing.setPrefix(this.requestPrefix);
            this.objectListing.setTruncated(this.listingTruncated);
            if (this.nextMarker != null) {
                this.objectListing.setNextMarker(this.nextMarker);
            } else if (this.listingTruncated) {
                String nextMarker = null;
                if (!this.objectListing.getObjectSummaries().isEmpty()) {
                    nextMarker = this.objectListing.getObjectSummaries().get(this.objectListing.getObjectSummaries().size() - 1).getKey();
                } else if (!this.objectListing.getCommonPrefixes().isEmpty()) {
                    nextMarker = this.objectListing.getCommonPrefixes().get(this.objectListing.getCommonPrefixes().size() - 1);
                } else {
                    log.error((Object)"S3 response indicates truncated results, but contains no object summaries or common prefixes.");
                }
                this.objectListing.setNextMarker(nextMarker);
            }
            return this.objectListing;
        }

        public String getMarkerForNextListing() {
            if (this.listingTruncated) {
                if (this.nextMarker != null) {
                    return this.nextMarker;
                }
                if (this.lastKey != null) {
                    return this.lastKey;
                }
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Unable to find Next Marker or Last Key for truncated listing");
                }
                return null;
            }
            return null;
        }

        public boolean isListingTruncated() {
            return this.listingTruncated;
        }

        public List<S3ObjectSummary> getObjects() {
            return this.objectListing.getObjectSummaries();
        }

        public String[] getCommonPrefixes() {
            return this.commonPrefixes.toArray(new String[this.commonPrefixes.size()]);
        }

        public String getRequestPrefix() {
            return this.requestPrefix;
        }

        public String getRequestMarker() {
            return this.requestMarker;
        }

        public String getNextMarker() {
            return this.nextMarker;
        }

        public long getRequestMaxKeys() {
            return this.requestMaxKeys;
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes attrs) {
            if (name.equals("Contents")) {
                this.currentObject = new S3ObjectSummary();
                this.currentObject.setBucketName(this.bucketName);
            } else if (name.equals("Owner")) {
                this.currentOwner = new Owner();
                this.currentObject.setOwner(this.currentOwner);
            } else if (name.equals("CommonPrefixes")) {
                this.insideCommonPrefixes = true;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void endElement(String uri, String name, String qName) {
            String elementText = this.currText.toString();
            if (name.equals("Name")) {
                this.bucketName = elementText;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Examining listing for bucket: " + this.bucketName));
                }
            } else if (!this.insideCommonPrefixes && name.equals("Prefix")) {
                this.requestPrefix = XmlResponsesSaxParser.this.checkForEmptyString(elementText);
            } else if (name.equals("Marker")) {
                this.requestMarker = XmlResponsesSaxParser.this.checkForEmptyString(elementText);
            } else if (name.equals("NextMarker")) {
                this.nextMarker = elementText;
            } else if (name.equals("MaxKeys")) {
                this.requestMaxKeys = XmlResponsesSaxParser.this.parseInt(elementText);
            } else if (name.equals("Delimiter")) {
                this.requestDelimiter = XmlResponsesSaxParser.this.checkForEmptyString(elementText);
            } else if (name.equals("IsTruncated")) {
                String isTruncatedStr = elementText.toLowerCase(Locale.getDefault());
                if (isTruncatedStr.startsWith("false")) {
                    this.listingTruncated = false;
                } else {
                    if (!isTruncatedStr.startsWith("true")) throw new RuntimeException("Invalid value for IsTruncated field: " + isTruncatedStr);
                    this.listingTruncated = true;
                }
            } else if (name.equals("Contents")) {
                this.objectListing.getObjectSummaries().add(this.currentObject);
            } else if (name.equals("Key")) {
                this.currentObject.setKey(elementText);
                this.lastKey = elementText;
            } else if (name.equals("LastModified")) {
                try {
                    this.currentObject.setLastModified(ServiceUtils.parseIso8601Date(elementText));
                }
                catch (ParseException e) {
                    throw new RuntimeException("Non-ISO8601 date for LastModified in bucket's object listing output: " + elementText, e);
                }
            } else if (name.equals("ETag")) {
                this.currentObject.setETag(ServiceUtils.removeQuotes(elementText));
            } else if (name.equals("Size")) {
                this.currentObject.setSize(XmlResponsesSaxParser.this.parseLong(elementText));
            } else if (name.equals("StorageClass")) {
                this.currentObject.setStorageClass(elementText);
            } else if (name.equals("ID")) {
                if (this.currentOwner == null) {
                    this.currentOwner = new Owner();
                    this.currentObject.setOwner(this.currentOwner);
                }
                this.currentOwner.setId(elementText);
            } else if (name.equals("DisplayName")) {
                this.currentOwner.setDisplayName(elementText);
            } else if (this.insideCommonPrefixes && name.equals("Prefix")) {
                this.commonPrefixes.add(elementText);
            } else if (name.equals("CommonPrefixes")) {
                this.insideCommonPrefixes = false;
            }
            this.currText = new StringBuilder();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.currText.append(ch, start, length);
        }
    }
}

